
/***************
**
**  dictword.h
**  last revised: april 9, 1992
**
**  Header file for functions implemented in dictword.c.
**  This module deals with conversion of words that are to be stored in a
**  dictionary (capitalise word, lowercase word, first letter capital,
**  etc.)
**
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote.
**
**  Copyright (C)1992, Andre Blum
**
**  root@waves.hacktic.nl (Andre Blum)
**  root@room101.hacktic.nl (Ronald Brockmann)
**
*/

#define NORMAL     0x0001
#define LOWER      0x0002
#define UPPER      0x0004
#define FIRSTUP    0x0008
#define REVERSE    0x0010
#define EXTNORMAL  0x0020 /* Extnormal: set when the switch -n is selected, */
                          /* extnormal is not, like NORMAL, turned off when */
                          /* LOWER, UPPER or FIRSTUP is selected            */
#define FIRSTWORD  0x0040
#define SECONDWORD 0x0080
#define THIRDWORD  0x0100
#define CHECK      0x0200

char *all_lower(char *d, char *s);
char *all_upper(char *d, char *s);
char *first_upper(char *d, char *s);
char *reverse(char *d, char *s);

/* EOF DICTWORD.H */
