
/***************
**
**  dictword.c
**  last revised: april 9, 1992
**
**  implementation of word-converting functions.
**  This module deals with conversion of words that are to be stored in a
**  dictionary (capitalise word, lowercase word, first letter capital,
**  etc.)
**
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote.
**
**  Copyright (C)1992, Zabkar
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <string.h>
#include <ctype.h>
#include "dictword.h"



/***************
 all_lower()
 converts a string to its lowercase-equivalent
***************/

char *all_lower(char *d, char *s)
{
    int i;

    for (i=0; i<strlen(s); i++)
        d[i] = tolower(s[i]);

    d[i] = '\0';
    return (d);
}



/***************
 all_upper()
 converts a string to its uppercase-equivalent
***************/

char *all_upper(char *d, char *s)
{
    int i;

    for (i=0; i<strlen(s); i++)
        d[i] = toupper(s[i]);

    d[i] = '\0';
    return (d);
}



/***************
 first_upper()
 converts a string to its lowercase-equivalent, with the first letter
 capitalized.
***************/

char *first_upper(char *d, char *s)
{
    all_lower(d, s);

    d[0] = toupper(s[0]);

    return (d);
}



/***************
 reverse()
 converts a string to its reversed-equivalent.
***************/

char *reverse(char *d, char *s)
{
    strcpy(d, s);
    return (strrev(d));
}

/* EOF DICTWORD.C */
