%==Menu tree================================================================%

"Main"
(  ( "Mark"       "Start/end marking text" mark )
   ( "Edit"       Edit )
   ( "Read"       Read )
   ( "Write"      Write )
   ( "Layout"     Layout )
   ( "View"       View )
   ( "Options"    Options )
   ( "New"        New )
   ( "Print"      Print )
   ( "Spell"      Spell )
   ( "Quit"       "Quit ChiWriter" *quit )
   ( "Help"       <Display quick reminder. (To get help on a command, highlight it and hit [Alt-H])> showhelp )
) set

   "Edit"
   (  ( "Format"     Format )
      ( "Dup"        <Duplicate marked text> *dup )
      ( "Cut"        <Cut marked text into paste buffer> *cut )
      ( "Paste"      <Insert text from paste buffer> *paste)
      ( "Add"        Addlevel )
      ( "Box/Table"  Box  )
      ( "Graphic"    Graphic )
      ( "Search"     <Search for pattern> *search)
      ( "Replace"    <Search and replace> *replace )
      ( "Undo"       <Undo the last command> undo )
      ( "rEdo"       <Undo the last undo command> redo )
   ) set

      "Format"
      (  ( "Spacing"       <Change spacing for marked paragraphs> (5 *chgfmt) )
         ( "Just"          <Change justification for marked paragraphs> (1 *chgfmt) )
         ( "Left margin"   <Change left margin for marked paragraphs> (2 *chgfmt) )
         ( "Right margin"  <Change right margin for marked paragraphs> (3 *chgfmt) )
         ( "inDent"        <Indent or outdent marked paragraphs> (4 *chgfmt) )
         ( "Case"          Case )
         ( "Font"          <Change font for marked area> *fontchg )
         ( "Hyphen"        <Hyphenation> *hyphen )
         ( "Inhibit"       <Inhibit page breaks> ihibreak)
      ) set

         "Case"
         (  ( "to Upper"   "Change marked area to upper case" (1 0 0 *change) )
            ( "to Lower"   "Change marked area to lower case" (-1 0 0 *change) )
         ) set

      "Addlevel"
      (  ("level Up"    <Add level up>                   (1 addlevel))
         ("level Down"  <Add level down>                 (-1 addlevel))
         ("spot Left"   <Add insert spot to the left>    (-1 ispot))
         ("spot Right"  <Add insert spot to the right>   (1 ispot))
         ("lIne draw"   <Line draw>                      *linedraw)
      ) set

      "Box"
      (  ( "Add"           Add )
         ( "Zap"           Zap )
         ( "Move"          Move )
         ( "Split"         "Split column" splitcol )
         ( "Join"          <Join with cell to the right to make multi-span cell> (1 joincell) )
         ( "Grow/Shrink"   "Resize column" (0 growcol) )
      ) set

         "Add"
         (  ( "row Up"        <Add row of cells above>            (0 -1 addrow) )
            ( "row Down"      <Add row of cells below>            (0 1 addrow) )
            ( "column Left"   <Add column of cells to the left>   (-1 *addcol) )
            ( "column Right"  <Add column of cells to the right>  (1 *addcol) )
            ( "rubber Band"   <Add rubber band>                   *addband )
         ) set

         "Zap"
         (  ( "Row"           <Delete row of cells>      delRow )
            ( "Column"        <Delete column of cells>   deletecol )
            ( "rubber Band"   <Delete rubber band>       *zapband )
         ) set

         "Move"
         (  ("Row"      <Move box row> ("Use arrow keys to move" message 0 moverow) )
            ("Column"   <Move box column> ("Use arrow keys to move" message 0 movecol) )
         ) set

      "Graphic"
      (  (  "Clip"         <Clip graphic>                *clip )
         (  "Scale"        <Change size>                 *scale   )
         (  "Grow/Shrink"  <Grow or shrink graphic>      *grow )
         (  "Reset"        Resetgr  )
      ) set

         "Resetgr"
         (  ("Yes"   <Reset size to original values and remove clip> resetgraph )
            ("No"    <Do not reset> () )
         ) set

   "Read"
   (  ( "Document"         <Read document>      *read)
      ( "Import ASCII"     <Import ASCII file>  *readasc)
      ( "Graphic"          <Import graphic>     *readgr)
      ( "Styles"           <Read styles from style file> *readsty ) ; ADDED IN 4.20
   ) set

   "Write"
   (  ( "Document"         <Write Document>        *write )
      ( "Export ASCII"     <Export file as ASCII>  *writeasc)
      ( "Change name"      <Change filename>       *chgname )
      ( "Styles"           <Write styles to file>  *writesty ) ; ADDED IN 4.20
   ) set

   "Layout"
   (  ( "Document"   <Set document format> *docfmt  )
      ( "Paragraph"  <Set paragraph format>  *parfmt )
      ( "Style"      <Apply, edit, insert, remove styles> *style )
      ( "Box/Table"  <Box/table layout> *boxfmt )
      ( "Cell"       <Cell layout> *cellfmt )
      ( "Header"     <Edit header>  ((*openhdr) *openhf) )
      ( "Footer"     <Edit footer>  ((*openftr) *openhf) )
      ( "footNote"   <Set footnote style> *fnfmt )
      ( "Graphic"    <Graphic layout> *editgr )
   ) set

   "View"
   (  ( "Documents"     <List all documents> *doclist )
      ( "Box bounds"    <View box boundary>     showbounds )
      ( "Font chart"    <Toggle font chart>     showchart)
      ( "Close"         <Close current window>  endHF )
      ( "Next"          <Change to next document or header/footer/footnote> (1 *chgwin) )
      ( "Previous"      <Change to previous document or header/footer/footnote> (0 *chgwin) )
      ( "Split"         <Split window> (Whichdoc menu2 dup NIL ne? (*splitwin) (pop) ifelse) )
   ) set

   "Options"
   (  ("Key sequences"     Keyseq)
      ("Globals"           <Global default settings> *global)
      ("Styles"            OptStyles ) ; ADDED IN 4.20
      ("Fonts"             <Assignment of fonts> *fontlst)
      ("Configuration"     Config )
      ("Run DOS"           <Exit to DOS temporarily> rundos )
      ("About"             <Information about ChiWriter> *version )
   ) set

      "Keyseq"
      (  ( "Read"          <Read key sequence file>  *readkey )
         ( "Write"         <Write key sequence file> *writekey  )
         ( "Define"        <Define a key sequence> *defkey )
         ( "Key sequence replay"       <Play back a key sequence> *playkey )
         ( "ChiScript"     <Run ChiScript> *chiscr )
      ) set

      "Config"
      (  ("Paragraph"            <Paragraph default settings>  *stdparfmt)
         ("Graphic"              <Graphic default settings>    *stdgraph)
         ("Read"                 <Read configuration file>     *readcon )
         ("Write"                <Write configuration file>    *writecon )
      ) set

      "OptStyles" ; ADDED IN 4.20
      (  ( "Read"    <Read styles from file> *readsty )
         ( "Write"   <Write styles to file>  *writesty )
      ) set

   "New"
   (  ( "Box"           <Create box> *math )
      ( "Table/Matrix"  <Create table/matrix> *matrix )
      ( "footNote"      <Open footnote> *openfn )
      ( "Index"         <Insert index token> *index ) ; ADDED IN 4.20
      ( "Counter"       <Insert page or footnote counter>   *insctr )
      ( "Page break"    <Enter hard page break> hardbreak )
      ( "Document"      <Edit a new document> *newdoc )
   ) set

   "Print"
   (  ( "Go"            <Print document> *print)
      ( "Options"       <Printing options> *prnopt)
      ( "Settings"      <Change printer settings>  *prnset)
      ( "Numbering"     <Numbering of pages and footnotes> *prnnum)
      ( "special Features" <Special features of this printer> *prnspec )
      ( "Mail merge"    <Information concerning mail merge> *mailmrg) ; ADDED IN 4.20
      ( "Labels"        <Information concerning lables> *labels) ; ADDED IN 4.20
   ) set

   "Spell"
   (  ( "Spell check"  <Start spell check> *spell )
      ( "Read Dictionaries" <Read in dictionaries> *readdic )
   ) set

%==Other Menus==============================================================%

"Attachto"
(  (Key  "Attach to a key or to a name?" 0)
   (Name "Attach to a key or to a name?" 1)
) set

"Cliplist"
(  ( "Left"    ""    0 )
   ( "Right"   ""    1 )
   ( "Top"     ""    2 )
   ( "Bottom"  ""    3 )
) set

"Changef1"
(  ("No"    "Font 1 is used for menu text. Ok to change/delete?"  0)
   ("Yes"   "Font 1 is used for menu text. Ok to change/delete?"  1)
) set

"Confirmquit"
(  ("No"    <Do not quit--continue editing>        0)
   ("Yes"   <Abandon changed documents and quit>   1)
   ("Write" <Write all changed documents and quit> 2)
) set

"Docmod"
(  ("No"    "Abandon document?" 0)
   ("Yes"   "Abandon document?" 1)
   ("Write" "Abandon document?" 2)
) set

"Hflist"
(  ( "Default" "" 0 )
   ( "Even"    "" 10 )
   ( "1st"     "" 1 )
   ( "2nd"     "" 2 )
   ( "3rd"     "" 3 )
   ( "4th"     "" 4 )
   ( "5th"     "" 5 )
   ( "6th"     "" 6 )
   ( "7th"     "" 7 )
   ( "8th"     "" 8 )
   ( "9th"     "" 9 )
) set

"Hychoice" ; ADDED IN 4.20 
(  ("Interactive" "Interactively hyphenate" 0 )
   ("Automatic" "Automatically hyphenate" 1 )
   ("Show word" "Modifies default hyphenation of word" 2 )
   ("Threshold" "Sets the hyphenation threshold" 3 )
) set

"Overwrite"
(  ( "Yes"  "File name already exists.  Overwrite?" 0 )
   ( "No"   "File name already exists.  Overwrite?" 1 )
) set

"Prevassign"
(  (Yes  "Overwrite previous assignment?" 1)
   (No   "Overwrite previous assignment?" 0)
) set

"Whichdoc"
(  ("1"  "Which document?" 1)
   ("2"  "Which document?" 2)
   ("3"  "Which document?" 3)
   ("4"  "Which document?" 4)
   ("5"  "Which document?" 5)
   ("6"  "Which document?" 6)
   ("7"  "Which document?" 7)
   ("8"  "Which document?" 8)
   ("9"  "Which document?" 9)
   ("10" "Which document?" 10)
) set

"Zapband"
(  ("Horizontal"  "Delete which rubber band?" 0 )
   ("Vertical"    "Delete which rubber band?" 1 )
   ("Both"        "Delete which rubber band?" 2 )
) set

%==Dialog boxes=============================================================%

"AddbandDlg"
(  (name "Add Rubber Band")
   (list "Direction:"      (Horizontal Vertical))
   (list "Style:"          (Normal Bold Double dOtted))
   (list "Fill:"           (Box Cell Draw-band))
   (button (Insert Cancel) )
) set

"AdvstyDlg" ; ADDED IN 4.20
;dialog box for setting advanced features
(  (  name     "Advanced Settings" )
   (  buffer "Default text:" 1 4 39 )
   (  table "Parent style" NIL 2 5 )
   (  table "Next style" NIL 2 5 )
   (  button   ( "  Ok  " Cancel ) )
) set

"BoxDlg"
(  ( name   "Box Format" )
   ( list   "Column format:"  (Left Right Center Grid Decimal) )
   ( string "Tab character:" )
   ( list   "Alignment:"   (Top Bottom Center Row) )
   ( int    "align at Row:" )
   ( button (Ok Cancel) )
) set

"CellfmtDlg"
(  (name    "Cell Format")
   (list    "Format:" (Left Right Center Grid Decimal))
   (button  (Ok Cancel))
) set

"ChgfmtDlg"
(  ( name   "Paragraph Format")
   NIL
   ( button ( Go Cancel ) )
) set

"ChgnameDlg"
(  ( name   "Change Filename")
   ( string "Filename:")
   (button  (Ok Cancel))
) set

"DateDlg"
(  (name "Date")
   (table "Formats" NIL 12 1)
   (button (Insert Cancel))
) set

"DefkeyDlg"
(  (name    "Key Sequence Name")
   (string  "")
   (button  (Go Cancel))
) set

"DictDlg"
(  ( name "Spell Dictionaries" )
   ( string "Main Dictionary :" )
   ( string "Ram Dictionary :" )
   ( string "sUbject AUX Dictionary :" )
   ( string "Secondary Dictionary :" )
   ( button ( Ok Cancel ) )
) set

"DocDlg"
(  ( name      "Document Format")
   ( unit      "Top margin:" 'v')
   ( unit      "Bottom margin:" 'v')
   ( unit      "Left margin:" )
   ( unit      "Right margin:" )
   ( unit      "paper Width:")
   ( unit      "paper leNgth:" 'v')
   ( unit      "tab Stops:")
   ( unit      "Hyphen threshold:")
   ( list      "orIentation:" ( Portrait Landscape )  )
   ( list      "Widow Control:" ( No Yes ) )
   ( button    ( Ok Cancel )  )
) set

"DoclistDlg"
(  (name "Documents")
   NIL
   (button (Edit "Write" "write All" Cancel))
) set

"EditgrDlg"
(  ( name   <Graphic layout>     )
   ( unit   "clip Left:"   'h'   )
   ( unit   "clip Right:"  'h'   )
   ( unit   "clip Top:"    'v'   )
   ( unit   "clip Bottom:" 'v'   )
   ( unit   "Offset:"      'h'   )
   ( list   "Border:"   ( None Single ) )
   ( list   "Alignment:"   ( Left Center Right ) )
   ( string "Path:" )
   ( button ( Keep Cancel )      )
) set

"ExpascDlg"
(  ( name      "Export ASCII")
   ( string    "Filename:")
   ( list      "Returns:" ( Hard Soft ))
   ( button ( Export Cancel ) )
) set

"FontDlg"
(  ( name   "Font Assignment" )
   NIL
   ( list "Category:" ( Symbol Alphabet ) )
   ( msg "" )
   ( button ( Read Cancel ))
) set

"FontlstDlg"
(  (name "Font List")
   (table "Available fonts" NIL 5 4 )
   (button (Select Read Delete Cancel) )
) set

"FnDlg"
(  ( name   "Footnote Style" )
   ( buffer "Separator:" 1 4 34 )
   ( list   "spAcing:" ( Single "1.5" Double Triple ) )
   ( list   "Position:" ( "page Bottom" "under Text" Endnotes ) )
   ( button ( Ok Cancel )  )
) set

"GlobDlg"
(  (name    "Global Settings" )
   (list    "default Unit:" (Inch Centimeter "Line/column") )
   (list    "status Line:" (Hide Display) )
   (list    "Menu line:" (Hide Display) )
   (list    "ScrollBar:" (None Vert Horz Both) )
   (list    "Insert mode:" (Insert Overtype) )
   (string  "document Directory:" )
   (string  "document Extension:")
   (string  "Backup directory:" )
   (int     "backup Frequency in min.:" )
   (string  "Key sequence file:" )
   (string  "stYle file:" ) ; ADDED IN 4.20
   (button  (Ok "Save Settings" Cancel) )
) set

"GotopgDlg"
(  (name "Goto Page")
   (int "   Page number:")
   (int "   Line number:")
   (button (Go Cancel))
) set

"GraphicsDlg"
(  ( name   <Import Graphics> )
   ( file   "*.pcx;*.tif" NIL )
   ( list   "Type:"  ( Auto PCX TIFF ) )
   ( unit   "Horizontal size:"   'h' )
   ( button  ( Read Cancel ) )
) set

"GrowDlg"
(  ( name   <Grow/Shrink Graphic> )
   ( msg    "" )
   ( unit   "Horizontal size:"   'h' )
   ( unit   "Vertical size:"     'v' )
   ( msg    "" )
   ( button ( Keep Cancel ) )
) set

"GrsetDlg"
(  ( name   <Graphics Settings> )
   ( list   "Display:"   ( Yes No ) )
   ( list   "Border:" ( None Single ) )
   ( list   "Alignment:" ( Left Center Right ) )
   ( unit   "Size:" 'h' )
   ( button ( Keep Cancel ) )
) set

"IndexDlg" ; ADDED IN 4.20
(  ( name   "Index" )
   ( buffer "Word/Phrase" 1 4 39 )
   ( button (OK Cancel) )
) set

"LinedrawDlg"
(  (name "Line Draw" )
   (list "Style:"    (Normal dOtted Bold Double))
   (list "Arrows:"   (None Left/Up Right/Down Both))
   (button (Ok Cancel))
) set

"LabelDlg" ; ADDED IN 4.20
(  ( name "Print Labels" )
   ( list   "Data file type:" ( CW dBase ASCII ))
   ( list   "Delimiters:" (Comma Tab Semicolon))
   ( string "Data file:" )
   ( int    "From record:" )
   ( int    "To record:" )
   ( int    "No. of copies:" )
   ( int    "Labels across page:" )
   ( int    "Labels along page:" )
   ( list   "Send output to:" (LABELS.CHI Printer))
   ( list   "Screen refresh:" ( No Yes ) )
   ( unit   "Margin Offset:" )
   ( list   "Quality:" ( Draft Letter ) )
   ( button ( Go Cancel ) )
) set

"MailmrgDlg" ; ADDED IN 4.20
(  ( name "Mail Merge" )
   ( list   "Data file type:" ( CW dBase ASCII ))
   ( list   "Delimiters:" (Comma Tab Semicolon))
   ( string "Data file:" )
   ( int    "From record:" )
   ( int    "To record:" )
   ( int    "No. of copies:" )
   ( list   "Send output to:" (MAIL.CHI Printer MAIL???.CHI))
   ( list   "Screen refresh:" ( No Yes ) )
   ( unit   "Margin Offset:" )
   ( list   "Quality:" ( Draft Letter ) )
   ( button ( Go Cancel ) )
) set

"MathboxDlg"
(  (name "Math Box")
   (table "Box type" NIL 7 5)
   (button (Insert Cancel) )
) set

"MatrixDlg"
(  (name "Create Matrix")
   (table "Table/Matrix"
      (  "Det" "Left{" "Matrix\[\]" "Matrix\(\)"
         "Plain" "Right}" "Table" "Table\[\]"
      )
      2 4
   )
   (int "# of Rows:")
   (int "# of Columns:")
   (button (Insert Cancel))
) set

"NewdocDlg"
(  (name    "New Document")
   (string  "Filename:")
   (button  (Ok Cancel))
) set

"NewstyDlg" ; ADDED IN 4.20
(  (  name     "Define Style" )
   (  msg      "" )
   (  string   "Style:" )
   (  msg      "" )
   (  button   ( "  Ok  " Cancel ) )
) set

"NumberDlg"
(  ( name "Print Numbering" )
   ( int    "first Page number:" )
   ( int    "first Footnote number:" )
   ( list   "Advance counters:" ( No Yes ) )
   ( msg "" )
   ( table  "Page number font" NIL 2 5 )
   ( table  "Footnote number font" NIL 2 5 )
   ( button ( Ok Cancel ) )
) set

"ParDlg"
(  ( name   "Paragraph Format")
   ( list   "Format:" (Left Right Center Full Grid Table) )
   ( unit   "Left margin:")
   ( unit   "Right margin:")
   ( unit   "Indent:"   )
   ( list   "Spacing:" (Single "1.5" Double Triple) )
   ( unit   "Above:" 'v' )
   ( unit   "Below:" 'v' )
   ( button ( Ok Cancel )  )
) set

"PlaykeyDlg"
(  (name "Key Sequence Playback")
   (table "Key Sequence Names" NIL 5 4 )
   (button  (Play Cancel))
) set

"PrnoptDlg"
(  ( name      "Print Options" )
   ( unit      "Margin offset:" )
   ( list      "Style:"  NIL )
   ( list      "Quality:"  (Draft Letter) )
   ( int       "No. of copies:" )
   ( list      "print tO file:" (No Yes) )
   ( int       "From page:" )
   ( int       "To page:" )
   ( list      "sHeets:" (All Odd Even Single) )
   ( button    ( Print "Keep settings" Cancel ) )
) set

"PrnsetDlg"
(  ( name   "Printer Settings" )
    NIL
   ( table  "Port:" ( LPT1 LPT2 LPT3 COM1 COM2 COM3 PRN XON1 XON2 AUX ) 1 10)
   ( list   "Download:" ( Automatic Manual ) )
   ( button ( Ok "Save Settings" Cancel ) )
) set

"PrnspecDlg"
(  ( name   "Special Features")
   ( msg     "This printer has no special features.")
   ( button (Ok) )
) set

"ReadascDlg"
( ( name    "Read ASCII File" )
  NIL
  ( list    "Returns:" ( Hard Soft ) )
  ( unit    "Tab stops:" )
  ( button  ( Import Merge Cancel ) )
) set

"ReadconDlg"
(  ( name   "Configuration File" )
   NIL
   ( button ( Read Cancel ))
) set

"ReaddocDlg"
(  ( name   "Read Document" )
    NIL
   ( button    ( Read Merge Cancel ) )
) set

"ReadkeyDlg"
(  ( name   "Read Key Sequence File" )
   NIL
   ( button ( Read Cancel ))
) set

"ReadstyDlg" ; ADDED IN 4.20
(  ( name   <Read Style> )
   ( file   "*.STY" NIL ) 
   ( button ( Apply Cancel ) )
) set

"ReformatDlg"
(  ( name   "")
   ( msg    "Changes are detected in print style or driver.")
   ( msg    "Your document must be reformatted before proceeding.")
   ( msg    "" )
   ( button (Ok Cancel))
) set

"ReplDlg"
(  (name    "Search and Replace")
   (buffer  "Search pattern:" 1 8 30 )
   (buffer  "Replacement text:" 1 8 30 )
   (list    "Case:"     (Ignore Match))
   (list    "Font:"     (Ignore Match))
   (button  (Go Abort))
) set

"ScaleDlg"
(  ( name   <Scale Graphic> )
   ( msg    <               > )
   ( unit   "Size:"     'h' )
   ( msg    <               > )
   ( button ( Keep Cancel ) )
) set

"SearchDlg"
(  (name    "Search")
   (buffer  "Search pattern:" 1 8 30 )
   (list    "Case:"     (Ignore Match))
   (list    "Font:"     (Ignore Match))
   (button  (Go Abort))
) set

"StyfmtDlg" ; ADDED IN 4.20
(  ( name NIL )
   ( list   "Format:" (Left Right Center Full) )
   ( unit   "Left margin:" )
   ( unit   "Right margin:" )
   ( unit   "Indent:" )
   ( list   "Spacing:" (Single "1.5" Double Triple) )
   ( unit   "Above:" 'v' )
   ( unit   "Below:" 'v' )
   ( table  "Font" NIL 2 5 )
   ( button ( "   Ok   " "Advanced" " Cancel " ) )
) set

"StyleDlg" ; ADDED IN 4.20
(  ( name   <Styles> )
   ( table  "" NIL 4 5 )
   ( msg "" )
   ( button ( Apply Define " Edit " Remove Write Cancel ) )
) set

"TableDlg"
(  ( name   "Table Format" )
   ( list   "Column format:"  (Left Right Center Grid Decimal) )
   ( string "Tab character:" )
   ( int    "tab Position:" )
   ( int    "column Width:" )
   ( button (Ok Cancel) )
) set

"ThreshDlg"
(  (  (name "Hyphen threshold")
      (unit "Threshold:")
      (button (Ok Cancel) )
   )
) set

"UnitDlg"
(  (name    "Default Unit Setting" )
   (list    "Unit:" (Inch Centimeter "Line/column") )
   ( button ( Go Cancel )  )
) set

"VerDlg" ; CHANGED IN 4.20
(  (msg <ChiWriter 4.20>)
   (msg <Copyright (C) 1992>)
   (msg <Horstmann Software>)
   (msg <Design Corporation>)
   (msg <10 S. Third St. #350>)
   (msg <San Jose, CA 95113>)
   (msg <408/298-0828>)
   (msg <All Rights Reserved>)
   (button (OK))
) set

"WriteDlg"
(  ( name            "Write Document")
   ( string          "File name:")
   ( button ( Write Cancel )  )
) set

"WriteconDlg"
(  ( name   "Configuration file")
   ( string "File name:")
   ( button ( Write Cancel )  )
) set

"WritekeyDlg"
(  ( name   "Write Key Sequence File")
   ( string "Filename")
   ( button ( Go Cancel )  )
) set

"WritestyDlg" ; ADDED IN 4.20
(  ( name   <Write Style> )
   ( string "File name:")
   ( button ( Write Cancel ) )
) set

%==Message Strings==========================================================%

"Assgft" <Assigning font file to font [%d]> set
"Copy" <Block copied to paste buffer> set
"Curgr" <Cursor must be in a graphic> set
"Cut" <Block cut to paste buffer> set
"Curbox" <Cursor must be in a box or table> set
"Endks" <Use [Ctrl-D] to end the key sequence> set
"Fromfont" <Change from font: ([Return] changes all)> set
"Found" <Search completed> set
"Keydef" <Enter the key which you want to define ([Esc] to cancel)> set
"Nameused" <File name was already used in another window!> set
"Nodup" <File already loaded!> set
"Noempty" <Graphic can only be read in an empty paragraph> set
"Nogrchg" <Cannot change graphics format> set
"Nokeys" <Cannot find KEYS.CS> set
"Noks" <No key sequence to play back> set
"Nomark" <Nothing marked!> set
"Nomenu" <Cannot find MENU.CS> set
"Nopdrv" <Cannot open printer driver.  Hit any key to continue.> set
"Noprn" <%s is not for printing!> set
"Noself" <Parent style cannot be itself> set
"Notbl" <Cannot create table paragraph here> set
"Notbox" <Cannot merge inside a box or table> set
"Notfnd" <Pattern not found> set
"Notksname" <Not a key sequence name> set
"Nowin" <No window to close> set
"Openerr" <Cannot open file> set
"Toband" <Please move cursor onto the rubber band you wish to delete> set
"Tofont" <Change to font:> set

%==Dialog Boxes Called from ChiWriter=======================================%

"SpellDbox"
( ( name "Spell Checker" )
  ( check )
  ( button ( Ok "Write to AUX" Cancel ) )
) set

"SpellRbox"
( ( name "Spell Checker" )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( button ( Ok ) )
) set

"HyphenDbox" ; ADDED IN 4.20
(  (name "Hyphenation Is Done")
   (button ( Ok Next Global ) )
) set

"HyphenSbox" ; ADDED IN 4.20
(  ( name   "Show hyphenated word")
   ( string "Hyphenation:" )
   ( button ( Ok "Write to AUX" Cancel )  )
) set

%==Functions called from ChiWriter==========================================%

"response"
; used in sr_srchNrpl()
(  (  ("Yes"      "Replace?" 1)
      ("No"       "Replace?" 0)
      ("Global"   "Replace?" 2)
      ("Cancel"   "Replace?" NIL)
   ) menu2
) def

%---------------------------------------------------------------------------%

"yes/no/write"
; used in dy_ok()
(  (  ("Yes"   "Memory is low.  Delete undos to get memory?" 1)
      ("No"    "Memory is low.  Delete undos to get memory?" 0)
      ("Write" "Memory is low.  Delete undos to get memory?" (0 0 writedoc pop 1))
   ) menu2
) def

%==Date=====================================================================%

; To translate the date key sequence
; - replace m, d, y, mmmm, 'd', etc... with letters appropriate in your language
; - order the DateOpt options by likely usage
; - translate the Shortmonth, Longmonth strings

;e.g. <mmmm d, yyyy> date
;m    -  Month without leading 0
;mm   -  Month with leading 0
;mmm  -  month in short form
;mmmm -  month in long form
;d    -  Day without leading 0
;dd   -  Day with leading 0
;yy   -  Year with last 2 digits
;yyyy -  Year with 4 digits

"_dmy"
(  ('d' 0 'm' 1 'y' 2 NIL NIL)
   case
) def

"DateOpt"
(  <mmmm d, yyyy> ; January 23, 1992
   <mmm. d, yyyy> ; Jan. 23, 1992
   <m/d/yy>       ; 1/23/92
   <mm/dd/yy>     ; 01/23/92
   <mm-dd-yy>     ; 01-23-92
   <d mmmm yyyy>  ; 23 January 1992
   <d-mmm-yy>     ; 23-Jan-92
   <dd-mm-yyyy>   ; 23-01-1992
   <dd/mm/yy>     ; 23/01/92
   <yyyy-mm-dd>   ; 1992-01-23
   <yy-m-d>       ; 92-1-23
   <yy/mm/dd>     ; 92/01/23
)
set

"_Month"
(  (  NIL <Jan> <Feb> <Mar> <Apr> <May> <Jun>
      <Jul> <Aug> <Sep> <Oct> <Nov> <Dec>
   )
   (  NIL <January> <February> <March> <April> <May> <June>
      <July> <August> <September> <October> <November> <December>
   )
)
set

%==Miscellaneous Language-Dependent Procedures==============================%

; Translate the message, and change the keys if necessary

"*qfind"

; direction *qfind --> p
; does a one-letter search
; if direction == 'b' then the search is backwards, otherwise it is forward
; if the user enters a font for the character, then it is font sensitive
; if found, p is the cursor position, otherwise p = NIL

(  <Enter char, [F..] char, [PgUp], [PgDn], [Home], [End], [Ctrl-N/X], [Alt-+/-]> message
   readkey dup
   (  'PgUp'   (pop _qup)
      'PgDn'   (pop _qdn)
      'Home'   (pop _qhome)
      'End'    (pop _qend)
      'Return' (pop _qend)
      'Ctrl-N' (pop "_Qft" 0 set "_Qch" 2 set _qchar)
      'Ctrl-X' (pop "_Qft" 0 set "_Qch" 9 set _qchar)
      'Alt-='  (pop _qfind)
      'Alt--'  (pop _qfind)
      'Esc'    (pop pop)
      NIL      (  dup getkeyfont
                  (  getkeyfont
                     "_Qft" xchg set
                     "_Qch" readkey set
                  )
                  ("_Qch" xchg set "_Qft" 0 set)
                  ifelse
                  _qchar
               )
   ) case
) def

%---------------------------------------------------------------------------%

; Translate the title and the justification names

"*stdparfmt"
(  ( pdefformat pdeflmrg pdefrmrg pdefindent pdefspace pdefabove pdefbelow)
   ParDlg
   copy xchg pop
   dup 0 get copy xchg pop "Default Paragraph Format" 1 put 0 put
   dup 1 get copy xchg pop (Left Right Center Full) 2 put 1 put
   dbox
) def

%---------------------------------------------------------------------------%

"*chiscr"
(  ()
   (  (msg <You are about to enter the ChiScript Interpreter.>)
      (msg <WARNING: If you don't know what you are doing,>)
      (msg <you can seriously damage or lose your documents.>)
      (button (Ok Cancel))
   )
   dialog xchg pop 0 eq? (executive) if
) def

%---------------------------------------------------------------------------%

; These are the tables that need to have have bands added in creation
; Translate the "Table.." strings to the same names as in MatrixBox

"_Tables"
(  "Table"     ("VNormalF" _newtable)
   "Table\[\]" ("VNormalH" _newtable)
   NIL (_newmatrix)
)
set

%---------------------------------------------------------------------------%

; Did you check the version number in VerDlg?
