/********************************************************************
 * GE144.ctl - PC installer control file for Aldus Gallery Effects
 * Classic Art 2
 *
 * Copyright (C) 1992 Aldus Corporation.  All rights reserved.
 *
 * ABSTRACT:
 * All product-specific text goes in the .CTL file.  Nothing in the .RC
 * file should be product-specific.  Both the .CTL and the .RC files
 * must be localized.
 *
 * When localizing, only text in "double quotes" need be translated.
 * (Although, if the names of files on the distribution diskettes have
 * been changed, they'll have to be changed in this control file too.)
 *
 *******************************************************************/

/* The PRODUCT command is required.  
 */
PRODUCT "Classic v2 1.0"

VERSIONREQ "1.03"      /* minimum installer version required */


/* There is one DISK statement for each distribution disk.  It gives
 * the name by which the user will be asked for the disk, and a list
 * of the files on the disk.  In addition to the file names, the list
 * of files contains the sizes of the files (uncompressed, in bytes)
 * and the subdirectories in which the files can be found.  If the
 * file is in the root, the subdirectory can be left off.  The options
 * CHECKDATE or NOREPLACE can be specified after the subdirectory.  Lines
 * are separated by commas.
 *
 * This part of the control file will be created automatically by the
 * Disk Builder Utility.
 */


DISK "1 (1.44MB)"
   {
   (C)ALDUS.'92         63,
   ALDSETUP.EXE     170704  CHECKDATE,
   ALDSETRS.RSL      30208  CHECKDATE,
   GE144.CTL          9043,
   COMMDLG.DL~       89248  CHECKDATE,
   README.TXT         6882,
   ALDVM.DL~         45550  "ALDUS"  CHECKDATE,
   ALDIM.DL~        148512  "ALDUS"  CHECKDATE,
   ALDIMRES.RS~       4080  "ALDUS\USENGLSH"  CHECKDATE,
   ALDVMRES.RS~       5824  "ALDUS\USENGLSH"  CHECKDATE,
   BRICK.TI~         30050  "TEXTURE.ART"  CHECKDATE,
   MARBLE.TI~        30034  "TEXTURE.ART"  CHECKDATE,
   ROCKS.TI~         30050  "TEXTURE.ART"  CHECKDATE,
   STUCCO.TI~        30040  "TEXTURE.ART"  CHECKDATE,
   WOOD.TI~          30038  "TEXTURE.ART"  CHECKDATE,
   GAUZE.TI~         65714  "TEXTURES"  CHECKDATE,
   WOOD1.TI~         65714  "TEXTURES"  CHECKDATE
   }


DISK "2 (1.44MB)"
   {
   (C)ALDUS.'92         63,
   ACCENTED.EF~      74352  "PLUG_IN"  CHECKDATE,
   ANGLEDST.EF~      74368  "PLUG_IN"  CHECKDATE,
   BASRELIE.EF~      74352  "PLUG_IN"  CHECKDATE,
   COLOREDP.EF~      78688  "PLUG_IN"  CHECKDATE,
   DIFFUSEG.EF~      71408  "PLUG_IN"  CHECKDATE,
   GLOWINGE.EF~      74352  "PLUG_IN"  CHECKDATE,
   GRAIN.EF~         82160  "PLUG_IN"  CHECKDATE,
   NOTEPAPE.EF~      73424  "PLUG_IN"  CHECKDATE,
   ACCENTED.HL~       1632  "PLUG_IN"  CHECKDATE,
   ANGLEDST.HL~       1632  "PLUG_IN"  CHECKDATE,
   BASRELIE.HL~       1632  "PLUG_IN"  CHECKDATE,
   COLOREDP.HL~       1632  "PLUG_IN"  CHECKDATE,
   DIFFUSEG.HL~       1632  "PLUG_IN"  CHECKDATE,
   GLOWINGE.HL~       1632  "PLUG_IN"  CHECKDATE,
   GRAIN.HL~          1632  "PLUG_IN"  CHECKDATE,
   NOTEPAPE.HL~       1632  "PLUG_IN"  CHECKDATE,
   GE1SAMPL.HL~       9087  "PLUG_IN"  CHECKDATE,
   PALETTEK.EF~      73936  "PLUG_IN"  CHECKDATE,
   CLASSIC2.HL~      41473  "PLUG_IN"  CHECKDATE,
   PATCHWOR.EF~      76640  "PLUG_IN"  CHECKDATE,
   PHOTOCOP.EF~      70624  "PLUG_IN"  CHECKDATE,
   ROUGHPAS.EF~     162800  "PLUG_IN"  CHECKDATE,
   SPRAYEDS.EF~      73616  "PLUG_IN"  CHECKDATE,
   STAMP.EF~         72832  "PLUG_IN"  CHECKDATE,
   TEXTURIZ.EF~     161120  "PLUG_IN"  CHECKDATE,
   UNDERPAI.EF~     164464  "PLUG_IN"  CHECKDATE,
   PALETTEK.HL~       1632  "PLUG_IN"  CHECKDATE,
   PATCHWOR.HL~       1632  "PLUG_IN"  CHECKDATE,
   PHOTOCOP.HL~       1632  "PLUG_IN"  CHECKDATE,
   ROUGHPAS.HL~       1632  "PLUG_IN"  CHECKDATE,
   SPRAYEDS.HL~       1632  "PLUG_IN"  CHECKDATE,
   STAMP.HL~          1632  "PLUG_IN"  CHECKDATE,
   TEXTURIZ.HL~       1632  "PLUG_IN"  CHECKDATE,
   UNDERPAI.HL~       1632  "PLUG_IN"  CHECKDATE,
   GE1SAMPL.EF~      82128  "PLUG_IN"  CHECKDATE
   }


INITIAL GEDir "C:\CLASSIC2.GE"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus Gallery Effects: Classic Art 2 files."
	" "
	"If this is the directory you want, click OK."
	}

PACKAGE PROLOGUE "" SELECTED INVISIBLE
	{
	SET MustReboot "FALSE"
	SET Answer2 "&Setup"    /* Set to "&Setup" to force computer adjustment of AUTOEXEC.BAT */

	GETALDDIR AldDir
	GETWINSYSDIR WinSysDir
	GETWINDIR WinDir
	}   /* end of Prologue */


DIALOG BadMove "&Setup" "&Manual"
  {
	CAPTION "Modify your system file?"
	TEXT
	{
	"The PATH statement in AUTOEXEC.BAT must include"
	"the Aldus Gallery Effects and Aldus directories in order for"
	"the program to run."
	" "
	"If you want to edit the PATH statement yourself later,"
	"click ""Manual.""  If you want Aldus Setup to modify"
	"the PATH statement, click ""Setup."""
	}
  }

DIALOG AldusGroup "&Continue"
  {
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus group window has been created containing"
	"Aldus Gallery Effects 1.5 and Aldus Setup. Double-click"
	"the Gallery Effects 1.5 icon to open it."
	}
  }

PACKAGE First "" SELECTED INVISIBLE
  {
	SET ExeInstalled "FALSE"
  }

PACKAGE Classic "GE Classic Art 2 (2.4MB)" SELECTED
    {
    CONFIRMDIR GEDir


/*    GETPERSONAL  */               /* ask user for personalization info */


    CONCAT AldDir "USENGLSH" EngDir
    CONCAT EngDir "SETUP" SetupDir
    CONCAT GEDir "TEXTURE.ART" TArtDir
    CONCAT GEDir "TEXTURES" TexturizDir
    CONCAT GEDir "GE_POUCH" PouchDir
    CONCAT PouchDir "PLUG_IN" PlugDir

	
    FILES AldDir
	{
	ALDIM.DL~
	ALDVM.DL~
	}

    FILES EngDir
	{
	ALDIMRES.RS~
	ALDVMRES.RS~
	}

    FILES SetupDir
	{
	ALDSETUP.EXE
	ALDSETRS.RSL
	GE144.CTL
	}

    FILES GEDir
	{
	(C)ALDUS.'92
	README.TXT
	}

    FILES TArtDir
	{
	BRICK.TI~
	MARBLE.TI~
	ROCKS.TI~
	STUCCO.TI~
	WOOD.TI~
	}

    FILES TexturizDir
	{
	GAUZE.TI~
	WOOD1.TI~
	}

    FILES PlugDir
	{
	ACCENTED.EF~
	ANGLEDST.EF~
	BASRELIE.EF~
	COLOREDP.EF~
	DIFFUSEG.EF~
	GLOWINGE.EF~
	GRAIN.EF~
	NOTEPAPE.EF~
	PALETTEK.EF~
	PATCHWOR.EF~
	PHOTOCOP.EF~
	ROUGHPAS.EF~
	SPRAYEDS.EF~
	STAMP.EF~
	TEXTURIZ.EF~
	UNDERPAI.EF~
	ACCENTED.HL~
	ANGLEDST.HL~
	BASRELIE.HL~
	COLOREDP.HL~
	DIFFUSEG.HL~
	GLOWINGE.HL~
	GRAIN.HL~
	NOTEPAPE.HL~
	PALETTEK.HL~
	PATCHWOR.HL~
	PHOTOCOP.HL~
	ROUGHPAS.HL~
	SPRAYEDS.HL~
	STAMP.HL~
	TEXTURIZ.HL~
	UNDERPAI.HL~
	CLASSIC2.HL~
	GE1SAMPL.EF~
	GE1SAMPL.HL~
	}

    FILES WinSysDir
	{
	COMMDLG.DL~
	}
	
    WININI
	{
	"Aldus" "GalleryLangDir" "USENGLSH"
	}

    /* Ask the user if they want their system files checked and
     * updated if necessary.  Record their answer in the variable
     * Answer.
     */

    SET Answer2 "&Setup"    /* Force modification of system files */
/*    DISPLAY BadMove Answer2   *//* Don't display dialog asking user about AUTOEXEC.BAT */
    IF Answer2 EQS "&Setup"
	{
	GETBOOTDRIVE BootDrive
	ONINSTALL
	    {
	    SET MustReboot "TRUE"
	    MODIFY "AUTOEXEC.BAT" BootDrive
		{
		PATH "path" AldDir
		}
	    } /* end oninstall */
	}  /* end if */



/*    CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
    CONCAT GEDir "GALLERY.EXE" FullGalleryName
    ONINSTALL
	{
	ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
	ADDPROGRAMITEM "Aldus" FullGalleryName "Gallery Effects 1.5" FullGalleryName 0
	DISPLAY AldusGroup
	} */

/*
    ONINSTALL
	{
	PERSONALIZE GEDir "GALLERY.EXE"     
	}
*/


    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
	{
	WINDOWSMENU GEDir "README.TXT" "&README.TXT" 
	}
    SET ExeInstalled "TRUE"
    }   /* end Gallery package */


DIALOG SucRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"The Aldus Gallery Effects Classic Art 2 files"
	"have been installed."
	" "
	"Please read the Aldus Gallery Effects README.TXT"
	"file, which has been added to the View menu of the"
	"Aldus Setup Main Window."
    }
}

DIALOG SucNoRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
    }
}

DIALOG RebootReminder "&OK"
{
    TEXT
	{
	"Your AUTOEXEC.BAT file has been changed."
	"You must restart your machine before running"
	"Aldus Gallery Effects Classic Art 2."
	}
}

PACKAGE Last "" SELECTED INVISIBLE
 {
    IF ExeInstalled EQS "TRUE"
	{  
	ONINSTALL
		{
		DISPLAY SucRead
		}
	}
    IF ExeInstalled EQS "FALSE"
	{
	ONINSTALL
		{
		DISPLAY SucRead
		}
	}
 }

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
    IF MustReboot EQS "TRUE"
	{
	DISPLAY RebootReminder
	}
    }
