/******************************************************************

Description:    WordPerfect 5.0 Run Exec.

Details:        This exec is used to run the WordPerfect program.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used as command params to
                WP.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/* Give header */
say
say ' WordPerfect 5.0'
say ' ---------------'
say


/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'WordPerfect')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'WORDPERFECT', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
      call RxOS2Ini , 'WORDPERFECT', 'WORKDIR', '$RXDEL'
   end
   else Local.Directory = ''
end

/* If not there then ask user */
do forever
   if Local.Directory = '' | rxDirExist(Local.Directory)=0 then do

     say ' Enter a local directory where WordPerfect files will be saved:'
     Local.Directory = translate(linein('STDIN'))
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
        leave
     end
     else do
      say d2c(7)
      say ' Invalid Directory.  Please enter a valid directory.'
     end
   end
   else leave
end  /* Do Forever */


/** Run WordPerfect 5.0 **/
say
say ' Starting WordPerfert 5.0...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while WP 5.0 is loaded.'
say '       ( This may take more than a minute )'
'WP /PS='Local.Directory' /D='Local.Directory
'exit'
