/******************************************************************

Description:    WordPerfect 5.0 Installation Exec.

Details:        This exec is used to install WordPerfect.

                Installation really only consists of asking the
                user for a local directory spec in which to
                store local files.  This info is stored in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

say
say ' WordPerfect 5.0 Installation'
say ' ----------------------------'
say

/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'WordPerfect')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'WORDPERFECT', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
      call RxOS2Ini , 'WORDPERFECT', 'WORKDIR', '$RXDEL'
   end
end

/* Let user change it */
do forever
   if rxDirExist(Local.Directory)=1 then do
    say ' Current local directory = 'Local.Directory
    say
   end
   say ' Enter a local directory where WordPerfect files will be saved:'
   Local.Directory = translate(linein('STDIN'))
   if Local.Directory<>'' then do
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
        leave
     end
   end
   say d2c(7)
   say ' Invalid Directory.  Please enter a valid directory.'
end  /* Do Forever */

/* Give message */
say
say ' WordPerfect is now ready to run.'
say
call RxPause

'exit'
