/******************************************************************

Description:    SPSS Run Exec.

Details:        This exec sets up the appropriate SPSS environment
                then executes SPSS.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR PACKAGE.
                HIDEWIN.EXE - Part of VENDOR PACKAGE.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   SPSS Statistics for OS/2

******************************************************************/
'@echo off'
trace 'o'


/* Load externals */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'


/* Get drive letter being used and set vars */
parse upper source . . drv
drv = left(drv,2)
env = 'OS2ENVIRONMENT'                /* Short Hand */
Session = 'SPSS Statistics for OS/2'  /* Session title (used by HIDEWIN) */


/* Give header */
say
say 'SPSS Statistics for OS/2'
say '------------------------'
say


/* Check local directory */
Local.Directory = RxOS2Ini(, 'SPSS', 'WORKDIR')
if RxDirExist(Local.Directory)=0 then do
  say d2c(7)
  say ' Local SPSS directory does not exist or could'
  say ' not be determined.'
  say
  say ' You must run the SPSS installation program before'
  say ' running SPSS.'
  say
  call RxPause
  'exit'
end
else do
  say ' Local SPSS directory = 'Local.Directory
  say
end


/* Give message that we are starting the program */
say ' Starting the SPSS program.'
say ' This will take a few moments, please be patient.'
say
say ' Once SPSS has started, this window will be hidden.'
say ' This window must be present for SPSS to run.....'


/* Setup session and run SPSS */
call value 'PATH',    drv'\;'value('PATH', ,env),  env
call value 'DPATH',   drv'\;'value('DPATH', ,env), env
call value 'SPSS',    drv'\',                      env
call value 'SPSSTMP', Local.Directory'\TEMP',      env
call directory Local.Directory
'start hidewin /D=10 'Session
'spsspm.exe'
'exit'
