/******************************************************************

Description:    Smalltalk/V PM Installation Exec.

Details:        Query user for name of local directory for
                 Smalltalk files, create directory (if needed),
                 and record directory spec in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Par of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: None
   Window Type: FS/Win
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

/* Load externals */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'


/* Give header */
say
say ' Smalltalk/V PM Installation'
say ' ---------------------------'
say


/* Setup a few vars */
parse source . . Drv
Drv = left(Drv,2)


/* Give current setting */
Local.Directory = RxOS2Ini(, 'SMALLTALK', 'WORKDIR')
if RxDirExist(Local.Directory)=1 then do
  say 'Current local directory = 'Local.Directory
end


/* Query user */
do forever
     say
     say ' Enter a local directory where your SmallTalk/V PM source files'
     say ' will be saved: '
     Local.Directory = linein('STDIN')
     if Local.Directory<>'' then do
       call rxMkDir Local.Directory
       if rxDirExist(Local.Directory) then do
          call RxOS2Ini , 'SMALLTALK', 'WORKDIR', Local.Directory
          leave
       end
     end
     say d2c(7)
     say ' Invalid Directory.  Please enter a valid directory.'
end  /* Do Forever */


/** Add drive entry to LIBPATH statement if needed **/
call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your C:\CONFIG.SYS file.  You must reboot before Smalltalk/V'
  say ' will run correctly.'
  say
end
else do
  say
  say ' Smalltalk/V PM is ready to run on your PC.'
  say
end
call RxPause
'exit'
