/******************************************************************

Description:    PMWORD Run Exec.

Details:        This exec determines a local directory spec
                and starts PMWORD.

                It will start it from the local directory if
                the PMWORD directory is in the LIBPATH.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
trace 'O'
'@echo off'

env = 'OS2ENVIRONMENT'  /* Short Hand */
Session = 'Word for OS/2'  /* Session title (used by HIDEWIN) */

/* Load external funcs */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

localpath=RxOs2Ini('USER', 'Microsoft Word', 'INI-PATH')
if (CurrINI = '$RXERROR') then do
     say
     say ' Please run installation program first'
     say
     call RxPause
     'exit'
end
localdrive=left(localpath,1)

parse source . . exec
path=left(exec, lastpos('\', exec))

call LIBEDIT path 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC', , 'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'path' entry has just been added to the LIBPATH statement'
  say ' of your CONFIG.SYS file.  You must reboot before PMWord'
  say ' will run correctly.'
  say
  say ' PMWord will be started this time, but will not work again'
  say ' until you reboot.'
  say
  call RxPause
end
else do
  call value 'PATH', path';'value('PATH', ,env), env
  call value 'PATH', drv'\;'value('PATH', ,env), env
  call directory localpath
end

say
say 'PMWord starting ....'
'start hidewin /D=3 'Session
'PMWord'
'exit'
