/******************************************************************

Description:    Freelance 4.0 Run Exec

Details:        This exec calls the DOSEXE.EXE program to execute
                the Freelance 4.0 program, FL.COM, from within
                the DOS box.

                Parameters to the DOSEXE.EXE program are actually
                commands to be run in the DOS box.

                The exec also asks the user what local directory
                was created by FLINSTAL, and stores said info in
                OS2.INI where the Freelance Run exec may get it.

                This exec also uses NET USE to assign the LOTUSLOT
                license alias.  The administrator must update the
                'Lic' variable as needed.             This UNC name
                is required in the PATHFILE file contained in the
                FLPLUS.V31 subdirectory of the license alias.
                Since this UNC name can be random (due to Vendor's
                dynamic licensing) the PATHFILE file is created
                or updated every time a user executes this exec.

Dependencies:
   Externals:   RXUTILS.DLL  - See RXUTILS PACKAGE on OS2TOOLS.
                HIDEWIN.EXE  - Part of VENDOR package.
                GIME.EXE     - See GIME PACKAGE on OS2TOOLS.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   Freelance 4.0 (Dos)
******************************************************************/
trace 'O'
'@echo off'

/*******************************************/
/** Give greetings messages               **/
/*******************************************/
say;
say 'Freelance 4.0 (DOS)'
say '-------------------'; say

/***************************************/
/** Initialize vars that might change **/
/***************************************/
PreApp  = ''                     /* Set COM1 for Plotter in DOS Box */
PostApp = ''                     /* Reset COM1 for Plotter in OS/2 */
App     = 'FL.COM'               /* Dos application to run          */
Params  = '/S'                   /* Parameters to DOS app (if any)  */
Session = 'Freelance 4.0 (DOS)'  /* Session title (used by HIDEWIN) */
Lic = 'Y:'                       /* Default License Drive           */

/*******************************************/
/** Initialze vars that will never change **/
/*******************************************/
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'
parse upper source . . fspec              /* Get full exec fspec   */
Dir = left(fspec, lastpos('\', fspec)-1)  /* Get full dir name     */
Drive = left(fspec,2)                     /* Get the drive letter  */
LocDir = RxOS2Ini(, 'Directories', 'FLV4')
if LocDir='$RXERROR' then do
 say d2c(7)
 say 'You must run the Freelance installation program before'
 say 'running Freelance.'; say
 call RxPause
 'EXIT'
end
'NET USE 'Lic' LOTUSLOT'
if RC<>0 then do
 say;
 say 'An error was encountered setting up the Freelance environment.'
 say 'Please append this problem to the CORE FORUM.'; say
 call RxPause
 'EXIT'
end
Unc=GetUncName(Lic)

stem.0=1; stem.1=Unc
call RxWrite Lic'\FLGDOS.V40\PATHFILE.', 'STEM.'
say; say 'Local directory is 'LocDir
say 'Starting Freelance in the DOS Box...'; say
say '    [ Symbol libraries located in:  'Drive'\SYMBOLS]'
say '    [ IBM Hardware Symbol library located in:  'Drive'\FL_IBM]'
say

COMport = RxOS2Ini(, 'FLCOMPORT', 'ACTIVE')
if COMport<>'$RXERROR' then do
   PreApp='SETCOM40 'COMport'=ON'
   PostApp='SETCOM40 'COMport'=OFF'
   say 'The DOS Box will be configured for 'COMport'...'
end

/******************************************************/
/** Stay in this loop until the user aborts or until **/
/** the DOS program is run successfully.             **/
/******************************************************/
call directory LocDir
'START HIDEWIN 'Session'>NUL 2>&1'
App' 'Params
'GIME LOTUSLOT /D>NUL 2>&1'
'EXIT'



/**************************************************/
/** GetUncName(Drive)                            **/
/**                                              **/
/** Uses NET USE to determine the UNC Name for a **/
/** particular LAN attached drive.               **/
/**                                              **/
/** The drive letter is returned.                **/
/**************************************************/
GetUncName: procedure
parse arg Drive .
do queued(); pull .; end
'NET USE 'Drive' | RXQUEUE'
pull .
parse pull line with . . Unc .
return Unc



/**************************************************/
/** YesNoPrompt(prompt)                          **/
/**                                              **/
/** Procedure which excepts a prompt and prompts **/
/** the user for a Y/N response.                 **/
/**************************************************/
YesNoPrompt: procedure
parse arg prompt
call RxSay prompt||' [Y/N] > '
do until resp='Y' | resp='N'
   resp = translate(RxGetKey('NOECHO'))
   if resp<>'Y' & resp<>'N' then call RxSay D2C(7)
end
say resp
return resp
