/******************************************************************

Description:    DeScribe 3.0 Run Exec.

Details:        This exec is used to run the DeScribe program.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used as command params to DeScribe.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: Work files (tutorial, layouts, clipart) must be
                in a local directory in order to be edited.
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/* Give header */
say
say ' DeScribe'
say ' --------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'DScribe3')

/* Let user change it */
do forever
  if rxDirExist(Local.Directory)=0 then do
    say ' Local DeScribe directory not set.'
    say ' Enter a local directory where DeScribe files will be saved:'
    Local.Directory = strip(left(translate(linein('STDIN')), 11))
    if Local.Directory<>'' then do
      call rxMkDir Local.Directory
      call rxMkDir Local.Directory'\temp'
      call rxMkDir Local.Directory'\usrdicts'
      if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'DScribe3', '$RXDEL'
        call RxOS2Ini , 'Directories', 'DScribe3', Local.Directory
       leave
      end
    end

    else do
      say d2c(7)
      say ' Invalid Directory.  Please enter a valid directory.'
  end
end  /* Do Forever */

/* Set up the TMP Environment Variable */
   call value 'TMP', Local.Directory'\temp', 'OS2ENVIRONMENT'

/** Change to local directory **/
call directory Local.Directory


/** Prepend remote drive to current PATH and DPATH **/
Env = 'OS2ENVIRONMENT'
parse source . . drv
drv = left(drv,3)
call value 'PATH',  drv';'||value('PATH',,Env), Env
call value 'DPATH', drv';'||value('DPATH',,Env), Env


/** Run DeScribe **/
say
say ' Starting DeScribe...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while DeScribe is loaded.'
say '       ( This may take more than a minute )'
say
say ' Once DeScribe has started this window will be'
say ' hidden...'
'START HIDEWIN /D=20 DeScribe'
'DESCRIBE'
'exit'
