/******************************************************************

Description:    Aldus PageMaker 3.01 Run Exec.

Details:        This exec is used to run the PageMaker program.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used as command params to PageMaker.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'


/* Give header */
say
say ' Aldus PageMaker'
say ' ---------------'
say


/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'AldusPM')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'ALDUSPM', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'AldusPM', Local.Directory
      call RxOS2Ini , 'ALDUSPM', 'WORKDIR', '$RXDEL'
   end
end

/* If not there then ask user */
do forever
   if Local.Directory = '' | rxDirExist(Local.Directory)=0 then do

     say ' Enter a local directory where PageMaker files will be saved:'
     Local.Directory = translate(linein('STDIN'))
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'AldusPM', Local.Directory
        leave
     end
     else do
      say d2c(7)
      say ' Invalid Directory.  Please enter a valid directory.'
     end
   end
   else leave
end  /* Do Forever */

/** Setup Env Vars **/
parse source . . dir
dir = left(dir, lastpos('\', dir)-1)
Env = 'OS2ENVIRONMENT'
call value 'PATH', dir';'value('PATH',,Env), Env
call value 'DPATH', dir';'value('DPATH',,Env), Env
call value 'PMCONFIG', Local.Directory, Env
call value 'PMDICT', Local.Directory, Env
if value('TEMP',,Env)='' then
  call value 'TEMP', Local.Directory, Env

/** Run Aldus PageMaker **/
say
say ' Starting Aldus PageMaker...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while PageMaker is loaded.'
say '       ( This may take more than a minute )'
say
say ' Once PageMaker has started this window will be'
say ' hidden...'
'START HIDEWIN /D=20 Aldus PageMaker'
'PMPM'
'exit'
