/******************************************************************

Description:    AutoDesk AutoCAD Run Exec.

Details:        This exec is used to run the ACAD.EXE program.
                It checks that a math coprocessor is in the
                workstation and reads Autocad local directory
                information from OS2.INI.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used to set the environment
                variables ACAD and ACADCFG which are used
                by the ACAD program.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package
                HIDEWIN.EXE - Part of VENDOR package
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   AutoCAD for OS/2 Rel. 10
******************************************************************/
trace 'o'
'@echo off'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

 say
 say ' AutoDesk AutoCAD'
 say '------------------'
 say

 mathco = RxDevConfig('MATHCO')

 if mathco = 0 then do
    say
    say d2c(7)
    say ' A Math Coprocessor is not present in this machine.'
    say ' AutoCAD requires a Math Coprocessor to run properly.'
    say
    call RxPause
 end
 else do
   /* Check if it already exists */
   Local.Directory = RxOS2Ini(, 'Directories', 'AUTOCAD')
   if Local.Directory = '$RXERROR' then do
      Local.Directory = RxOS2Ini(, 'AUTOCAD', 'LOCALDIR')
      if Local.Directory <> '$RXERROR' then do
         call RxOS2Ini , 'Directories', 'AUTOCAD', Local.Directory
         call RxOS2Ini , 'AUTOCAD', 'LOCALDIR', '$RXDEL'
      end
   end
    do while rxDirExist(Local.Directory)=0
      /* Get the valid local drives, remove the VDISK, prompt user */
      DrvMap = RxDriveMap('C:', 'LOCAL' )
      parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
      if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

      say
      say ' AutoCAD drawings will be saved on your workstation.'
      say ' Valid local Drives:' DrvMap
      say
      say ' Enter a local directory where AutoCad files will be saved:'
      say

      OK=0
      do until OK=1
         Local.Directory = translate( LINEIN('STDIN') )
         if POS( left(Local.Directory,2), DrvMap) <> 0 then OK=1
      end /* do */

      call rxMkDir(Local.Directory)
      if rxDirExist(Local.Directory)=1 then
        call RxOS2Ini , 'Directories', 'AUTOCAD', Local.Directory
      else
        say d2c(7)||' Cannot create directory.  Try again....'
    end
    if rxFileExist( Local.Directory'\ACAD.CFG' )=0 then do
      say 'Copying default ACAD.CFG file to 'Local.Directory
      'COPY ACAD.CFG 'Local.Directory'\ACAD.CFG > NUL'
    end
    say
    say ' Loading AutoCAD....'
    say
    say ' Local directory = 'Local.Directory
    say
    say ' Once AutoCAD has started, this window will be hidden.  This'
    say ' window must be present for AutoCAD to run.....'
    say
    say ' This can take up to 30 seconds.  Please Wait...'
    call value 'ACAD',    Local.Directory, 'OS2ENVIRONMENT'
    call value 'ACADCFG', Local.Directory, 'OS2ENVIRONMENT'
    'START HIDEWIN /D=30 AutoCAD for OS/2 Rel. 10'
    'ACAD.EXE'
 end
'exit 0'
