/******************************************************************

Description:    123R3 Executions Exec.

Details:        This exec is used to execute 123R3.

                Installation really only consists of asking the
                user for a local directory spec in which to
                store local files.  A little helpful info on running
                the 123R3 INSTALL program is also give.

Dependencies:
   Externals:   RXUTILS.DLL - \AUXPROGS subdir of inst disk.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

/** Load externals **/
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/** Setup misc vars **/
LicAlias='LOTUSLOT'       /* IMPORTANT - Change License Alias name if needed */
Env='OS2ENVIRONMENT'
parse source . . drv
drv=left(drv,2)


/** Give Header **/
say
say ' 123/R3'
say ' ------'
say


/* Check if 123R3 local Directory it already exists */
Local.Directory = RxOS2Ini(, 'Directories', '123R3')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, '123R3', 'LOCALDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', '123R3', Local.Directory
      call RxOS2Ini , '123R3', 'LOCALDIR', '$RXDEL'
   end
end
if Local.Directory = '' | rxDirExist(Local.Directory)=0 then do
   say ''
   say ' ERROR - You must run the 123/R3 Installation program'
   say '         before running 123/R3.'
   call RxPause
   'exit'
end


/** Change to local directory **/
call directory Local.Directory   /* Change to local subdirectory */
say ' Local directory = 'Local.Directory; say


/***********************************************************
** Assign License Drive:                                  **
***********************************************************/
say ' Initializing LOTUS License Drive...'; say
do queued(); pull .; end
'net use y: 'LicAlias
if rc<>0 then do
  say d2c(7)
  say ' Error assigning LOTUS License Drive.'
  say ' Please contact an OS/2 consultant.'; say
  call RxPause
  'exit'
end


/** Setup new dpath for license drive entry and path for exe use **/
call value 'DPATH', drive';'value('DPATH', ,Env), Env
call value 'PATH', drv';'value('PATH', ,Env), Env


/** Start the application **/
say ' Starting 123/R3...'
'123'                     /* Run Program */


/** Drop license drive and exit **/
'net use y: /d>nul'  /* Drop license drive */
'exit'
