/******************************************************************

Description:    123R3 Installation Exec.

Details:        This exec is used to install 123R3.

                Installation really only consists of asking the
                user for a local directory spec in which to
                store local files.  A little helpful info on running
                the 123R3 INSTALL program is also give.

Dependencies:
   Externals:   RXUTILS.DLL - \AUXPROGS subdirectory of inst disk.
                LIBEDIT.CMD - \FRNTENDS subdirectory of inst disk.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

/** Load external functions **/
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/** Get/Set misc vars **/
parse source . . drv
drv=left(drv,2)

Local.Directory = RxOS2Ini(, 'Directories', '123R3')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, '123R3', 'LOCALDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', '123R3', Local.Directory
      call RxOS2Ini , '123R3', 'LOCALDIR', '$RXDEL'
   end
end


/** Give header **/
say
say ' 123/R3 Installation'
say ' -------------------'


/* Get the valid local drives, remove the VDISK, prompt user */
DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/** Let user change local dir **/
do forever
   if rxDirExist(Local.Directory)=1 then
      say ' Current 123R3 local directory = 'Local.Directory

   say
   say ' Lotus 123 files you create will be saved on your workstation.'
   say ' Valid local Drives:' DrvMap
   say
   say ' Enter a local directory where 123R3 files will be saved:'
   say

   OK=0
   do until OK=1
      Local.Directory = translate( LINEIN('STDIN') )
      if POS( left(Local.Directory,2), DrvMap) <> 0 then OK=1
   end /* do */

   call rxMkDir(Local.Directory)
   if rxDirExist(Local.Directory)=1 then do
     call RxOS2Ini , 'Directories', '123R3', Local.Directory
     leave
   end
   else
     say d2c(7)||' Cannot create directory.  Try again....'
end  /* Do Forever */


/** Give user info about running install program **/
say
say ' Important information about 123R3 INSTALL program (Please Read):'
say ' ---------------------------------------------------------------'
say
say ' The 123R3 INSTALL will ask you what you would like to save your'
say ' local configuration file (DCF) as.'
say
say ' At the '"'SPECIFYING YOUR DCF'"' panel make sure to enter the'
say ' following:'
say
say  '          'Local.Directory'\123'
say
call RxPause ' Press any key to run INSTALL program...'


/** Run the install program **/
say ' Loading 123/R3 Installation Program.  Please Wait...'
'INSTALL'


/** Add drive entry to LIBPATH statement if needed **/
call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC', , 'OS2ENVIRONMENT')
if LibEditRC=0 then do
  call RxCls
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your C:\CONFIG.SYS file.  You must reboot before 123/R3'
  say ' will run correctly.'; say
end
else do
  call RxCls
  say
  say '123/R3 is ready to run on your PC.'; say
end
call RxPause
'EXIT'
