echo off 
rem =========================================================================
rem STACDOS5.BAT - Version 3.00.100, MS-DOS 5.0 Upgrade Batch File
rem =========================================================================
rem Purpose:
rem   To facilitate an installation of the MS-DOS 5.0 Upgrade on those systems
rem   where Stacker is already installed. This includes updating the system
rem   files residing on the Stacker drive, as well as updating those device
rem   drivers which can be located, on either the uncompressed drive or
rem   the Stacker drive.
rem 
rem Assumptions: 
rem   The batch file MUST be run from the Stacker directory on the Stacker
rem   drive.
rem 
rem Parameters (first three required):
rem   %1 = PASS 1: drive letter to install from (A, B, A:, or B:)
rem      = PASS 2: drive & directory name of DOS directory on boot drive
rem   %2 = PASS 1: drive letter for Stacker drive with the DOS directory (eg., C:)
rem        PASS 2: full path to stacker directory
rem   %3 = PASS 1: name of the DOS directory on the Stacker drive (eg., \DOS)
rem        PASS 2: 2, to indicate second pass processing
rem   %4 = PASS 1: path to Stacker directory (if other than \STACKER)
rem 
rem Environment variables used:
rem   _b = drive letter of real boot drive (uncompressed), with ':' 
rem        character appended
rem   _d = user's DOS directory name; must have leading '\' on it
rem  _hd = hard drive letter for DOS directory (must be a Stacker drive)
rem  _fd = floppy drive letter for drive DOS 5 is installed from 
rem  _fs = floppy diskette size; _f=3 means 3.50", _f=5LD means 5.25" 360kb,
rem        _f=5HD means 5.25" 1.2mb
rem  _sp = path to Stacker directory if other than \STACKER (no drive letter)
rem
rem Troubleshooting:
rem   The batch file creates a file called STACDOS5.LOG in the root directory 
rem   of the uncompressed drive. This log file is eventually moved to the
rem   Stacker directory on the uncompressed drive. Echo statements are used
rem   to append to the file so that tech support can know how far the process
rem   got if it fails.
rem =========================================================================
rem Flow of processing...
rem 
rem PASS 1:
rem   Verify that there are three parameters.
rem   Check for sufficient environment space.
rem   Check for user supplied path to Stacker directory and verify (%4).
rem   Check for SATTRIB, SWAPMAP and DRVTYPE in Stacker directory.
rem   Determine the real boot drive using SWAPMAP.
rem   Verify the drive letter (%1).
rem   Verify the DOS directory name specified (%2).
rem   Verify that the drive for the DOS directory is on a Stacker drive (%3).
rem   Verify that VIDTYPE.EXE is in the Stacker directory.
rem 
rem   Display the welcome screen with user instructions.
rem   Rename CONFIG.SYS and AUTOEXEC.BAT for later restoration.
rem   Prompt for diskette containing EXPAND.EXE and copy it.
rem   Prompt for distribution diskettes and expand files into DOS directory.
rem   Delete .COM versions of old DOS files which are .EXE in DOS 5.0.
rem   Update driver files in root, DOS, and Windows directories as needed.
rem   Update COMMAND.COM and system files on Stacker drive.
rem   Create correct DOSSHELL based on video type.
rem   Prepare for pass 2 by copying ourselves to the boot disk.
rem   Transfer control to Setup /M.
rem 
rem PASS 2:
rem   Restore config.sys and autoexec.bat from Stacker directory. 
rem   Cleanup after SETUP /M (copy files to dos directory).
rem   Instruct the user to reboot and exit.
rem =========================================================================
rem Clear environment in case of restarting from error condition
set _b=
set _d=
set _fd=
set _fs=
set _hd=
set _sp=

rem Check for version switch
if not %1!==/! goto start
if %2!==v! goto dispver
if %2!==V! goto dispver
goto start

:dispver
cls
echo STACDOS5.BAT - 3.00.100, (c) Copyright 1991-92 Stac Electronics, Carlsbad, CA         
echo.
goto alldone

:start
rem If third parameter is 2, then it's time for PASS 2.
if %3!==2! goto pass2

rem PASS 1 Process.

rem Verify that there are three parameters.
if %1!==! goto noparms
if %2!==! goto noparms
if %3!==! goto noparms

rem Check for sufficient environment space. This check will fail for one
rem of 2 reasons: 1) not enough environment, and 2) DOS version prior to
rem 3.1. Those DOS versions don't handle environment vars in batch files.
:chkenv
set _b=1234567890123456789012345678901234567890
if %_b%==1234567890123456789012345678901234567890 goto chkenv_e
goto nospace
:chkenv_e
set _b=

set _hd=%2
set _d=%3

if exist %_hd%%_d%\chkdsk.com goto chkstdir
if exist %_hd%:%_d%\chkdsk.com goto addcolon

rem Check to see if we're updating from MS-DOS 5.0
if exist %_hd%%_d%\chkdsk.exe goto chkstdir
if not exist %_hd%:%_d%\chkdsk.exe goto direrr1

:addcolon
set _hd=%_hd%:

:chkstdir
rem Check to see if the Stacker directory exists on the user supplied path 
if %4!==! goto defsp
set _sp=%4
if exist %_hd%%_sp%\sdir.exe goto ckstkr
goto nostdir
:defsp
set _sp=\stacker

rem Make sure the drive for the DOS directory is a Stacker drive.
:ckstkr
%_hd%%_sp%\drvtype %_hd%
if errorlevel 3 goto notstkr2
if errorlevel 2 goto chkvidtyp
goto notstkr2

:chkvidtyp
if not exist %_hd%%_sp%\vidtype.exe goto novid
if not exist %_hd%%_sp%\datetest.com goto novid

rem Check to see that we're in the Stacker directory. We need to be here
rem so we can use the SATTRIB, SWAPMAP, and DRVTYPE commands later on.
if not exist %_hd%%_sp%\swapmap.com goto notstkr1
if not exist %_hd%%_sp%\drvtype.exe goto notstkr1
if exist %_hd%%_sp%\sattrib.com goto bootdrv
if exist %_hd%%_sp%\sattrib.exe goto bootdrv
goto notstkr1

rem Find out what the real boot drive is.
:bootdrv
%_hd%%_sp%\swapmap c:
if errorlevel 26  goto noboot
if errorlevel 25  goto bootZ
if errorlevel 24  goto bootY
if errorlevel 23  goto bootX
if errorlevel 22  goto bootW
if errorlevel 21  goto bootV
if errorlevel 20  goto bootU
if errorlevel 19  goto bootT
if errorlevel 18  goto bootS
if errorlevel 17  goto bootR
if errorlevel 16  goto bootQ
if errorlevel 15  goto bootP
if errorlevel 14  goto bootO
if errorlevel 13  goto bootN
if errorlevel 12  goto bootM
if errorlevel 11  goto bootL
if errorlevel 10  goto bootK
if errorlevel  9  goto bootJ
if errorlevel  8  goto bootI
if errorlevel  7  goto bootH
if errorlevel  6  goto bootG
if errorlevel  5  goto bootF
if errorlevel  4  goto bootE
if errorlevel  3  goto bootD
if errorlevel  2  goto bootC
goto noboot

:bootC
set _b=C:
goto bootdon

:bootD
set _b=D:
goto bootdon

:bootE
set _b=E:
goto bootdon

:bootF
set _b=F:
goto bootdon

:bootG
set _b=G:
goto bootdon

:bootH
set _b=H:
goto bootdon

:bootI
set _b=I:
goto bootdon

:bootJ
set _b=J:
goto bootdon

:bootK
set _b=K:
goto bootdon

:bootL
set _b=L:
goto bootdon

:bootM
set _b=M:
goto bootdon

:bootN
set _b=N:
goto bootdon

:bootO
set _b=O:
goto bootdon

:bootP
set _b=P:
goto bootdon

:bootQ
set _b=Q:
goto bootdon

:bootR
set _b=R:
goto bootdon

:bootS
set _b=S:
goto bootdon

:bootT
set _b=T:
goto bootdon

:bootU
set _b=U:
goto bootdon

:bootV
set _b=V:
goto bootdon

:bootW
set _b=W:
goto bootdon

:bootX
set _b=X:
goto bootdon

:bootY
set _b=Y:
goto bootdon

:bootZ
set _b=Z:
:bootdon
rem Begin creating LOG file on boot drive.
if exist \stacdos5.log del \stacdos5.log
echo STACDOS5.BAT start.>> %_b%\stacdos5.log
echo Boot drive is %_b% >> %_b%\stacdos5.log

rem Check for a Stacker directory on the user's boot drive.
rem If one doesn't exist, create it.
copy %_hd%%_d%\command.com %_b%%_sp%\command.com > nul
if exist %_b%%_sp%\command.com goto dofiles
mkdir %_b%%_sp% > nul
copy %_hd%%_d%\command.com %_b%%_sp% > nul
if not exist %_b%%_sp%\command.com goto nostroot

:dofiles
del %_b%%_sp%\command.com > nul

rem Check for presence and validity of the drive letter parameter.
if %1==a: goto setdrv
if %1==A: goto setdrv
if %1==b: goto setdrv
if %1==B: goto setdrv
if %1==a  goto setdrv
if %1==A  goto setdrv
if %1==b  goto setdrv
if %1==B  goto setdrv
goto nodrive

rem Set drive letter variable.
:setdrv
if %1==a: set _fd=A:
if %1==A: set _fd=A:
if %1==b: set _fd=B:
if %1==B: set _fd=B:
if %1==a  set _fd=A:
if %1==A  set _fd=A:
if %1==b  set _fd=B:
if %1==B  set _fd=B:

rem We're done error checking, let's tell them why we're here. This is
rem the normal opening screen for the target audience.
cls
echo         Welcome to the MS-DOS 5.0 Upgrade for Stacker users.
echo         ----------------------------------------------------
echo This process will allow you to upgrade your system to MS-DOS 5.0. During
echo this process you will be prompted to insert each of your MS-DOS 5.0
echo Upgrade diskettes. All of the DOS command files and drivers on your
echo system will be updated.
echo.
echo This process will take approximately 20 minutes.
echo.
echo You will need at least 3 MB of disk space on your Stacker drive.
echo.
echo You will also need at least 650 KB of disk space on your uncompressed
echo boot drive.
echo.
echo ********
echo WARNING: IF YOU PERFORM YOUR MS-DOS 5.0 UPGRADE USING THIS PROCEDURE, 
echo ******** YOU WILL NOT BE ABLE TO USE THE MS-DOS 5.0 UNINSTALL FEATURE
echo          TO RETURN TO YOUR OLD DOS VERSION.
echo.
echo If You need to Exit At This Time, Press CTRL-C, then Y.
echo. 
pause
cls
dir %_b% /w
echo                    --------------------
echo                             ^
echo                             :
echo                             :
echo If the number displayed above as "bytes free" is less than 650,000, 
echo be sure to do the following:
echo.
echo   1. Press Ctrl-C to exit this process.
echo   2. Make at least 650 KB available on drive %_b%. You can do this by
echo      deleting unnecessary files or backing up files to diskettes.
echo   3. Re-run this batch file.
echo.
echo If there is sufficient space available, you may continue this process.
echo.
pause
cls
dir %_hd%%_d% /w
echo                    --------------------
echo                             ^
echo                             :
echo                             :
echo.
echo If the number displayed above as "bytes free" is less than 3,000,000,
echo be sure to do the following:
echo.
echo   1. Press Ctrl-C to exit this process.
echo   2. Make at least 3 MB available on the Stacker drive containing the
echo      %_hd%%_d% directory. You can do this by deleting unnecessary files 
echo      or by backing up files to diskettes.
echo   3. Re-run this batch file.
echo.
echo If there is sufficient space available, you may continue this process.
echo.
pause

rem At this point we're ready to get started with the process.
:nostkauto
rem Get the disk with EXPAND.EXE on it.
cls
:gtexpdsk
echo If you have 5.25" 360kb MS-DOS diskettes, insert DISK 6.
echo.
echo If you have 5.25" 1.2mb MS-DOS diskettes, insert DISK 2.
echo.
echo If you have 3.50" 720kb MS-DOS diskettes, insert DISK 3.
echo.
pause
if exist %_fd%expand.exe goto cpyexpnd
cls
echo Error: This is the wrong disk, please try again.
echo        We are looking for the file EXPAND.EXE.
echo        Press Ctrl-C now if you need to exit.
echo.
echo This batch file was designed to assist you during installation of
echo the Microsoft MS-DOS 5.0 Upgrade. It does not support installation of
echo any other DOS 5.0. Please check to be sure you have the correct version
echo of DOS 5.0 for your system. If you need assistance installing any other
echo DOS 5.0, please contact Stac Technical Support.
echo.
goto gtexpdsk

:cpyexpnd
echo Copying expand.exe to %_hd%%_d%...
copy %_fd%expand.exe expand.exe > nul
echo.
rem Figure out which diskette format.
rem _fs=3 means 3.5"; _fs=5LD means 5.25" 360kb; _fs=5HD means 5.25" 1.2mb
rem 
if exist %_fd%appnotes.txt set _fs=5LD
if exist %_fd%4201.cp_ set _fs=3
if exist %_fd%edit.com set _fs=5HD

rem Based on disk format, start prompting for the distribution diskettes.
if %_fs%==3 goto getdsk31
if %_fs%==5LD goto getdk51L
if %_fs%==5HD goto getdk51H
goto nodisk

rem Copy files from 3.5" diskettes.
:getdsk31
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%command.co_ goto copyd31
cls
echo Error: This doesn't look like DISK 1, please try again.
echo        We are looking for the file COMMAND.CO_.
echo        Press Ctrl-C now if you need to exit.
echo.
echo You may be trying to install a different version of DOS 5.0.
echo This procedure was designed to install the MS-DOS Upgrade version of
echo DOS 5.0. Check to be sure you have the correct version of DOS 5.0
echo for your system.
echo.
goto getdsk31

:copyd31
echo Expanding contents of DISK 1 to %_hd%%_d%...
echo.
if exist %_hd%%_d%\command.com sattrib -r -s -h %_hd%%_d%\command.com > nul
copy %_fd%io.sy_ %_hd%%_d%\io.sy_ > nul
copy %_fd%msdos.sy_ %_hd%%_d%\msdos.sy_ > nul
expand %_fd%command.co_ %_hd%%_d%\command.com
expand %_fd%ega.sy_ %_hd%%_d%\ega.sys
expand %_fd%format.co_ %_hd%%_d%\format.com
copy %_fd%hdbkup.exe %_hd%%_d%\hdbkup.exe > nul
copy %_fd%setup.ini %_hd%%_d%\setup.ini > nul
copy %_fd%setup.exe %_hd%%_d%\setup.exe > nul
expand %_fd%uninstal.ex_ %_hd%%_d%\uninstal.exe
copy %_fd%readme.1st %_hd%%_d%\readme.1st > nul
expand %_fd%country.sy_ %_hd%%_d%\country.sys
expand %_fd%display.sy_ %_hd%%_d%\display.sys
expand %_fd%ega.cp_ %_hd%%_d%\ega.cpi
expand %_fd%himem.sy_ %_hd%%_d%\himem.sys
expand %_fd%keyb.co_ %_hd%%_d%\keyb.com
expand %_fd%keyboard.sy_ %_hd%%_d%\keyboard.sys
expand %_fd%mode.co_ %_hd%%_d%\mode.com
expand %_fd%nlsfunc.ex_ %_hd%%_d%\nlsfunc.exe
expand %_fd%setver.ex_ %_hd%%_d%\setver.exe
expand %_fd%ansi.sy_ %_hd%%_d%\ansi.sys
expand %_fd%debug.ex_ %_hd%%_d%\debug.exe
if exist %_fd%doskey.co_ expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
expand %_fd%edlin.ex_ %_hd%%_d%\edlin.exe
expand %_fd%emm386.ex_ %_hd%%_d%\emm386.exe
expand %_fd%fastopen.ex_ %_hd%%_d%\fastopen.exe
expand %_fd%fdisk.ex_ %_hd%%_d%\fdisk.exe
expand %_fd%mem.ex_ %_hd%%_d%\mem.exe
expand %_fd%mirror.co_ %_hd%%_d%\mirror.com
if exist %_fd%ramdrive.sy_ expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
expand %_fd%share.ex_ %_hd%%_d%\share.exe
expand %_fd%smartdrv.sy_ %_hd%%_d%\smartdrv.sys
expand %_fd%sys.co_ %_hd%%_d%\sys.com
expand %_fd%undelete.ex_ %_hd%%_d%\undelete.exe
copy %_fd%unformat.com %_hd%%_d%\unformat.com > nul
expand %_fd%xcopy.ex_ %_hd%%_d%\xcopy.exe
expand %_fd%cga.vi_ %_hd%%_d%\cga.vid
if exist %_fd%8514.vi_ expand %_fd%8514.vi_ %_hd%%_d%\8514.vid

:getdsk32
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%edit.com goto copyd32
cls
echo Error: This doesn't look like DISK 2, please try again.
echo        We are looking for the file EDIT.COM.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdsk32

:copyd32
echo Expanding contents of DISK 2 to %_hd%%_d%...
echo.
expand %_fd%cga.gr_ %_hd%%_d%\cga.grb
expand %_fd%cga.in_ %_hd%%_d%\cga.ini
expand %_fd%dosshell.co_ %_hd%%_d%\dosshell.com
expand %_fd%dosshell.ex_ %_hd%%_d%\dosshell.exe
expand %_fd%dosswap.ex_ %_hd%%_d%\dosswap.exe
expand %_fd%ega.gr_ %_hd%%_d%\ega.grb
expand %_fd%ega.in_ %_hd%%_d%\ega.ini
expand %_fd%ega.vi_ %_hd%%_d%\ega.vid
expand %_fd%egamono.gr_ %_hd%%_d%\egamono.grb
expand %_fd%herc.gr_ %_hd%%_d%\herc.grb
expand %_fd%herc.vi_ %_hd%%_d%\herc.vid
expand %_fd%mono.gr_ %_hd%%_d%\mono.grb
expand %_fd%mono.in_ %_hd%%_d%\mono.ini
copy %_fd%packing.lst %_hd%%_d%\packing.lst > nul
expand %_fd%print.ex_ %_hd%%_d%\print.exe
expand %_fd%vga.gr_ %_hd%%_d%\vga.grb
expand %_fd%vga.vi_ %_hd%%_d%\vga.vid
expand %_fd%vgamono.gr_ %_hd%%_d%\vgamono.grb
expand %_fd%doshelp.hl_ %_hd%%_d%\doshelp.hlp
expand %_fd%dosshell.hl_ %_hd%%_d%\dosshell.hlp
copy %_fd%hdrstore.exe %_hd%%_d%\hdrstore.exe > nul
expand %_fd%help.ex_ %_hd%%_d%\help.exe
expand %_fd%recover.ex_ %_hd%%_d%\recover.exe
expand %_fd%edit.hl_ %_hd%%_d%\edit.hlp
expand %_fd%msherc.co_ %_hd%%_d%\msherc.com
expand %_fd%qbasic.hl_ %_hd%%_d%\qbasic.hlp
copy %_fd%edit.com %_hd%%_d%\edit.com > nul
expand %_fd%qbasic.ex_ %_hd%%_d%\qbasic.exe

:getdsk33
echo Insert DISK 3 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 3 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%readme.txt goto copyd33
cls
echo Error: This doesn't look like DISK 3, please try again.
echo        We are looking for the file README.TXT.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdsk33

:copyd33
echo Expanding contents of DISK 3 to %_hd%%_d%...
echo.
expand %_fd%4201.cp_ %_hd%%_d%\4201.cpi
expand %_fd%4208.cp_ %_hd%%_d%\4208.cpi
expand %_fd%5202.cp_ %_hd%%_d%\5202.cpi
expand %_fd%append.ex_ %_hd%%_d%\append.exe
expand %_fd%assign.co_ %_hd%%_d%\assign.com
expand %_fd%attrib.ex_ %_hd%%_d%\attrib.exe
expand %_fd%backup.ex_ %_hd%%_d%\backup.exe
expand %_fd%chkdsk.ex_ %_hd%%_d%\chkdsk.exe
expand %_fd%comp.ex_ %_hd%%_d%\comp.exe
expand %_fd%diskcomp.co_ %_hd%%_d%\diskcomp.com
expand %_fd%diskcopy.co_ %_hd%%_d%\diskcopy.com
expand %_fd%driver.sy_ %_hd%%_d%\driver.sys
expand %_fd%fc.ex_ %_hd%%_d%\fc.exe
expand %_fd%find.ex_ %_hd%%_d%\find.exe
expand %_fd%graftabl.co_ %_hd%%_d%\graftabl.com
expand %_fd%graphics.co_ %_hd%%_d%\graphics.com
expand %_fd%gorilla.ba_ %_hd%%_d%\gorilla.bas
expand %_fd%label.ex_ %_hd%%_d%\label.exe
expand %_fd%money.ba_ %_hd%%_d%\money.bas
expand %_fd%more.co_ %_hd%%_d%\more.com
expand %_fd%nibbles.ba_ %_hd%%_d%\nibbles.bas
expand %_fd%remline.ba_ %_hd%%_d%\remline.bas
expand %_fd%restore.ex_ %_hd%%_d%\restore.exe
expand %_fd%sort.ex_ %_hd%%_d%\sort.exe
expand %_fd%wina20.38_ %_hd%%_d%\wina20.386
expand %_fd%exe2bin.ex_ %_hd%%_d%\exe2bin.exe
expand %_fd%graphics.pr_ %_hd%%_d%\graphics.pro
expand %_fd%join.ex_ %_hd%%_d%\join.exe
expand %_fd%lcd.cp_ %_hd%%_d%\lcd.cpi
expand %_fd%loadfix.co_ %_hd%%_d%\loadfix.com
expand %_fd%printer.sy_ %_hd%%_d%\printer.sys
copy %_fd%readme.txt %_hd%%_d%\readme.txt > nul
expand %_fd%replace.ex_ %_hd%%_d%\replace.exe
expand %_fd%subst.ex_ %_hd%%_d%\subst.exe
expand %_fd%tree.co_ %_hd%%_d%\tree.com
if exist %_fd%doskey.co_ expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
if exist %_fd%ramdrive.sy_ expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
copy %_fd%appnotes.txt %_hd%%_d%\appnotes.txt > nul
if exist %_fd%mouse.co_ expand %_fd%mouse.co_ %_hd%%_d%\mouse.com
goto allok

rem Copy files from 5.25" 360kb diskettes.
:getdk51L
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%command.co_ goto copyd51L
cls
echo Error: This doesn't look like DISK 1, please try again.
echo        We are looking for the file COMMAND.CO_.
echo        Press Ctrl-C now if you need to exit.
echo.
echo You may be trying to install a different version of DOS 5.0.
echo This procedure was designed to install the MS-DOS Upgrade version of
echo DOS 5.0. Check to be sure you have the correct version of DOS 5.0
echo for your system.
echo.
goto getdk51L

:copyd51L
echo Expanding contents of DISK 1 to %_hd%%_d%...
echo.
copy %_fd%io.sy_ %_hd%%_d%\io.sy_ > nul
copy %_fd%msdos.sy_ %_hd%%_d%\msdos.sy_ > nul
if exist %_hd%%_d%\command.com sattrib -r -s -h %_hd%%_d%\command.com > nul
expand %_fd%command.co_ %_hd%%_d%\command.com
expand %_fd%ega.sy_ %_hd%%_d%\ega.sys 
expand %_fd%format.co_ %_hd%%_d%\format.com
copy %_fd%hdbkup.exe %_hd%%_d%\hdbkup.exe > nul
copy %_fd%setup.exe %_hd%%_d%\setup.exe > nul
copy %_fd%setup.ini %_hd%%_d%\setup.ini > nul
expand %_fd%uninstal.ex_ %_hd%%_d%\uninstal.exe > nul
copy %_fd%readme.1st %_hd%%_d%\readme.1st > nul

:getdk52L
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%unformat.com goto copyd52L
cls
echo Error: This doesn't look like DISK 2, please try again.
echo        We are looking for the file UNFORMAT.COM.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk52L

:copyd52L
echo Expanding contents of DISK 2 to %_hd%%_d%...
echo.
expand %_fd%country.sy_ %_hd%%_d%\country.sys
expand %_fd%display.sy_ %_hd%%_d%\display.sys
expand %_fd%ega.cp_ %_hd%%_d%\ega.cpi
expand %_fd%himem.sy_ %_hd%%_d%\himem.sys
expand %_fd%keyb.co_ %_hd%%_d%\keyb.com
expand %_fd%keyboard.sy_ %_hd%%_d%\keyboard.sys
expand %_fd%mode.co_ %_hd%%_d%\mode.com
expand %_fd%nlsfunc.ex_ %_hd%%_d%\nlsfunc.exe
expand %_fd%setver.ex_ %_hd%%_d%\setver.exe
expand %_fd%ansi.sy_ %_hd%%_d%\ansi.sys
expand %_fd%debug.ex_ %_hd%%_d%\debug.exe
if exist %_fd%doskey.co_ expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
expand %_fd%edlin.ex_ %_hd%%_d%\edlin.exe
expand %_fd%emm386.ex_ %_hd%%_d%\emm386.exe
expand %_fd%fastopen.ex_ %_hd%%_d%\fastopen.exe
expand %_fd%fdisk.ex_ %_hd%%_d%\fdisk.exe
expand %_fd%mem.ex_ %_hd%%_d%\mem.exe
expand %_fd%mirror.co_ %_hd%%_d%\mirror.com
if exist %_fd%ramdrive.sy_ expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
expand %_fd%share.ex_ %_hd%%_d%\share.exe
expand %_fd%smartdrv.sy_ %_hd%%_d%\smartdrv.sys
expand %_fd%sys.co_ %_hd%%_d%\sys.com
expand %_fd%undelete.ex_ %_hd%%_d%\undelete.exe
copy %_fd%unformat.com %_hd%%_d%\unformat.com > nul
expand %_fd%xcopy.ex_ %_hd%%_d%\xcopy.exe
expand %_fd%cga.vi_ %_hd%%_d%\cga.vid
if exist %_fd%8514.vi_ expand %_fd%8514.vi_ %_hd%%_d%\8514.vid

:getdk53L
echo Insert DISK 3 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 3 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%packing.lst goto copyd53L
cls
echo Error: This doesn't look like DISK 3, please try again.
echo        We are looking for the file PACKING.LST.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk53L

:copyd53L
echo Expanding contents of DISK 3 to %_hd%%_d%...
echo.
expand %_fd%cga.gr_ %_hd%%_d%\cga.grb
expand %_fd%cga.in_ %_hd%%_d%\cga.ini
expand %_fd%dosshell.co_ %_hd%%_d%\dosshell.com
expand %_fd%dosshell.ex_ %_hd%%_d%\dosshell.exe
expand %_fd%dosswap.ex_ %_hd%%_d%\dosswap.exe
expand %_fd%ega.gr_ %_hd%%_d%\ega.grb
expand %_fd%ega.in_ %_hd%%_d%\ega.ini
expand %_fd%ega.vi_ %_hd%%_d%\ega.vid
expand %_fd%egamono.gr_ %_hd%%_d%\egamono.grb
expand %_fd%herc.gr_ %_hd%%_d%\herc.grb
expand %_fd%herc.vi_ %_hd%%_d%\herc.vid
expand %_fd%mono.gr_ %_hd%%_d%\mono.grb
expand %_fd%mono.in_ %_hd%%_d%\mono.ini
copy %_fd%packing.lst %_hd%%_d%\packing.lst > nul
expand %_fd%print.ex_ %_hd%%_d%\print.exe
expand %_fd%vga.gr_ %_hd%%_d%\vga.grb
expand %_fd%vga.vi_ %_hd%%_d%\vga.vid
expand %_fd%vgamono.gr_ %_hd%%_d%\vgamono.grb
expand %_fd%doshelp.hl_ %_hd%%_d%\doshelp.hlp
expand %_fd%dosshell.hl_ %_hd%%_d%\dosshell.hlp
copy %_fd%hdrstore.exe %_hd%%_d%\hdrstore.exe > nul
expand %_fd%help.ex_ %_hd%%_d%\help.exe
expand %_fd%recover.ex_ %_hd%%_d%\recover.exe


:getdk54L
echo Insert DISK 4 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 4 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%edit.com goto copyd54L
cls
echo Error: This doesn't look like DISK 4, please try again.
echo        We are looking for the file EDIT.COM.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk54L

:copyd54L
echo Expanding contents of DISK 4 to %_hd%%_d%...
echo.
expand %_fd%edit.hl_ %_hd%%_d%\edit.hlp
expand %_fd%msherc.co_ %_hd%%_d%\msherc.com
expand %_fd%qbasic.hl_ %_hd%%_d%\qbasic.hlp
copy %_fd%edit.com %_hd%%_d%\edit.com > nul
expand %_fd%qbasic.ex_ %_hd%%_d%\qbasic.exe

:getdk55L
echo Insert DISK 5 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 5 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%readme.txt goto copyd55L
cls
echo Error: This doesn't look like DISK 5, please try again.
echo        We are looking for the file README.TXT.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk55L

:copyd55L
echo Expanding contents of DISK 5 to %_hd%%_d%...
echo.
expand %_fd%4201.cp_ %_hd%%_d%\4201.cpi
expand %_fd%4208.cp_ %_hd%%_d%\4208.cpi
expand %_fd%5202.cp_ %_hd%%_d%\5202.cpi
expand %_fd%append.ex_ %_hd%%_d%\append.exe
expand %_fd%assign.co_ %_hd%%_d%\assign.com
expand %_fd%attrib.ex_ %_hd%%_d%\attrib.exe
expand %_fd%backup.ex_ %_hd%%_d%\backup.exe
expand %_fd%chkdsk.ex_ %_hd%%_d%\chkdsk.exe
expand %_fd%comp.ex_ %_hd%%_d%\comp.exe
expand %_fd%diskcomp.co_ %_hd%%_d%\diskcomp.com
expand %_fd%diskcopy.co_ %_hd%%_d%\diskcopy.com
expand %_fd%driver.sy_ %_hd%%_d%\driver.sys
expand %_fd%fc.ex_ %_hd%%_d%\fc.exe
expand %_fd%find.ex_ %_hd%%_d%\find.exe
expand %_fd%graftabl.co_ %_hd%%_d%\graftabl.com
expand %_fd%graphics.co_ %_hd%%_d%\graphics.com
expand %_fd%gorilla.ba_ %_hd%%_d%\gorilla.bas
expand %_fd%label.ex_ %_hd%%_d%\label.exe
expand %_fd%money.ba_ %_hd%%_d%\money.bas
expand %_fd%more.co_ %_hd%%_d%\more.com
expand %_fd%nibbles.ba_ %_hd%%_d%\nibbles.bas
expand %_fd%remline.ba_ %_hd%%_d%\remline.bas
expand %_fd%restore.ex_ %_hd%%_d%\restore.exe
expand %_fd%sort.ex_ %_hd%%_d%\sort.exe
expand %_fd%wina20.38_ %_hd%%_d%\wina20.386
expand %_fd%exe2bin.ex_ %_hd%%_d%\exe2bin.exe
expand %_fd%graphics.pr_ %_hd%%_d%\graphics.pro
expand %_fd%join.ex_ %_hd%%_d%\join.exe
expand %_fd%lcd.cp_ %_hd%%_d%\lcd.cpi
expand %_fd%loadfix.co_ %_hd%%_d%\loadfix.com
expand %_fd%printer.sy_ %_hd%%_d%\printer.sys
copy %_fd%readme.txt %_hd%%_d%\readme.txt > nul
expand %_fd%replace.ex_ %_hd%%_d%\replace.exe
expand %_fd%subst.ex_ %_hd%%_d%\subst.exe
expand %_fd%tree.co_ %_hd%%_d%\tree.com
if exist %_fd%doskey.co_ expand %_fd%doskey.co_ %_hd%%_d%\doskey.com

:getdk56L
echo Insert DISK 6 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 6 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%appnotes.txt goto copyd56L
cls
echo Error: This doesn't look like DISK 6, please try again.
echo        We are looking for the file APPNOTES.TXT.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk56L

:copyd56L
echo Expanding contents of DISK 6 to %_hd%%_d%...
echo.
if exist %_fd%ramdrive.sy_ expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
copy %_fd%appnotes.txt %_hd%%_d%\appnotes.txt > nul
if exist %_fd%mouse.co_ expand %_fd%mouse.co_ %_hd%%_d%\mouse.com
goto allok

rem Copy files from 5.25" 1.2mb diskettes.
:getdk51H
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%command.co_ goto copyd51H
cls
echo Error: This doesn't look like DISK 1, please try again.
echo        We are looking for the file COMMAND.CO_.
echo        Press Ctrl-C now if you need to exit.
echo.
echo You may be trying to install a different version of DOS 5.0.
echo This procedure was designed to install the MS-DOS Upgrade version of
echo DOS 5.0. Check to be sure you have the correct version of DOS 5.0
echo for your system.
echo.
goto getdk51H

:copyd51H
echo Expanding contents of DISK 1 to %_hd%%_d%...
echo.
if exist %_hd%%_d%\command.com sattrib -r -s -h %_hd%%_d%\command.com > nul
copy %_fd%io.sy_ %_hd%%_d%\io.sy_ > nul
copy %_fd%msdos.sy_ %_hd%%_d%\msdos.sy_ > nul
expand %_fd%command.co_ %_hd%%_d%\command.com
expand %_fd%ega.sy_ %_hd%%_d%\ega.sys
expand %_fd%format.co_ %_hd%%_d%\format.com
copy %_fd%hdbkup.exe %_hd%%_d%\hdbkup.exe > nul
copy %_fd%setup.ini %_hd%%_d%\setup.ini > nul
copy %_fd%setup.exe %_hd%%_d%\setup.exe > nul
expand %_fd%uninstal.ex_ %_hd%%_d%\uninstal.exe
copy %_fd%readme.1st %_hd%%_d%\readme.1st > nul
expand %_fd%country.sy_ %_hd%%_d%\country.sys
expand %_fd%display.sy_ %_hd%%_d%\display.sys
expand %_fd%ega.cp_ %_hd%%_d%\ega.cpi
expand %_fd%himem.sy_ %_hd%%_d%\himem.sys
expand %_fd%keyb.co_ %_hd%%_d%\keyb.com
expand %_fd%keyboard.sy_ %_hd%%_d%\keyboard.sys
expand %_fd%mode.co_ %_hd%%_d%\mode.com
expand %_fd%nlsfunc.ex_ %_hd%%_d%\nlsfunc.exe
expand %_fd%setver.ex_ %_hd%%_d%\setver.exe
expand %_fd%ansi.sy_ %_hd%%_d%\ansi.sys
expand %_fd%debug.ex_ %_hd%%_d%\debug.exe
expand %_fd%edlin.ex_ %_hd%%_d%\edlin.exe
expand %_fd%emm386.ex_ %_hd%%_d%\emm386.exe
expand %_fd%fastopen.ex_ %_hd%%_d%\fastopen.exe
expand %_fd%fdisk.ex_ %_hd%%_d%\fdisk.exe
expand %_fd%mem.ex_ %_hd%%_d%\mem.exe
expand %_fd%mirror.co_ %_hd%%_d%\mirror.com
expand %_fd%share.ex_ %_hd%%_d%\share.exe
expand %_fd%smartdrv.sy_ %_hd%%_d%\smartdrv.sys
expand %_fd%sys.co_ %_hd%%_d%\sys.com
expand %_fd%undelete.ex_ %_hd%%_d%\undelete.exe
copy %_fd%unformat.com %_hd%%_d%\unformat.com > nul
expand %_fd%xcopy.ex_ %_hd%%_d%\xcopy.exe
expand %_fd%cga.vi_ %_hd%%_d%\cga.vid
expand %_fd%8514.vi_ %_hd%%_d%\8514.vid
expand %_fd%cga.gr_ %_hd%%_d%\cga.grb
expand %_fd%cga.in_ %_hd%%_d%\cga.ini
expand %_fd%dosshell.co_ %_hd%%_d%\dosshell.com
expand %_fd%dosshell.ex_ %_hd%%_d%\dosshell.exe
expand %_fd%dosswap.ex_ %_hd%%_d%\dosswap.exe
expand %_fd%ega.gr_ %_hd%%_d%\ega.grb
expand %_fd%ega.in_ %_hd%%_d%\ega.ini
expand %_fd%ega.vi_ %_hd%%_d%\ega.vid
expand %_fd%egamono.gr_ %_hd%%_d%\egamono.grb
expand %_fd%herc.gr_ %_hd%%_d%\herc.grb
expand %_fd%herc.vi_ %_hd%%_d%\herc.vid
expand %_fd%mono.gr_ %_hd%%_d%\mono.grb
expand %_fd%mono.in_ %_hd%%_d%\mono.ini
copy %_fd%packing.lst %_hd%%_d%\packing.lst > nul
expand %_fd%print.ex_ %_hd%%_d%\print.exe
expand %_fd%vga.gr_ %_hd%%_d%\vga.grb
expand %_fd%vga.vi_ %_hd%%_d%\vga.vid
expand %_fd%vgamono.gr_ %_hd%%_d%\vgamono.grb
expand %_fd%doshelp.hl_ %_hd%%_d%\doshelp.hlp
expand %_fd%dosshell.hl_ %_hd%%_d%\dosshell.hlp
copy %_fd%hdrstore.exe %_hd%%_d%\hdrstore.exe > nul
expand %_fd%help.ex_ %_hd%%_d%\help.exe
expand %_fd%recover.ex_ %_hd%%_d%\recover.exe

:getdk52H
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 2 of your MS-DOS 5.0 Upgrade into drive %_fd%
pause
if exist %_fd%edit.com goto copyd52H
cls
echo Error: This doesn't look like DISK 2, please try again.
echo        We are looking for the file EDIT.COM.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdk52H

:copyd52H
echo Expanding contents of DISK 2 to %_hd%%_d%...
echo.
expand %_fd%edit.hl_ %_hd%%_d%\edit.hlp
expand %_fd%msherc.co_ %_hd%%_d%\msherc.com
expand %_fd%qbasic.hl_ %_hd%%_d%\qbasic.hlp
copy %_fd%edit.com %_hd%%_d%\edit.com > nul
expand %_fd%qbasic.ex_ %_hd%%_d%\qbasic.exe
expand %_fd%4201.cp_ %_hd%%_d%\4201.cpi
expand %_fd%4208.cp_ %_hd%%_d%\4208.cpi
expand %_fd%5202.cp_ %_hd%%_d%\5202.cpi
expand %_fd%append.ex_ %_hd%%_d%\append.exe
expand %_fd%assign.co_ %_hd%%_d%\assign.com
expand %_fd%attrib.ex_ %_hd%%_d%\attrib.exe
expand %_fd%backup.ex_ %_hd%%_d%\backup.exe
expand %_fd%chkdsk.ex_ %_hd%%_d%\chkdsk.exe
expand %_fd%comp.ex_ %_hd%%_d%\comp.exe
expand %_fd%diskcomp.co_ %_hd%%_d%\diskcomp.com
expand %_fd%diskcopy.co_ %_hd%%_d%\diskcopy.com
expand %_fd%driver.sy_ %_hd%%_d%\driver.sys
expand %_fd%fc.ex_ %_hd%%_d%\fc.exe
expand %_fd%find.ex_ %_hd%%_d%\find.exe
expand %_fd%graftabl.co_ %_hd%%_d%\graftabl.com
expand %_fd%graphics.co_ %_hd%%_d%\graphics.com
expand %_fd%gorilla.ba_ %_hd%%_d%\gorilla.bas
expand %_fd%label.ex_ %_hd%%_d%\label.exe
expand %_fd%money.ba_ %_hd%%_d%\money.bas
expand %_fd%more.co_ %_hd%%_d%\more.com
expand %_fd%nibbles.ba_ %_hd%%_d%\nibbles.bas
expand %_fd%remline.ba_ %_hd%%_d%\remline.bas
expand %_fd%restore.ex_ %_hd%%_d%\restore.exe
expand %_fd%sort.ex_ %_hd%%_d%\sort.exe
expand %_fd%wina20.38_ %_hd%%_d%\wina20.386
expand %_fd%exe2bin.ex_ %_hd%%_d%\exe2bin.exe
expand %_fd%graphics.pr_ %_hd%%_d%\graphics.pro
expand %_fd%join.ex_ %_hd%%_d%\join.exe
expand %_fd%lcd.cp_ %_hd%%_d%\lcd.cpi
expand %_fd%loadfix.co_ %_hd%%_d%\loadfix.com
expand %_fd%printer.sy_ %_hd%%_d%\printer.sys
copy %_fd%readme.txt %_hd%%_d%\readme.txt > nul
expand %_fd%replace.ex_ %_hd%%_d%\replace.exe
expand %_fd%subst.ex_ %_hd%%_d%\subst.exe
expand %_fd%tree.co_ %_hd%%_d%\tree.com
expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
copy %_fd%appnotes.txt %_hd%%_d%\appnotes.txt > nul
expand %_fd%mouse.co_ %_hd%%_d%\mouse.com

:allok
rem Delete the .COM files in the DOS directory that are .EXE files in DOS 5.0.
rem Do this on the Stacker drive.
if exist %_hd%%_d%\backup.com del %_hd%%_d%\backup.com
if exist %_hd%%_d%\chkdsk.com del %_hd%%_d%\chkdsk.com
if exist %_hd%%_d%\comp.com del %_hd%%_d%\comp.com
if exist %_hd%%_d%\debug.com del %_hd%%_d%\debug.com
if exist %_hd%%_d%\edlin.com del %_hd%%_d%\edlin.com
if exist %_hd%%_d%\fdisk.com del %_hd%%_d%\fdisk.com
if exist %_hd%%_d%\help.com del %_hd%%_d%\help.com
if exist %_hd%%_d%\label.com del %_hd%%_d%\label.com
if exist %_hd%%_d%\print.com del %_hd%%_d%\print.com
if exist %_hd%%_d%\recover.com del %_hd%%_d%\recover.com
if exist %_hd%%_d%\restore.com del %_hd%%_d%\restore.com

rem Do the same for the boot drive.
if exist %_b%%_d%\backup.com del %_b%%_d%\backup.com
if exist %_b%%_d%\chkdsk.com del %_b%%_d%\chkdsk.com
if exist %_b%%_d%\comp.com del %_b%%_d%\comp.com
if exist %_b%%_d%\debug.com del %_b%%_d%\debug.com
if exist %_b%%_d%\edlin.com del %_b%%_d%\edlin.com
if exist %_b%%_d%\fdisk.com del %_b%%_d%\fdisk.com
if exist %_b%%_d%\help.com del %_b%%_d%\help.com
if exist %_b%%_d%\label.com del %_b%%_d%\label.com
if exist %_b%%_d%\print.com del %_b%%_d%\print.com
if exist %_b%%_d%\recover.com del %_b%%_d%\recover.com
if exist %_b%%_d%\restore.com del %_b%%_d%\restore.com
echo .COM files which are now .EXE in DOS 5.0 have been deleted from %_d%. >> %_b%\stacdos5.log

rem Delete the .COM files in the root directory that are .EXE files in DOS 5.0.
rem Do this on the Stacker drive.
if exist %_hd%\backup.com del %_hd%\backup.com
if exist %_hd%\chkdsk.com del %_hd%\chkdsk.com
if exist %_hd%\comp.com del %_hd%\comp.com
if exist %_hd%\debug.com del %_hd%\debug.com
if exist %_hd%\edlin.com del %_hd%\edlin.com
if exist %_hd%\fdisk.com del %_hd%\fdisk.com
if exist %_hd%\help.com del %_hd%\help.com
if exist %_hd%\label.com del %_hd%\label.com
if exist %_hd%\print.com del %_hd%\print.com
if exist %_hd%\recover.com del %_hd%\recover.com
if exist %_hd%\restore.com del %_hd%\restore.com

rem Do the same for the boot drive.
if exist %_b%\backup.com del %_b%\backup.com
if exist %_b%\chkdsk.com del %_b%\chkdsk.com
if exist %_b%\comp.com del %_b%\comp.com
if exist %_b%\debug.com del %_b%\debug.com
if exist %_b%\edlin.com del %_b%\edlin.com
if exist %_b%\fdisk.com del %_b%\fdisk.com
if exist %_b%\help.com del %_b%\help.com
if exist %_b%\label.com del %_b%\label.com
if exist %_b%\print.com del %_b%\print.com
if exist %_b%\recover.com del %_b%\recover.com
if exist %_b%\restore.com del %_b%\restore.com
echo .COM files which are now .EXE in DOS 5.0 have been deleted.
echo .COM files which are now .EXE in DOS 5.0 have been deleted from root dirs. >> %_b%\stacdos5.log

copy %_hd%%_d%\edlin.exe  %_b%%_d% > nul
copy %_hd%%_d%\chkdsk.exe %_b%%_d% > nul
copy %_hd%%_d%\setver.exe %_b%%_d% > nul
copy %_hd%%_d%\find.exe   %_b%%_d% > nul
copy %_hd%%_d%\more.com   %_b%%_d% > nul
copy %_hd%%_d%\wina20.386 %_hd%\ > nul
copy %_hd%%_d%\wina20.386 %_b%\ > nul
echo WINA20.386 and others copied to the Stacker and boot drives. >> %_b%\stacdos5.log

rem Update the following files on Drive C: and the uncompressed drive:
rem 
rem HIMEM.SYS, SMARTDRV.SYS, RAMDRIVE.SYS, EMM386.EXE, ANSI.SYS, DRIVER.SYS  
rem
rem   Copy them from the DOS directory to the appropriate destinations.
echo Updating device drivers on the Stacker drive and boot drive...

rem HIMEM.SYS - check root, DOS & Windows directories
if not exist %_hd%\himem.sys goto L1
datetest %_hd%\himem.sys %_hd%%_d%\himem.sys > nul
if errorlevel 1 goto L1
copy %_hd%%_d%\himem.sys %_hd%\himem.sys > nul
:L1
if not exist %_hd%\windows\himem.sys goto L2
datetest %_hd%\windows\himem.sys %_hd%%_d%\himem.sys > nul
if errorlevel 1 goto L2
copy %_hd%%_d%\himem.sys %_hd%\windows\himem.sys > nul
:L2
if exist %_b%\himem.sys copy %_hd%%_d%\himem.sys %_b%%_sp%\himem.sys > nul
if exist %_b%%_d%\himem.sys copy %_hd%%_d%\himem.sys %_b%%_sp%\himem.sys > nul
if exist %_b%\windows\himem.sys copy %_hd%%_d%\himem.sys %_b%%_sp%\himem.sys > nul
if exist %_b%%_sp%\himem.sys echo HIMEM.SYS copied. >> %_b%\stacdos5.log

rem SMARTDRV.SYS - check root, DOS & Windows directories
if not exist %_hd%\smartdrv.sys goto L3
datetest %_hd%\smartdrv.sys %_hd%%_d%\smartdrv.sys > nul
if errorlevel 1 goto L3
copy %_hd%%_d%\smartdrv.sys %_hd%\smartdrv.sys > nul
:L3
if not exist %_hd%\windows\smartdrv.sys goto L4
datetest %_hd%\windows\smartdrv.sys %_hd%%_d%\smartdrv.sys > nul
if errorlevel 1 goto L4
copy %_hd%%_d%\smartdrv.sys %_hd%\windows\smartdrv.sys > nul
:L4
if exist %_b%\smartdrv.sys copy %_hd%%_d%\smartdrv.sys %_b%%_sp%\smartdrv.sys > nul
if exist %_b%%_d%\smartdrv.sys copy %_hd%%_d%\smartdrv.sys %_b%%_sp%\smartdrv.sys > nul
if exist %_b%\windows\smartdrv.sys copy %_hd%%_d%\smartdrv.sys %_b%%_sp%\smartdrv.sys > nul
if exist %_b%%_sp%\smartdrv.sys echo SMARTDRV.SYS copied. >> %_b%\stacdos5.log

rem RAMDRIVE.SYS - check root, DOS & Windows directories
if not exist %_hd%\ramdrive.sys goto L5
datetest %_hd%\ramdrive.sys %_hd%%_d%\ramdrive.sys > nul
if errorlevel 1 goto L5
copy %_hd%%_d%\ramdrive.sys %_hd%\ramdrive.sys > nul
:L5
if not exist %_hd%\windows\ramdrive.sys goto L6
datetest %_hd%\windows\ramdrive.sys %_hd%%_d%\ramdrive.sys > nul
if errorlevel 1 goto L6
copy %_hd%%_d%\ramdrive.sys %_hd%\windows\ramdrive.sys > nul
:L6
if exist %_b%\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%%_sp%\ramdrive.sys > nul
if exist %_b%%_d%\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%%_sp%\ramdrive.sys > nul
if exist %_b%\windows\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%%_sp%\ramdrive.sys > nul
if exist %_b%%_sp%\ramdrive.sys echo RAMDRIVE.SYS copied. >> %_b%\stacdos5.log

rem EMM386.EXE - check root, DOS & Windows directories
if not exist %_hd%\emm386.exe goto L7
datetest %_hd%\emm386.exe %_hd%%_d%\emm386.exe > nul
if errorlevel 1 goto L7
copy %_hd%%_d%\emm386.exe %_hd%\emm386.exe > nul
:L7
if not exist %_hd%\windows\emm386.exe goto L8
datetest %_hd%\windows\emm386.exe %_hd%%_d%\emm386.exe > nul
if errorlevel 1 goto L8
copy %_hd%%_d%\emm386.exe %_hd%\windows\emm386.exe > nul
:L8
if exist %_b%\emm386.exe copy %_hd%%_d%\emm386.exe %_b%%_sp%\emm386.exe > nul
if exist %_b%%_d%\emm386.exe copy %_hd%%_d%\emm386.exe %_b%%_sp%\emm386.exe > nul
if exist %_b%\windows\emm386.exe copy %_hd%%_d%\emm386.exe %_b%%_sp%\emm386.exe > nul
if exist %_b%%_sp%\emm386.exe echo EMM386.EXE copied. >> %_b%\stacdos5.log

rem ANSI.SYS - check root & DOS directories
if exist %_hd%\ansi.sys copy %_hd%%_d%\ansi.sys %_hd%\ansi.sys > nul
if exist %_b%\ansi.sys copy %_hd%%_d%\ansi.sys %_b%%_sp%\ansi.sys > nul
if exist %_b%%_d%\ansi.sys copy %_hd%%_d%\ansi.sys %_b%%_sp%\ansi.sys > nul
if exist %_b%%_sp%\ANSI.sys echo ANSI.SYS copied. >> %_b%\stacdos5.log

rem DRIVER.SYS - check root & DOS directories
if exist %_hd%\driver.sys copy %_hd%%_d%\driver.sys %_hd%\driver.sys > nul
if exist %_b%\driver.sys copy %_hd%%_d%\driver.sys %_b%%_sp%\driver.sys > nul
if exist %_b%%_d%\driver.sys copy %_hd%%_d%\driver.sys %_b%%_sp%\driver.sys > nul
if exist %_b%%_sp%\driver.sys echo DRIVER.SYS copied. >> %_b%\stacdos5.log

rem Update the following National Language Support files on Drive C: and the
rem uncompressed drive:
rem 
rem   COUNTRY.SYS, DISPLAY.SYS, KEYBOARD.SYS, PRINTER.SYS, 
rem   KEYB.COM, NLSFUNC.EXE, *.CPI
rem
rem Copy them from the DOS directory to the appropriate destinations.
echo Updating National Language Support files on the Stacker drive and boot drive...

rem COUNTRY.SYS - check root & DOS directories
if exist %_hd%\country.sys copy %_hd%%_d%\country.sys %_hd%\country.sys > nul
if exist %_b%\country.sys copy %_hd%%_d%\country.sys %_b%%_sp%\country.sys > nul
if exist %_b%%_d%\country.sys copy %_hd%%_d%\country.sys %_b%%_sp%\country.sys > nul
if exist %_b%%_sp%\country.sys echo COUNTRY.SYS copied. >> %_b%\stacdos5.log

rem DISPLAY.SYS - check root & DOS directories
if exist %_hd%\display.sys copy %_hd%%_d%\display.sys %_hd%\display.sys > nul
if exist %_b%\display.sys copy %_hd%%_d%\display.sys %_b%%_sp%\display.sys > nul
if exist %_b%%_d%\display.sys copy %_hd%%_d%\display.sys %_b%%_sp%\display.sys > nul
if exist %_b%%_sp%\display.sys echo DISPLAY.SYS copied. >> %_b%\stacdos5.log

rem KEYBOARD.SYS - check root & DOS directories
if exist %_hd%\keyboard.sys copy %_hd%%_d%\keyboard.sys %_hd%\keyboard.sys > nul
if exist %_b%\keyboard.sys copy %_hd%%_d%\keyboard.sys %_b%%_sp%\keyboard.sys > nul
if exist %_b%%_d%\keyboard.sys copy %_hd%%_d%\keyboard.sys %_b%%_sp%\keyboard.sys > nul
if exist %_b%%_sp%\keyboard.sys echo KEYBOARD.SYS copied. >> %_b%\stacdos5.log

rem PRINTER.SYS - check root & DOS directories
if exist %_hd%\printer.sys copy %_hd%%_d%\printer.sys %_hd%\printer.sys > nul
if exist %_b%\printer.sys copy %_hd%%_d%\printer.sys %_b%%_sp%\printer.sys > nul
if exist %_b%%_d%\printer.sys copy %_hd%%_d%\printer.sys %_b%%_sp%\printer.sys > nul
if exist %_b%%_sp%\printer.sys echo PRINTER.SYS copied. >> %_b%\stacdos5.log

rem KEYB.COM - check root & DOS directories
if exist %_hd%\keyb.com copy %_hd%%_d%\keyb.com %_hd%\keyb.com > nul
if exist %_b%\keyb.com copy %_hd%%_d%\keyb.com %_b%%_sp%\keyb.com > nul
if exist %_b%%_d%\keyb.com copy %_hd%%_d%\keyb.com %_b%%_sp%\keyb.com > nul
if exist %_b%%_sp%\keyb.com echo KEYB.COM copied. >> %_b%\stacdos5.log

rem NLSFUNC.EXE - check root & DOS directories
if exist %_hd%\nlsfunc.exe copy %_hd%%_d%\nlsfunc.exe %_hd%\nlsfunc.exe > nul
if exist %_b%\nlsfunc.exe copy %_hd%%_d%\nlsfunc.exe %_b%%_sp%\nlsfunc.exe > nul
if exist %_b%%_d%\nlsfunc.exe copy %_hd%%_d%\nlsfunc.exe %_b%%_sp%\nlsfunc.exe > nul
if exist %_b%%_sp%\nlsfunc.exe echo NLSFUNC.EXE copied. >> %_b%\stacdos5.log

rem 4201.CPI - check root & DOS directories
if exist %_hd%\4201.cpi copy %_hd%%_d%\4201.cpi %_hd%\4201.cpi > nul
if exist %_b%\4201.cpi copy %_hd%%_d%\4201.cpi %_b%%_sp%\4201.cpi > nul
if exist %_b%%_d%\4201.cpi copy %_hd%%_d%\4201.cpi %_b%%_sp%\4201.cpi > nul
if exist %_b%%_sp%\4201.cpi echo 4201.CPI copied. >> %_b%\stacdos5.log

rem 4208.CPI - check root & DOS directories
if exist %_hd%\4208.cpi copy %_hd%%_d%\4208.cpi %_hd%\4208.cpi > nul
if exist %_b%\4208.cpi copy %_hd%%_d%\4208.cpi %_b%%_sp%\4208.cpi > nul
if exist %_b%%_d%\4208.cpi copy %_hd%%_d%\4208.cpi %_b%%_sp%\4208.cpi > nul
if exist %_b%%_sp%\4208.cpi echo 4208.CPI copied. >> %_b%\stacdos5.log

rem 5202.CPI - check root & DOS directories
if exist %_hd%\5202.cpi copy %_hd%%_d%\5202.cpi %_hd%\5202.cpi > nul
if exist %_b%\5202.cpi copy %_hd%%_d%\5202.cpi %_b%%_sp%\5202.cpi > nul
if exist %_b%%_d%\5202.cpi copy %_hd%%_d%\5202.cpi %_b%%_sp%\5202.cpi > nul
if exist %_b%%_sp%\5202.cpi echo 5202.CPI copied. >> %_b%\stacdos5.log

rem EGA.CPI - check root & DOS directories
if exist %_hd%\ega.cpi copy %_hd%%_d%\ega.cpi %_hd%\ega.cpi > nul
if exist %_b%\ega.cpi copy %_hd%%_d%\ega.cpi %_b%%_sp%\ega.cpi > nul
if exist %_b%%_d%\ega.cpi copy %_hd%%_d%\ega.cpi %_b%%_sp%\ega.cpi > nul
if exist %_b%%_sp%\ega.cpi echo EGA.CPI copied. >> %_b%\stacdos5.log

rem LCD.CPI - check root & DOS directories
if exist %_hd%\lcd.cpi copy %_hd%%_d%\lcd.cpi %_hd%\lcd.cpi > nul
if exist %_b%\lcd.cpi copy %_hd%%_d%\lcd.cpi %_b%%_sp%\lcd.cpi > nul
if exist %_b%%_d%\lcd.cpi copy %_hd%%_d%\lcd.cpi %_b%%_sp%\lcd.cpi > nul
if exist %_b%%_sp%\lcd.cpi echo LCD.CPI copied. >> %_b%\stacdos5.log

rem Update COMMAND.COM in the root of the Stacker drive (the current drive).
echo Updating COMMAND.COM on the Stacker drive...
if exist %_hd%\command.com sattrib -h -r -s %_hd%\command.com > nul
if exist %_hd%\command.com copy %_hd%%_d%\command.com %_hd%\command.com > nul
echo COMMAND.COM updated in root of Stacker drive. >> %_b%\stacdos5.log

rem Un-attrib COMMAND.COM in the root and DOS directories of the boot drive.
sattrib -r -s -h %_b%\command.com > nul
if exist %_b%%_d%\command.com sattrib -r -s -h %_b%%_d%\command.com > nul
echo Attributes removed from COMMAND.COMs on the boot drive. >> %_b%\stacdos5.log

rem Update DOS hidden files on Stacker drive (the current drive).
rem Handle both MS-DOS and IBM versions.
if exist %_hd%\msdos.sys goto st_doms
if exist %_hd%\ibmdos.com goto st_doibm
goto st_put

:st_doibm
rem Unhide and delete IBM DOS files on Stacker drive.
sattrib -h -r -s %_hd%\ibmbio.com > nul
sattrib -h -r -s %_hd%\ibmdos.com > nul
del %_hd%\ibmbio.com > nul
del %_hd%\ibmdos.com > nul
goto st_put

:st_doms
rem Unhide MS-DOS files on Stacker drive.
sattrib -h -r -s %_hd%\io.sys > nul
sattrib -h -r -s %_hd%\msdos.sys > nul

:st_put
echo System files on drive C: unhidden. >> %_b%\stacdos5.log
expand %_hd%%_d%\io.sy_ %_hd%\io.sys > nul
expand %_hd%%_d%\msdos.sy_ %_hd%\msdos.sys > nul
rem Cleanup
del %_hd%%_d%\io.sy_ 
del %_hd%%_d%\msdos.sy_ 
rem Hide system files on Stacker drive.
sattrib +h +r +s %_hd%\io.sys > nul
sattrib +h +r +s %_hd%\msdos.sys > nul
echo Hidden files on Stacker drive updated. >> %_b%\stacdos5.log

rem Determine video type and install appropriate DOSSHELL files.
%_sp%\vidtype > nul
if errorlevel  7 goto MCA
if errorlevel  6 goto HERC
if errorlevel  5 goto VGAMONO
if errorlevel  4 goto VGA
if errorlevel  3 goto EGAMONO
if errorlevel  2 goto EGA
if errorlevel  1 goto CGA

:MONO
echo MONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for MONO.
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul 
copy %_hd%%_d%\mono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:CGA
echo CGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for CGA.
copy %_hd%%_d%\cga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\cga.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\cga.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:EGA
echo EGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for EGA.
copy %_hd%%_d%\ega.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\ega.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\ega.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:EGAMONO
echo EGAMONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for EGAMONO.
copy %_hd%%_d%\ega.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\egamono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:VGA
echo VGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for VGA.
copy %_hd%%_d%\vga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\ega.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vga.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:VGAMONO
echo VGAMONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for VGAMONO.
copy %_hd%%_d%\vga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vgamono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:HERC
echo HERC video. >> %_b%\stacdos5.log
echo DOSSHELL set up for HERC.
copy %_hd%%_d%\herc.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\herc.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:MCA
echo MCA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for MCA.
copy %_hd%%_d%\cga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\cga.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vga.grb %_hd%%_d%\dosshell.grb > nul
:ENDVID

cls
echo.
echo MS-DOS 5.0 files copied successfully.
echo.
echo You will now enter the MS-DOS 5.0 SETUP program which will install 
echo the remaining files needed to complete your upgrade to MS-DOS 5.0.
echo Note that this process will perform a Minimal Installation since
echo we've already copied the files from the MS-DOS 5.0 Upgrade diskettes.
echo.
echo You will need one or two blank diskettes for this process. They do
echo not need to be formatted.
echo.
echo  1. The MS-DOS 5.0 SETUP program will ask you to verify your system
echo     configuration, including the "DOS Path".  
echo.
echo        *** Be sure to accept the default setting of %_b%\DOS. ***
echo.
echo  2. Once you've completed the SETUP process, your system will reboot.
echo     After rebooting you MUST type the following command at the C
echo     prompt to complete the upgrade process.
echo.
echo                           STAC5
echo.
pause
cls
echo.
echo                        **** REMINDER ****
echo.
echo SETUP will create UNINSTALL diskettes, but you will not be able to use
echo the UNINSTALL feature of MS-DOS 5.0.
echo.
echo The MS-DOS 5.0 SETUP program will ask you to verify your system
echo configuration, including the "DOS Path".  
echo.
echo     *** Be sure to accept the default setting of %_b%\DOS. ***
echo.
echo Once you've completed the SETUP process, your system will reboot and
echo after rebooting you MUST type the following command at the C prompt to 
echo complete the upgrade process.
echo.
echo                              STAC5
echo.
echo   ***************************************************************
echo   *       WRITE THIS INSTRUCTION DOWN. YOUR UPGRADE WILL        *
echo   *        NOT BE COMPLETE UNTIL THIS LAST STEP IS DONE.        *
echo   ***************************************************************
echo.
pause

:getdsk1
echo Insert DISK 1 of your MS-DOS 5.0 Upgrade in drive %_fd%
pause
if exist %_fd%command.co_ goto setup_m
cls
echo Error: This doesn't look like DISK 1, please try again.
echo        We are looking for the file COMMAND.CO_.
echo        Press Ctrl-C now if you need to exit.
echo.
goto getdsk1

:setup_m
echo Transferring control to Setup /M. >> %_b%\stacdos5.log
echo Copy STACDOS5.BAT to boot drive for PASS 2.  >> %_b%\stacdos5.log

if exist %_b%\stacdos5.bat del %_b%\stacdos5.bat
copy %_sp%\stacdos5.bat %_b%\stacdos5.bat > nul
copy %_sp%\datetest.com %_b%\

rem Save config.sys and autoexec.bat on the boot drive. 
if exist %_b%\config.sys copy %_b%\config.sys %_b%\config.$s$ > nul
if exist %_b%\autoexec.bat copy %_b%\autoexec.bat %_b%\autoexec.$s$ > nul

rem Create a 1-line batch file for use after Setup /M reboot.
echo STACDOS5 C:%_d% %_hd%%_sp% 2 > %_b%\STAC5.BAT
echo Creating STAC5.BAT containing STACDOS5 C:%_d% %_hd%%_sp% 2 >> %_b%\stacdos5.log
echo . >> %_b%\STAC5.BAT
echo PASS 1 completed. >> %_b%\stacdos5.log
echo . >> %_b%\stacdos5.log
%_fd%
setup /m
goto finish

rem =========================================================================
rem PASS 2 Process.

:pass2
path %1
set _b=c:
set _d=%1
set _sp=%2
copy c:\command.com %_d% > nul
if exist %_d%\command.com goto copydos
goto direrr_1

:copydos
rem Cleanup the root directory.
copy \config.$s$ \config.sys > nul
copy \autoexec.$s$ \autoexec.bat > nul
copy \config.$s$ \stacker\config.sys > nul
copy \autoexec.$s$ \stacker\autoexec.bat > nul
del \config.$s$ > nul
del \autoexec.$s$ > nul
echo CONFIG.SYS and AUTOEXEC.BAT restored. >> %_b%\stacdos5.log

rem Copy those DOS files which exist in the DOS & Windows directories.
rem Including himem.sys, smartdrv.sys, ramdrive.sys, emm386.exe, ansi.sys, 
rem driver.sys, country.sys, display.sys, keyboard.sys, printer.sys, 
rem keyb.com, nlsfunc.exe, *.cpi
rem For each file, delete it after copying (if present).

rem HIMEM.SYS - check root, DOS, & Windows directories
if not exist \himem.sys goto L9 
datetest \himem.sys %_sp%\himem.sys > nul
if errorlevel 1 goto L9
copy %_sp%\himem.sys \himem.sys > nul
:L9
if not exist %_d%\himem.sys goto L10
datetest %_d%\himem.sys %_sp%\himem.sys > nul
if errorlevel 1 goto L10
copy %_sp%\himem.sys %_d%\himem.sys > nul
:L10
if not exist \windows\himem.sys goto L11
datetest \windows\himem.sys %_sp%\himem.sys > nul
if errorlevel 1 goto L11
copy %_sp%\himem.sys \windows\himem.sys > nul
:L11
if exist %_sp%\himem.sys echo HIMEM.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\himem.sys del %_sp%\himem.sys > nul

rem SMARTDRV.SYS - check root, DOS & Windows directories
if not exist \smartdrv.sys goto L12
datetest \smartdrv.sys %_sp%\smartdrv.sys > nul
if errorlevel 1 goto L12
copy %_sp%\smartdrv.sys \smartdrv.sys > nul
:L12
if not exist %_d%\smartdrv.sys goto L13
datetest %_d%\smartdrv.sys %_sp%\smartdrv.sys > nul
if errorlevel 1 goto L13
copy %_sp%\smartdrv.sys %_d%\smartdrv.sys > nul
:L13
if not exist \windows\smartdrv.sys goto L14
datetest \windows\smartdrv.sys %_sp%\smartdrv.sys > nul
if errorlevel 1 goto L14
copy %_sp%\smartdrv.sys \windows\smartdrv.sys > nul
:L14
if exist %_sp%\smartdrv.sys echo SMARTDRV.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\smartdrv.sys del %_sp%\smartdrv.sys > nul

rem RAMDRIVE.SYS - check root, DOS & Windows directories
if not exist \ramdrive.sys goto L15
datetest \ramdrive.sys %_sp%\ramdrive.sys > nul
if errorlevel 1 goto L15
copy %_sp%\ramdrive.sys \ramdrive.sys > nul
:L15
if not exist %_d%\ramdrive.sys goto L16
datetest %_d%\ramdrive.sys %_sp%\ramdrive.sys > nul
if errorlevel 1 goto L16
copy %_sp%\ramdrive.sys %_d%\ramdrive.sys > nul
:L16
if not exist \windows\ramdrive.sys goto L17
datetest \windows\ramdrive.sys %_sp%\ramdrive.sys > nul
if errorlevel 1 goto L17
copy %_sp%\ramdrive.sys \windows\ramdrive.sys > nul
:L17
if exist %_sp%\ramdrive.sys echo RAMDRIVE.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\ramdrive.sys del %_sp%\ramdrive.sys > nul

rem EMM386.EXE - check root, DOS & Windows directories
if not exist \emm386.exe goto L18
datetest \emm386.exe %_sp%\emm386.exe > nul
if errorlevel 1 goto L18
copy %_sp%\emm386.exe \emm386.exe > nul
:L18
if not exist %_d%\emm386.exe goto L19
datetest %_d%\emm386.exe %_sp%\emm386.exe > nul
if errorlevel 1 goto L19
copy %_sp%\emm386.exe %_d%\emm386.exe > nul
:L19
if not exist \windows\emm386.exe goto L20
datetest \windows\emm386.exe %_sp%\emm386.exe > nul
if errorlevel 1 goto L20
copy %_sp%\emm386.exe \windows\emm386.exe > nul
:L20
if exist %_sp%\emm386.exe echo EMM386.EXE updated. >> %_b%\stacdos5.log
if exist %_sp%\emm386.exe del %_sp%\emm386.exe > nul

rem ANSI.SYS - check root & DOS directories
if exist \ansi.sys copy %_sp%\ansi.sys \ansi.sys > nul
if exist %_d%\ansi.sys copy %_sp%\ansi.sys %_d%\ansi.sys > nul
if exist %_sp%\ansi.sys echo ANSI.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\ansi.sys del %_sp%\ansi.sys > nul

rem DRIVER.SYS - check root & DOS directories
if exist \driver.sys copy %_sp%\driver.sys \driver.sys > nul
if exist %_d%\driver.sys copy %_sp%\driver.sys %_d%\driver.sys > nul
if exist %_sp%\driver.sys echo DRIVER.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\driver.sys del %_sp%\driver.sys > nul

rem COUNTRY.SYS - check root & DOS directories
if exist \country.sys copy %_sp%\country.sys \country.sys > nul
if exist %_d%\country.sys copy %_sp%\country.sys %_d%\country.sys > nul
if exist %_sp%\country.sys echo COUNTRY.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\country.sys del %_sp%\country.sys > nul

rem DISPLAY.SYS - check root, DOS & Windows directories
if exist \display.sys copy %_sp%\display.sys \display.sys > nul
if exist %_d%\display.sys copy %_sp%\display.sys %_d%\display.sys > nul
if exist %_sp%\display.sys echo DISPLAY.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\display.sys del %_sp%\display.sys > nul

rem KEYBOARD.SYS - check root & DOS directories
if exist \keyboard.sys copy %_sp%\keyboard.sys \keyboard.sys > nul
if exist %_d%\keyboard.sys copy %_sp%\keyboard.sys %_d%\keyboard.sys > nul
if exist %_sp%\keyboard.sys echo KEYBOARD.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\keyboard.sys del %_sp%\keyboard.sys > nul

rem PRINTER.SYS - check root & DOS directories
if exist \printer.sys copy %_sp%\printer.sys \printer.sys > nul
if exist %_d%\printer.sys copy %_sp%\printer.sys %_d%\printer.sys > nul
if exist %_sp%\printer.sys echo PRINTER.SYS updated. >> %_b%\stacdos5.log
if exist %_sp%\printer.sys del %_sp%\printer.sys > nul

rem KEYB.COM - check root & DOS directories
if exist \keyb.com copy %_sp%\keyb.com \keyb.com > nul
if exist %_d%\keyb.com copy %_sp%\keyb.com %_d%\keyb.com > nul
if exist %_sp%\keyb.com echo KEYB.COM updated. >> %_b%\stacdos5.log
if exist %_sp%\keyb.com del %_sp%\keyb.com > nul

rem NLSFUNC.EXE - check root & DOS directories
if exist \nlsfunc.exe copy %_sp%\nlsfunc.exe \nlsfunc.exe > nul
if exist %_d%\nlsfunc.exe copy %_sp%\nlsfunc.exe %_d%\nlsfunc.exe > nul
if exist %_sp%\nlsfunc.exe echo NLSFUNC.EXE updated. >> %_b%\stacdos5.log
if exist %_sp%\nlsfunc.exe del %_sp%\nlsfunc.exe > nul

rem 4201.CPI - check root & DOS directories
if exist \4201.cpi copy %_sp%\4201.cpi \4201.cpi > nul
if exist %_d%\4201.cpi copy %_sp%\4201.cpi %_d%\4201.cpi > nul
if exist %_sp%\4201.cpi echo 4201.CPI updated. >> %_b%\stacdos5.log
if exist %_sp%\4201.cpi del %_sp%\4201.cpi > nul

rem 4208.CPI - check root, DOS & Windows directories
if exist \4208.cpi copy %_sp%\4208.cpi \4208.cpi > nul
if exist %_d%\4208.cpi copy %_sp%\4208.cpi %_d%\4208.cpi > nul
if exist %_sp%\4208.cpi echo 4208.CPI updated. >> %_b%\stacdos5.log
if exist %_sp%\4208.cpi del %_sp%\4208.cpi > nul

rem 5202.CPI - check root & DOS directories
if exist \5202.cpi copy %_sp%\5202.cpi \5202.cpi > nul
if exist %_d%\5202.cpi copy %_sp%\5202.cpi %_d%\5202.cpi > nul
if exist %_sp%\5202.cpi echo 5202.CPI updated. >> %_b%\stacdos5.log
if exist %_sp%\5202.cpi del %_sp%\5202.cpi > nul

rem EGA.CPI - check root & DOS directories
if exist \ega.cpi copy %_sp%\ega.cpi \ega.cpi > nul
if exist %_d%\ega.cpi copy %_sp%\ega.cpi %_d%\ega.cpi > nul
if exist %_sp%\ega.cpi echo EGA.CPI updated. >> %_b%\stacdos5.log
if exist %_sp%\ega.cpi del %_sp%\ega.cpi > nul

rem LCD.CPI - check root & DOS directories
if exist \lcd.cpi copy %_sp%\lcd.cpi \lcd.cpi > nul
if exist %_d%\lcd.cpi copy %_sp%\lcd.cpi %_d%\lcd.cpi > nul
if exist %_sp%\lcd.cpi echo LCD.CPI updated. >> %_b%\stacdos5.log
if exist %_sp%\lcd.cpi del %_sp%\lcd.cpi > nul

rem Instruct the user to reboot.
cls
echo.
echo Your MS-DOS 5.0 Upgrade is now complete.
echo.
echo Some files from your previous DOS version may still be located in
echo the %_d% directory. These files have no corresponding replacement
echo in DOS 5.0. Please examine them and consult your User's Guide to see
echo if they can be deleted. Be careful not to delete anything which may
echo be required for normal operation of your system.
echo.
echo Your CONFIG.SYS and AUTOEXEC.BAT files are the same as when you started
echo this process. You will need to modify them if you wish to take advantage
echo of the exciting new features offered in MS-DOS 5.0. You can find some
echo hints on this by looking at the files CONFIG.NEW and AUTOEXEC.NEW in the
echo root directory of the uncompressed drive. Be sure you use the correct
echo path names when adding any new commands to your CONFIG.SYS file.
echo.
echo To access your Stacker drives...
echo.
echo      *************************************************************
echo      *        PRESS CTRL+ALT+DEL NOW TO REBOOT YOUR SYSTEM       *
echo      *                                                           *
echo      *               THANK YOU FOR CHOOSING STACKER              *
echo      *************************************************************
echo.
echo PASS 2 completed. >> %_b%\stacdos5.log
echo STACDOS5.BAT complete. >> %_b%\stacdos5.log
copy %_b%\stacdos5.log %_sp% > nul
del %_b%\stacdos5.log
del %_b%\stac5.bat
del %_b%\datetest.com
goto alldone

rem =========================================================================
rem Error Displays - All errors which exit after display are here.
rem =========================================================================

:direrr1
cls
echo ERROR1: We are unable to verify the DOS directory, %_hd%%_d%. We're looking 
echo         for the CHKDSK command file to verify this. Also, please make 
echo         sure the directory name was entered with a leading '\'.
echo.
echo ERROR1 >> \stacdos5.log
goto errexit

:direrr_1
cls
echo ERROR2: We are unable to confirm that a DOS directory, %_d%, exists
echo         on the uncompressed boot drive. We are looking for DOS directories
echo         on the Stacker drive and the uncompressed boot drive with the 
echo         same name. Please run STACDOS5 again with the correct name of the 
echo         DOS directory on the uncompressed drive. (Also include the name 
echo         of the Stacker directory on the uncompressed drive.)
echo.
echo For example, if the DOS directory on the uncompressed drive is named
echo C:\DOS33, and the Stacker directory is C:\STACKER, type the following:
echo.
echo              STACDOS5 C:\DOS33 C:\STACKER
echo.
echo DO NOT try to run STAC5 again, as you will receive this same error message.
echo.
echo ERROR2 >> %_b%\stacdos5.log
goto errexit

:noboot
echo ERROR3: The SWAPMAP program is unable to determine the boot drive. This
echo         may be caused by an incorrect version of SWAPMAP. Please verify
echo         that you have the correct version of SWAPMAP for your version of
echo         Stacker by running SWAPMAP from the command line.
echo.
echo         Please contact Stac technical support for additional assistance.
echo ERROR3 >> \stacdos5.log
goto errexit

:nodisk
cls
echo Error4: We could not determine which disk size you are using. Specific 
echo         files we are looking for were not found on the disk you inserted. 
echo         It is possible that you have a DOS 5.0 other than the MS-DOS 5.0 
echo         Upgrade. Please check to be sure that you have the correct 
echo         version of DOS 5.0.
echo.
echo ERROR4 >> %_b%\stacdos5.log
goto errexit

:nodrive
cls
echo ERROR5: You must provide the drive letter of the diskette drive
echo         that you will be installing your MS-DOS 5.0 Upgrade from. The
echo         drive letter must be A: or B:.
echo.
echo ERROR5 >> %_b%\stacdos5.log
goto errexit

:noparms
cls
goto errmsg

:nospace
cls
echo ERROR6: STACDOS5.BAT cannot run. There are two possible reasons for this.
echo.
echo 1. There is not enough DOS environment space available. Although the
echo    update process requires very little space, there is not enough
echo    available to allow the batch file to run. Please delete one or
echo    more of your environment variables and run STACDOS5.BAT again.
echo.
echo                              or
echo
echo 2. You are running a version of DOS prior to DOS 3.1. This batch
echo    batch file requires features available in DOS 3.1 and later.
echo.
echo    You are currently running the following DOS version:
echo.
ver
echo.
echo ERROR6 >> \stacdos5.log
goto errexit

:nostdir
cls
echo ERROR7: We couldn't verify the path you supplied for the Stacker
echo         directory. We are looking for the program SDIR.EXE in
echo         the %_hd%%_sp% directory.
echo.
echo         Please check to make sure you typed the path correctly when
echo         you started the batch file and also that SDIR.EXE is in 
echo         your %_hd%%_sp% directory
echo.
echo ERROR7 >> \stacdos5.log
goto errexit 

:nostroot
cls
echo ERROR8: We are trying to copy COMMAND.COM from the %_hd%%_d% directory
echo          to the Stacker directory on the boot drive %_b%, but are unable 
echo          to copy the file successfully.  
echo.
echo Please make sure that a directory named %_sp% exists on the boot drive
echo %_b% and that a copy of COMMAND.COM is in the %_hd%%_d% directory.
echo.
echo ERROR8 >> %_b%\stacdos5.log
goto errexit

:notstkr1
cls
echo ERROR9: This batch file must be run from your Stacker drive, with
echo         the Stacker directory as your current directory. We're looking
echo         for the SATTRIB, SWAPMAP, and DRVTYPE Stacker utilities to
echo         verify this. If you have deleted SATTRIB.COM (version 1 or 2), 
echo         SATTRIB.EXE (version 3), SWAPMAP.COM, or DRVTYPE.EXE from your 
echo         Stacker directory, you must copy them from the Stacker diskette 
echo         to your Stacker directory before you can complete this process.
echo.
echo ERROR9 >> \stacdos5.log
goto errexit

:notstkr2
cls
echo ERROR10: The drive letter you have specified for your DOS directory, %_hd%
echo          is not a Stacker drive.
echo.
echo ERROR10 >> \stacdos5.log
goto errexit

:novid
cls
echo ERROR11: We could'nt find either the program VIDTYPE.EXE or DATETEST.COM 
echo          in the STACKER directory. Make sure that STACDOS5.BAT, VIDTYPE.EXE
echo          and DATETEST.COM are present in the STACKER directory on the 
echo          Stacker drive, then restart the batch file.
echo.
echo For example, if drive C: is a Stacker drive, your Stacker directory
echo is named STACKER, the DOS directory is named DOS, and you will be
echo installing from drive A:, type the following commands:
echo. 
echo                 COPY A:STACDOS5.BAT C:\STACKER 
echo                 COPY A:VIDTYPE.EXE C:\STACKER
echo                 COPY A:DATETEST.COM C:\STACKER
echo                 C:
echo                 CD \STACKER
echo                 STACDOS5 A: C: \DOS
echo. 
echo ERROR11 >> \stacdos5.log
goto errexit

:errmsg
echo STACDOS5 requires three parameters. Run STACDOS5.BAT from the Stacker 
echo directory on your Stacker drive with the following parameters:
echo.
echo               STACDOS5  d1:  d2:  dosdir  [stackerdir] 
echo.
echo          d1:  the drive letter of the diskette drive you will be installing
echo               your MS-DOS 5.0 Upgrade from. This must be A: or B:.
echo.
echo          d2:  the drive letter containing the DOS directory. This drive
echo               MUST be a Stacker drive.
echo.
echo       dosdir  the name of the DOS directory on your Stacker drive,
echo               (for example, \DOS).
echo.
echo [stackerdir]  optional parameter. The pathname (without drive letter) of 
echo               your Stacker directory, if other than \STACKER.
echo.
echo For example, if you're installing MS-DOS 5.0 from drive A:, the DOS
echo directory on drive C:, a Stacker drive, is called DOS, and your Stacker
echo files are in the C:\STACKER directory, type the following:
echo.
echo                    STACDOS5 A: C: \DOS
echo.
goto finish

:errexit
set >> %_b%\stacdos5.log
goto finish

:alldone
rem Be sure to keep the environment clean on exit.
set _b=
set _d=
set _fd=
set _fs=
set _hd=
set _sp=
:finish

