#include "FUNCky.h"

#ifdef __TURBO__
extern int _stklen = 8000;
#endif

char * filespec = "*.bmp                                                    ";
int dither = 128;

void main(void)
{

   int neg = 0, h;
   char ** filename = NULL;
   int flag, nKey, x, numfiles, start = 0;
   BITMAP * bm = NULL;
   char command[128];
   int height, width;

   IF( _argc() GT 0 )
      _argv(1, filespec);
   ENDIF

   /*
   *  Get the command line to check for /EGA /VGA
   */
   _command( command );

   /*
   *  Check for Bitmap files
   */
   numfiles = _filecount( filespec, A_NORMAL);
   IF( ! numfiles )   
      _stdoutline( "No BitMap files found...");
      return;
   ENDIF

   /*
   *  Allocate memory for BitMap file names
   */
   filename = _malloc( numfiles * sizeof(char *));
   IF( ! filename )
         _stdoutline("Memory allocation error...");
         return;
   ENDIF

   /*
   *  This holds the file names
   */
   FOR( x=0; x < numfiles; x++)
      filename[x] = (char *) _malloc(66);
      IF( ! filename[x] )
         numfiles = x-1;
         EXIT;
      ENDIF
   NEXT

   _settitle("[ FUNCky II Text Mode Windows BITMAP Viewer ]", 2, 113);
   _shadowtype( 3, 0, "\0xFF\0xFF\0xFF");

   /*
   *  This'll nuke the ninth bit on VGA adapters
   */
   _scanlines(350, 0);

   /*
   *  Setup BitMaps to display from the second font table
   *  and use 16 scanline high fonts.
   */
   _fontSize(16);
   _fontDefine(1, 2);

   /*
   *  Load the file names
   */
   _floadfile(filename, filespec, A_NORMAL, numfiles);

   DOWHILE( TRUE )

      DOWHILE (TRUE)

      /*
      *  Allocate a bitmap for this bitmap
      */
      h    = _fopen( filename[start], O_READONLY);
      flag = _bmpInfo( h, &height, &width);

      IF( flag GE 0 )
         IF( bm )
            _free(bm);
         ENDIF

         IF( height GT 160 )
            height = 160;
         ENDIF
         height = height + (height % 8 );
         bm = _bmpCreate(height, width, 5, 10, "\x0", 2, 31);

         IF( neg )
               _bmpRead(bm, h, dither);
         ELSE
               _bmpRead(bm, h, 0-dither);
         ENDIF

         _bmpLoad(bm);
      ENDIF

      _fclose(h);

      /*
      *  Display them.
      */
      _cls(23, " ");
      _printn(0,0,"",113, _maxcol()+1);
      _print(0,0,"Current BitMap: ", 113);

      _printn(0,18,filename[start], 113, 20);
      _printn(0,34, "\x1A \x1B To invert,  \x18\x19 Next/Previous Icon", 113, 40);

      _bmpDisplay( bm );

      nKey = _inkey(0);

         DOCASE

            CASE( nKey EQ ESC )
               _fontReset();
               return;

            CASE( nKey EQ DOWNARROW)
               start = start - IIF( start == 0, 0, 1);
               LOOP;

            CASE( nKey EQ UPARROW)
               start = start + IIF( start == numfiles-1, 0, 1);
               LOOP;

            CASE( nKey EQ RIGHTARROW)
               neg = 0;
               LOOP;

            CASE( nKey EQ LEFTARROW)
               neg = 1;
               LOOP;

         ENDCASE
      ENDDO
   ENDDO

}




