#include "FUNCky.h"

   /*
   *  QFS - Quick Filesize program.
   *  Total size of all files contained in subdirectory
   *  Does not count hidden or system attributes
	*	Usage: QFS [<pattern>]
	*
	* <pattern> can be specified with multiple file patterns
	* if they are enclosed in quotes in the command line
   */

void main(void)
{

   char buffer[128], filename[16], filesize[36];
   long total, size;
   int  count;

   total = 0L;
   count = 0;

   /*
   *  Display Sign on
   */
	_stdoutline( "Quick File Size   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

   /*
   *  Verify arguments, or use default
   */
   IF( _argc() LT 1)
      _findfirst( "*.*", A_NORMAL, filename);
   ELSE
      _findfirst( _argv(1, buffer), A_NORMAL, filename);
   ENDIF

   /*
   *  Loop till matching filename is a NULLSTR
   */
   DOWHILE(* filename)

      /*
      *  Count number of files, get the size, and calc total size
      */

      count++;
      size = _findsize();
      total += size;

      /*
      *  Get the next matching file
      */
      _findnext(filename);
      
   ENDDO

   /*
   *  Convert total size
   */
   _ltoa(total,filesize);
   _comma(filesize, filesize);

   /*
   *  and output totals
   */
   _stdout("\t");
   _stdout(filesize);
   _stdout(" total bytes in ");
   _itoa(count, buffer);
   _comma(buffer, buffer);
   _stdout(buffer);
   _stdoutline(" files.");

   return;
}
         
      
   

      

