#include "FUNCky.h"

extern int  MyCopy(int, void far **, long, long);
extern int  system(char far *);
extern int  CheckMacro(void);
extern void RecordPlayError(void);
extern void WriteFile(void);
extern void WriteState(NOTEPAD *, char *);
extern int  CheckSave(void);
extern int  Edit(NOTEPAD * np);

#define TOSWITCH  291
#define TOCAP     276
#define TOLOWER   277
#define TOUPPER   278
#define AERROR    28
#define ATITLE    30
#define ANORMAL   23
#define ABOLD     31
#define AREVERSE  113
#define TABSIZE   4
#define MAXLINES  3000
#define MAXCOLS   1024
#define BUFFSIZE  (1024 * 60)
#define RECORDMAX 1023
#define SINGLEBOX  "͸Գ "
#define SINGLEBOX2 "͸Գ"
#define ESC 27

#define COPYWIN      304
#define WINCOPY      305
#define READFILE     275
#define ALTP         281
#define GOTOBOOK     292
#define SOFTENTER    10
#define CTRLBACK     127
#define CTRLX        24
#define GRAYMINUS    4096
#define GRAYPLUS     4097
#define GRAYASTERISK 4098
#define GOTOLINE     290
#define PLAYBACK     -7
#define RECORD       -6
#define INSERTMODE   279
#define NEWFILENAME  280
#define DELLINE      288
#define DELEOL       293
#define SAVEBUFF     273
#define DELETEWORD   20
#define ADJUSTLEFT   287
#define KEYMARK      306
#define COPYBUFF     46
#define PASTE        22
#define MARKLINE     294

unsigned int save;
int h, clipsize;
NOTEPAD * np;
char far * text;
void far * screen;
int * recorder;
int reccount;
char filename[128];
char title[128];
char temp_buff[513];
char far * cr = "\x0d";
char far * crlf = "\x0d\x0a";

void main(void)
{

   int start_row = 1, start_col = 1, top_org = 1, left_org = 1;

   /*
   *  If arguments, open file
   */
   IF( _argc() GT 0 )

      /*
      *  Grab file or file pattern to edit
      */
      _argv(1, filename);

      /*
      *  Convert to fully qualified filename if wildcards used
      */
      IF( _chrany("*?", filename))
         _findfirst(filename, A_NORMAL, NULL);
         _findname(filename);
      ENDIF

      /*
      *  Whoops, no can do
      */
      IF( _empty(filename))
			_cls(7, " ");
			_print(0, 0, "No valid files were specified.",7);
			_csrput(1, 0);
			return;
		ENDIF

   ELSE

      /*
      *  Track down our saved info
      */
      h = _fopen("nstate.rst", O_READONLY);

      /*
      *  Whoops, no can do
      */
		IF( h EQ ERROR )
			_cls(7, " ");
			_print(0, 0, "No valid files were specified.",7);
			_csrput(1, 0);
			return;
		ENDIF

      /*
      *  Otherwise we'll read the whole thing in as a string.
      */
		_freadstr(h, temp_buff, 512);
		_fclose(h);

      /*
      *  Simple scan for the file= statement
      */
		h = _ati("file=", temp_buff);
		IF( h NE ERROR )

         /*
         *  Parse out the info
         */
			_token(&temp_buff[h], "= ", 2, filename);
			_token(&temp_buff[h], "= ", 3, title);
			left_org = _atoi(title);
			_token(&temp_buff[h], "= ", 4, title);
			top_org = _atoi(title);
			_token(&temp_buff[h], "= ", 5, title);
			start_col = _atoi(title);
			_token(&temp_buff[h], "= ", 6, title);
			start_row = _atoi(title);
		ELSE
         _strcpy(filename, "nstate.rst");
      ENDIF
   ENDIF

   reccount = 0;
   screen   = _malloc( 16000 );
   recorder = (int *) _malloc( (RECORDMAX + 1) * sizeof(int));
   text     = (char far *) _malloc( BUFFSIZE + 2);

   IF( screen EQ NULL OR recorder EQ NULL OR text EQ NULL )
      _cls(7, " ");
      _print(0,0,"I've fallen and can't get up!",7);
      _csrput(1,0);
      return;
   ENDIF

   IF( _isfile(filename, A_NORMAL) )
         h = _fopen( filename, O_READWRITE);
			IF( _flen(h) GE (long) BUFFSIZE - (MAXLINES * 4))
			    _cls(7, " ");
			    _print(0,0,"File is too large for me to digest.",7);
			    _csrput(1,0);
			    return;
         ENDIF
           _freadstr(h, text, BUFFSIZE - (MAXLINES * 4));
           _fclose(h);
   ELSE
         * text = 0;
   ENDIF

   _strappend( title, " ", filename, " ", NULL);
   _settitle (title, 1, ATITLE );
   _setshadow(FALSE);
   _box ( 0, 0, _lastrow()-1, _lastcol(), SINGLEBOX, ANORMAL );
   _printn ( _lastrow(), 0, "", ANORMAL, _lastcol()+1);
   _print ( _lastrow(), 48, " Line:       Col:       ", ANORMAL);
   _clock12(_lastrow(), _lastcol()-7, ANORMAL);
   _printn( _lastrow(), 0, "dNOTE v1.0 - (C) 1992 by dLESKO Inc.", ABOLD, 47);

   np = _npCreate ( 1, 1, _lastrow()-2, _lastcol()-1, ANORMAL, BUFFSIZE, MAXLINES, MAXCOLS, TABSIZE );

   _npStore ( np, 1, text);
   _npEolChar(np, 32);
   _npEofChar(np, 32);
   _npTabChar(np, 32);
   _npBlockColor(np, _roloc( _npColor(np, DEFAULT)));

	_npWinTopOrg(np, top_org);
	_npWinLeftOrg(np, left_org);
	_npCsrGoto(np, start_row, start_col);

   _npDisplay ( np );

   Edit(np);

   _npFree(np);
   _unclock12();
   _cls(7, " ");

}

int Edit(NOTEPAD * np)
{

   int insert = TRUE, marking = FALSE, nKey = 0, tKey = 0;
   int change = FALSE, hcount = 0, ecount = 0, RecordMode = FALSE;
   int PlayBack = FALSE, PlayIndex = 0, MacroFlag = FALSE;
   int xcode, h;
   unsigned char buff[128], buff2[128];
   char far * temp1, * temp2;

   _csrtype(0);

   DOWHILE( TRUE )

      _npDisplay ( np );
      _csrput ( _npScrRow(np), _npScrCol(np));
      _printn ( _lastrow(), _lastcol()-24, _utoa( _npCsrRow(np), buff), ANORMAL, 4 );
      _printn ( _lastrow(), _lastcol()-13, _utoa( _npCsrCol(np), buff), ANORMAL, 4 );

      IF( ! PlayBack )
         nKey  = _inkey(0);
         xcode = _xscancode();
         IF( nKey == 43 )
            IF( xcode == 0x4e )
               nKey = 4096;
            ENDIF
         ELSEIF( nKey == 45 )
            IF( xcode == 0x4a )
               nKey = 4097;
            ENDIF
         ELSEIF( nKey == 42 )
            IF( xcode == 0x37 )
               nKey = 4098;
            ENDIF
         ENDIF
      ELSE
        IF( PlayIndex GE RECORDMAX )
             _printn( _lastrow(), 0, "Macro Recorder is full.", AERROR, 47);
           LOOP;
        ENDIF

         nKey = recorder[PlayIndex];

         IF( nKey == 0 )
            PlayBack = FALSE;
            LOOP;
         ENDIF

         PlayIndex++;
      ENDIF

      IF( RecordMode )
         IF( nKey == PLAYBACK )
            RecordPlayError();
            LOOP;
         ELSE
            IF( nKey == RECORD )
               recorder[PlayIndex] = 0;
            ELSE
               recorder[PlayIndex++] = nKey;
            ENDIF
         ENDIF
      ENDIF

      IF( nKey != HOME )
         hcount = 0;
      ENDIF

      IF( nKey != ENDKEY )
         ecount = 0;
      ENDIF

      DOCASE

         CASE ( nKey >= 'A' AND nKey <= 'z' )
            IF ( insert )
               _npInsert ( np, nKey );
            ELSE
               _npOverWrite ( np, nKey );
            ENDIF
            LOOP;

         CASE ( nKey == LEFTARROW )
            _npCsrLeft ( np, 1 );
            LOOP;

         CASE ( nKey == RIGHTARROW )
            _npCsrRight ( np, 1 );
            LOOP;

         CASE ( nKey == UPARROW )
            _npCsrUp ( np, 1 );
            LOOP;

         CASE ( nKey == DOWNARROW )
            IF( _kbdstat(4) )
               WriteFile();
               return(0);
            ELSE
               _npCsrDown ( np, 1 );
            ENDIF
            LOOP;

         CASE ( nKey == BACKSPACE )
            change = TRUE;
            _npBackSpace ( np );
            LOOP;

         CASE ( nKey == DEL )
            change = TRUE;
            IF( marking )
               _npDeleteBlock ( np );
               _npUnMark ( np );
               marking = FALSE;
            ELSE
               _npDelete ( np );
            ENDIF
            LOOP;

         CASE ( nKey == DELEOL )
            change = TRUE;
            _npDeleteEnd ( np );
            LOOP;

         CASE ( nKey == CTRLRIGHT)
            _npWordRight ( np );
            LOOP;

         CASE ( nKey == CTRLLEFT )
            _npWordLeft ( np );
            LOOP;

         CASE ( nKey == DELETEWORD )
            change = TRUE;
            _npDeleteWord ( np );
            LOOP;

         CASE ( nKey ==  ADJUSTLEFT )
            change = TRUE;
            _npLeftJustify ( np );
            LOOP;

         CASE ( nKey == HOME )
            hcount++;
            IF( hcount == 1 )
               _npCsrHome ( np );
            ELSEIF( hcount == 2 )
               _npCsrTop( np );
            ELSEIF( hcount == 3 )
               _npHome( np );
               hcount = 0;
            ENDIF
            LOOP;

         CASE ( nKey == ENDKEY )
            ecount++;
            IF( ecount == 1 )
               _npCsrEnd ( np );
            ELSEIF( ecount == 2 )
               _npCsrBottom( np );
               _npCsrEnd ( np );
            ELSEIF( ecount == 3 )
               _npEnd( np );
               ecount = 0;
            ENDIF
            LOOP;

         CASE ( nKey == PGUP )
            _npPageUp ( np );
            LOOP;

         CASE ( nKey == PGDN )
            _npPageDown ( np );
            LOOP;

         CASE ( nKey == KEYMARK )
            marking = (! marking );
            IF ( marking )
               _npBeginMark ( np );
            ELSE
               _npUnMark ( np );
            ENDIF
            LOOP;

         CASE (nKey == 4096 )
            IF( marking )
               _npCopyBlock ( np );
               _printn( _lastrow(), 0, "Block copied to scrap.", ABOLD, 47);
               _npUnMark ( np );
               marking = FALSE;
            ELSE
               _npMarkLine(np);
               _npCopyBlock ( np );
               _printn( _lastrow(), 0, "Line copied to scrap.", ABOLD, 47);
               _npUnMark ( np );
          ENDIF

            LOOP;

         CASE (nKey == 4097 )
            IF( marking )
               _npCopyBlock ( np );
               _npDeleteBlock ( np );
               _printn( _lastrow(), 0, "Block deleted to scrap.", ABOLD, 47);
               _npUnMark ( np );
               marking = FALSE;
            ELSE
               _npMarkLine(np);
               _npCopyBlock ( np );
               _npCsrHome( np );
               _npDeleteEnd( np );
               _npDelete( np );
               _printn( _lastrow(), 0, "Line cut to scrap.", ABOLD, 47);
               _npUnMark ( np );
            ENDIF
            change = TRUE;

          LOOP;

         CASE (nKey == 4098 )
               _printn( _lastrow(), 0, "Haven't learned how to undo.", AERROR, 47);

         CASE ( nKey == NEWFILENAME )
            _printn( _lastrow(), 0, "New filename: ", ABOLD, 47);
            _untrim(filename, 33, NULL);

            tKey = _reads( _lastrow(), 14, filename, ABOLD, NULL);

            IF( tKey NE ESC AND (! _empty(filename)))
               change = TRUE;
               _alltrim(filename, NULL);
               _strappend( title, " ", filename, " ", NULL);
               _settitle (title, 1, 30 );
               _box ( 0, 0, _lastrow()-1, _lastcol(), SINGLEBOX2, ANORMAL );
            ENDIF

            _printn( _lastrow(), 0, "", ABOLD, 47);
            LOOP;

         CASE ( nKey == PASTE )
            change = TRUE;
            _npInsertBlock ( np, NULL );
            _printn(_lastrow(), 0, "Scrap Inserted.", ABOLD, 47);
            _npUnMark ( np );
            marking = FALSE;
            LOOP;

         CASE ( nKey == MARKLINE )
            marking = (! marking );
            IF ( marking )
               _npMarkLine ( np );
            ELSE
               _npUnMark ( np );
            ENDIF
            LOOP;

         CASE ( nKey == GOTOLINE )
            _printn( _lastrow(), 0, "Go to Line: ", ABOLD, 47);
            buff[5] = 0;
            _memset(buff, ' ', 5);
            tKey = _reads( _lastrow(), 12, buff, ABOLD, NULL);

            IF( tKey NE ESC )
               tKey = _atoi( buff );

               IF( tKey GT 0 )
                  _npGotoLine(np, tKey);
               ENDIF

            ENDIF

            _printn( _lastrow(), 0, "", ABOLD, 47);
            LOOP;

         CASE ( nKey == DELLINE )
            change = TRUE;
            _npDeleteLine(np);
            LOOP;

         CASE ( nKey == ALTP )
            IF( marking )
               temp1 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
               temp2 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
               _npCopyBlock(np);
               _npSavePad( np, temp1 );
               _strtran(temp1, cr, crlf, 1, DEFAULT, temp2);
               _lprintbyte(13, 1);
               _memlprint(temp2, _strlen(temp2), 1);
               _npUnMark(np);
               marking = FALSE;
               _free(temp1);
               _free(temp2);
            ENDIF
            LOOP;

         CASE ( nKey == INS )
            IF( marking )
                     change = TRUE;
                    _npInsertBlock ( np, NULL );
                    _printn(_lastrow(), 0, "Scrap Inserted.", ABOLD, 47);
                    _npUnMark ( np );
                    marking = FALSE;
            ENDIF
            LOOP;

         CASE ( nKey == WINCOPY )
            IF( marking )
               IF( _mswClipOpen() NE 0)
                     _printn(_lastrow(), 0, "Windows Clipboard not available.", ABOLD, 47);
                     LOOP;
               ENDIF

               temp1 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
               temp2 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
               _npCopyBlock(np);
               _npSavePad( np, temp1 );
               _strtran(temp1, cr, crlf, 1, DEFAULT, temp2);
               _mswClipWrite(temp2);
               _mswClipClose();
               _npUnMark(np);
               marking = FALSE;
               _free(temp1);
               _free(temp2);
               _printn(_lastrow(), 0, "Scrap Inserted to Clipboard.", ABOLD, 47);
            ENDIF
            LOOP;

         CASE ( nKey == COPYWIN )
            IF( _mswClipOpen() NE 0)
                  _printn(_lastrow(), 0, "Windows Clipboard not available.", ABOLD, 47);
                  LOOP;
            ENDIF

            clipsize = _mswClipSize();

            temp1 = (char far *) _malloc( clipsize );
            temp2 = (char far *) _malloc( clipsize );

            _mswClipRead( temp1 );
            _mswClipClose();

            _strtran(temp1, crlf, cr, 1, DEFAULT, temp2);
            _npInsertText(np, temp2);
            _printn(_lastrow(), 0, "Clipboard Inserted.", ABOLD, 47);
            _free(temp1);
            _free(temp2);
            LOOP;

         CASE ( nKey == INSERTMODE )
            insert = (! insert);
            IF ( insert );
               _csrtype( 0 );
            ELSE
               _csrtype( 1 );
            ENDIF
            LOOP;

         CASE ( nKey == GOTOBOOK )
            _printn( _lastrow(), 0, "Go to Bookmark [1-10]: ", ABOLD, 47);
            buff[5] = 0;
            _memset(buff, ' ', 5);
            tKey = _reads( _lastrow(), 23, buff, ABOLD, NULL);

            IF( tKey NE ESC )
               tKey = _atoi( buff );

               IF( tKey LT 1 OR tKey GT 10)
                  LOOP;
               ENDIF

               _npGoBookMark ( np, tKey );
            ENDIF
            _printn( _lastrow(), 0, "", ABOLD, 47);
            LOOP;

         CASE ( nKey == READFILE )
            _printn( _lastrow(), 0, "File: ", ABOLD, 47);
            buff[41] = 0;
            _memset(buff, ' ', 41);

            tKey = _reads( _lastrow(), 6, buff, ABOLD, NULL);

            IF( tKey NE ESC AND (! _empty(buff)))
               h = _fopen(buff, O_READONLY);
               IF( h == ERROR )
                  _printn( _lastrow(), 0, "Error reading file...", AERROR, 47);
                  LOOP;
               ENDIF

               temp1 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4) + 1);
               _freadstr(h, temp1, BUFFSIZE - (MAXLINES * 4));
               _fclose(h);
               buff[0] = 138;
               buff[1] = 141;
               buff[2] = 10;
               buff[3] = 0;

               buff2[0] = ' ';
               buff2[1] = ' ';
               buff2[2] = 0;

               _chrswap(temp1, buff, buff2, NULL);
               _npInsertText(np, temp1);
               change = TRUE;
               _free(temp1);
            ENDIF

            _printn( _lastrow(), 0, "", ABOLD, 47);
            LOOP;

         CASE ( nKey GE 376 AND nKey LE 385 )
            _printn( _lastrow(), 0, "Bookmark dropped.", ABOLD, 47);
            _npSetBookMark ( np, nKey - 375 );
            LOOP;

         CASE ( nKey GE -39 AND nKey LE -30)
            _npGoBookMark ( np, _abs(nKey) - 29 );
            LOOP;

         CASE ( nKey ==  ESC OR nKey == 301)
            IF( change )
               IF( ! CheckSave() );
                  WriteState(np, filename);
                  return (FALSE);
               ENDIF
            ELSE
               WriteState(np, filename);
               return (FALSE);
            ENDIF
            LOOP;

         CASE ( nKey == SAVEBUFF )
            IF( marking )
               _printn( _lastrow(), 0, "Write block as: ", ABOLD, 47);
               buff[31] = 0;
               _memset(buff, ' ', 31);
               tKey = _reads( _lastrow(), 16, buff, ABOLD, NULL);

               IF( tKey NE ESC )
                  _strappend( buff2, "Writing ", _alltrim(buff, NULL), "...", NULL);
                  _printn( _lastrow(), 0, buff2, ABOLD, 47);
                  h = _fcreate( buff, C_READWRITE);
                  temp1 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
                  temp2 = (char far *) _malloc( BUFFSIZE - (MAXLINES * 4));
                  _npCopyBlock(np);
                  _npSavePad(np, temp1);
                  _strtran(temp1, cr, crlf, 1, DEFAULT, temp2);
                  _fwrite(h, temp2, _strlen(temp2));
                  _fclose(h);
                  _free(temp1);
                  _free(temp2);
               ENDIF
               _printn( _lastrow(), 0, "", ABOLD, 47);
               LOOP;
            ENDIF

            IF( ! change )
               _printn( _lastrow(), 0, "File has not been modified -- not written.", AERROR, 47);
               LOOP;
            ELSE
               WriteFile();
               change = FALSE;
            ENDIF
            LOOP;

         CASE ( nKey == TOUPPER )
            IF( marking )
					save = _npCsrIndex(np, 0);
               _npCopyBlock(np);
               temp1 = (char far *) _malloc( _npPadSize(np) + 1 );
               _npSavePad(np, temp1);
					_upper(temp1, NULL);
					_npDeleteBlock(np);
					_npRestorePad(np, temp1);
					_npInsertBlock(np, NULL);
               _free(temp1);
					change = TRUE;
					_npCsrIndex(np, save);
            ENDIF

         CASE ( nKey == TOLOWER )
            IF( marking )
					save = _npCsrIndex(np, 0);
               _npCopyBlock(np);
               temp1 = (char far *) _malloc( _npPadSize(np) + 1 );
               _npSavePad(np, temp1);
					_lower(temp1, NULL);
					_npDeleteBlock(np);
					_npRestorePad(np, temp1);
					_npInsertBlock(np, NULL);
               _free(temp1);
					change = TRUE;
					_npCsrIndex(np, save);
            ENDIF

         CASE ( nKey == TOCAP )
            IF( marking )
					save = _npCsrIndex(np, 0);
               _npCopyBlock(np);
               temp1 = (char far *) _malloc( _npPadSize(np) + 1 );
               _npSavePad(np, temp1);
					_capfirst(temp1, NULL);
					_npDeleteBlock(np);
					_npRestorePad(np, temp1);
					_npInsertBlock(np, NULL);
               _free(temp1);
					change = TRUE;
					_npCsrIndex(np, save);
            ENDIF

         CASE ( nKey == TOSWITCH )
            IF( marking )
					save = _npCsrIndex(np, 0);
               _npCopyBlock(np);
               temp1 = (char far *) _malloc( _npPadSize(np) + 1 );
               _npSavePad(np, temp1);
					_strswitch(temp1, NULL);
					_npDeleteBlock(np);
					_npRestorePad(np, temp1);
					_npInsertBlock(np, NULL);
               _free(temp1);
					change = TRUE;
					_npCsrIndex(np, save);
            ENDIF


         CASE ( nKey == RECORD )
            IF( MacroFlag AND (! RecordMode))
               IF( ! CheckMacro())
                  LOOP;
               ENDIF
            ENDIF

            PlayIndex  = 0;
            MacroFlag  = TRUE;
            RecordMode = (! RecordMode);
            IF( RecordMode )
               _printn( _lastrow(), 0, "Defining keystroke macro.", ABOLD, 47);
            ELSE
               _printn( _lastrow(), 0, "Keystroke macro defined.", ABOLD, 47);
            ENDIF
            LOOP;

         CASE ( nKey == PLAYBACK )
            PlayIndex = 0;
            PlayBack = TRUE;
            LOOP;

         OTHERWISE
            change = TRUE;
            IF( nKey == 127 )
               IF( _kbdstat( 4 ) )
                  _npWordLeft( np );
                  _npDeleteWord ( np );
                  LOOP;
               ENDIF
            ENDIF

            IF( nKey == 10 )
               IF( _kbdstat(4) )
                  _npCsrHome( np );
                  _npCsrDown(np, 1);
                  _npInsert(np, 13);
                  _npCsrUp(np, 1 );
                  LOOP;
               ENDIF
            ENDIF

            IF ( insert )
               _npInsert ( np, nKey );
            ELSE
               IF ( nKey NE ENTER )
                  _npOverWrite ( np, nKey );
               ELSE
                  _npCsrDown ( np, 1 );
                  _npCsrHome ( np );
               ENDIF
            ENDIF
      ENDCASE

   ENDDO

return(FALSE);
}

void WriteFile(void)
{

   char buff[128], merge[256];


   _fmerge("*.bak", filename, merge);
   _ffcopy(filename, merge, MyCopy);

   _strappend( buff, "Opening ", filename, "...", NULL);
   _printn(_lastrow(), 0, buff, ABOLD, 47);

   _npRetrieve(np, 1, text);

   _strappend( buff, "Writing ", filename, "...", NULL);
   _printn( _lastrow(), 0, buff, ABOLD, 47);

   h = _fcreate( filename, C_READWRITE);
   _fwrite(h, text, _len(text));
   _fclose(h);

   _printn( _lastrow(), 0, "Write Successful.", ABOLD, 47);

}

int CheckSave(void)
{

   int tKey = 0, r;

   _printn( _lastrow(), 0, "1 buffer has not been saved. Exit [ynw] ?", ABOLD, 47);
   _csrput( _lastrow(), 42);

   tKey = _nupper( _inkey(0) );

   IF( tKey EQ 'Y')
      r = FALSE;
   ELSEIF( tKey EQ 'N')
      r = TRUE;
   ELSEIF( tKey EQ 'W')
      WriteFile();
      r = FALSE;
   ENDIF

   _printn( _lastrow(), 0, "", ABOLD, 47);

return(r);
}

void RecordPlayError(void)
{
   _printn( _lastrow(), 0, "Can't playback while remembering.", AERROR, 47);
}


int CheckMacro(void)
{

   int k = 0;
   char buff[16];

   _printn( _lastrow(), 0, "Overwrite existing keyboard macro [yn]? ", ABOLD, 47);
   _csrput( _lastrow(), 40);

   k = _inkey(0);
   _chr( (unsigned char) k, buff);

   IF( k != 27 )
      _printn( _lastrow(), 40, buff, ABOLD, 1);
      _csrput( _lastrow(), 41);
   ENDIF

   _printn( _lastrow(), 0, "", ANORMAL, 47);

return( _nupper(k) == 'Y' );
}

int MyCopy(int size, void far ** buff, long len, long left)
{

   char tbuff[32];
   static long bytes = 0L;

   bytes += len;
   _ultoa(bytes, tbuff);
   _printn( _lastrow(), 0, "Creating backup file... ", ABOLD, 47);
   _printn( _lastrow(), 24, tbuff, ABOLD, 18 );
   _printn( _lastrow(), 24 + _strlen(tbuff), "written.", ABOLD, 18 );

return(size);
}

void WriteState(NOTEPAD * np, char * filename)
{

   char tbuff[256], tbuff2[32];

   _strcpy(tbuff, "file=");
   _strcat(tbuff, filename);
   _strcat(tbuff, " ");
   _strcat(tbuff, _itoa( _npWinLeftOrg(np, DEFAULT), tbuff2));
   _strcat(tbuff, " ");
   _strcat(tbuff, _itoa( _npWinTopOrg(np, DEFAULT), tbuff2));
   _strcat(tbuff, " ");
   _strcat(tbuff, _itoa( _npCsrCol(np), tbuff2));
   _strcat(tbuff, " ");
   _strcat(tbuff, _itoa( _npCsrRow(np), tbuff2));
   
   h = _fcreate( "nstate.rst", C_READWRITE);
   _fwrite(h, tbuff, _len(tbuff));
   _fclose(h); 

}
