#include "FUNCky.h"

   /*
   *  FWC - FUNCky Word Count.
   *  Count words in a file or group of files.
	*	Usage: FWC <pattern>
   *
   *  Link with a STACK size of 10000 highly recursive!!!
   */

extern int myfunc(char *, char *);
extern int myfunc2(int, long, char *, char *);

char * filebuffer;
char buff2[128];
int dcount   = 0;
long wcount  = 0L;
long total   = 0L;

void main(void)
{

	char filebuff[128], drive[3], path[65], name[16], ext[5], buff[25];

	/*
	*	Print our copyright message
	*/
	_stdoutline( "FUNCky Word Count   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

	/*
	*	Get the file pattern
	*/
	IF(_argc() < 1 )
      _strcpy( filebuff, "*.*" );
   ELSE
   	_argv(1, filebuff);
	ENDIF

   /*
   * If no spaces in file argument, make it valid
   * Otherwise assume it means multiple file specs...
   */
   IF( _chrcount(" ", filebuff) LT 1 )
   	_fsplit(filebuff, drive, path, name, ext);

   	IF( _empty(drive));
   		_curdrive(drive);
   	ENDIF

   	IF( _empty(path))
   		_getdir(drive, path);
   	ENDIF

   	IF( _empty(name))
   		IF( _empty(ext))
   			_strcat(name, "*");
   			_strcat(ext, ".*");
   		ENDIF
   	ENDIF

   	/*
   	*	Make valid drive specifier
   	*/
   	_fmake(drive, path, name, ext, filebuff);

   ENDIF


   /*
   * Allocate memory to read in files < 65000 bytes
   */
   filebuffer = (char *) _malloc(65000); 

   IF( ! filebuff )
		_stdoutline("Memory Allocation Error");
		return;
   ENDIF
 
	/*
	*	Use call to _filescan() to search all matching files
	*/
	_filescan(filebuff, A_NORMAL, myfunc);

	/*
	*	Print tally of files scanned and Words Counted
	*/
	_itoa(dcount, buff);
	_stdouts("\r\n", buff, " file(s) searched, ", NULL);
	_ltoa(total, buff);
	_stdouts( _comma( buff, buff2) , " words counted. ", "\r\n", NULL);

   _free(filebuff);

}

int myfunc(char * filename, char * fullname)
{

	int handle, len;
   long flen;
	char buffer[128];

   /*
   * Open matching file
   */
	handle = _fopen(fullname, O_READONLY | S_DENYNONE);

   /*
   * Increment number of files scanned
   */
	dcount++;

   /*
   * wcount comes back with a word count
   */
	wcount = 0L;

   IF( (flen = _flen( handle)) LT 65000L )
      len = _fread( handle, filebuffer, (int) flen);
      filebuffer[len] = 0;
      wcount = (long) _numtoken( filebuffer, NULL);
   ELSE
   	_fscanline(handle, NULL, myfunc2);
   ENDIF

	_fclose(handle);

   /*
   * Add to the total and print out results for
   * this last file.
   */
   total += wcount;

	_ltostr(wcount, 6, buffer);
	_stdouts(buffer, " Words in ", fullname, "\r\n", NULL);

return(1);
}
	
int myfunc2(int handle, long pos1, char * str, char * line)
{

   /*
   * Count number of words in each line using _numtoken()
   */
   wcount += (long) _numtoken( line, NULL);

return(FALSE);
}


