#include "FUNCky.h"

   /*
   *  FTS - FUNCky Text Search
   *  Search all files for text, can include
	*	wildcard characters in text. When using wildcards,
	*	use * before and after the text string.
	*	Compile with stack size of at least 20000! highly recursive.
	*	Usage: FTS <pattern> <text>
   */

extern int myfunc(char *, char *);
extern int myfunc2(int, long, char *, char *);

char buff2[128];
int dircount = 1;
int dcount   = 0;
int wildflag = FALSE;
long lcount  = 0L;
long occur   = 0L;

void main(void)
{

	char filebuff[128], drive[3], path[65], name[16], ext[5], buff[25];

	/*
	*	Print our copyright message
	*/
	_stdoutline( "FUNCky Text Search   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

	/*
	*	Get the str and check for wildcards
	*/
	_argv(2, buff2);

	IF(_empty(buff2))
		_stdoutline("Usage: FTS <files> <text>");
		return;
	ENDIF

	IF( _chrany("*?", buff2))
		wildflag = TRUE;
	ENDIF

	/*
	*	Check the file argument
	*/
	_argv(1, filebuff);
	_fsplit(filebuff, drive, path, name, ext);
	IF( _empty(drive));
		_curdrive(drive);
	ENDIF
	IF( _empty(path))
		_getdir(drive, path);
	ENDIF
	IF( _empty(name))
		IF( _empty(ext))
			_strcat(name, "*");
			_strcat(ext, ".*");
		ENDIF
	ENDIF

	/*
	*	Make valid drive specifier
	*/
	_fmake(drive, path, name, ext, filebuff);

	/*
	*	Use call to _filescan() to search
	*/
	_filescan(filebuff, A_NORMAL, myfunc);

	/*
	*	Print tally of files scanned and text found
	*/
	_itoa(dcount, buff);
	_stdouts("\r\n", buff, " file(s) searched, ", NULL);
	_ltoa(occur, buff);
	_stdouts(buff, " occurrence(s) found. ", "\r\n", NULL);

}

int myfunc(char * filename, char * fullname)
{

	int handle;
	char buffer[128];

	_stdouts("Scanning : ", fullname, "\r\n", NULL);
	handle = _fopen(fullname, O_READONLY | S_DENYNONE);
	lcount = 0L;
	dcount++;
	_fscanline(handle, buff2, myfunc2);
	_fclose(handle);

return(1);
}

int myfunc2(int handle, long pos1, char * str, char * line)
{

	char buff[35];
	int pos;

	lcount++;
	IF(wildflag)
		pos = _wildat(str, line, FALSE);
	ELSE
		pos = _ati(str, line);
	ENDIF

	IF(pos NE ERROR)
		occur++;
		line+= pos;
		_truncate(line, 50);
		_untrim(_ltoa(lcount, buff), 5, NULL);
		_stdouts("   Line# ", buff, "- ", line, "\r\n", NULL);
	ENDIF

return(FALSE);
}

	

