#include "FUNCky.h"

   /*
   *  FLD - FUNCky List Directories
   *  List all directories found
	*	Compile with stack size of at least 20000! highly recursive.
	*	Usage: FLD [<directory>]
   */

extern int myfunc(char *, char *);
extern int myfunc2(char *, char *);

int dircount = 1;

void main(void)
{

	char filebuff[128], drive[5], path[65], fname[15];
	int backflag;

	/*
	*	Print our copyright message
	*/
	_stdoutline( "FUNCky List Directories   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

	/*
	*	Get the command line arguments as uppercase
	*/
	_upper( _argv(1, filebuff), NULL);

	/*
	*	Make and print out first directory. Use fname since
	*	last directory in filename gets treated like a filename
	*/
	_fsplit(filebuff, drive, path, fname, NULL);
	IF( path[0] EQ 0)
		path[0] = '\\';
		path[1] = 0;
		backflag = FALSE;
	ELSE
		IF(path[0] EQ '\\' AND path[1] EQ 0)
			backflag = FALSE;
		ELSE
			backflag = TRUE;
		ENDIF
	ENDIF
	_fmake(drive, path, fname, "", filebuff);
	_stdouts("  ", filebuff, "\r\n", NULL);

	IF(backflag)
		_strcat(filebuff, "\\");
	ENDIF

	/*
	*	Use recursive calls to _filescan() to print directories
	*/
	_strcat(filebuff, "*.*");
	_filescan(filebuff, A_DIRECTORY, myfunc);

	/*
	*	Print count and leave
	*/
	_itoa(dircount, filebuff);
	_stdouts("\r\n", filebuff, " directories", "\r\n", NULL);

}

int myfunc(char * filename, char * fullname)
{

	int 	result;
	char buffer[65];

	/*
	*	Make sure the directory name isn't . or ..
	*	If it isn't, append \*.* and get the count of
	*	Directories (less . and ..)
	*/
	IF(filename[0] NE '.')
		_strcpy(buffer, fullname);
		_strcat(buffer, "\\*.*");
		result = _filescan(buffer, A_DIRECTORY, myfunc2);

		/*
		*	If we made it this far, we have at least one
		*	directory name
		*/
		_stdouts("  ", fullname, "\r\n", NULL);

		/*
		*	If there are more directories, call ourselves
		*	Until <result> comes back 0
		*/
		IF(result GT 0)
			_filescan(buffer, A_DIRECTORY, myfunc);
		ENDIF

		/*
		*	every time we make it to here we've printed 1 more
		*/
		dircount++;
	ENDIF

return(1);
}

int myfunc2(char * filename, char * fullname)
{

	/*
	*	Only count those directories that are not . or ..
	*	returning a 2 means to ignore this entry in the
	*	count that _filescan() returns.
	*/
	IF( (filename[0] EQ '.' AND filename[1] EQ 0))
		return(2);
	ELSEIF( (filename[0] EQ '.' AND filename[1] EQ '.' AND filename[2] EQ 0 ))
		return(2);
	ENDIF

return(1);
}
