#include "FUNCky.h"

   /*
   *  FLC - FUNCky Line Count
   *  Count all lines in specified file(s)
	*	Compile with stack size of at least 6000 - recursive.
	*	Usage: FLC <pattern>
   */

extern int myfunc(char *, char *);

char buff2[128];
int dcount   = 0;
long lcount  = 0L;
long total   = 0L;

void main(void)
{

	char filebuff[128], drive[3], path[65], name[16], ext[5], buff[25];

	/*
	*	Print our copyright message
	*/
	_stdoutline( "FUNCky Line Count   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

	/*
	*	Get the file pattern
	*/
	IF(_argc() < 1 )
      _strcpy( filebuff, "*.*" );
   ELSE
   	_argv(1, filebuff);
	ENDIF

	/*
	*	Check the file argument
	*/

	_fsplit(filebuff, drive, path, name, ext);
	IF( _empty(drive));
		_curdrive(drive);
	ENDIF
	IF( _empty(path))
		_getdir(drive, path);
	ENDIF
	IF( _empty(name))
		IF( _empty(ext))
			_strcat(name, "*");
			_strcat(ext, ".*");
		ENDIF
	ENDIF

	/*
	*	Make valid drive specifier
	*/
	_fmake(drive, path, name, ext, filebuff);

	/*
	*	Use call to _filescan() to search
	*/
	_filescan(filebuff, A_NORMAL, myfunc);

	/*
	*	Print tally of files scanned and Lines found
	*/
	_itoa(dcount, buff);
	_stdouts("\r\n", buff, " file(s) searched, ", NULL);
	_ltoa(total, buff);
	_stdouts( _comma( buff, buff2) , " lines found. ", "\r\n", NULL);

}

int myfunc(char * filename, char * fullname)
{

	int handle;
	char buffer[128];

	handle = _fopen(fullname, O_READONLY | S_DENYNONE);

	dcount++;
	lcount = _flinecount( handle );
   total += lcount;

	_fclose(handle);

	_ltostr(lcount, 6, buffer);
	_stdouts(buffer, " Lines in ", fullname, "\r\n", NULL);

return(1);
}
	


