#include "FUNCky.h"

   /*
   *  FCD - FUNCky Change Directory
   *  Find a file on the specified drive(s) or directory(s)
	*  and change to that drive and directory if found.
	*	Compile with stack size of at least 6000.
	*	Usage: FCD <file> [<drive | directories>]
	*
	* Note: Only finds the first file 
   */

void main(void)
{

	char filename[128], paths[128], foundfile[128], drive[5], dir[65];

	/*
	*	Print our copyright message
	*/
	_stdoutline( "FUNCky Change Directory   Version 1.0");
   _stdoutline( "Copyright (C) dLESKO Inc. 1992.  All Rights Reserved");
   _stdoutline( "");

	/*
	*	Get the command line arguments as uppercase
	*/
	_upper( _argv(1, filename), NULL);
	_upper( _argv(2, paths), NULL);

	/*
	*	Verify arguments
	*/
	IF( filename[0] EQ 0)
		_stdoutline("Usage:  FCD <file> [<drive | directories>]");
		return;
	ENDIF

	_filefind(filename, paths, foundfile);

	IF( ! _empty( foundfile ))
		_findfirst( foundfile, A_NORMAL, NULL);
		_findname( foundfile);
		_stdouts("File found: ", foundfile, "\r\n", NULL);
		_fsplit( foundfile, drive, dir, NULL, NULL);
		_setdrive( drive );
		_chdir( dir );
	ELSE
		_stdoutline("File not found...");
	ENDIF

}


