/*
  Ŀ
 ݳ                                                                         
 ݳ   Program : Browse                                                      
 ݳ   Purpose : Browse a DBF file with optional index and scoping           
 ݳ   Usage   : Browse [<DBFname>] [<NTXname>]  <enter>                     
 ݳ                                                                         
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1990, dLESKO INC. All Rights reserved.        
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
  
 
*/

// standard colors
#define cBACKCOLOR    1         // blue on black
#define mBACKCOLOR    7         // white on black
#define MONOCOLOR    112        // black on White
#define COLORCOLOR   23         // white on Blue
#define DEFAULT      -2         // tells FUNCky to use default colors
#define cTITLECOLOR  30         // yellow on blue for title
#define mTITLECOLOR  112        // or black on white if mono

// background pattern for 2.00 stuff
STATIC pattern := ""

// array of titles and fields, first column has scoping rule
STATIC titles := {}
STATIC fields := {}


FUNCTION browse()


LOCAL x, y, r, color, tcolor, bcolor, tempscrn, lcol := lastcol(),;
      lrow := lastrow(), DBFname := upper(argv(1)), NTXname := argv(2)

        /*
        * Mouse reset and csr off
        */
        m_reset()
        csroff()

        IF( fontValid(1))
                m_install(1)
        ENDIF

        IF (! iscolor()) .or. ("/M" $ upper(command()))
                standard(MONOCOLOR)
                bcolor := mBACKCOLOR
                tcolor := mTITLECOLOR
        ELSE
                standard(COLORCOLOR)
                bcolor := cBACKCOLOR
                tcolor := cTITLECOLOR
        ENDIF

        /*
        * Fixup filenames and
        * Check for presence of files
        */
        IF( argc() < 1 )
                ? 
                ? "Usage:  Browse <DBFname> [<NTXname>]   <enter>"
                ?
                quit
        ENDIF

        IF( argc() > 0)
                IF( chrfound(".", DBFname))
                        DBFname := strswap( DBFname, ".", 2, "")
                ENDIF

                IF( ! isfile(DBFname+".dbf"))
                        ? "Can't find "+DBFname
                        quit
                ENDIF
        ENDIF

        IF( argc() > 1)
                IF( chrfound(".", NTXname))
                        NTXname := strswap( NTXname, ".", 2, "")
                ENDIF

                IF( ! isfile(NTXname+".mdx"))
                        ? "Can't find "+NTXname
                        quit
                ENDIF
        ENDIF

        /*
        * save a copy of the incoming screen
        */
        tempscrn := savevideo()

        /*
        * Black shadow works best on patterned background
        */
        shadowtype( 3, 0, "")

        // Top line centered title default color
        settitle( "[ THE " + DBFname + " DATABASE ]", 1, tcolor )

        /*
        * Use the files
        */
        IF( argc() > 1 )
                use (DBFname) index (NTXname)
        ELSE
                use (DBFname)
        ENDIF

        /*
        * Verify we used it OK
        */
        IF( ! used() .or. fcount() < 1)
                ? "Error USEing "+ DBFname
                quit
        ENDIF

        /*
        * Verify index key has no unsupported external functions
        */
        IF( argc() > 1 )
                IF( "U" $ type( indexkey() ))
                        ? "Index key uses a function that is not available"
                        quit
                ENDIF
        ENDIF

        /*
        * Setup titles and fields - Afields() is not recommended
        * and DBstruct is just too ambitious for this
        */
        titles := array(fcount())
        fields := array(fcount())

        FOR x = 1 to fcount()
                titles[x] := fieldname(x)

                y := type( titles[x] )
                IF( y = "M" )
                        fields[x] := ["MEMO"]
                ELSEIF ( y = "C" )
                        fields[x] := titles[x]
                ELSEIF ( y = "N" )
                        fields[x] := "str(" + titles[x] + ")"
                ELSEIF ( y = "D" )
                        fields[x] := "dtoc(" + titles[x] + ")"
                ELSEIF ( y = "L" )
                        fields[x] := "iif(" + titles[x] + ", [.T.], [.F.] )"
                ELSE
                        fields[x] := ["Unknown Field Type"]
                ENDIF

        NEXT

        /*
        * If index in use, setup first column as index key value
        */
        IF( argc() > 1 )
                AAdd(titles, 1)
                Ains(titles, 1)
                titles[1] := "Scoped on: "+ indexkey()+" "

                AAdd(fields, 1)
                Ains(fields, 1)
                y := type( indexkey() )

                IF ( y = "C" )
                        fields[1] := indexkey()
                ELSEIF ( y = "N" )
                        fields[1] := "str(" + indexkey() + ")"
                ELSEIF ( y = "D" )
                        fields[1] := "dtoc(" + indexkey() + ")"
                ELSEIF ( y = "L" )
                        fields[1] := "iif(" + indexkey() + ", [.T.], [.F.] )"
                ELSE
                        fields[1] := ["Unknown Index Key expression type"]
                ENDIF
        ENDIF

        /*
        * Display something useful
        */
        cls( bcolor, pattern)

        IF( argc() > 1 )
                print(0, 0, " DBF Browser With Scoping Demonstration", DEFAULT, lcol+1)
                print(lrow, 0, "Press ALT/F to create a filter (Use Quotes if String). No Filter means ALL", DEFAULT, lcol + 1)
        ELSE
                print(0, 0, " DBF Browser Demonstration", DEFAULT, lcol+1)
                print(lrow, 0, "", DEFAULT, lcol + 1)
        ENDIF

        /*
        * Mouse csr on after video is painted
        */
        m_csron()

        /*
        * Display a scoping browse, start with no scope. Use NIL so that 
        * the scoping flag is OFF to start with. Otherwise CTRL/END
        * CTRL/HOME skips through the entire file before hitting bof()
        * or eof(). Luckily it does it in blocks of 10 so its not that slow,
        * but is a lot slower than using NIL!
        */
        r := maxdbfscope(5, 5, lrow-5, lcol-5, titles, fields, DEFAULT, NIL )

        /*
        * Show what they picked
        */
        // Turn title off otherwise it displays here too!
        settitle("")

        IF( r > 0 )
                m_display("You Selected Record #: " + ltrim(str(r))+", Press Any key to Exit", DEFAULT )
        ENDIF

        /*
        * Get out of here
        */
        vidreset()
        restvideo(tempscrn)
        m_reset()
        csron()
        
return NIL

