/*
  Ŀ
 ݳ                                                                         
 ݳ   Program : Allfonts                                                    
 ݳ   Purpose : Display some EGA/VGA fonts                                  
 ݳ   Usage   : Allfonts <enter>                                            
 ݳ                                                                         
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1990, dLESKO INC. All Rights reserved.        
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
  
 
*/

#include "FUNCky.ch"

#define NUMFONTS 19
#define LOADFONT(x)  EVAL( tables[x] )

STATIC names := { ;
"3270        ", "AVANTGARD   ", "BAUHAUS     ", "BODONI      ", ;
"BROADWAY    ", "CALLIGRAPHY ", "COMPUTER    ", "COURIER     ", ;
"DIGITAL     ", "GARAMOND    ", "ITALIC1     ", "ITALIC2     ", ;
"LEGEND      ", "OLDENGLISH  ", "PARKAVE     ", "PERCY       ", ;
"ROMANY      ", "SCRIPT1     ", "SCRIPT2     " }

STATIC tables := { ;
{ || FL3270(1) }   , { || FLavantgard(1) }, { || FLbauhaus(1) }, ;
{ || FLbodoni(1) } , { || FLbroadway(1) }, { || FLcalligraphy(1) }, ;
{ || FLcomputer(1) }, { || FLcourier(1) }, { || FLdigital(1) }, ;
{ || FLgaramond(1) }, { || FLitalic1(1) }, { || FLitalic2(1) }, ; 
{ || FLlegend(1) }, { || FLoldenglish(1) }, { || FLparkave(1) }, ;
{ || FLpercy(1) }, { || FLromany(1) }, { || FLscript1(1) }, ;
{ || FLscript2(1) } }

FUNCTION main()


	LOCAL oldfont
	LOCAL curfont := 1

	/*
	*	Verify adaptor accepts EGA/VGA fonts
	*/
	IF( ! fontValid(1))
		stdoutline("EGA or VGA adaptor required...")
		return NIL
	ENDIF

	/*
	*	Save old font
	*/
	fontSave(0, fontHeight(), 256, 1, @oldfont)

	/*
	*	Display something
	*/
	cls(71, chr(177))
	box(10, 10, 20, 70, "", 23)
	print(12, 12, "This is the font: ", 23)
	print(12, 30, "DEFAULT ROM ", 23)
	print(14, 12, "ABCDEFGHIJKMLNOPQRSTUVWXYZ", 23)
	print(14, 40, "abcdefghijkmlnopqrstuvwxyz", 23)
	print(16, 12, "Press any key to view next font...", 23)

	/*
	*	Use another macro to access the tables directly
	*/
	DO WHILE( curfont LE NUMFONTS )
		
		IF( inkey(0) EQ ESC)
			EXIT
		ENDIF

		LOADFONT( curfont )

		print(12, 30, names[curfont], 23)

		curfont++
	ENDDO

	print(16, 12, "Press any key to exit...          ", 23)
	inkey(0)

	/*
	*	Reset adaptor to default text mode values
	*/
	fontReset()
	
return NIL
