/* RE_SID: @(%)/usr/dosnfs/shades_SCCS/unix/serial/slipd40/usr/SCCS/s.sunslip.c 9.3 91/05/11 05:39:56 SMI */

/*
 * slip.c
 *
 * Dialup slip line allocator.
 *
 * Copyright 1987 by University of California, Davis
 *
 * Greg Whitehead 10-1-87
 * Computing Services
 * University of California, Davis
 */

/* Copyright (c) 1988-1990 Sun Microsystems, Inc.  Billerica, MA   */
/*   @(#)sunslip.c	9.3 	5/11/91    */

/*
 * This program provides a means to obtain a slip line on a dialup tty.
 * It reads the file USER_FL to determine if an interface is available,
 * and to make sure that no internet address logs in more than once.
 * It updates the file with each login/disconnect in order to maintain
 * a record of which addresses are attached to which interfaces.
 *
 * In order to "ifconfig" and "slattach", slip must run setuid to root.
 *
 * Extensively modified by
 *
 *	Geoff Arnold
 *	Sun Microsystems Inc.
 *	10-28-87
 *
 * Modifications include:
 *
 * - allowing hostnames instead of dotted addresses (see also "mkslipuser")
 * - writing a line describing the configuration assigned by "sunslip"
 *   to stdout; a corresponding PC program can parse this and use the
 *   addressing information to check/update its local state
 * - for Sun systems, replacing the calls to slattach/ifconfig with the
 *   equivalent ioctls
 *
 */

#define YELLOW_PAGES	1 /* assumes SLIP server is a YP server too */

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netdb.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "slip.h"


char *ttyname();
char *getlogin();

void bye();			/* SIGHUP handler to remove USER_FL entry */


int ufd = -1;			/* global info on USER_FL entry */
struct sl_urec urec;
int urec_i = -1;

struct ifreq ifr;

char *tty, *name;

extern char *attach_error_message; /* in attach.c */


main(argc,argv)
int argc;
char **argv;
{
    int uid;

    FILE *hfd;
    char host_line[80], host_name[80], host_addr[80];
    char local_addr[32], remote_addr[32];
    struct in_addr addr;
    struct hostent *h;
    struct hostent *hh;
    struct sl_urec urec_tmp;
    char sys_str[160];
    int x;
    int unit;


fprintf(stderr,"SUNSLIP\n");

    /*
     * Mask all signals except SIGSTOP, SIGKILL, and SIGHUP.
     *
     */
     sigsetmask(~sigmask(SIGHUP));
     signal(SIGHUP,SIG_DFL);


    /*
     * Must have a tty to attach to.
     *
     */
    if ((tty=ttyname(0))==NULL) {
	fail("Bad login port", NULL);
	/* NOTREACHED */
    }


    /*
     * Need uid to put in USER_FL.
     * (checking it is paranoid, but complete)
     *
     */
    if ((uid=getuid())<0) {
	fail("Bad uid", NULL);
	/* NOTREACHED */
    }


    /*
     * Must have a login name to look up.
     *
     */
    if ((name=getlogin())==NULL) {
	fail("Bad login name", NULL);
	/* NOTREACHED */
    }


    /*
     * Open HOST_FL.
     *
     */
    if ((hfd=fopen(HOST_FL,"r"))==NULL) {
	fail("Can't open list of valid user-host mappings", NULL);
	/* NOTREACHED */
    }


    /*
     * look up login name in host file.
     *
     */
    for (;;) {    
	if (fgets(host_line,80,hfd)==NULL) {
	    fail("User %s is not authorized to connect to SLIP", name);
		/* NOTREACHED */
	}
        if (*host_line!='#' && sscanf(host_line,"%s %s",host_addr,host_name)==2)
	    if (strcmp(name,host_name)==0)
		break;
    }
    fclose(hfd);


    /*
     * Build internet addr from HOST_FL entry.
     *
     */
    if((h = gethostbyname(host_addr)) != NULL)
        addr.s_addr = *((int *)h->h_addr);
    else
    if ((addr.s_addr=inet_addr(host_addr))<0) {
	fail("Invalid address %s in hosts file", host_addr);
	/* NOTREACHED */
    }


    /*
     * Open USER_FL and get an exclusive lock on it.
     *
     */
    if ((ufd=open(USER_FL,O_RDWR))<0) {
	fail("Can't open SLIP user file", NULL);
	/* NOTREACHED */
    }
    if (flock(ufd,LOCK_EX)<0) {
	close(ufd);
	fail("Unable to lock SLIP user file", NULL);
	/* NOTREACHED */
    }


    /*
     * Make sure that this internet address isn't already logged in,
     * and look for a free interface
     *
     */
    for (x=0;read(ufd,&urec_tmp,sizeof(urec_tmp))==sizeof(urec_tmp);x++)
	if (urec_tmp.sl_uid<0) {
	    if (urec_i<0) {
		urec_i=x;
		bcopy(&urec_tmp,&urec,sizeof(urec));
	    }
	}
	else if (urec_tmp.sl_haddr.s_addr==addr.s_addr) {
	    unlock_fail("Host %s is already attached",inet_ntoa(addr));
	/* NOTREACHED */
	}


    /*
     * If there is a free interface then take it.
     *
     */
    if (urec_i<0) {
	unlock_fail("All lines are busy. Try again later.");
	/* NOTREACHED */
    }

    strcpy(remote_addr, inet_ntoa(addr));
    strcpy(local_addr, inet_ntoa(urec.sl_saddr));

    h = gethostbyaddr(&addr, 4, AF_INET);
    printf("Attaching %s (%s)",
	h->h_name, remote_addr);
    hh = gethostbyaddr(&urec.sl_saddr, 4, AF_INET);
#ifdef YELLOW_PAGES
    getdomainname(host_line, 79);
    printf(" to domain %s via %s (%s)\n",
        host_line, hh->h_name, local_addr);
#else
    printf(" to network via %s (%s)\n",
        hh->h_name, inet_ntoa(urec.sl_saddr));
#endif
    unit = slattach(0, local_addr, remote_addr, 0);
    if(unit < 0) {
        unlock_fail("Unable to start SLIP: %s.", attach_error_message);
	/* NOTREACHED */
    }

    /*
     * Build and write USER_FL entry.
     *
     */
    urec.sl_unit = unit;
    urec.sl_haddr.s_addr = addr.s_addr;
    urec.sl_uid = uid;
    if (lseek(ufd,urec_i*sizeof(urec),L_SET)<0) {
	fprintf(stderr,"%s: can't seek\n",USER_FL);
	unlock_close(1);
    }
    signal(SIGHUP,bye);
    if (write(ufd,&urec,sizeof(urec))!=sizeof(urec)) {
	fprintf(stderr,"%s: can't write\n");
	clean_user(1);
    }


    /*
     * Through with critical code. Unlock USER_FL.
     */
    if (flock(ufd,LOCK_UN)<0)
	clean_user(1);



    /*
     * Wait until carrier drops.
     * clean_usr() will be called.
     *
     */
    for(;;)
        pause();
}


unlock_close(status)
int status;
{
    /*
     * Unlock and close USER_FL, and exit with "status".
     *
     */ 

    flock(ufd,LOCK_UN);
    sldetach(0);
    close(ufd);
    exit(status);
}

unlock_fail(s1, s2)
char *s1;
char *s2;
{
    /*
     * Unlock and close USER_FL, and fail
     *
     */ 

    flock(ufd,LOCK_UN);
    close(ufd);
    fail(s1, s2);
}

fail(s1, s2)
char *s1;
char *s2;
{
	fputs("\nConnection failure: ", stderr);
	fprintf(stderr, s1, s2);
	fputs("\n\n", stderr);
	exit(1);
}
clean_user(status)
int status;
{
    /*
     * mark line free in USER_FL, unlock and close USER_FL, and
     * exit with "status".
     *
     */ 

    urec.sl_uid = -1;
    if (lseek(ufd,urec_i*sizeof(urec),L_SET)<0 || write(ufd,&urec,sizeof(urec))!=sizeof(urec))
	status = -1;
    unlock_close(status);
}


void bye()
{
    /*
     * Handle SIGHUP.
     * Get an exclusive lock on USER_FL, mark line free in USER_FL,
     * unlock and close USER_FL, and exit with status 0.
     *
     */

    if (flock(ufd,LOCK_EX)<0) {
	close(ufd);
	exit(1);
    }
    clean_user(0);
}
