/* RE_SID: @(%)/usr/dosnfs/shades_SCCS/unix/serial/slipd40/usr/SCCS/s.mkslipuser.c 9.3 91/05/11 05:37:59 SMI */

/*
 * mkslipuser.c
 *
 * Creates a blank user file based on a description of the network
 * configuration.  Initializes the dialup slip system.
 *
 * Copyright 1987 by University of California, Davis
 *
 * Greg Whitehead 10-1-87
 * Computing Services
 * University of California, Davis
 */

/* Copyright (c) 1988-1990  Sun Microsystems, Inc.   Billerica, MA    */
/*  @(#)mkslipuser.c	9.3 	5/11/91     */

/*
 * This program creates the dialup slip USER_FL from a configuration file. The
 * configuration file consists of a number of one-line entries; one for
 * each simultaneous login that is allowed. The number of simultaneous
 * logins must, of course, be less than or equal to the number of interfaces
 * available. Each one-line entry contains an internet address (a.b.c.d format)
 * for the server side of the slip line. They may all be the same, or they may
 * be different, depending on how you prefer to administer your network.
 * The configuration file may also contain comments (lines starting with a #).
 *
 * Modified by Geoff Arnold, Sun Microsystems 10-21-87:
 *
 * Allow a hostname instead of a dotted internet address.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/types.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include "slip.h"


main(argc,argv)
int argc;
char **argv;
{
    FILE *cfd;
    char cline[80], cifname[80], cifaddr[80];
    int ufd;
    struct sl_urec urec;
    int free;
    struct hostent *h;
    char *c;


    /*
     * Open CONFIG_FL and USER_FL.
     *
     */
    if ((cfd=fopen(CONFIG_FL,"r"))==NULL) {
	perror(CONFIG_FL);
	exit(-1);
    }
    if ((ufd=open(USER_FL,O_WRONLY|O_CREAT,0644))<0) {
	perror(USER_FL);
	exit(-1);
    }


    /*
     * create USER_FL.
     *
     */
    urec.sl_uid = -1;
    while (fgets(cline,80,cfd)!=NULL)
	if (*cline!='#') {
            c = strchr(cline, '\n'); *c = '\0'; /* zap the newline */
            if ((h = gethostbyname(cline)) == NULL)
	        urec.sl_saddr.s_addr=inet_addr(cline);
            else
                urec.sl_saddr.s_addr = *((int *) h->h_addr); /* internet only */
	    if (write(ufd,&urec,sizeof(urec))!=sizeof(urec)){
		fprintf(stderr,"%s: write failed\n",USER_FL);
		fclose(cfd);
		close(ufd);
		exit(-1);
	    }
	}

    fclose(cfd);
    close(ufd);
    exit(0);
}
