/* Copyright (c) 1988-1990 Sun Microsystem, Inc.   Billerica, MA  */
/*  @(#)attach.c	9.2 	3/23/90     */

#include <stdio.h>
#include <sys/types.h>
#include <sgtty.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netdb.h>
#include <stropts.h>
#include <fcntl.h>

#ifndef SIOCGUNIT
/* SLIP - get unit number */
#define SIOCGUNIT       _IOR(i, 51, int)                /* get unit number */
#endif

char *attach_error_message = NULL;

int
slattach(ttyfd, source_name, destination_name, speed)
int ttyfd;
char *source_name;
char *destination_name;
int speed;	/* if 0 don't change */
{
	struct sgttyb sgtty;
	struct strioctl s;
	int fd;
	int n;
	struct	ifreq ifr;

#ifdef DEBUG
fprintf(stderr, "slattach(%d,%s,%s,0X%X)\n",
	 ttyfd, source_name, destination_name, speed);
#endif

#ifdef DEBUG
fprintf(stderr, "getting current sgtty settings\n");
#endif
	if (ioctl(ttyfd,TIOCGETP,&sgtty) < 0){
		attach_error_message = "unable to get tty parameters";
		return(-1);
	}
	if(speed)
		sgtty.sg_ispeed  = sgtty.sg_ospeed = speed;
	sgtty.sg_flags = RAW | ANYP;
#ifdef DEBUG
fprintf(stderr, "setting sgtty with RAW and speed requested\n");
#endif
	if (ioctl(ttyfd,TIOCSETP,&sgtty) < 0){
		attach_error_message = "unable to set tty parameters";
		return(-1);
	}

#ifdef DEBUG
fprintf(stderr, "pushing 'slip' streams module\n");
#endif
	if (ioctl(ttyfd,I_PUSH,"sl")<0){
		attach_error_message = "unable to push SLIP Streams module";
		return(-1);
	}

	s.ic_cmd = SIOCGUNIT;
	s.ic_dp = (caddr_t) &n;
	s.ic_len = sizeof(n);
	s.ic_timout = 0;
#ifdef DEBUG
fprintf(stderr, "issuing SIOCGUNIT ioctl (getting unit number) \n");
#endif
	if (ioctl(ttyfd, I_STR, &s) < 0) {
		attach_error_message = "couldn't determine SLIP unit number";
		return(-1);
	}

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
		attach_error_message = "unable to create socket";
		return(-1);
	}
	sprintf(ifr.ifr_name,"sl%d",n);

	if(getaddr(destination_name, (struct sockaddr_in *)&ifr.ifr_dstaddr))
		return(-1);
#ifdef DEBUG
fprintf(stderr, "issuing SIOCSIFDSTADDR ioctl (setting destination address) \n");
#endif
	if (ioctl(fd, SIOCSIFDSTADDR, (caddr_t)&ifr) < 0) {
		attach_error_message = "couldn't specify address of remote system";
		return(-1);
	}

	if(getaddr(source_name,(struct sockaddr_in *)&ifr.ifr_addr))
		return(-1);
#ifdef DEBUG
fprintf(stderr, "issuing SIOCSIFADDR ioctl (setting local address) \n");
#endif
	if (ioctl(fd, SIOCSIFADDR, (caddr_t)&ifr) < 0) {
		attach_error_message = "couldn't specify address of local system";
		return(-1);
	}

#ifdef DEBUG
fprintf(stderr, "issuing SIOCGIFFLAGS ioctl (getting flags) \n");
#endif
	if (ioctl(fd, SIOCGIFFLAGS, (caddr_t)&ifr) < 0) {
		attach_error_message = "couldn't get interface configuration";
		return(-1);
	}

	ifr.ifr_flags |= IFF_UP;

#ifdef DEBUG
fprintf(stderr, "issuing SIOCSIFFLAGS ioctl (getting flags) \n");
#endif
	if (ioctl(fd, SIOCSIFFLAGS, (caddr_t)&ifr) < 0) {
		attach_error_message = "couldn't mark interface as UP";
		return(-1);
	}
#ifdef DEBUG
fprintf(stderr, "SLIP interface sl%d is now up\n", n);
#endif
	return(n);

}

struct	in_addr inet_makeaddr();
static char errbuf[80];

int
getaddr(s, sin)
char *s;
struct sockaddr_in *sin;
{
	struct hostent *hp;
	struct netent *np;
	int val;

	bzero(sin, sizeof(struct sockaddr_in));
	hp = gethostbyname(s);
	if (hp) {
		sin->sin_family = hp->h_addrtype;
		bcopy(hp->h_addr, (char *)&sin->sin_addr, hp->h_length);
		return(0);
	}
	np = getnetbyname(s);
	if (np) {
		sin->sin_family = np->n_addrtype;
		sin->sin_addr = inet_makeaddr(np->n_net, INADDR_ANY);
		return(0);
	}
	sin->sin_family = AF_INET;
	val = inet_addr(s);
	if (val != -1) {
		sin->sin_addr.s_addr = val;
		return(0);
	}
	val = inet_network(s);
	if (val != -1) {
		sin->sin_addr = inet_makeaddr(val, INADDR_ANY);
		return(0);
	}
	sprintf(errbuf, "'%s' is not a valid host/network name or address\n", s);
	attach_error_message = errbuf;
	return(-1);
}


sldetach(ttyfd)
int ttyfd;
{
#ifdef DEBUG
fprintf(stderr, "popping 'slip' streams module\n");
#endif
	if (ioctl(ttyfd,I_POP, 0)<0){
		perror("unable to pop SLIP Streams module");
		return(-1);
	}
}
