FLAG 0 ;Debug flag;
FLAG 1 ;Player is out in open when ON, hiding when OFF.;  
FLAG 2  (* Player has offered treasures back to Sorcerer *)
FLAG 3 ;player hears Sorcerer's footsteps approaching;
FLAG 4 ;player has unlocked the teak box;
FLAG 5 ;player has told Zim how s/he got into his lab;
FLAG 6 ;Zim at door when ON, Zim able to block player's movements when OFF
FLAG 7 ;Player has jumped with Zim in room;
FLAG 8 ;player on a shelf when on;
FLAG 9 ;music box playing;
FLAG 10 ;falling walking stick flag:
FLAG 11 ;player in open drawer
REM: ANY commands

VARIABLE 1  ;how many times player kisses Sorcerer;
VARIABLE 2  ;how many times miniaturized player attacks Sorcerer;

COUNTER 1  ;How many turns player has been on the same tile with Zim;

REM: What happens when a player takes a plunge.

COMMAND ANY
 AtLocation 135
 NOT Present 399  ;No zim here;
 FlagOFF 3 player not hearing footsteps;
 Chance 8 ;of upsetting blackthorn stick;
 TurnFlagON 10 ;falling stick flag;
 PrintMessage 73 ;Stick falls;
 GoToRoom 80 ;The Fall Room;
 EndGame
END_COMMAND

COMMAND ANY
 AtLocation 80  (Player has fallen off a high place and ends back in lab)
 RelocateAll 18 0  ;all treasure in treasure room is lost, too;
END_COMMAND

COMMAND ANY
 AtLocation 80  ;Player has fallen off a high place and ends back in lab;
 IsCarryingSomething  ;tests to see if player has any of zim's stuff;
 SendAllToRoom 0   ;player loses all his treasure;
END_COMMAND

COMMAND ANY
 AtLocation 80  ;Player has fallen off a high place and ends back in lab;
 Present 399
 FlagON 6
 TurnFlagON 7  ; Falling player flag;
END_COMMAND

COMMAND ANY
 FlagOFF 7 Player not falling in Zim's presence
 AtLocation 80
 EndGame
END_COMMAND

COMMAND ANY
 NOT InRoom 399
 Destroy 399
END_COMMAND

REM: Zim Greenleaf's random entries into his magic laboratory.

COMMAND ANY
 FlagOFF 10
 CHANCE 1  (* Of Hearing Zim's approaching footsteps. *)
 NOT AtLocationLT 3    ;Player not in room less than Location 2;
 NOT AtLocationGT 171 ;Player not in room greater than 172 - Zim's normal lab; 
 NOT InRoom 399  ;Zim is not in the room -- yet;
 FlagOFF 3   ;player does not hear footsteps;
 PrintMessage 12    (* Player hears footsteps approaching laboratory *)
 TurnFlagON 1   ;player is out in open;
 TurnFlagON 3   ;player hears approaching footsteps;
END_COMMAND

COMMAND ANY
 FlagON 1   (Player is not in hiding)
 FlagON 3   ;player hears footsteps approaching
 NOT InRoom 399  ;Zim is not in the room -- yet;
 AtLocation  88 (but player is in closet)
 TurnFlagOFF 1  (Player is already in hiding, so Zim does not find him)
 PrintMessage 21   (* Players hears Zim come in, putter, and leave. *)
 TurnFlagOFF 3
 DoneWithTurn
END_COMMAND

COMMAND ANY
 FlagON 1    ; Player is not in hiding;
 FlagON 3   ;player hears footsteps approaching
 NOT InRoom 399  ;Zim is not in the room -- yet;
 AtLocationGT 16     Player is in room greater than Location 16
 AtLocationLT 20     Player is in room less than 20  (under bureau)
 OR
 AtLocation 89 ;but player is under mid-chest;
 OR
 AtLocation 131    ; Player is in top of date tree;
 OR
 AtLocationGT 89   ;under bookcase;
 AtLocationLT 94
 TurnFlagOFF 1  (Player is already in hiding, so Zim does not find him.)
 PrintMessage 13   (* Players hears Zim come in, putter, and leave. *)
 TurnFlagOFF 3
 DoneWithTurn
END_COMMAND

COMMAND ANY
 FlagON 1   ; Player is not in hiding;
 FlagON 3   ;player hears footsteps approaching;
 NOT InRoom 399  ;Zim is not in the room -- yet;
 AtLocation 10   ;cabinet;
 OR
 AtLocation 11
 OR
 AtLocation 38    ;cabinet;
 OR
 AtLocationGT 155    ;Player is in room greater than Location 155;
 AtLocationLT 169    ;Player is in room less than 20  (in cabinet);
 TurnFlagOFF 1  (Player is already in hiding, so Zim does not find him.)
 PrintMessage 121   (* Player sees Zim come in, putter, and leave. *)
 TurnFlagOFF 3
 DoneWithTurn
END_COMMAND  

COMMAND ANY
 FlagON 1  ;Player is not hiding.;
 FlagON 3   ;player hears footsteps approaching
 NOT InRoom 399  ;Zim is not in the room -- yet;
 AtLocationGT 135     ;Player is in room greater than Location 137;
 AtLocationLT 145     ;Player is in room less than 145 (inside bureau);
 OR
 AtLocationGT 150 ;drawer spaces;
 AtLocationLT 152
 TurnFlagOFF 1  ;(Player is already in hiding, so Zim does not find him.);
 PrintMessage 22   (* Players hears Zim come in, putter, and leave. *)
 TurnFlagOFF 3  ;no longer hearing approaching footsteps;
 DoneWithTurn
END_COMMAND

COMMAND ANY
 NOT InRoom 399 ;Zim is not in room -- yet;
 FlagON 1  ;Player is not hiding.;
 FlagON 3   ;player hears footsteps approaching;
 NOT AtLocationLT 3    Player is in room greater than Location 2
 NOT AtLocationGT 171 ;Player is in room less than 172 - Zim's normal lab *)
 PrintMessage 23   (* Ask and get answer to question "What should you do? *)
 PromptForYes   ;TRUE if yes;
 TurnFlagOFF 1    (* Turn flag off because player is hiding. *)
 PrintMessage 13   (* Players hears Zim come in, putter, and leave. *)
 TurnFlagOFF 3  ;no more footsteps;
 DoneWithTurn
END_COMMAND

COMMAND ANY
 FlagON 1  (player is not hiding)
 FlagON 3 ;player hearing footsteps approach;
 PrintMessage 11  (* Last warning for player *)
 PrintMessage 23   (* Shall we hide?;
 PromptForYes   ;TRUE if yes;
 TurnFlagOFF 1   ;player is hiding;
 PrintMessage 13   (* Zim comes in, putters, and leaves. *)
 TurnFlagOFF 3 ;player not hearing footsteps anymore;
 DoneWithTurn
END_COMMAND

COMMAND ANY
 FlagON 1 (* Player is not in hiding *)
 FlagON 3 ;player hearing footsteps;
 NOT AtLocationLT 2    ;Player not in room less than Location 2;
 NOT AtLocationGT 171 ;Player not in room greater than 172 - Zim's normal lab; 
 NOT InRoom 399  ;zim not in room
 Tone 65 1000  ;makes a sound;
 Tone 80 1000
 Tone 105 1000
 PrintMessage 10   ;Zim enters room;
 PutInCurrentRoom 399 ; Put Zim in current room;
 TurnFlagOFF 3  ;now that Zim is here, who needs footsteps?
 AddToGroup 399
END_COMMAND

COMMAND ANY
 Present 399  ;zim is in room
 FlagON 1 (* Player is not in hiding *)
 NOT AtLocationLT 3    ;Player not in room less than Location 3;
 NOT AtLocationGT 171 ;Player not in room greater than 172 - Zim's normal lab; 
 PrintMessage 9 ;Zim enters, introduces self; asks how player got in;
 TurnFlagOFF 1   ;player does not need to hide, zim's here;
 TurnFlagON 6  ;Zim is at door;
 DoneWithTurn
END_COMMAND

COMMAND ANY
 Present 399 ;Zim present;
 Present 301 ;Carnivora horriblis present;
 FlagON 6 ;Zim is at door;
 PrintMessage 60  ;Zim rescues player;
 Destroy 301  ;Whisks horriblis away.  (this will rarely happen!);
 TurnFlagOFF 6 ;Zim can prevent a jump;
 DoneWithTurn
END_COMMAND
        
COMMAND ANY
 Present 399   ;zim is present;
 FlagON 6   ;Zim is standing at door;
 FlagOFF 8  ;Tests if player is on shelf;
 AtLocationGT 104 ;in or on bookcase.  Any shelf lower than 105 Zim will miss;
 AtLocationLT 131  ;120 to 130 is the oak table;
 OR
 AtLocation 135  ;climbing the stick;
 OR
 AtLocation 142 ;drawer;
 OR
 AtLocationGT 144 ;bureau top;
 AtLocationLT 148
 TurnFlagON 8   ;Player on a shelf;
END_COMMAND

COMMAND ANY
 Present 399 ;zim present;
 FlagON 6  ;Zim is standing at door;
 AtLocationGt 150  ;Bench;
 AtLocationLT 154
 OR
 AtLocationGT 167 ;cabinet top;
 AtLocationLT 172
 OR
 AtLocation 199  ;on round table
 TurnFlagON 8 ;player on a shelf;
END_COMMAND

COMMAND ANY
 FlagON 6 ;zim at door;
 FlagON 8 ;player on shelf;
 AtLocation 135 ;climbing blackthorn stick;
 PrintMessage 116 ;Zim lifts stick and moves player;
 GoToRoom 117  ;sets him/her on top of the bookcase;
 TurnFlagOFF 6  ;Zim close to player;
 DoneWithTurn
END_COMMAND     

COMMAND ANY
 FlagON 8
 Present 399 
 AtLocation 199  ;on round table;
 VerbIsDirection
 FlagON 6  ;zim at door, far from player;
 TurnFlagON 7 ;falling player flag;
 PrintMessage 39  ;Zim runs forward to rescue player;
 Chance 50   ;of Zim catching player before he kills himself;      
 PrintMessage 41  ;Zim catches player;
 TurnFlagOFF 7  ;player not falling;
 GoToRoom 117   ;sets him/her on top of the bookcase;
 TurnFlagOFF 6  ;Zim close to player;
 DoneWithTurn
END_COMMAND     

COMMAND ANY
 Present 399
 FlagON 6  ;Zim far from player;
 FlagON 7  ;falling player flag;
 PrintMessage 40  ;Zim misses and has to fix up player before proceeding;
 GoToRoom 117  ;top of bookcase;
 PutInCurrentRoom 223  ;Gold bed;
 TurnFlagOFF 6  ;Zim close to player;
 TurnFlagOFF 7  ;falling player flag;
 DoneWithTurn
END_COMMAND 

COMMAND ANY
 Present 399
 FlagON 6 ;Zim is at door;
 FlagON 8  ;player was on bureau top;
 AtLocation 142  ;player has moved to open drawer;
 TurnFlagON 11  ;player in open drawer;
END_COMMAND

COMMAND ANY
 Present 399
 FlagON 6  ;Zim is at door;
 SendToRoom 252 63  ;Put big feet in Room 63;
END_COMMAND

COMMAND ANY
 CounterEquals 1 8  ;player has been close to zim for 8 turns.;
 PrintMessage 141
 GoToRoom 120
 TurnFlagOFF 6 ;zim close to player;
 TurnFlagON 8 ;player on a shelf;
 TurnCounterOFF 1
 DoneWithTurn
END_COMMAND

COMMAND ANY
 Present 399
 FlagON 6
 CounterEquals 1 0
 AtLocation 62
 OR
 AtLocation 63
 OR
 AtLocation 96
 TurnCounterON 1 ;Counts how many turns player is close to Zim;
 QuitAllCmds
END_COMMAND                            

REM: What happens when player tries to escape

COMMAND EAST
 Present 399             ;THIS durn bunch of EAST commands are not working;
 FlagON 6 ;Zim at door;
 AtLocationGT 120 ;Tabletop; ;the same NORTH, SOUTH, and WEST commands;
 AtLocationLT 126 ;Tabletop;
 OR 
 AtLocationGT 131 ;bench;
 AtLocationLT 135 ;Bench;
 OR
 AtLocationGT 145 ;bureau (This excludes part with open drawer);
 AtLocationLt 148
 OR
 AtLocation 169
 TurnFlagON 7 ;player falling flag;
 PrintMessage 39 ;Zim runs forward to catch player;
END_COMMAND

COMMAND EAST
 Present 399 ;zim in room;
 FlagON 7 ;player falling;
 Chance 50 ;of Zim catching player before he kills himself;
 PrintMessage 41  ;Zim catches player;
 TurnFlagOFF 7  ;player not falling;
 GoToRoom 117   ;sets him on top of the bookcase;
 TurnFlagOFF 6 ;Zim can prevent fall now;
 DoneWithTurn
END_COMMAND

COMMAND EAST
 Present 399
 FlagON 6  ;Zim at door;
 FlagON 7  ;falling player;
 PrintMessage 40  ;Zim misses and has to fix up player before proceeding;
 GoToRoom 117  ;top of bookcase;
 PutInCurrentRoom 223
 TurnFlagOFF 6 ;zim can prevent further falls;
 TurnFlagOFF 7  ;player not falling;
 DoneWithTurn
END_COMMAND
  
COMMAND EAST         
 Present 399           ;as far as I know, THIS bunch IS working;
 NOT Present 301
 FlagOFF 6 ;zim can catch player;
 AtLocationGT 120 ;big tabletop;
 AtLocationLT 126
 RandomMessage 68 72 ;zim cannot allow jump          
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND           
 
COMMAND EAST
 FlagOFF 6 ;Zim is nearby; 
 FlagON 11 ;player has been in drawer;
 AtLocationGT 145 ;top of bureau;
 AtLocationLT 148 
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND 

COMMAND EAST
 Present 399
 FlagOFF 8  ;player on floor;
 FlagOFF 6
 PrintMessage 111 ;Zim moves in;
 PutInCurrentRoom 244 ;zim's hand;
 RandomMessage 34 36
 DoneWithTurn
END_COMMAND

COMMAND EAST
 Present 399
 FlagON 6 ;zim at door;
 FlagOFF 8  ;player on floor;
 RandomMessage 136 140
 QuitAllCMDS
END_COMMAND 

COMMAND NORTH
 Present 399
 FlagON 6  ;Zim at door;     
 AtLocation 120   ;top of bookcase;
 OR
 AtLocation 121 ;tabletop;
 OR
 AtLocation 130 ;tabletop;
 OR
 AtLocation 147 ;top of bureau;
 TurnFlagON 7 ;player falling flag;
 PrintMessage 39  ;Zim runs forward to catch player;
END_COMMAND

COMMAND NORTH
 Present 399 ;zim in room;
 FlagON 7  ;falling player flag;     
 Chance 50   ;of Zim catching player before he kills himself;
 PrintMessage 41  ;Zim catches player;
 TurnFlagOFF 7  ;player not falling;
 GoToRoom 117   ;sets him on top of the bookcase; 
 TurnFlagOFF 6  ;Zim can prevent another accident;
 DoneWithTurn
END_COMMAND                         

COMMAND NORTH
 Present 399
 FlagON 6  ;Zim at door;
 FlagON 7  ;Player falling;
 PrintMessage 40  ;Zim misses and has to fix up player before proceeding;
 GoToRoom 117  ;top of bookcase;
 PutInCurrentRoom 223 ;put bed on bookcase;
 TurnFlagOFF 6 ; zim can stop fall;
 TurnFlagOFF 7 ;player not falling;
 DoneWithTurn
END_COMMAND
    
COMMAND NORTH
 Present 399  ;Zim here;
 FlagOff 6    ;Zim has rescued player from fall, can prevent a second one;
 AtLocation 120  ;top of bookcase;
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244  ;zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND NORTH
 Present 399
 NOT Present 301
 FlagOFF 6 ;zim can catch player;
 AtLocation 121 ;big tabletop;
 OR
 AtLocation 130 ;big tabletop;
 RandomMessage 68 72 ;zim cannot allow jump;          
 PutInCurrentRoom 244 ;zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND NORTH
 Present 399
 FlagON 6
 FlagON 11  ;player has moved into open drawer;
 PrintMessage 112  ;player disappears into bureau to no avail;
 TurnFlagOFF 6
 DoneWithTurn
END_COMMAND

COMMAND NORTH
 Present 399
 FlagOFF 6 ;zim is close up;
 FlagON 11 ;player is in drawer;
 AtLocation 142 ;open drawer;
 PutInCurrentRoom 244 ;hand;
 RandomMessage 113 115  ; zim remarks ;
 DoneWithTurn
END_COMMAND

COMMAND NORTH
 FlagOFF 6
 FlagON 11 ;player has been in drawer;
 AtLocation 147 ;top of bureau;
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND NORTH
 Present 399
 FlagOFF 8  ;player on floor;
 FlagOFF 6  ;Zim is close;
 PutInCurrentRoom 244 ;hand;
 PrintMessage 111 ;Zim has moved in;
 PrintMessage 58  ;hand blocks player's escape;
 RandomMessage 34 36  ;reassurances;
 DoneWithTurn
END_COMMAND  

COMMAND NORTH
 Present 399
 FlagON 6 ;zim at door;
 RandomMessage 136 140
 QuitAllCMDS
END_COMMAND

COMMAND SOUTH
 Present 399
 FlagON 6 ;Zim is still at door;
 AtLocation 117  ;top of bookcase;
 OR
 AtLocationGT 124  ;S tabletop;
 AtLocationLT 127
 OR
 AtLocation 145 ;bureau top;
 OR 
 AtLocationGT 168  ;Top of cabinet;
 AtLocationLT 172
 TurnFlagON 7 ;falling player flag;
 PrintMessage 39 ;Zim runs forward to catch player;
END_COMMAND

COMMAND SOUTH                                      
 FlagON 7  ;falling player flag
 Chance 50   ;of Zim catching player before he kills himself;
 PrintMessage 41  ;Zim catches player;
 TurnFlagOff 7  ;player no longer falling
 GoToRoom 117   ;sets him on top of the bookcase; 
 TurnFlagOFF 6  ;Zim can prevent another fall;
 DoneWithTurn
END_COMMAND

COMMAND SOUTH
 Present 399
 FlagON 6
 FlagON 7  ;player falling flag;
 PrintMessage 40  ;Zim misses and has to fix up player before proceeding;
 GoToRoom 117  ;top of bookcase;
 PutInCurrentRoom 223
 TurnFlagOFF 6   ;Zim close to player;
 TurnFlagOFF 7   ;Player not falling;
 DoneWithTurn
END_COMMAND 

COMMAND SOUTH  
 Present 399
 FlagOff 6    ;Zim has rescued player from fall, can prevent a second one;
 AtLocation 117  ;S top of bookcase;
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND SOUTH
 Present 399
 FlagOFF 6 ;zim can catch player;
 AtLocationGT 124 ;big tabletop;
 AtLocationLT 127
 RandomMessage 68 72 ;zim cannot allow jump;          
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND SOUTH
 FlagOFF 6 ;Zim is nearby;
 FlagON 11 ;player has been in drawer;
 AtLocation 145 ;top of bureau;
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND 

COMMAND SOUTH
 Present 399
 FlagOFF 8  ;player on floor;
 PutInCurrentRoom 244   ;long slender hand;
 PrintMessage 111 ;zim has moved in;
 PrintMessage 58  ;zim blocks players' path with hand;
 RandomMessage 34 36   ; reassurances ;
 TurnFlagOFF 6  ;Zim is close to player;
 DoneWithTurn
END_COMMAND

COMMAND WEST
 Present 399
 FlagON 6    ;Zim is still at door;
 AtLocationGt 104  ;in bookcase;
 AtLocationLt 121   ;top of bookcase;
 OR
 AtLocationGT 125 ;tabletop;
 AtLocationLT 131 ;tabletop;
 OR
 AtLocation 171  ;w cabinet top
 PrintMessage 39  ;Zim runs forward;
 TurnFlagON 7 ;Falling player flag;
END_COMMAND

COMMAND WEST
 FlagON 6  ;Zim is in door;
 FlagON 7   ;player falling;
 Chance 50   ;of Zim catching player before he kills himself;
 PrintMessage 41  ;Zim catches player;
 TurnFlagOFF 7  ;player not falling;
 GoToRoom 117   ;sets him on top of the bookcase;
 PutInCurrentRoom 223 ;gold bed;
 TurnFlagOFF 6  ;Zim can prevent a second fall;
 DoneWithTurn
END_COMMAND

COMMAND WEST
 Present 399
 FlagON 6
 FlagON 7
 PrintMessage 40  ;Zim misses and has to fix up player before proceeding;
 GoToRoom 117  ;top of bookcase;
 PutInCurrentRoom 223
 TurnFlagOFF 6  ;zim can prevent accidents;
 TurnFlagOFF 7  ;player not falling;
 DoneWithTurn
END_COMMAND  

COMMAND WEST
 Present 399
 FlagOff 6    ;Zim has rescued player from fall, can prevent a second one;
 AtLocationGt 116  ;top of bookcase;
 AtLocationLt 121   ;top of bookcase;
 RandomMessage 68 72  ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND

COMMAND WEST
 Present 399
 NOT Present 301
 FlagOFF 6 ;Zim can catch player;
 AtLocationGt 125
 AtLocationLt 131
 RandomMessage 68 72 ;Zim cannot allow player to move;
 PutInCurrentRoom 244 ;Zim's hand;
 DoneWithTurn
END_COMMAND           

COMMAND WEST
 Present 399
 FlagOFF 8  ;player on floor;
 PutInCurrentRoom 244   ;long slender hand;
 PrintMessage 111 ;zim has moved in;
 PrintMessage 58  ;zim blocks players' path with hand;
 RandomMessage 34 36   ; reassurances ;
 TurnFlagOFF 6  ;Zim is close to player;
 DoneWithTurn
END_COMMAND

REM: INteraction with Zim commands

COMMAND TOUCH ZIM
 Present 399
 FlagOFF 6
 PrintMessage 90 ;Zim tells player he's real;
 DoneWithTurn
END_COMMAND

COMMAND TOUCH ZIM
 Present 399
 FlagON 6
 PrintMessage 91  ;Zim is too far away to touch;
 DoneWithTurn
END_COMMAND

COMMAND TAKE ZIM
 Present 399
 NOT AtLocation 198 ;sorcerer's normal-sized lab;
 PrintMessage 92 ;Zim is too big to take;
 DoneWithTurn
END_COMMAND

COMMAND TAKE ZIM
 Present 399
 AtLocation 198 ;Zim's normal lab;
 PrintMessage 93 ;Zim will not be taken;
 DoneWithTurn
END_COMMAND

COMMAND KISS ZIM
 Present 399
 FlagON 6 ;But he is not close up;
 PrintMessage 91  ;Zim is too far away to touch, let alone kiss;
 DoneWithTurn
END_COMMAND

COMMAND KISS HAND
 Present 244  ;hand;
 VariableEquals 1 0
 AddToVariable 1 1
 PrintMessage 127  ;Zim states he does not care for groveling;
 DoneWithTurn
END_COMMAND

COMMAND KISS HAND
 Present 244
 VariableGT 1 0  
 VariableLT 1 4
 AddToVariable 1 1
 RandomMessage 128 129
 DoneWithTurn
END_COMMAND

COMMAND KISS HAND
 Present 244
 VariableGT 1 3
 PrintMessage 130  ;Zim will stop player from this time forward;
 DoneWithTurn
END_COMMAND

COMMAND HELLO
 Present 399  ;Zim present;
 PrintMessage 37   ;Zim greets player back;
 DoneWithTurn
END_COMMAND

COMMAND TELL ZIM ABOUT VEEBRIS
 Present 399
 IsNowhere 247  ;Veebris;
 AtLocation 198
 PrintMessage 103  ;Zim tells player Veebris' lab is beyond portal;
 DoneWithTurn                    
END_COMMAND

COMMAND TELL ZIM ABOUT VEEBRIS
 Present 399
 IsNowhere 247  ;Veebris;
 AtLocation 199 ;round table;
 OR
 AtLocationGT 2    ;Player not in room less than Location 2;
 AtLocationLT 171 ;Player not in room greater than 172 - Zim's normal lab; 
 PrintMessage 38
 TurnFlagON 5   ;player has told zim how he got there.;
END_COMMAND

COMMAND TELL ZIM ABOUT VEEBRIS
 FlagON 5 ;player has told zim how he got there;
 PrintMessage 46  (* Zim asks if player likes new size *)
 PromptForYES   ;Prompts for Y or N -- TRUE if Yes;
 PrintMessage 8   (* Zim says "You do?" if player says 'yes.' *)
 PromptForYes   
 PrintMessage 14 ;Zim cannot turn player loose if s/he remains miniature. *)
 PromptForYes
 PrintMessage 7   (* Zim makes player his tiny ward. *)
 TurnFlagOFF 5
 EndGame
 DoneWithTurn
END_COMMAND

COMMAND TELL ZIM ABOUT VEEBRIS
 Present 399 ;Zim;
 FlagON 5     ;player has explained how s/he got into laboratory;
 FlagON 8  ;player is on a shelf;
 PrintMessage 6 ;zim sets player down & returns him to normal
 GoToRoom 198    ;Move Zim and player to Sorcerer's normal-sized lab *) 
 PutInCurrentRoom 238  ;puts portal in room;
 DoneWithTurn
END_COMMAND   

COMMAND TELL ZIM ABOUT VEEBRIS
 Present 399
 FlagON 5
 FlagOFF 8  ;player is NOT on shelf;
 PrintMessage 24 ; Zim returns player to normal and opens portal to Veebris.;
 GoToRoom 198    ;Move Zim and player to Sorcerer's normal-sized lab *) 
 PutInCurrentRoom 238  ;puts portal in room;
 DoneWithTurn
END_COMMAND   

COMMAND TELL ZIM ABOUT PORTAL
 ReDirectTo TELL ZIM ABOUT VEEBRIS
END_COMMAND
 
COMMAND ZIM, TELL ABOUT CRYSTAL VIAL
 NamePresent 399
 NameIsNumber 399
 ObjectIsNumber 233
 PrintMessage 44
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT GLASS VIAL
 NamePresent 399
 NameIsNumber 399
 ObjectIsNumber 242
 PrintMessage 47  ;zim tells player about macromorphic vapors;
 FlagOFF 5   ;player has not told zim how he entered laboratory;
 PrintMessage 45  ;zim persists in asking how person entered laboratory;
 DoneWithTurn
END_COMMAND     

COMMAND ZIM, TELL ABOUT SPIDER
 NamePresent 399
 NameIsNumber 399
 IsSomewhere 310  ;live spider;
 OR
 IsSomewhere 249 ;dead spider;
 PrintMessage 99 ;The thing probably stowed away on a plant;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT SIZE
 NamePresent 399
 NameIsNumber 399
 FlagOFF 5
 PrintMessage 42
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT BIRD
 NamePresent 399
 NameIsNumber 399
 PrintMessage 43
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT IRON KEY
 NamePresent 399
 NameIsNumber 399
 Present 209
 ObjectIsNumber 209
 PrintMessage 50
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT SILVER KEY
 NamePresent 399
 NameIsNumber 399
 Present 207  ;silver key is present;
 ObjectIsNumber 207
 PrintMessage 51
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT COPPER KEY
 NamePresent 399
 NameIsNumber 399
 Present 204  ;copper key is present;
 ObjectIsNumber 204
 PrintMessage 57 ;key to friend's house.;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND          

COMMAND ZIM, TELL ABOUT ELECTRUM KEY
 NamePresent 399
 NameIsNumber 399
 Present 206
 ObjectIsNumber 206
 PrintMessage 52
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT PLATINUM KEY
 NamePresent 399
 NameIsNumber 399
 ObjectIsNumber 208
 AtLocationGT 2    ;Player not in room less than Location 2;
 AtLocationLT 171 ;Player not in room greater than 198 - Zim's normal lab; 
 OR
 AtLocation 199 ;round table;
 PrintMessage 48
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT PLATINUM KEY
 NamePresent 399
 NameIsNumber 399
 ObjectIsNumber 208
 AtLocation 198
 OR
 AtLocation 199
 PrintMessage 49
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT BOTANY
 NamePresent 399
 NameIsNumber 399
 PrintMessage 53
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT WAND
 NamePresent 399
 NameIsNumber 399
 Present 203
 PrintMessage 66 ;Light wand is for detailed botanical work;
 FlagOFF 5
 PrintMessage 45
DoneWithTurn
END_COMMAND  

COMMAND ZIM, TELL ABOUT HORRIBLIS
 NamePresent 399
 NameIsNumber 399
 IsSomewhere 301
 OR
 IsNowhere 301
 PrintMessage 54  ;Zim tells player horriblis was not a deliberate trap;
 IsSomewhere 204  ;Slimy puddle;
 PrintMessage 55
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT ZIM
 NamePresent 399
 NameIsNumber 399
 PrintMessage 56  ;Zim tells player that his favorite pursuit is botany;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT BERRY
 NamePresent 399
 NameIsNumber 399
 Present 226 ;ze berry; 
 PrintMessage 74
 FlagOFF 5
 PrintMessage 45  ;persistent, isn't he?;
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT POLE
 NamePresent 399
 NameIsNumber 399
 Present 227
 PrintMessage 80  ;Zim does not know what pole is used for;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT PIN
 NamePresent 399
 NameIsNumber 399
 Present 205
 PrintMessage 75 ;small things on floor;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT MUSIC BOX
 NamePresent 399
 NameIsNumber 399
 Present 235
 PrintMessage 76 ;Zim created music box himself;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT CASKET
 NamePresent 399
 NameIsNumber 399
 Present 224
 PrintMessage 77 ;Zim created casket.  one of his hobbies is miniatures;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT GOLD KEY
 NamePresent 399
 NameIsNumber 399
 Present 222
 PrintMessage 77 ;Zim created casket.  one of his hobbies is miniatures;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT BED
 NamePresent 399
 NameIsNumber 399
 Present 223  ;bed present;
 PrintMessage 79 ;Bed given to zim as gift.;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT TWIG
 NamePresent 399
 NameIsNumber 399
 Present 221  ;twig present;
 PrintMessage 75 ;little things on floor.;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT BAG
 NamePresent 399
 NameIsNumber 399
 Present 220  ;bag present;
 PrintMessage 85 ;it's an Infinity Pouch;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT KNIFE
 NamePresent 399
 NameIsNumber 399
 Present 212 ;silver knife;
 PrintMessage 87 ;Zim created the silverware;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT SILVERWARE
 NamePresent 399
 NameIsNumber 399
 Present 219 ;silver knife;
 PrintMessage 87 ;Zim created the silverware;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT EMERALD
 NamePresent 399
 NameIsNumber 399
 Present 225  ;emerald present;
 PrintMessage 88 ;simply a spare emerald;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT HAIR
 NamePresent 399
 NameIsNumber 399
 Present 214  ;hair present;
 PrintMessage 89 ;It's obvious where the green hair came from;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT FISHHOOK
 NamePresent 399
 NameIsNumber 399
 Present 232 ;fishhook present;
 PrintMessage 97 ;Zim got it from Tip;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT POWDER
 NamePresent 399
 NameIsNumber 399
 IsCarrying 202
 PrintMessage 100  ;Zim evasively tells player his answer is on the table;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT WEED KILLER
 NamePresent 399
 NameIsNumber 399
 PrintMessage 102  ;Zim evasively tells player his answer is on the table;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT RUBY
 NamePresent 399
 NameIsNumber 399
 AtLocation 199
 OR
 AtLocation 198
 OR
 AtLocationGT 116 ;bookcase top;
 AtLocationLT 121
 PrintMessage 101  ;It's an alarm.;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND  

COMMAND ZIM, TELL ABOUT DATE
 NamePresent 399
 NameIsNumber 399
 IsSomewhere 211
 AtLocation 199
 OR
 AtLocation 198
 OR
 AtLocationGT 116 ;bookcase top;
 AtLocationLT 121
 PrintMessage 49  ;PLayer knows what date is for!;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND   

COMMAND ZIM, TELL ABOUT DATE
 NamePresent 399
 NameIsNumber 399
 Present 211
 PrintMessage 122  ;Zim only says the player could have hurt himself;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND   

COMMAND ZIM, TELL ABOUT CANISTER
 NamePresent 399
 NameIsNumber 399
 Present 228
 PrintMessage 123  ;both are smoking equipment;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND   

COMMAND ZIM, TELL ABOUT MATCHBOX
 NamePresent 399
 NameIsNumber 399
 Present 231
 PrintMessage 123  ;both are smoking equipment;
 FlagOFF 5
 PrintMessage 45
 DoneWithTurn
END_COMMAND   

COMMAND ZIM, TELL ABOUT ANY
 NamePresent 399
 NameIsNumber 399
 NOUNPresent
 PrintMessage 102 ;player ought to know what article is for;
 DoneWithTurn
END_COMMAND

COMMAND ZIM, TELL ABOUT ANY
 NamePresent 399
 NameIsNumber 399
 NOUNIsSomewhere
 PrintMessage 98 ;Zim politely tells the player to produce the article;
 DoneWithTurn
END_COMMAND  

COMMAND TALK TO ZIM
 Present 399  ;zim;
 RandomMessage 124 126
 DoneWithTurn
END_COMMAND

REM: dealing with the vial that shrinks player to escape closet

COMMAND OPEN VIAL
 Present 233  ;Vial in room;
 PrintMessage 20  ;The violet contents shrink player to five inches tall.;
 Delay 10
 ClearScreen
 PrintMessage 61  ;normal perspective door;
 Delay 5
 ClearScreen
 PrintMessage 62  ;smaller and smaller;
 Delay 5
 ClearScreen
 PrintMessage 63  ;giant door;
 Delay 5
 PrintMessage 64  ;vapor clears, player is five or six inches tall;
 GoToRoom 88  (Puts player in giant version of first closet)
 Destroy 233   (* gets rid of full vial *)
 DoneWithTurn (* finished with this turn *)
END_COMMAND

REM: dealing with anything player plants.

COMMAND SOW BERRY
 AtLocation 85     (* Player is located under north workbench *)
 InRoom 234      (The planting soil is here)
 IsCarrying 226   ; Ivy berry is being carried.;
 SendToItem 226 234  (* Put berry in location of planting soil *)
 PrintMessage 2 (Player plants berry.)
 ChangePassageway 9 132   (* Vine grows to north end of workbench *)
 PrintMessage 3   (The vine grows to the workbench and cabinet top.)
 Destroy 226  (Puts berry in room 0, cause it's a vine, now)
 PutInCurrentRoom 243 ;puts giant ivy in room;
 DoneWithTurn
END_COMMAND

COMMAND PLAY MUSIC BOX
 TurnFlagON 9 ;music box playing;
 PrintMessage 86 ;fairies under the globe dance;
 Tone 784 222
 Tone 880 200
 Tone 932 100
 Tone 1047 100
 Tone 1175 400
 Tone 1047 200
END_COMMAND

COMMAND PLAY MUSIC BOX
 FlagON 9
 Tone 932 222
 Tone 1047 200 
 Tone 1175 200
 Tone 1047 222 
 Tone 880 200
 Tone 698 200
 Tone 698 222 
 Tone 880 200
END_COMMAND

COMMAND PLAY MUSIC BOX
 FlagON 9 ;box playing
 Tone 698 200 
 Tone 1397 222 
 Tone 880 200
 Tone 698 200
 Tone 698 222 
 Tone 880 200 
 Tone 698 200 
 Tone 1047 222
 Tone 880 200
END_COMMAND

COMMAND PLAY MUSIC BOX
 FlagON 9 ;box Playing;
 Tone 698 200 
 Tone 784 100 
 Tone 880 100 
 Tone 932 200
 Tone 784 200 
 Tone 1175 222 
 Tone 932 200 
END_COMMAND

COMMAND PLAY MUSIC BOX
 FlagON 9 ;box playing;
 Tone 784 200 
 Tone 784 222
 Tone 932 200 
 Tone 784 200 
 Tone 1568 222 
 Tone 932 200 
 Tone 784 200 
END_COMMAND

COMMAND PLAY MUSIC BOX
 FlagON 9
 Tone 1397 400 
 Tone 1397 250    ;at this point box begins to slow down;
 Tone 1397 275  
 Tone 1568 310
 Tone 1760 390
 Tone 1397 800 
 Tone 1175 1600
 TurnFlagOFF 9   ;stop the music!;
 DoneWithTurn
END_COMMAND

COMMAND WIND MUSIC BOX
 ReDirectTo PLAY MUSIC BOX
END_COMMAND

COMMAND MEASURE WITH YARDSTICK
 Present 250  ;yardstick;
 PrintMessage 118 ;player finds s/he's one-twelfth scale;
 DoneWithTurn
END_COMMAND

COMMAND WEIGH ON SCALE
 Present 251 ;the scale;
 IsCarryingSomething
 PrintMessage 120
 DoneWithTurn
END_COMMAND

COMMAND WEIGH ON SCALE
 Present 251 ;scale;
 NOT IsCarryingSomething
 PrintMessage 119
 DoneWithTurn
END_COMMAND  

REM: Polishing off nasty critters commands.

COMMAND KILL HORRIBLIS WITH WEED KILLER
Present 301   ; Fungus is in room ;
IsCarrying  230  ; Weed killer is being carried ;
PrintMessage  1   (Ding, dong, Carnivora Horriblis is dead.)
Destroy 301    (Fungus is now NOWHERE (in room 0)
PutInCurrentRoom 240  ;slimy black puddle;
SendToItem 230 229   ;player can go back to box for more weed killer;
DoneWithTurn    (All Done this turn -- get input next)
END_COMMAND

COMMAND THROW WEED KILLER AT HORRIBLIS
RedirectTo  KILL HORRIBLIS WITH WEED KILLER
END_COMMAND

COMMAND KILL SPIDER WITH PIN
 Present 310   (spider is in room)
 IsCarrying  205   (Silver Pin is being carried)
 PrintMessage  4   (Ding, dong, the hairy spider's dead.)
 Destroy  310    (spider is now NOWHERE (in room 0)
 PutInCurrentRoom 249  ;replace live spider with dead spider;
 DoneWithTurn    (All Done this turn -- get input next)
END_COMMAND

COMMAND KILL ANY 
 Present 249   (dead spider is in room)
 OR
 Present 240  (slimy puddle)
 NOT IsCarryingSomething
 PrintMessage 95  ;Tell player not to be so relentless!; 
 DoneWithTurn    (All Done this turn -- get input next)
END_COMMAND

COMMAND KILL ANY WITH ANY
 Present 249   (dead spider is in room)
 OR
 Present 240  (slimy puddle)
 IsCarryingSomething
 PrintMessage 95  ;Tell player not to be so relentless!; 
 DoneWithTurn    (All Done this turn -- get input next)
END_COMMAND

COMMAND STAB HAND WITH PIN
 Present 244
 IsCarrying 205  ;silver pin;
 VariableLT 2 4  ;Player has not attacked Zim yet, or he still has patience; 
 PrintMessage 78  ;Zim laughs when hand is stabbed;
 RandomVariable 2 4 ;sets how patient Zim is with player;
 DoneWithTurn
END_COMMAND

COMMAND STAB HAND WITH PIN
 Present 244
 IsCarrying 205  ;silver pin;
 VariableGt 2 3  ;Sorcerer begins to lose patience;
 VariableLt 2 8
 RandomMessage 131 133   ;Zim laughs when hand is stabbed;
 AddToVariable 2 1 ;Each time he is attacked, Zim loses more patience;
 DoneWithTurn
END_COMMAND

COMMAND STAB HAND WITH PIN
 Present 244
 IsCarrying 205  ;silver pin;
 NOT AtLocation 198  ;not in Sorcerer's normal lab;
 VariableEquals 2 8  ;Zim finally loses patience, and uses his Magic Mirror;
 Destroy 205
 PrintMessage 134  ;zim finds out with his mirror how player entered; 
 PrintMessage 15  ;Zim confiscates treasure;
 DropEverything
 RemoveEverything
 PrintMessage 33 ;sends player back to home dimension;
 RemoveFromGroup 399
 EndGame
 DoneWithTurn       
END_COMMAND

REM: Polishing off homicidal players commands.

COMMAND THROW BLUE POWDER AT ZIM
 IsCarrying 202
 FlagOFF 6
 Present 399
 PrintMessage 31   ;zim tells player powder does not work on good sorcerers;
 Destroy 202
 DoneWithTurn
END_COMMAND

COMMAND THROW ANY AT ZIM
 NOT AtLocation 198
 FlagOFF 6 ;Zim is near;
 Present 399
 NOUNPresent
 DropNOUN 
 PrintMessage 135 ;Any noun the player throws does Zim no harm whatsoever;
 DoneWithTurn     ;even the weed killer;
END_COMMAND

COMMAND ATTACK ZIM WITH ANY
 Present 399
 AtLocationGT 2  ;player is still five inches, not in normal lab.;
 AtLocationLT 172
 OR
 AtLocation 199
 PrintMessage 32  ;An attack might amuse him;
 DoneWithTurn
END_COMMAND

COMMAND ATTACK ZIM WITH ANY
 AtLocation 198 ;player is normal, in normal lab.
 Present 399 ;Zim is here;
 Present 238 ;portal is in room;
 IsCarryingsomething (* Player is carrying something *)
 PrintMessage 15    (* Zim confiscates his stuff from the player *)
 DropEverything      (* Drop all items being carried *)
 RemoveEverything    (* Remove all items being worn *)
 ReLocateAll 18 0
 PrintMessage 33    (* Zim sends back player to home dimension emptyhanded *) 
 RemoveFromGroup 399 (* Zim stays in home dimension, naturally *)
 EndGame             (* Game ends with player emptyhanded;
END_COMMAND
 
COMMAND KILL ZIM WITH ANY
 ReDirectTo ATTACK ZIM WITH ANY
END_COMMAND    

REM: Open and unlock commands

COMMAND OPEN DOOR
 AtLocation 170  ;player is at cabinet mid-top;
 Present 239   ;teak door;
 IsUnlocked 239  ;teak door is unlocked
 ChangePassageway 1 175
 PrintMessage 27  ;door is unlocked and player can proceed north
 DoneWithTurn
END_COMMAND

COMMAND CLOSE DOOR
 FlagON 4  ;player has unlocked door
 Present 239  ;teak door;
 Closeit 239  ;close teak door;
 ChangePassageway 1 0  ;close passage to north into box;
 PrintMessage 26  ;player cannot enter box;
 DoneWithTurn   
END_COMMAND

COMMAND OPEN DOOR
 Present 218  ;massive oak door to lab;
 PrintMessage 96  ;player cannot even reach the knob;
 DoneWithTurn
END_COMMAND

COMMAND LOOK IN BAG
 IsCarrying 220  ;drawstring bag
 IsOpen 220
 ShowContents 18 ;treasure room;
 DoneWithTurn  
END_COMMAND

COMMAND PUT ANY IN BAG
 NOUNIsCarrying
 NOT NOUNIsNumber 220
 IsCarrying 220 ;drawstring bag;
 IsOpen 220  ;the same bag
 SendNOUNtoRoom 18 ;Treasure Room;
 PrintMessage 84 ;NOUN is now in bag
 DoneWithTurn
END_COMMAND

COMMAND GET ANY FROM BAG
 IsCarrying 220 ;bag
 IsOpen 220  ;bag;
 NOUNIsLocated 18  ;in the bag;
 PutNOUNInCurrentRoom
 GetNOUN
 PrintMessage 81
 DoneWithTurn
END_COMMAND

REM: Eat commands

COMMAND EAT DATES
 Present 210   ;the edible dates are here;
 PrintMessage 28   ;player can only eat half a date;
 DoneWithTurn
END_COMMAND

COMMAND EAT DATE
 IsCarrying 211  ;Dull date is here;
 PrintMessage 29   ;player is not a beaver;
 DoneWithTurn
END_COMMAND

COMMAND EAT SOIL
 Present 234  (rapid plant growth soil)
 PrintMessage 19  (* Tells player this stuff does not work on humans. *)
 DoneWithTurn     (* All Done this turn -- get input next *)
END_COMMAND

;rem:  noisy player commands;

COMMAND SCREAM
 Present 399
 NOT AtLocation 198
 RandomMessage 104 109
 DoneWithTurn
END_COMMAND

COMMAND SCREAM
 Present 399
 AtLocation 198
 PrintMessage 110
 DoneWithTurn
END_COMMAND

REM: Various opening functions

COMMAND PRY DATE WITH KNIFE
 Present 211  ;dull date;
 IsCarrying 212  ;silver knife;
 UnlockIt 211  ;date unlocked;
 OpenIt 211   ;date opens ;
 PrintMessage 30  ;says player has pried date open;
 DoneWithTurn
END_COMMAND

COMMAND OPEN DATE WITH KNIFE
 ReDirectTo PRY DATE WITH KNIFE
END_COMMAND

COMMAND OPEN DATE
 Present 211   ;date;
 IsLocked 211   ;date;
 PrintMessage 94  ;player not strong enough to pop date apart;
 DoneWithTurn
END_COMMAND

COMMAND LOOK IN DATE
 Present 211   ;player has dull date;
 IsOpen 211       ;player has opened the date;
 SomethingInside
 ShowContents
 DoneWithTurn
END_COMMAND

COMMAND PRY DOOR WITH POLE
 AtLocation 9 ;carpet before mid-cabinet;
 Present 217  ;giant door;
 Present 227  ;silver pole;
 UnlockIt 217  ;giant door;
 OpenIt 217 ;giant door;
 PrintMessage 67  ;player pries door open;
 ChangePassageway 1 10  ;can enter cabinet;
 PrintMessage 27  ;Player can go n;
 DoneWithTurn
END_COMMAND

COMMAND OPEN DOOR WITH POLE
 ReDirectTo PRY DOOR WITH POLE
END_COMMAND

REM: Commands for winning of game
 
COMMAND PUSH RUBY
 PrintMessage 5   ;chime rings and zim enters room.
 PutInCurrentRoom 399  ;put Zim in room;
 PrintMessage 9  ;zim greets the player; 
 TurnFlagON 6 ;zim still stands in door, will run to save player;
 DoneWithTurn
END_COMMAND

COMMAND GIVE ALL TO ZIM
 Present 399
 NOT AtLocation 198
 PrintMessage 82
 DoneWithTurn
END_COMMAND

COMMAND GIVE ALL TO ZIM
 Present 399 (Addressee is Zim)
 TurnFlagON 2  (* Player has offered to give Zim's stuff back.)
 IsCarryingsomething   (* Player is carrying something. *)
 ScoreLT 1700
 PrintMessage 59   (* Player may keep treasures -- but not enough to win*) 
 EndGame
END_COMMAND

COMMAND GIVE ANY TO ZIM
 Present 399 (Addressee is Zim)
 TurnFlagON 2  (* Player has offered to give Zim's stuff back.)
 NOUNPresent
 ScoreLT 1700
 PrintMessage 59   (* Player may keep treasures -- but not enough to win*) 
 EndGame
END_COMMAND

COMMAND GIVE ALL TO ZIM
TurnFlagON 2  (* Player has offered to give Zim's stuff back.)
Present 399   ;zim is here;
AtLocation 198  ;Zim's normal lab;
IsCarryingSomething   (* Player is carrying something. *)
ScoreGT 1699
PrintMessage 17   (* Print Zim's message that player may keep treasures *) 
WinGame            (Player wins game at end of turn)
DoneWithTurn
END_COMMAND

COMMAND GIVE ANY TO ZIM
 TurnFlagON 2  (* Player has offered to give Zim's stuff back.)
 Present 399   ;zim is here;
 AtLocation 198  ;Zim's normal lab;
 NOUNPresent
 ScoreGT 1699
 PrintMessage 17   (* Print Zim's message that player may keep treasures *) 
 WinGame            (Player wins game at end of turn)
 DoneWithTurn
END_COMMAND

COMMAND ENTER PORTAL
AtLocation  198    (* Player is normal size in Sorcerer's lab *)
Present 399    (* Zim is here *)
Present 238    ;portal is in room;
NOT IsCarryingsomething (* Player is not carrying something *)
RelocateAll 18 0  ;destroy all treasures in treasure room;
RemoveFromGroup 399 (* Zim stays in home dimension, naturally *)
PrintMessage 25    (* Zim sends player to home dimension *)
EndGame
END_COMMAND 

COMMAND ENTER PORTAL
 AtLocation  198    (* Player is normal size in Sorcerer's lab *)
 Present 399    (* Zim is here *)
 Present 238    ;portal is in room;
 FlagOFF 2  ;player has not yet given things back;
 IsCarryingSomething (* Player is carrying something *)
 PrintMessage 15    (* Zim confiscates his stuff from the player *)
 DropEverything      (* Drop all items being carried *)
 RemoveEverything    (* Remove all items being worn *)
 RelocateAll 18 0   ;player loses everything in treasure room;
 PrintMessage 16    (* Zim sends back player to home dimension emptyhanded *) 
 RemoveFromGroup 399 (* Zim stays in home dimension, naturally *)
 EndGame             (* Game ends with player emptyhanded;
END_COMMAND                                                 
