;
;        FILE: ADVDATA2.ASM  -  THE VORTEX FACTOR
;
;
; DATA VARIABLES AND TABLES
;

;******************************
;
; VERB TABLE.  EACH VERB IS
; LISTED FOLLOWED BY IT'S
; ASSIGNED VERB NUMBER.
;
;******************************

VERBTB EQU $
 DB 'LOOK',1
 DB 'L   ',1
 DB 'EXAM',1
 DB 'READ',1
 DB 'INVE',2
 DB 'I   ',2
 DB 'G   ',3
 DB 'GET ',3
 DB 'TAKE',3
 DB 'GRAB',3
 DB 'PUT ',4
 DB 'DROP',4
 DB 'P   ',4
 DB 'THRO',4
 DB 'NORT',5
 DB 'N   ',5
 DB 'SOUT',6
 DB 'S   ',6
 DB 'EAST',7
 DB 'E   ',7
 DB 'WEST',8
 DB 'W   ',8
 DB 'UP  ',9
 DB 'U   ',9
 DB 'DOWN',10
 DB 'D   ',10
 DB 'GO  ',11
 DB 'WALK',11
 DB 'RUN ',11
 DB 'SAVE',12
 DB 'LOAD',13
 DB 'HELP',14
 DB 'SCOR',15
 DB 'QUIT',16
 DB 'OPEN',17
 DB 'CLOS',18
 DB 'EXIT',19
 DB 'LEAV',19
 DB 'INSE',20
 DB 'UNLO',21
 DB 'PRES',22
 DB 'PUSH',22
 DB 'TURN',23
 DB 'PULL',24
 DB 'MOVE',24
 DB 'SAW ',25
 DB 'PICK',26
 DB 'POUR',27
 DB 'CUT ',28
 DB 'SQUE',29
 DB 'GIVE',30
 DB 'WEAR',31
 DB 'DIG ',32
 DB 'REMO',33
 DB 'EAT ',34
 DB 'MELT',35
 DB 'HEAT',35
 DB 'LIGH',36
 DB 'UNLI',37
 DB 'EXTI',37
 DB 'MAKE',38
 DB 'MOLD',38
 DB 'DIAL',39
 DB 'SET ',39
 DB 0

;******************************
;
; NOUN TABLE.  LISTS ALL NOUNS
; AND THEIR ASSOCIATED NUMBER
;
;******************************

NOUNTB EQU $
 DB 'NORT',1
 DB 'SOUT',2
 DB 'EAST',3
 DB 'WEST',4
 DB 'UP  ',5
 DB 'DOWN',6
 DB 'INVE',7
 DB 'CALE',8
 DB 'BLUE',9
 DB 'CARB',10
 DB 'HELM',10
 DB 'COAL',11
 DB 'SHOV',12
 DB 'RED ',13
 DB 'KEY ',14
 DB 'PAGE',15
 DB 'YELL',16
 DB 'SAPP',17
 DB 'GOLD',18
 DB 'NUGG',18
 DB 'JADE',19
 DB 'BUDD',19
 DB 'DOCU',20
 DB 'BIRT',20
 DB 'CERT',20
 DB 'NOTE',21
 DB 'SACK',23
 DB 'BAG ',23
 DB 'SAND',26
 DB 'LIME',27
 DB 'VIAL',28
 DB 'HACK',29
 DB 'SAW ',29
 DB 'HAIR',30
 DB 'PIN ',30
 DB 'SCEP',31
 DB 'DIAM',32
 DB 'PEEL',35
 DB 'PINK',36
 DB 'SPAC',37
 DB 'SUIT',37
 DB 'NEWS',38
 DB 'CLIP',38
 DB 'WHIT',39
 DB 'WAX ',41
 DB 'STRI',43
 DB 'CAND',44
 DB 'BIRD',46
 DB 'SPOO',47
 DB 'SILV',48
 DB 'CUP ',48
 DB 'EMER',49
 DB 'RUBY',50
 DB 'NECK',50
 DB 'PLAT',51
 DB 'BRAC',51
 DB 'BRAS',52
 DB 'RING',52
 DB 'CHAR',78
 DB 'CHAP',78
 DB 'PICT',79
 DB 'SECR',82
 DB 'PASS',82
 DB 'LEVE',83
 DB 'STAR',85
 DB 'SHIP',85
 DB 'MODE',85
 DB 'ROCK',86
 DB 'MUMM',87
 DB 'SARC',89
 DB 'MAE ',90
 DB 'WATE',91
 DB 'MUTA',92
 DB 'HUMA',92
 DB 'JUIC',93
 DB 'PUDD',93
 DB 'BATT',96
 DB 'WORK',97
 DB 'BENC',97
 DB 'COUN',98
 DB 'GADG',99
 DB 'HOLE',100
 DB 'TORC',102
 DB 'CHES',106
 DB 'WIND',108
 DB 'BARS',108
 DB 'SKEL',109
 DB 'GATE',110
 DB 'IRON',110
 DB 'DIAL',113
 DB 'SAFE',114
 DB 'SIGN',115
 DB 'PLAQ',116
 DB 'GAUG',117
 DB 'BUTT',118
 DB 'SLOT',119
 DB 'BOOK',120
 DB 'TIME',121
 DB 'MACH',121
 DB 'CYLI',121
 DB 'DEVI',122
 DB 'OUT ',123
 DB 'DESK',124
 DB 'DRAW',124
 DB 'CART',125
 DB 'LOCK',126
 DB 'DOOR',127
 DB 'ALL ',128
 DB 'EVER',128
 DB 0

;******************************
;
; SPECIAL ACTION TABLE. LISTS
; VERB/NOUN COMBO'S THAT HAVE
; SPECIAL PROCESSING ROUTINES.
; FORMAT IS:
;
;  # BYTES       DEXCRIPTION
;  -------   ------------------
;     1      VERB NUMBER
;     1      NOUN NUMBER
;     2      SPECIAL RTN ADDR
;
;******************************

SPCRTN EQU $
 DW 0109H,LOOK04 ;LOOK BLUE
 DW 010DH,LOOK04 ;LOOK RED
 DW 010FH,LOOK11 ;LOOK PAGE
 DW 0110H,LOOK04 ;LOOK YELLOW
 DW 0115H,LOOK10 ;L NOTEBOOK
 DW 0117H,LOOK12 ;L SACK
 DW 0157H,LOOK09 ;L MUMMY
 DW 015AH,LOOK09 ;L MAE
 DW 0161H,LOOK09 ;L WORKBENCH
 DW 0162H,LOOK09 ;L COUNTER
 DW 0166H,LOOK14 ;L TORCH
 DW 016AH,LOOK13 ;L CHEST
 DW 016DH,LOOK15 ;L SKELETON
 DW 0171H,LOOK08 ;LOOK DIAL
 DW 0172H,LOOK05 ;LOOK SAFE
 DW 0175H,LOOK06 ;LOOK GAUGE
 DW 0177H,LOOK03 ;LOOK SLOT
 DW 0178H,LOOK01 ;LOOK BOOKCASE
 DW 017CH,LOOK02 ;LOOK DESK
 DW 017DH,DMSG37 ;LOOK CART
 DW 017FH,LOOK07 ;LOOK DOOR
 DW 0307H,VINVE  ;TAKE INVENTORY
 DW 0308H,GET01  ;GET CALENDAR
 DW 0309H,GET02  ;GET BLUE
 DW 030DH,GET02  ;GET RED
 DW 0310H,GET02  ;GET YELLOW
 DW 0324H,GET02  ;GET PINK
 DW 0327H,GET02  ;GET WHITE
 DW 0353H,GET03  ;GET LEVER
 DW 037BH,GO03   ;GET OUT
 DW 037DH,DMSG37 ;GET CART
 DW 0425H,PUT01  ;PUT SUIT
 DW 047DH,DMSG37 ;PUT CART
 DW 0B52H,GO07   ;GO PASSAGE
 DW 0B64H,GO05   ;GO HOLE
 DW 0B6CH,GO06   ;GO WINDOW
 DW 0B79H,GO01   ;GO TIME MACH
 DW 0B7AH,GO02   ;GO DEVICE
 DW 0B7BH,GO03   ;GO OUT
 DW 0B7FH,GO04   ;GO DOOR
 DW 1115H,OPEN03 ;NOTEBOOK
 DW 1159H,OPEN04 ;OPEN SARC
 DW 116AH,LOOKOB ;OPEN CHEST
 DW 116EH,OPEN05 ;OPEN GATE
 DW 117CH,OPEN02 ;OPEN DESK
 DW 117FH,OPEN01 ;OPEN DOOR
 DW 1215H,CLOS03 ;NOTEBOOK
 DW 127CH,CLOS02 ;CLOSE DESK
 DW 127FH,CLOS01 ;CLOSE DOOR
 DW 157FH,UNLK01 ;UNLOCK DOOR
 DW 170FH,TURN03 ;TURN PAGE
 DW 1771H,TURN01 ;TURN DIAL
 DW 1766H,TURN02 ;TURN TORCH
 DW 1753H,TURN04 ;TURN LEVER
 DW 1866H,TURN02 ;PULL TORCH
 DW 1853H,TURN04 ;PULL LEVER
 DW 191BH,SAW02  ;SAW LIME
 DW 196CH,SAW01  ;SAW WINDOW
 DW 1A7EH,PICK01 ;PICK LOCK
 DW 1B1CH,POUR01 ;POUR VIAL
 DW 1B5DH,POUR01 ;POUR JUICE
 DW 1C1BH,SAW02  ;CUT LIME
 DW 1D1BH,SQU01  ;SQUEEZE LIME
 DW 1E34H,GIVE01 ;GIVE RING
 DW 1F25H,WEAR01 ;WEAR SUIT
 DW 2125H,REMO01 ;REMOVE SUIT
 DW 2329H,MELT01 ;MELT WAX
 DW 232EH,MELT01 ;MELT BIRD
 DW 242CH,LITE01 ;LITE CANDLE
 DW 252CH,UNLI01 ;UNLI CANDLE
 DW 262CH,MAKE01 ;MAKE CANDLE
 DW 2771H,TURN01 ;DIAL DIAL
 DW 0

;******************************
;
; SPECIAL ACTION ON ENTRY TO A
; ROOM TABLE.  FORMAT IS:
;      ROOM#,RTNADDR
;
;******************************

ENTRTB EQU $
 DB 41
 DW ENTR41
 DB 0

;******************************
;
; SPECIAL ACTION ON EXIT FROM
; A ROOM TABLE.
;
;******************************

EXITTB EQU $
 DB 48
 DW INRM48
 DB 50
 DW INRM48
 DB 51
 DW INRM48
 DB 0

;******************************
;
; SPECIAL ACTION FOR COMMANDS
; GIVEN WHILE IN A ROOM TABLE
;
;******************************

INRMTB EQU $
 DB 14
 DW INRM15
 DB 15
 DW INRM15
 DB 47
 DW INRM15
 DB 48
 DW INRM48
 DB 50
 DW INRM48
 DB 51
 DW INRM48
 DB 0

;******************************
;
; MESSAGE TABLE FOR GENERAL
; LOOK AT OBJECT ROUTINE
;
; FMT: DB OBJ#
;          MSG# IF CARRYING
;          MSG# IF IN ROOM
;
;******************************

OBJMSG EQU $
 DB 008,033,033 ;CALENDAR
 DB 015,033,033 ;CALENDAR
 DB 020,051,010 ;BIRTH CERT
 DB 021,052,010 ;NOTEBOOK
 DB 025,022,012 ;EMPTY SACK
 DB 028,022,010 ;VIAL
 DB 033,066,010 ;FULL VIAL
 DB 038,071,010 ;NEWS CLIPPING
 DB 040,014,012 ;WEARING SUIT
 DB 041,079,010 ;HARD WAX
 DB 042,080,010 ;SOFT WAX
 DB 044,029,029 ;UNLIT CANDLE
 DB 045,028,028 ;LIT CANDLE
 DB 052,088,010 ;BRASS RING
 DB 079,091,091 ;PICTURES
 DB 083,086,086 ;EMPTY SARC
 DB 084,086,086 ;EMPTY SARC
 DB 085,087,087 ;TREKBOER
 DB 088,085,085 ;OPEN SARC
 DB 089,016,016 ;CLOSED SARC
 DB 090,081,081 ;MAE WEST
 DB 092,072,072 ;MUTANT
 DB 094,062,062 ;BATTERY
 DB 095,061,061 ;BATTERY
 DB 096,060,060 ;BATTERY
 DB 103,049,049 ;KING TUT SIGN
 DB 104,047,047 ;HG WELLS SIGN
 DB 105,018,018 ;OPEN CHEST
 DB 106,017,017 ;LOCKED CHEST
 DB 107,018,018 ;OPEN WINDOW
 DB 108,057,057 ;BARRED WIND
 DB 111,042,042 ;PRESSURE SIGN
 DB 112,041,041 ;SAFE SIGN
 DB 113,022,022 ;OPEN SAFE
 DB 114,039,039 ;LOCKED SAFE
 DB 115,055,055 ;SIGN
 DB 116,032,032 ;PLAQUE
 DB 119,038,038 ;SLOT
 DB 120,048,048 ;BOOKCASE
 DB 123,012,012 ;OPEN DESK
 DB 124,035,035 ;CLOSED DESK
 DB 125,018,018 ;OPEN DOOR
 DB 126,016,016 ;CLOSED DOOR
 DB 127,017,017 ;LOCKED DOOR
 DB 0

;******************************
; OBJECT EQUATE TABLE DEFINES
; OBJECTS THAT MAY HAVE MULTIPLE
; OBJECT NUMBERS.
;
; FORMAT: DB X,Y,Y,Y,Y
;  WHERE: X = PRIMARY OBJ #
;         Y = SECONDARY OBJ #
;             OR ZERO FOR NONE
;******************************

EQUTAB EQU $
 DB 8,15,0         ;CALENDAR
 DB 21,22,0        ;NOTEBOOK
 DB 23,24,25,0     ;SACK LUNCH
 DB 27,34,35,0     ;LIME
 DB 28,33,0        ;VIAL
 DB 37,40,0        ;SPACE SUIT
 DB 41,42,0        ;WAX
 DB 44,45,0        ;CANDLE
 DB 89,88,83,84,0  ;SARC
 DB 96,95,94,0     ;BATTERY
 DB 100,80,81,0    ;HOLE
 DB 102,101,0      ;TORCH
 DB 106,105,0      ;CHEST
 DB 108,107,0      ;WINDOW
 DB 113,114,0      ;SAFE DIAL
 DB 114,113,0      ;WALL SAFE
 DB 115,112,111    ;SIGN
 DB 104,103,0      ;  "
 DB 124,123,0      ;DEVICE
 DB 127,126,125,0  ;DOOR
 DB 0

;******************************
; DEFINE OBJECTS THAT SHOULD
; BE REFERRED TO AS "THEM"
;
; FORMAT IS: OBJ#,TYPE
;      WHERE TYPE IS:
;     0 = IT    1 = THEM
;     2 = HER   3 = HIM
;     4 = ONE   5 = ANY
;******************************

THEMTB EQU $
 DB 034,1   ;LIME HALVES
 DB 035,1   ;LIME PEELS
 DB 078,3   ;CHARLIE CHAPLIN
 DB 087,3   ;MUMMY
 DB 090,2   ;MAE WEST
 DB 092,3   ;MUTANT
 DB 102,4   ;TORCHES
 DB 0

;******************************
; LITERAL TABLE FOR IT,THEM,HIM
; HER MESSAGES.
;******************************

LITTAB EQU $
 DB 'it.',0
 DB 'them.',0
 DB 'her.',0
 DB 'him.',0
 DB 'one.',0
 DB 'any.',0

;
; TIME MACH MOVEMENT TABLE
;    DB CART COLOR,TO ROOM

TIMTAB EQU $
 DB 9,38  ;BLUE CART
 DB 13,12 ;RED CART
 DB 16,34 ;YELLOW CART
 DB 36,16 ;PINK CART
 DB 39,49 ;WHITE CART
 DB 0

;******************************
;
; ROOM TABLE.  DEFINES THE
; LAYOUT OF THE ADVENTURE. EACH
; ENTRY HAS THE FOLLOWING
; FORMAT:
;
; # BYTES        DESCRIPTION
; -------   -------------------
;    1      ROOM # TO NORTH
;    1      ROOM # TO SOUTH
;    1      ROOM # TO EAST
;    1      ROOM # TO WEST
;    1      ROOM # UP
;    1      ROOM # DOWN
;
;******************************

RMTBDF EQU $
;ROOM 1
 DB 0,2,5,0,0,0
;ROOM 2
 DB 1,3,6,17,0,0
;ROOM 3
 DB 2,4,7,18,0,0
;ROOM 4
 DB 3,0,8,19,0,0
;ROOM 5
 DB 0,0,0,1,0,0
;ROOM 6
 DB 0,0,10,2,0,0
;ROOM 7
 DB 0,0,11,3,0,0
;ROOM 8
 DB 0,0,13,4,0,0
;ROOM 9
 DB 0,0,0,0,0,0
;ROOM 10
 DB 0,11,0,6,0,0
;ROOM 11
 DB 10,13,0,7,0,0
;ROOM 12
 DB 0,0,0,0,0,0
;ROOM 13
 DB 11,0,0,8,0,0
;ROOM 14
 DB 0,15,0,0,0,0
;ROOM 15
 DB 14,47,0,0,0,0
;ROOM 16
 DB 0,0,0,0,0,0
;ROOM 17
 DB 0,0,2,0,0,0
;ROOM 18
 DB 0,0,3,0,0,0
;ROOM 19
 DB 0,0,4,0,0,0
;ROOM 20
 DB 0,0,0,0,0,0
;ROOM 21
 DB 0,0,0,0,0,0
;ROOM 22
 DB 0,0,0,0,0,0
;ROOM 23
 DB 0,24,27,0,0,0
;ROOM 24
 DB 23,25,28,0,0,0
;ROOM 25
 DB 24,26,29,0,0,0
;ROOM 26
 DB 25,0,30,0,0,0
;ROOM 27
 DB 0,0,0,23,0,0
;ROOM 28
 DB 0,0,32,24,0,0
;ROOM 29
 DB 0,0,33,25,0,0
;ROOM 30
 DB 0,0,35,26,0,0
;ROOM 31
 DB 0,0,0,0,0,0
;ROOM 32
 DB 0,33,0,28,0,0
;ROOM 33
 DB 32,35,0,29,0,0
;ROOM 34
 DB 0,0,0,0,0,0
;ROOM 35
 DB 33,0,0,30,0,0
;ROOM 36
 DB 0,37,0,0,0,0
;ROOM 37
 DB 36,39,0,0,0,0
;ROOM 38
 DB 0,0,0,0,0,0
;ROOM 39
 DB 37,0,40,41,0,0
;ROOM 40
 DB 44,43,44,43,0,0
;ROOM 41
 DB 0,0,0,0,0,0
;ROOM 42
 DB 0,43,0,0,0,0
;ROOM 43
 DB 43,0,0,44,0,0
;ROOM 44
 DB 45,44,43,44,0,0
;ROOM 45
 DB 44,45,39,45,0,0
;ROOM 46
 DB 0,0,0,0,0,0
;ROOM 47
 DB 15,0,0,0,0,0
;ROOM 48
 DB 51,50,0,0,0,0
;ROOM 49
 DB 0,0,0,0,0,0
;ROOM 50
 DB 48,0,0,0,0,0
;ROOM 51
 DB 0,48,0,0,0,0
;ROOM 52
 DB 0,0,0,0,0,0
;ROOM 53
 DB 0,0,0,0,0,0

; ROOM OBJECTS TABLE
; EACH VARIABLE LENGTH ENTRY
; DELIMITED BY $00

RMOBDF EQU $
;ROOM 1
 DB 127,0
;ROOM 2
 DB 0
;ROOM 3
 DB 0
;ROOM 4
 DB 127,0
;ROOM 5
 DB 124,8,9+INV,14+INV
 DB 114+INV,16+INV,0
;ROOM 6
 DB 0
;ROOM 7
 DB 0
;ROOM 8
 DB 98,99,21+INV,28+INV,0
;ROOM 9
 DB 0
;ROOM 10
 DB 122,118,112,10,11,0
;ROOM 11
 DB 120,121,104,13+INV,0
;ROOM 12
 DB 119,118,117,96,0
;ROOM 13
 DB 79,0
;ROOM 14
 DB 91,0
;ROOM 15
 DB 91,121,38,0
;ROOM 16
 DB 119,118,117,94,0
;ROOM 17
 DB 78,90,51+INV,46,0
;ROOM 18
 DB 116,37,86,85,0
;ROOM 19
 DB 103,0
;ROOM 20
 DB 125,118,0
;ROOM 21
 DB 126,118,0
;ROOM 22
 DB 125,115,97,23+INV,29+INV,0
;ROOM 23
 DB 127,0
;ROOM 24
 DB 0
;ROOM 25
 DB 0
;ROOM 26
 DB 0
;ROOM 27
 DB 124,20+INV,0
;ROOM 28
 DB 0
;ROOM 29
 DB 0
;ROOM 30
 DB 98,99,30+INV,0
;ROOM 31
 DB 0
;ROOM 32
 DB 122,12,118,112,0
;ROOM 33
 DB 120,121,104,36+INV,0
;ROOM 34
 DB 119,118,117,94,0
;ROOM 35
 DB 79,0
;ROOM 36
 DB 110,102,0
;ROOM 37
 DB 121,102,0
;ROOM 38
 DB 119,118,117,94,0
;ROOM 39
 DB 102,0
;ROOM 40
 DB 102,0
;ROOM 41
 DB 127,109,108,47+INV
 DB 43+INV,52+INV,0
;ROOM 42
 DB 107,102,17,0
;ROOM 43
 DB 102,0
;ROOM 44
 DB 102,18,0
;ROOM 45
 DB 102,0
;ROOM 46
 DB 106,102,100,31+INV,19,0
;ROOM 47
 DB 91,92,0
;ROOM 48
 DB 121,0
;ROOM 49
 DB 119,118,117,94,0
;ROOM 50
 DB 0
;ROOM 51
 DB 89,50+INV,0
;ROOM 52
 DB 82,49,0
;ROOM 53
 DB 80,48,0
;RESERVE AREAS
 DB 20 DUP(0)

RMTBEND DB 0

; ROOM DIRECTION TABLE USED DURING GAME PLAY - SOURCE IS RMTBDF

ROOMTB DB (RMOBDF - RMTBDF) DUP(?)

; ROOM OBJECT TABLE USED DURING GAME PLAY - SOURCE IS RMOBDF

RMOBT1 DB (RMTBEND - RMOBDF) DUP(?)

RMOBT2 DB 0,0,0

RMTB_LEN DW (RMTBEND - RMTBDF)

;******************************
; TREASURE POINT TABLE
;
; FORMAT: DB TREASURE,POINTS
;******************************

PNTTAB EQU $
 DB 17,10 ;SAPPHIRE
 DB 18,06 ;GOLD NUGGET
 DB 19,13 ;JADE BUDDHA
 DB 31,18 ;SCEPTER
 DB 32,16 ;DIAMOND
 DB 48,10 ;SILVER CUP
 DB 49,10 ;EMERALD
 DB 50,15 ;RUBY NECKLACE
 DB 51,02 ;PLATINUM BRACELET
 DB 0

;******************************
;
; GRAPHIC SCREEN INDICATOR
; TABLE (BY ROOM)
;
;******************************

SCRIND EQU $
;ROOM 1
 DB 5,34,35,36,37,33,38,39,16
 DB 15,0
;ROOM 2
 DB 5,20,21,22,23,24,16,19
 DB 14,15,18,0
;ROOM 3
 DB 5,20,21,22,23,25,26,16,19
 DB 14,15,17,18,0
;ROOM 4
 DB 5,34,35,36,16,14,15,0
;ROOM 5
 DB 4,2,3,4,5,6,7,8,9,10,11
 DB 12,13,56,57,58,59,0
;ROOM 6
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112
 DB 113,114,115,116,117,0
;ROOM 7
 DB 4,140,141,142,143,144,145
 DB 146,147,148,149,150,151
 DB 152,153,0
;ROOM 8
 DB 1,241,201,202,242,243,244
 DB 245,246,247,248,249,250
 DB 251,252,253,254,OV2,1
 DB OV2,2,OV2,3,OV2,4,OV2,5
 DB OV2,6,OV2,7,OV2,8,OV2,9
 DB OV2,10,OV2,11,OV2,12
 DB OV2,13,OV2,14,OV2,15
 DB OV2,16,OV2,23,0
;ROOM 9
 DB 4,225,201,202,0
;ROOM 10
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112
 DB 118,119,120,121,122,123
 DB 124,0
;ROOM 11
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 128,131,132,133
 DB 134,135,136,137,138,139,0
;ROOM 12
 DB 2,176,177,178,179,180,181
 DB 182,183,184,185,0
;ROOM 13
 DB 4,140,141,142,143,144,145
 DB OV2,37,OV2,38,OV2,39
 DB OV2,40,OV2,41,OV2,42
 DB OV2,43,OV2,44,OV2,45,0
;ROOM 14
 DB 8,156,157,158,159,160,161
 DB 162,163,164,165,166,0
;ROOM 15
 DB 8,156,157,158,159,160,161
 DB 164,165,166
 DB 128,133,134,135
 DB 136,0
;ROOM 16
 DB 2,176,177,178,179,180,181
 DB 182,183,184,185,0
;ROOM 17
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112
 DB OV2,26,OV2,27,OV2,28
 DB OV2,29,OV2,30,OV2,31
 DB OV2,32,0
;ROOM 18
 DB 4,140,141,142,143,144,145
 DB 167,168,169,170,171,175
 DB 199,200,0
;ROOM 19
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112,155,0
;ROOM 20
 DB 7,68,69,70,71,74,0
;ROOM 21
 DB 7,68,69,70,71,74,0
;ROOM 22
 DB 2,77,78,79,80,81,82,83,84
 DB 85,86,87,0
;ROOM 23
 DB 5,34,35,36,37,33,38,39,16
 DB 15,0
;ROOM 24
 DB 5,20,21,22,23,24,16,19
 DB 15,18,0
;ROOM 25
 DB 5,20,21,22,23,16,19,14
 DB 17,0
;ROOM 26
 DB 5,34,35,36,16,14,0
;ROOM 27
 DB 4,2,3,4,5,6,7,8,9,10,11
 DB 12,13,56,57,58,59,0
;ROOM 28
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112
 DB 113,114,115,116,117,0
;ROOM 29
 DB 4,140,141,142,143,144,145
 DB 146,147,148,149,150,151
 DB 152,153,0
;ROOM 30
 DB 1,241,201,202,242,243,244
 DB 245,246,247,248,249,250
 DB 251,252,253,254,OV2,1
 DB OV2,2,OV2,3,OV2,4,OV2,5
 DB OV2,6,OV2,7,OV2,8,OV2,9
 DB OV2,10,OV2,11,OV2,12
 DB OV2,13,OV2,14,OV2,15
 DB OV2,16,OV2,23,0
;ROOM 31
 DB 4,225,201,202,0
;ROOM 32
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 112
 DB 118,119,120,121,122,123
 DB 124,0
;ROOM 33
 DB 3,92,93,94,95,96,97,98,99
 DB 100,101,102,103,104,105
 DB 106,107,108,109,110,111
 DB 128,131,132,133,134,135
 DB 136,137,138,139,0
;ROOM 34
 DB 2,176,177,178,179,180,181
 DB 182,183,184,185,0
;ROOM 35
 DB 4,140,141,142,143,144,145
 DB OV2,37,OV2,38,OV2,39
 DB OV2,40,OV2,41,OV2,42
 DB OV2,43,OV2,44,OV2,45,0
;ROOM 36
 DB 6,43,44,54,55,186,187,0
;ROOM 37
 DB 6,128,133,134,135,136,0
;ROOM 38
 DB 2,176,177,178,179,180,181
 DB 182,183,184,185,0
;ROOM 39
 DB 6,43,44,54,55,0
;ROOM 40
 DB 6,27,28,40,48,41,49,42
 DB 43,44,54,55,0
;ROOM 41
 DB 6,197,198,188,189,190,191
 DB 192,193,0
;ROOM 42
 DB 6,27,28,40,48,41,49,42
 DB 43,44,54,55,195,196,0
;ROOM 43
 DB 6,27,28,40,48,41,49,42
 DB 43,44,54,55,0
;ROOM 44
 DB 6,27,28,40,48,41,49,42
 DB 43,44,54,55,0
;ROOM 45
 DB 6,27,28,40,48,41,49,42
 DB 43,44,54,55,0
;ROOM 46
 DB 6,197,198,OV2,62,0
;ROOM 47
 DB 8,156,157,158,159,160,161
 DB 162,163,164,165,166,0
;ROOM 48
 DB 4,225,226,203,204,227,228
 DB 229,230,231,232,233,234
 DB 235,236,237,0
;ROOM 49
 DB 2,176,177,178,179,180,181
 DB 182,183,184,185,0
;ROOM 50
 DB 4,225,226,203,204,227,228
 DB 229,230,231,232,233,234
 DB 235,236,237,0
;ROOM 51
 DB 4,225,201,202,203,204,205
 DB 206,207,208,209,210,211
 DB 212,213,214,215,216,217,0
;ROOM 52
 DB 4,225,201,202,203,204,206
 DB 207,209,210,211,212,213
 DB 214,215,216,217,227,240,0
;ROOM 53
 DB 9,201,202,0

;******************************
;
; ANTIMATION ROUTINES BY ROOM
;
; FORMAT: ROOM #,RTN VECTOR
;
;******************************

ANTTAB EQU $
 DB 07
 DW MOVFSH
 DB 08
 DW MOVLAB
 DB 29
 DW MOVFSH
 DB 30
 DW MOVLAB
 DB 36
 DW MOVTOR
 DB 37
 DW MOVTOR
 DB 39
 DW MOVTOR
 DB 40
 DW MOVTOR
 DB 42
 DW MOVTOR
 DB 43
 DW MOVTOR
 DB 44
 DW MOVTOR
 DB 45
 DW MOVTOR
 DB 47
 DW MOVMUT
 DB 0

;******************************
;
; IF OBJECT DROPPED IN ROOM
; PUT IT IN ANOTHER ROOM TABLE
;
; FORMAT: CURR ROOM,NEW ROOM
;
;******************************

PUTTAB EQU $
 DB 0

GENHLP EQU $
 DB 13,'T','r','y'+SPC
 DB 'examinin','g'+SPC
 DB 'things.',0

 DB 13,'N','o'+SPC
 DB 'HEL','P'+SPC
 DB 'available.',0

 DB 13,'U','s','e'+SPC
 DB 'SAV','E'+SPC
 DB 'whe','n'+SPC
 DB 'enterin','g'+SPC
 DB 'dangerou','s'+SPC
 DB 'areas.',0

 DB 13,C$IM
 DB 'stumpe','d'+SPC
 DB 'too!',0

;******************************
;
; DIRECTION DESCRIPTIONS TABLE
;
;******************************

DIRECT EQU $
 DB 'North',0
 DB 'South',0
 DB 'East',0
 DB 'West',0
 DB 'Up',0
 DB 'Down',0

;******************************
;
; COMPRESSED PHRASE TABLE
;
;******************************

TXTTAB EQU $
 DB 'th','e'+SPC,0
 DB 'smal','l'+SPC,0
 DB 'ar','e'+SPC,0
 DB 'se','e'+SPC,0
 DB 'can',QUOTE,'t'+SPC,0
 DB 'don',QUOTE,'t'+SPC,0
 DB 'larg','e'+SPC,0
 DB 'I',QUOTE,'m'+SPC,0
 DB C$IN,'a'+SPC,0
 DB 'o','n'+SPC,'a'+SPC,0
 DB 'i','s'+SPC,'a'+SPC,0
 DB 'It',QUOTE,'s'+SPC,0
 DB 'Th','e'+SPC,0
 DB 'i','s'+SPC,0
 DB 'an','d'+SPC,0
 DB 'a','n'+SPC,0
 DB 'a','t'+SPC,0
 DB 'o','f'+SPC,0
 DB 'I','t'+SPC,'s','a','y','s',':',13,0
 DB 'i','n'+SPC,0
 DB 't','o'+SPC,0
 DB 'm','y'+SPC,0
 DB 'i','n'+SPC,0
 DB 'o','n'+SPC,0
 DB 'Yo','u'+SPC,0
 DB C$YYOU,'ar','e'+SPC,0

;******************************
;
; VERB ROUTINE JUMP VECTORS
;
;******************************

RTNTAB EQU $
 DW VLOOK,VINVE,VGET,VPUT
 DW VNORTH,VSOUTH,VEAST,VWEST
 DW VUP,VDOWN,VGO,VSAVE
 DW VLOAD,VHELP,VSCORE,ENDGAM
 DW BADINP,BADINP,GO03
 DW VINSRT,BADINP,VPUSH,VTURN
 DW BADINP,BADINP,BADINP
 DW BADINP,BADINP,BADINP
 DW VGIVE,BADINP,VDIG,BADINP
 DW VEAT,BADINP,BADINP
 DW BADINP,BADINP,VTURN

;******************************
;
; NON ARRAY VARIABLES
;
;******************************

COMMA DB ','+SPC,0

;******************************
;
; ASSORTED TEXT MESSAGES
;
;******************************

MSG0 DB 13,13,'O','K',','+SPC,0

MSG1 DB 13,13
 DB 'Obviou','s'+SPC
 DB 'directions',':'+SPC
 DB 0

MSG2 DB 13,13
 DB 'I'+SPC,C$SEE,8,':'+SPC,0

MSG3 DB 13
 DB 'I'+SPC
 DB C$SEE
 DB 'n','o'+SPC
 DB 'wa','y'+SPC
 DB 't','o'+SPC,'g','o'+SPC
 DB C$IN
 DB 'tha','t'+SPC
 DB 'direction.'
 DB 0

MSG4 DB 13
 DB 'I'+SPC,C$DONT
 DB 'understan','d'+SPC,'"'
 DB 0

MSG5 DB 13,C$IM
 DB 'carryin','g'+SPC
 DB C$THE
 DB 'following:',13,0

MSG6 DB 13
 DB 'nothing.',0

MSG7 DB 13,'I'+SPC,C$DONT
 DB C$SEE,0

MSG8 DB 13
 DB C$IM
 DB 'carryin','g'+SPC,0

MSG9 DB 13,'I'+SPC,C$CANT
 DB 'carr','y'+SPC
 DB 'anymore.',0

MSG10 DB 13
 DB 'I'+SPC,C$DONT
 DB 'hav','e'+SPC,0

MSG11 DB 13
 DB 'Hey',','+SPC,'I'+SPC
 DB 'foun','d'+SPC,0

MSG12 DB 13,'I'+SPC,C$SEE
 DB 'nothin','g'+SPC
 DB 'special.',0

MSG13 DB 13,C$IM,'o','n'+SPC
 DB 'it!',0

MSG14 DB 13,C$IM,C$IN
 DB 'it!',0

MSG15 DB 13,C$IITS
 DB 'beyon','d'+SPC,'m','y'+SPC
 DB 'powe','r'+SPC
 DB 't','o'+SPC,'d','o'+SPC
 DB 'that.',0

MSG16 DB 13,C$IITS
 DB 'closed.',0

MSG17 DB 13,C$IITS
 DB 'locked.',0

MSG18 DB 13,C$IITS
 DB 'open.',0

MSG19 DB 13,C$IITS
 DB 'unlocked.',0

MSG20 DB 13
 DB 'Won',QUOTE,'t'+SPC
 DB 'budge.',0

MSG21 DB 13
 DB 'Doesn',QUOTE,'t'+SPC
 DB 'work.',0

MSG22 DB 13,C$IITS
 DB 'empty.',0

MSG23 DB 13,'I'+SPC,C$CANT
 DB 'd','o'+SPC
 DB 'tha','t'+SPC
 DB '.','.','.'+SPC
 DB 'now!',0

MSG24 DB 13
MSG24B DB '00000'
 DB ' ',C$OF
 DB '10','0'+SPC
 DB 'point','s'+SPC
 DB 'scored',13
MSG24A DB '00000'
 DB ' move','s'+SPC
 DB 'used.',0

MSG25 DB 13,13
 DB 'Thi','s'+SPC
 DB 'Adventur','e'+SPC
 DB C$IS
 DB 'over.',13
MSG25B DB '00000'
 DB ' ',C$OF
 DB '10','0'+SPC
 DB 'point','s'+SPC
 DB 'scored',13
MSG25A DB '00000'
 DB ' move','s'+SPC
 DB 'wer','e'+SPC
 DB 'used.',13,13
 DB 'Pla','y'+SPC
 DB 'agai','n'+SPC
 DB '(Y/N)','?'+SPC,0

MSG26 DB 13
 DB 'Don',QUOTE,'t'+SPC
 DB 'b','e'+SPC
 DB 'ridiculous.',0

MSG27 DB 13,13
 DB 'Congratulations',','+SPC
 DB 'yo','u'+SPC
 DB 'di','d'+SPC
 DB 'it!',0

MSG28 DB 13,C$IITS
 DB 'lit.',0

MSG29 DB 13,C$IITS
 DB 'out.',0

MSG30 DB 'I'+SPC
 DB 'fel','l'+SPC
 DB 'dow','n'+SPC,C$AND
 DB 'cracke','d'+SPC
 DB 'm','y'+SPC
 DB 'head','.'+SPC,C$IM
 DB 'dead!',0

MSG31 DB 13
 DB 'Wheeeee...',0

MSG32 DB 13,C$ITSA
 DB 'I','n'+SPC
 DB 'gratefu','l'+SPC
 DB 'appreciatio','n'+SPC
 DB 't','o'+SPC,C$THE
 DB 'cre','w'+SPC,C$OF,C$THE
 DB 'S','S'+SPC
 DB 'Trekboer.',0

MSG33 DB 13,C$ITSA
 DB 'Jun','e'+SPC
 DB '15',','+SPC
 DB '2063',0

MSG34 DB 13
 DB 'Hey',','+SPC
 DB 'there',QUOTE,'s'+SPC
 DB 'a'+SPC
 DB 'saf','e'+SPC
 DB 'behin','d'+SPC
 DB 'it!',0

MSG35 DB 13,'I'+SPC,C$SEE
 DB 'a'+SPC
 DB 'close','d'+SPC
 DB 'drawer.',0

MSG36 DB 13,'I','t'+SPC
 DB 'contain','s'+SPC,0

MSG37 DB 13
 DB 'Pleas','e'+SPC
 DB 'refe','r'+SPC,C$TO,C$THE
 DB 'cartridge','s'+SPC
 DB 'b','y'+SPC
 DB 'color.',0

MSG38 DB 13,'A'+SPC,C$SMAL
 DB 'ta','g'+SPC
 DB 'besid','e'+SPC,'i','t'+SPC
 DB 'says',':'+SPC
 DB '"INSER','T'+SPC
 DB 'HERE".',0

MSG39 DB 13
 DB 'There',QUOTE,'s'+SPC
 DB 'a'+SPC
 DB 'dia','l'+SPC
 DB 'o','n'+SPC
 DB 'it.',0

MSG40 DB 13,'I','t'+SPC
 DB 'ha','s'+SPC
 DB 'number','s'+SPC
 DB 'fro','m'+SPC,'0','0'+SPC
 DB C$TO,'9','9'+SPC
 DB 'o','n'+SPC
 DB 'it.',0

MSG41 DB 13,C$ITSA
 DB 'AL','L'+SPC
 DB 'CLEAR',0

MSG42 DB 13,C$ITSA
 DB 'PRESSURIZED',0

MSG43 DB 13
 DB 'Nothin','g'+SPC
 DB 'happens.',0

MSG44 DB 13,C$ITSA
 DB 'Detroit',','+SPC
 DB 'Jun','e'+SPC
 DB '2063',0

MSG45 DB 13,C$ITSA
 DB 'Detroit',','+SPC
 DB 'Ma','y'+SPC
 DB '1967',0

MSG46 DB 13,C$ITSA
 DB 'London',','+SPC
 DB 'Apri','l'+SPC
 DB '1200',0

MSG47 DB 13,C$ITSA
 DB 'Herbert',','+SPC,C$THE
 DB 'ma','n'+SPC,C$AND
 DB 'hi','s'+SPC
 DB 'times.',0

MSG48 DB 13,C$IITS
 DB 'jus','t'+SPC,'a'+SPC
 DB 'bookcase.',0

MSG49 DB 13,C$ITSA,C$TTHE
 DB 'Kin','g'+SPC
 DB 'Tu','t'+SPC
 DB 'exhibi','t'+SPC
 DB 'move','s'+SPC,C$TO
 DB 'Chicag','o'+SPC
 DB 'o','n'+SPC
 DB 'Jun','e'+SPC
 DB '12th','.'+SPC
 DB 'Tu','t'+SPC
 DB 'Tu','t'+SPC
 DB 'Tutsie',','+SPC
 DB 'goodbye.',0

MSG50 DB 13,'T','o'+SPC
 DB 'whic','h'+SPC
 DB 'number','?'+SPC,0

MSG51 DB 13,C$IITS,'a'+SPC
 DB 'birt','h'+SPC
 DB 'certificat','e'+SPC
 DB 'fo','r'+SPC
 DB 'Edga','r'+SPC
 DB 'Collin','s'+SPC
 DB 'bor','n'+SPC
 DB 'Novembe','r'+SPC
 DB '29th',','+SPC
 DB '1942.',0

MSG52 DB 13,C$ITSA
 DB 'NOTES',','+SPC
 DB 'Dr','.'+SPC,'A'+SPC
 DB 'Polowski',0

MSG53 DB 13,C$ITSA
 DB C$TTHE
 DB 'Cyclas','e'+SPC
 DB 'Theorem',13,13
 DB 'Well','s'+SPC
 DB 'wa','s'+SPC
 DB 'right',','+SPC,C$AN
 DB 'enzym','e'+SPC,C$IS,C$THE
 DB 'key.',0

MSG54 DB 13,C$ITSA
 DB C$TTHE
 DB 'Vorte','x'+SPC
 DB 'Factor',13,13
 DB 'Cyclizatio','n'+SPC,C$IS
 DB 'mandator','y'+SPC
 DB 'bu','t'+SPC
 DB 'require','s'+SPC,'a'+SPC
 DB 'tricarboxyli','c'+SPC
 DB 'aci','d'+SPC
 DB 'base','d'+SPC
 DB 'catalyst.',0

MSG55 DB 13,C$ITSA
 DB 'Jus','t'+SPC
 DB 'stac','k'+SPC
 DB 'ne','w'+SPC
 DB 'treasure','s'+SPC
 DB 'here','.'+SPC,C$TTHE
 DB 'curator.',0

MSG56 DB 13,13
 DB 'A','s'+SPC,'I'+SPC
 DB 'ente','r'+SPC,C$THE
 DB 'doo','r'+SPC
 DB 'slam','s'+SPC
 DB 'shut!',0

MSG57 DB 13
 DB 'Stee','l'+SPC
 DB 'bar','s'+SPC
 DB 'bloc','k'+SPC,C$THE
 DB 'way.',0

MSG58 DB 13
 DB 'Fastene','d'+SPC
 DB C$TO,C$THE
 DB 'wall.',0

MSG59 DB 13
 DB 'Fastene','d'+SPC
 DB 'securel','y'+SPC
 DB C$TO,C$THE
 DB 'wall.',0

MSG60 DB 13,C$IITS
 DB 'bon','e'+SPC
 DB 'dry.',0

MSG61 DB 13,C$IITS
 DB 'ful','l'+SPC,C$OF
 DB 'acid.',0

MSG62 DB 13,C$IITS
 DB 'full','y'+SPC
 DB 'charged.',0

MSG63 DB 13
 DB '(int','o'+SPC
 DB 'vial)',0

MSG64 DB 13
 DB '(ont','o'+SPC
 DB 'floor)',0

MSG65 DB 13
 DB '(int','o'+SPC
 DB 'battery)',0

MSG66 DB 13,C$IITS
 DB 'ful','l'+SPC,C$OF
 DB 'juice.',0

MSG67 DB 13,C$ITSA
 DB 'Vorte','x'+SPC
 DB 'Facto','r'+SPC
 DB 'unresolved.',0

MSG68 DB 13,13,'A'+SPC
 DB 'distan','t'+SPC
 DB 'voic','e'+SPC
 DB 'says',':'+SPC
 DB 'Wh','o'+SPC
 DB 'lef','t'+SPC,0

MSG69 DB ' '
 DB 'jus','t'+SPC
 DB 'layin','g'+SPC
 DB 'here?',0

MSG70 DB 13,C$ITSA
 DB 'Sa','n'+SPC
 DB 'Francisco',','+SPC
 DB 'Augus','t'+SPC
 DB '2305',0

MSG71 DB 13,C$ITSA
 DB 'NUCLEA','R'+SPC
 DB 'ACCIDEN','T'+SPC
 DB 'CONTAMINATE','S'+SPC
 DB 'ENTIR','E'+SPC
 DB 'WES','T'+SPC
 DB 'COAST',0

MSG72 DB 13
 DB 'Poo','r'+SPC
 DB 'devi','l'+SPC
 DB 'look','s'+SPC
 DB 'hal','f'+SPC
 DB 'starved.',0

MSG73 DB 13,'H','e'+SPC
 DB 'gulp','s'+SPC
 DB 'dow','n'+SPC,C$THE
 DB 'sandwich',','+SPC
 DB 'slip','s'+SPC
 DB 'somethin','g'+SPC
 DB 'int','o'+SPC,'m','y'+SPC
 DB 'han','d'+SPC,C$AND
 DB 'run','s'+SPC
 DB 'off.',0

MSG74 DB 13,13,'I'+SPC,C$DONT
 DB 'fee','l'+SPC,'s','o'+SPC
 DB 'good.',0

MSG75 DB 13,13,'M','y'+SPC
 DB 'hea','d'+SPC,C$IS
 DB 'spinning.',0

MSG76 DB 13,13,'I'+SPC
 DB 'ca','n'+SPC
 DB 'hardl','y'+SPC
 DB 'breathe!',0

MSG77 DB 'I'+SPC
 DB 'hav','e'+SPC
 DB 'succumbe','d'+SPC,C$TO
 DB 'radiatio','n'+SPC
 DB 'poisoning.',0

MSG78 DB 'Suddenly',','+SPC
 DB C$THE
 DB 'mutan','t'+SPC
 DB 'attack','s'+SPC
 DB 'me','.'+SPC,C$IM
 DB 'dead!',0

MSG79 DB 13,C$IITS
 DB 'hard.',0

MSG80 DB 13,C$IITS
 DB 'soft.',0

MSG81 DB 13
 DB 'Quit','e'+SPC,'a'+SPC
 DB 'gal',','+SPC,'e','h'+SPC
 DB 'sweetie?',0

MSG82 DB 13,C$ITSA
 DB 'Cairo',','+SPC
 DB 'Moo','n'+SPC,'2'+SPC
 DB '318','8'+SPC
 DB 'BC',0

MSG83 DB 13,13,C$TTHE
 DB 'candl','e'+SPC
 DB 'burn','s'+SPC
 DB 'ou','t'+SPC,C$IN
MSG83A DB '0 '
 DB 'move(s).',0

MSG84 DB C$IITS
 DB 'pitc','h'+SPC
 DB 'black','.'+SPC
 DB 'I'+SPC,C$CANT,C$SEE
 DB 'anything.',0

MSG85 DB 13
 DB 'I'+SPC,C$SEE,'a'+SPC
 DB 'mummy.',0

MSG86 DB 13
 DB 'Hey',','+SPC
 DB 'ther','e'+SPC,C$IS
 DB 'a'+SPC,C$SMAL
 DB 'leve','r'+SPC,C$IN
 DB 'it!',0

MSG87 DB 13,C$IITS,C$THE
 DB 'Trekboer.',0

MSG88 DB 13
 DB 'Ther','e'+SPC
 DB 'appear','s'+SPC,C$TO
 DB 'b','e'+SPC
 DB 'hieroglyphic','s'+SPC
 DB 'inscribe','d'+SPC
 DB 'o','n'+SPC
 DB 'it.',0

MSG89 DB 13,C$TTHE
 DB 'mumm','y'+SPC
 DB 'rises',','+SPC
 DB 'accept','s'+SPC,C$THE
 DB 'rin','g'+SPC,C$AND
 DB 'exit','s'+SPC
 DB 'vi','a'+SPC,'a'+SPC
 DB 'secre','t'+SPC
 DB 'passag','e'+SPC,C$IN
 DB 'on','e'+SPC,C$OF,C$THE
 DB 'walls.',0

MSG90 DB 13
 DB '(t','o'+SPC
 DB 'mummy)',13,0

MSG91 DB 13
 DB 'The','y'+SPC
 DB 'sur','e'+SPC
 DB 'ar','e'+SPC
 DB 'pretty.',0

MSG92 DB 13
 DB '(wit','h'+SPC
 DB 'hai','r'+SPC
 DB 'pin)',0

; OBJECT & ROOM DESCRIPTIONS
;

;******************************
;
; OBJECT DESCRIPTIONS TABLE
;
;******************************

OBJTAB EQU $

 DB 8,'a'+SPC
 DB 'calendar',0

 DB 9,'a'+SPC
 DB 'blu','e'+SPC
 DB 'cartridge',0

 DB 10,'a'+SPC
 DB 'helmet',0

 DB 11,'a'+SPC
 DB 'lum','p'+SPC,C$OF
 DB 'coal',0

 DB 12,'a'+SPC
 DB 'shovel',0

 DB 13,'a'+SPC
 DB 're','d'+SPC
 DB 'cartridge',0

 DB 14,'a'+SPC
 DB 'key',0

 DB 15,PNT,8,0

 DB 16,'a'+SPC
 DB 'yello','w'+SPC
 DB 'cartridge',0

 DB 17,'a'+SPC,C$LARG
 DB 'sapphire',0

 DB 18,'a'+SPC
 DB 'gol','d'+SPC
 DB 'nugget',0

 DB 19,'a'+SPC
 DB 'jad','e'+SPC
 DB 'buddha',0

 DB 20,C$AN
 DB 'ol','d'+SPC
 DB 'document',0

 DB 21,'a'+SPC
 DB 'notebook',0

 DB 22,PNT,21,0

 DB 23,'a'+SPC,C$SMAL
 DB 'sack',0

 DB 24,PNT,23,0

 DB 25,PNT,23,0

 DB 26,'a'+SPC
 DB 'sandwich',0

 DB 27,'a'+SPC
 DB 'lime',0

 DB 28,'a'+SPC,C$SMAL
 DB 'vial',0

 DB 29,'a'+SPC
 DB 'hacksaw',0

 DB 30,'a'+SPC
 DB 'hai','r'+SPC
 DB 'pin',0

 DB 31,'a'+SPC
 DB 'jewe','l'+SPC
 DB 'encruste','d'+SPC
 DB 'scepter',0

 DB 32,'a'+SPC,C$LARG
 DB 'diamond',0

 DB 33,PNT,28,0

 DB 34
 DB 'lim','e'+SPC
 DB 'halves',0

 DB 35
 DB 'lim','e'+SPC
 DB 'peels',0

 DB 36,'a'+SPC
 DB 'pin','k'+SPC
 DB 'cartridge',0

 DB 37,'a'+SPC
 DB 'spac','e'+SPC
 DB 'suit',0

 DB 38,'a'+SPC
 DB 'new','s'+SPC
 DB 'clipping',0

 DB 39,'a'+SPC
 DB 'whit','e'+SPC
 DB 'cartridge',0

 DB 40
 DB 'wearin','g'+SPC,'a'+SPC
 DB 'spac','e'+SPC
 DB 'suit',0

 DB 41,'a'+SPC
 DB 'bal','l'+SPC,C$OF
 DB 'wax',0

 DB 42,PNT,41,0

 DB 43,'a'+SPC
 DB 'string',0

 DB 44,'a'+SPC
 DB 'candle',0

 DB 45,PNT,44,0

 DB 46,'a'+SPC
 DB 'statu','e'+SPC
 DB C$OF,'a'+SPC
 DB 'bird',0

 DB 47,'a'+SPC
 DB 'spoon',0

 DB 48,'a'+SPC
 DB 'slive','r'+SPC
 DB 'cup',0

 DB 49,'a'+SPC,C$LARG
 DB 'emerald',0

 DB 50,'a'+SPC
 DB 'rub','y'+SPC
 DB 'necklace',0

 DB 51,'a'+SPC
 DB 'platinu','m'+SPC
 DB 'bracelet',0

 DB 52,'a'+SPC
 DB 'bras','s'+SPC
 DB 'ring',0

 DB 78,'a'+SPC
 DB 'statu','e'+SPC,C$OF
 DB 'Charli','e'+SPC
 DB 'Chaplin',0

 DB 79
 DB 'pictures',0

 DB 80,'a'+SPC
 DB 'hol','e'+SPC,C$IN,C$THE
 DB 'Ceiling',0

 DB 81,'a'+SPC
 DB 'hol','e'+SPC,C$IN,C$THE
 DB 'floor',0

 DB 82,'a'+SPC
 DB 'secre','t'+SPC
 DB 'passage',0

 DB 83,PNT,88,0

 DB 84,PNT,88,0

 DB 85,'a'+SPC
 DB 'starshi','p'+SPC
 DB 'model',0

 DB 86,'a'+SPC
 DB 'rocket',0

 DB 87,'a'+SPC
 DB 'mummy',0

 DB 88,'a'+SPC
 DB 'sarcophagus',0

 DB 89,PNT,88,0

 DB 90,'a'+SPC
 DB 'statu','e'+SPC,C$OF
 DB 'Ma','e'+SPC
 DB 'West',0

 DB 91
 DB 'water',0

 DB 92,'a'+SPC
 DB 'mutan','t'+SPC
 DB 'humanoid',0

 DB 93,'a'+SPC
 DB 'puddl','e'+SPC,C$OF
 DB 'juice',0

 DB 94,'a'+SPC
 DB 'battery',0

 DB 95,PNT,94,0

 DB 96,PNT,94,0

 DB 97,'a'+SPC
 DB 'workbench',0

 DB 98,'a'+SPC,C$LARG
 DB 'counter',0

 DB 99
 DB 'scientifi','c'+SPC
 DB 'gadgets',0

 DB 100,'a'+SPC
 DB 'hol','e'+SPC,C$IN,C$THE
 DB 'wall',0

 DB 101,PNT,102,0

 DB 102
 DB 'torches',0

 DB 103,PNT,115,0

 DB 104,PNT,115,0

 DB 105,'a'+SPC,C$LARG
 DB 'chest',0

 DB 106,PNT,105,0

 DB 107,C$AN
 DB 'ope','n'+SPC
 DB 'window',0

 DB 108,'a'+SPC
 DB 'barre','d'+SPC
 DB 'window',0

 DB 109,'a'+SPC
 DB 'skeleton',0

 DB 110,'a'+SPC,C$LARG
 DB 'iro','n'+SPC
 DB 'gate',0

 DB 111,PNT,115,0

 DB 112,PNT,115,0

 DB 113,'a'+SPC
 DB 'wal','l'+SPC
 DB 'safe',0

 DB 114,PNT,113,0

 DB 115,'a'+SPC
 DB 'sign',0

 DB 116,'a'+SPC
 DB 'plaque',0

 DB 117,'a'+SPC
 DB 'gauge',0

 DB 118,'a'+SPC
 DB 'button',0

 DB 119,'a'+SPC,C$SMAL
 DB 'slot',0

 DB 120,'a'+SPC
 DB 'bookcase',0

 DB 121,'a'+SPC,C$LARG
 DB 'cylinder',0

 DB 122,'a'+SPC,C$LARG
 DB 'device',0

 DB 123,'a'+SPC
 DB 'desk',0

 DB 124,PNT,123,0

 DB 125,'a'+SPC
 DB 'door',0

 DB 126,PNT,125,0

 DB 127,PNT,125,0

;******************************
;
; ROOM DESCRIPTIONS TABLE
;
;******************************

DESCTB EQU $
;ROOM 1
 DB C$IM,C$INA,C$LARG
 DB 'hallway.',0
;ROOM 2
 DB PNT,1,0
;ROOM 3
 DB PNT,1,0
;ROOM 4
 DB PNT,1,0
;ROOM 5
 DB C$IM,C$IN,C$THE
 DB 'mai','n'+SPC
 DB 'office.',0
;ROOM 6
 DB C$IM,C$IN,C$THE
 DB 'prehistori','c'+SPC
 DB 'exhibit.',0
;ROOM 7
 DB C$IM,C$IN,C$THE
 DB 'aquati','c'+SPC
 DB 'exhibit.',0
;ROOM 8
 DB C$IM,C$IN,C$THE
 DB 'scienc','e'+SPC
 DB 'exhibit.',0
;ROOM 9
 DB C$IM
 DB 'insid','e'+SPC
 DB 'a'+SPC,C$LARG
 DB 'device.',0
;ROOM 10
 DB C$IM,C$IN,C$THE
 DB 'minin','g'+SPC
 DB 'exhibit.',0
;ROOM 11
 DB C$IM,C$IN,'a'+SPC
 DB 'strang','e'+SPC
 DB 'exhibit.',0
;ROOM 12
 DB C$IM,C$INA
 DB 'tim','e'+SPC
 DB 'machine.',0
;ROOM 13
 DB C$IM,C$IN,C$AN
 DB 'ar','t'+SPC
 DB 'exhibit.',0
;ROOM 14
 DB PNT,15,0
;ROOM 15
 DB C$IM,C$ONA
 DB 'sand','y'+SPC
 DB 'shore.',0
;ROOM 16
 DB PNT,12,0
;ROOM 17
 DB C$IM,C$INA
 DB 'wa','x'+SPC
 DB 'museum.',0
;ROOM 18
 DB C$IM,C$IN,C$THE
 DB 'spac','e'+SPC
 DB 'expo.',0
;ROOM 19
 DB C$IM,C$INA,C$LARG
 DB 'empt','y'+SPC
 DB 'room.',0
;ROOM 20
 DB C$IM,C$INA
 DB 'ver','y'+SPC,C$SMAL
 DB 'room.',0
;ROOM 21
 DB PNT,20,0
;ROOM 22
 DB 'Thi','s'+SPC
 DB 'mus','t'+SPC
 DB 'b','e'+SPC,C$THE
 DB 'curator',QUOTE,'s'+SPC
 DB 'workroom.',0
;ROOM 23
 DB PNT,1,0
;ROOM 24
 DB PNT,1,0
;ROOM 25
 DB PNT,1,0
;ROOM 26
 DB PNT,1,0
;ROOM 27
 DB PNT,5,0
;ROOM 28
 DB PNT,6,0
;ROOM 29
 DB PNT,7,0
;ROOM 30
 DB PNT,8,0
;ROOM 31
 DB PNT,9,0
;ROOM 32
 DB PNT,10,0
;ROOM 33
 DB PNT,11,0
;ROOM 34
 DB PNT,12,0
;ROOM 35
 DB PNT,13,0
;ROOM 36
 DB C$IM,C$INA,C$LARG
 DB 'ston','e'+SPC
 DB 'corridor.',0
;ROOM 37
 DB PNT,36,0
;ROOM 38
 DB PNT,12,0
;ROOM 39
 DB PNT,36,0
;ROOM 40
 DB C$IM,C$INA
 DB 'twist','y'+SPC
 DB 'passageway.',0
;ROOM 41
 DB C$IM,C$INA
 DB 'dan','k'+SPC
 DB 'dungeon.',0
;ROOM 42
 DB PNT,40,0
;ROOM 43
 DB PNT,40,0
;ROOM 44
 DB PNT,40,0
;ROOM 45
 DB PNT,40,0
;ROOM 46
 DB C$IM,C$INA,C$LARG
 DB 'jewe','l'+SPC
 DB 'room.',0
;ROOM 47
 DB PNT,15,0
;ROOM 48
 DB C$IM,C$INA
 DB 'dust','y'+SPC
 DB 'ston','e'+SPC
 DB 'chamber','.'+SPC
 DB 'Hieroglyphic','s'+SPC
 DB 'populat','e'+SPC,C$THE
 DB 'walls.',0
;ROOM 49
 DB PNT,12,0
;ROOM 50
 DB PNT,48,0
;ROOM 51
 DB C$IM,C$INA
 DB 'buria','l'+SPC
 DB 'chamber.',0
;ROOM 52
 DB PNT,48,0
;ROOM 53
 DB PNT,48,0

;******************************
;
;  MOVABLE OBJECT TABLE
;
; OBJECT#, OVERLAY#,
;    ROOM#,...,ROOM#, 0
;
;******************************

MOVOBJ EQU $

 DB 8,47,0      ;CALENDAR
 DB 5,0

 DB 13,66,0     ;RED CART
 DB 5,27,0

 DB 10,126,0    ;HELMET
 DB 10,32,0

 DB 11,125,0    ;COAL
 DB 10,32,0

 DB 11,OV2,70,0 ;COAL
 DB 9,31,0

 DB 12,127,0    ;SHOVEL
 DB 10,32,0

 DB 13,154,0    ;RED CART
 DB 11,33,0

 DB 14,65,0     ;KEY
 DB 5,27,0

 DB 17,OV2,60,0 ;SAPPHIRE
 DB 42,0

 DB 18,OV2,61,0 ;GOLD NUGGET
 DB 44,0

 DB 19,OV2,64   ;JADE BUDDHA
 DB    OV2,65,0
 DB 46,0

 DB 20,67,0     ;DOCUMENT
 DB 5,27,0

 DB 21,OV2,74,0 ;NOTEBOOK
 DB 8,0

 DB 22,OV2,74,0 ;NOTEBOOK
 DB 8,0

 DB 23,89,0     ;SACK
 DB 22,0
 DB 24,89,0
 DB 22,0
 DB 25,89,0
 DB 22,0

 DB 26,88,0     ;SANDWICH
 DB 22,0

 DB 27,90,0     ;LIME
 DB 22,0

 DB 29,91,0     ;HACKSAW
 DB 22,0

 DB 31,OV2,66   ;SCEPTER
 DB    OV2,67,0
 DB 46,0

 DB 32,OV2,71,0 ;DIAMOND
 DB 9,31,0

 DB 37,172,173  ;SPACE SUIT
 DB    174,0
 DB 18,0

 DB 38,OV2,46,0 ;NEWS CLIPPING
 DB 14,15,47,0

 DB 46,OV2,33   ;BIRD STATUE
 DB    OV2,34
 DB    OV2,35
 DB    OV2,36,0
 DB 17,0

 DB 47,OV2,75,0 ;SPOON
 DB 41,0

 DB 48,OV2,68,0 ;SILVER CUP
 DB 53,0

 DB 49,OV2,69,0 ;EMERALD
 DB 52,0

 DB 50,OV2,72,0 ;RUBY NECKLESS
 DB 51,0

 DB 51,OV2,73,0 ;BRACLET
 DB 17,0

 DB 82,224,0    ;SECRET PASS
 DB 51,0

 DB 83,129,130  ;SARC W/HOLE
 DB    239,223,0
 DB 51,0

 DB 84,218,219  ;SARC NO MUMMY
 DB    220,221,0
 DB 51,0

 DB 88,218,219  ;SARC W/MUMMY
 DB    220,221
 DB    222,0
 DB 51,0

 DB 89,218,219  ;CLOSED SARC
 DB    220,0
 DB 51,0

 DB 92,OV2,47   ;MUTANT
 DB    OV2,48
 DB    OV2,49
 DB    OV2,50
 DB    OV2,51
 DB    OV2,53
 DB    OV2,55,0
 DB 47,0

 DB 100,46,0    ;HOLE IN WALL
 DB 37,0

 DB 101,OV2,56  ;TURNED TORCH
 DB     44
 DB     54,55,0
 DB 37,0

 DB 102,43,44   ;TORCH
 DB     54,55,0
 DB 37,0

 DB 105,OV2,63,0 ;OPEN CHEST
 DB 46,0

 DB 107,194,0   ;OPEN WINDOW
 DB 41,0

 DB 113,63,64,0 ;OPEN SAFE
 DB 5,0

 DB 114,60,61,0 ;CLOSED SAFE
 DB 5,0

 DB 123,62,0    ;OPEN DESK
 DB 5,27,0

 DB 125,31,32,0 ;OPEN DOOR
 DB 4,0

 DB 125,75,76,0 ;OPEN DOOR
 DB 20,21,0

 DB 126,29,30,0 ;CLOSED DOOR
 DB 4,0

 DB 126,72,73,0 ;CLOSED DOOR
 DB 20,21,0

 DB 127,29,30,0 ;LOCKED DOOR
 DB 4,0

 DB 0           ;END OF TABLE

;
; DEFINE OVERLAYS AND SCREENS
;

;******************************
;
; GRAPHIC SCREEN PNTR TABLE
;
;******************************

SCRTAB EQU $
 DW SCRBLU,SCRBLK,SCRWHT
 DW SCRRED,SCR001,SCR002
 DW SCR003,SCR004,SCR005

;******************************
;
; GRAPHIC OBJECT PNTR TABLE
;
;******************************

SCROBJ EQU $
 DEFOVL OVL001,55,1     ;001
 DEFOVL OVL002,74,1     ;002
 DEFOVL OVL003,1,13     ;003
 DEFOVL OVL004,1,113    ;004
 DEFOVL OVL005,1,17     ;005
 DEFOVL OVL006,1,45     ;006
 DEFOVL OVL007,1,49     ;007
 DEFOVL OVL008,1,81     ;008
 DEFOVL OVL009,1,85     ;009
 DEFOVL OVL010,48,17    ;010
 DEFOVL OVL011,69,17    ;011
 DEFOVL OVL012,54,17    ;012
 DEFOVL OVL013,51,85    ;013
 DEFOVL OVL014,41,13    ;014
 DEFOVL OVL015,41,101   ;015
 DEFOVL OVL016,78,45    ;016
 DEFOVL OVL017,53,45    ;017
 DEFOVL OVL018,53,77    ;018
 DEFOVL OVL019,75,53    ;019
 DEFOVL OVL020,2,45     ;020
 DEFOVL OVL021,13,57    ;021
 DEFOVL OVL022,14,57    ;022
 DEFOVL OVL023,14,69    ;023
 DEFOVL OVL024,52,57    ;024
 DEFOVL OVL025,61,61    ;025
 DEFOVL OVL026,61,65    ;026
 DEFOVL OVL027,2,41     ;027
 DEFOVL OVL028,2,85     ;028
 DEFOVL OVL029,51,61    ;029
 DEFOVL OVL030,51,65    ;030
 DEFOVL OVL031,51,61    ;031
 DEFOVL OVL032,51,65    ;032
 DEFOVL OVL037,27,73    ;033
 DEFOVL OVL034,2,45     ;034
 DEFOVL OVL035,2,45     ;035
 DEFOVL OVL036,2,81     ;036
 DEFOVL OVL037,27,49    ;037
 DEFOVL OVL038,39,57    ;038
 DEFOVL OVL039,48,57    ;039
 DEFOVL OVL040,2,97     ;040
 DEFOVL OVL041,52,57    ;041
 DEFOVL OVL042,34,69    ;042
 DEFOVL OVL043,22,21    ;043
 DEFOVL OVL043,22,117   ;044
 DEFOVL OVL045,20,55    ;045
 DEFOVL OVL046,20,55    ;046
 DEFOVL OVL047,29,29    ;047
 DEFOVL OVL048,2,57     ;048
 DEFOVL OVL049,23,65    ;049
 DEFOVL OVL050,13,21    ;050
 DEFOVL OVL054,13,117   ;051
 DEFOVL OVL052,13,21    ;052
 DEFOVL OVL050,13,117   ;053
 DEFOVL OVL054,13,21    ;054
 DEFOVL OVL052,13,117   ;055
 DEFOVL OVL056,74,5     ;056
 DEFOVL OVL057,74,121   ;057
 DEFOVL OVL058,29,1     ;058
 DEFOVL OVL059,84,17    ;059
 DEFOVL OVL060,31,29    ;060
 DEFOVL OVL061,31,33    ;061
 DEFOVL OVL062,56,97    ;062
 DEFOVL OVL063,31,29    ;063
 DEFOVL OVL064,31,33    ;064
 DEFOVL OVL065,51,101   ;065
 DEFOVL OVL066,80,109   ;066
 DEFOVL OVL067,81,97    ;067
 DEFOVL OVL068,1,37     ;068
 DEFOVL OVL069,1,85     ;069
 DEFOVL OVL070,1,41     ;070
 DEFOVL OVL071,74,25    ;071
 DEFOVL OVL072,19,57    ;072
 DEFOVL OVL073,19,61    ;073
 DEFOVL OVL074,44,81    ;074
 DEFOVL OVL075,19,57    ;075
 DEFOVL OVL076,19,61    ;076
 DEFOVL OVL077,1,113    ;077
 DEFOVL OVL078,72,1     ;078
 DEFOVL OVL079,1,61     ;079
 DEFOVL OVL080,14,53    ;080
 DEFOVL OVL081,22,93    ;081
 DEFOVL OVL082,47,13    ;082
 DEFOVL OVL083,61,17    ;083
 DEFOVL OVL084,61,81    ;084
 DEFOVL OVL085,61,85    ;085
 DEFOVL OVL086,64,21    ;086
 DEFOVL OVL087,61,49    ;087
 DEFOVL OVL088,49,29    ;088
 DEFOVL OVL089,42,37    ;089
 DEFOVL OVL090,48,49    ;090
 DEFOVL OVL091,48,61    ;091
 DEFOVL OVL092,1,9      ;092
 DEFOVL OVL093,1,1      ;093
 DEFOVL OVL094,1,121    ;094
 DEFOVL OVL095,13,9     ;095
 DEFOVL OVL096,13,117   ;096
 DEFOVL OVL097,13,13    ;097
 DEFOVL OVL098,15,9     ;098
 DEFOVL OVL099,17,9     ;099
 DEFOVL OVL100,17,25    ;100
 DEFOVL OVL100,17,41    ;101
 DEFOVL OVL100,17,57    ;102
 DEFOVL OVL100,17,73    ;103
 DEFOVL OVL100,17,89    ;104
 DEFOVL OVL100,17,105   ;105
 DEFOVL OVL106,17,117   ;106
 DEFOVL OVL107,41,9     ;107
 DEFOVL OVL098,45,9     ;108
 DEFOVL OVL107,51,9     ;109
 DEFOVL OVL110,18,1     ;110
 DEFOVL OVL111,18,125   ;111
 DEFOVL OVL112,62,1     ;112
 DEFOVL OVL113,55,33    ;113
 DEFOVL OVL114,55,93    ;114
 DEFOVL OVL115,36,29    ;115
 DEFOVL OVL116,41,29    ;116
 DEFOVL OVL117,26,93    ;117
 DEFOVL OVL118,42,29    ;118
 DEFOVL OVL119,46,33    ;119
 DEFOVL OVL119,46,61    ;120
 DEFOVL OVL121,21,77    ;121
 DEFOVL OVL122,21,81    ;122
 DEFOVL OVL123,39,81    ;123
 DEFOVL OVL124,31,89    ;124
 DEFOVL OVL125,57,17    ;125
 DEFOVL OVL126,37,49    ;126
 DEFOVL OVL127,19,33    ;127
 DEFOVL OVL128,24,29    ;128
 DEFOVL OVL218,54,61    ;129
 DEFOVL OVL220,64,17    ;130
 DEFOVL OVL131,10,73    ;131
 DEFOVL OVL132,10,77    ;132
 DEFOVL OVL133,37,29    ;133
 DEFOVL OVL134,37,41    ;134
 DEFOVL OVL135,37,33    ;135
 DEFOVL OVL136,46,45    ;136
 DEFOVL OVL137,13,77    ;137
 DEFOVL OVL137,27,77    ;138
 DEFOVL OVL137,41,77    ;139
 DEFOVL OVL140,61,1     ;140
 DEFOVL OVL141,56,9     ;141
 DEFOVL OVL141,56,37    ;142
 DEFOVL OVL141,56,65    ;143
 DEFOVL OVL141,56,93    ;144
 DEFOVL OVL141,56,121   ;145
 DEFOVL OVL146,7,13     ;146
 DEFOVL OVL146,7,65     ;147
 DEFOVL OVL148,7,57     ;148
 DEFOVL OVL148,7,109    ;149
 DEFOVL OVL150,7,17     ;150
 DEFOVL OVL150,7,69     ;151
 DEFOVL OVL152,20,25    ;152
 DEFOVL OVL153,36,81    ;153
 DEFOVL OVL154,63,77    ;154
 DEFOVL OVL155,68,57    ;155
 DEFOVL OVL156,58,41    ;156
 DEFOVL OVL157,54,57    ;157
 DEFOVL OVL158,66,33    ;158
 DEFOVL OVL159,49,121   ;159
 DEFOVL OVL160,45,77    ;160
 DEFOVL OVL161,48,81    ;161
 DEFOVL OVL162,40,21    ;162
 DEFOVL OVL163,44,25    ;163
 DEFOVL OVL164,68,13    ;164
 DEFOVL OVL165,66,49    ;165
 DEFOVL OVL166,59,53    ;166
 DEFOVL OVL167,13,25    ;167
 DEFOVL OVL168,21,29    ;168
 DEFOVL OVL169,70,21    ;169
 DEFOVL OVL170,46,49    ;170
 DEFOVL OVL171,46,53    ;171
 DEFOVL OVL172,29,77    ;172
 DEFOVL OVL173,29,81    ;173
 DEFOVL OVL174,38,85    ;174
 DEFOVL OVL175,21,49    ;175
 DEFOVL OVL176,21,1     ;176
 DEFOVL OVL177,21,5     ;177
 DEFOVL OVL178,14,57    ;178
 DEFOVL OVL179,14,73    ;179
 DEFOVL OVL180,14,61    ;180
 DEFOVL OVL181,45,45    ;181
 DEFOVL OVL182,60,45    ;182
 DEFOVL OVL183,60,49    ;183
 DEFOVL OVL184,60,85    ;184
 DEFOVL OVL185,61,89    ;185
 DEFOVL OVL186,14,53    ;186
 DEFOVL OVL187,14,57    ;187
 DEFOVL OVL188,1,1      ;188
 DEFOVL OVL189,12,5     ;189
 DEFOVL OVL190,1,9      ;190
 DEFOVL OVL191,11,61    ;191
 DEFOVL OVL192,17,121   ;192
 DEFOVL OVL193,15,125   ;193
 DEFOVL OVL194,16,61    ;194
 DEFOVL OVL191,47,5     ;195
 DEFOVL OVL194,54,5     ;196
 DEFOVL OVL197,1,1      ;197
 DEFOVL OVL198,1,113    ;198
 DEFOVL OVL199,37,45    ;199
 DEFOVL OVL200,72,77    ;200
 DEFOVL OVL201,1,1      ;201
 DEFOVL OVL202,1,113    ;202
 DEFOVL OVL203,1,41     ;203
 DEFOVL OVL204,1,49     ;204
 DEFOVL OVL205,14,45    ;205
 DEFOVL OVL203,1,77     ;206
 DEFOVL OVL204,1,85     ;207
 DEFOVL OVL208,1,81     ;208
 DEFOVL OVL209,9,17     ;209
 DEFOVL OVL210,20,17    ;210
 DEFOVL OVL209,31,17    ;211
 DEFOVL OVL210,9,53     ;212
 DEFOVL OVL209,20,53    ;213
 DEFOVL OVL210,31,53    ;214
 DEFOVL OVL209,9,89     ;215
 DEFOVL OVL210,20,89    ;216
 DEFOVL OVL209,31,89    ;217
 DEFOVL OVL218,54,73    ;218
 DEFOVL OVL219,55,29    ;219
 DEFOVL OVL220,64,29    ;220
 DEFOVL OVL221,49,29    ;221
 DEFOVL OVL222,59,33    ;222
 DEFOVL OVL223,70,61    ;223
 DEFOVL OVL224,42,97    ;224
 DEFOVL OVL225,67,1     ;225
 DEFOVL OVL226,18,65    ;226
 DEFOVL OVL227,5,45     ;227
 DEFOVL OVL203,1,97     ;228
 DEFOVL OVL204,1,105    ;229
 DEFOVL OVL227,5,101    ;230
 DEFOVL OVL209,9,9      ;231
 DEFOVL OVL210,20,9     ;232
 DEFOVL OVL209,31,9     ;233
 DEFOVL OVL210,42,9     ;234
 DEFOVL OVL209,53,9     ;235
 DEFOVL OVL209,10,65    ;236
 DEFOVL OVL237,10,85    ;237
 DEFOVL OVL238,70,61    ;238
 DEFOVL OVL221,49,17    ;239
 DEFOVL OVL227,5,81     ;240
 DEFOVL OVL241,67,1     ;241
 DEFOVL OVL242,46,5     ;242
 DEFOVL OVL243,52,9     ;243
 DEFOVL OVL244,52,61    ;244
 DEFOVL OVL245,54,89    ;245
 DEFOVL OVL246,54,85    ;246
 DEFOVL OVL247,61,89    ;247
 DEFOVL OVL248,54,9     ;248
 DEFOVL OVL249,54,13    ;249
 DEFOVL OVL250,54,21    ;250
 DEFOVL OVL248,54,41    ;251
 DEFOVL OVL249,54,45    ;252
 DEFOVL OVL250,54,53    ;253
 DEFOVL OVL248,65,93    ;254

SCROB2 EQU $
 DEFOVL OVL249,65,97    ;255
 DEFOVL OVL250,65,105   ;256
 DEFOVL OVL257,40,21    ;257
 DEFOVL OVL258,32,41    ;258
 DEFOVL OVL259,40,45    ;259
 DEFOVL OVL260,44,53    ;260
 DEFOVL OVL261,34,57    ;261
 DEFOVL OVL262,1,53     ;262
 DEFOVL OVL263,2,57     ;263
 DEFOVL OVL264,8,33     ;264
 DEFOVL OVL265,8,37     ;265
 DEFOVL OVL266,45,89    ;266
 DEFOVL OVL267,34,93    ;267
 DEFOVL OVL268,39,109   ;268
 DEFOVL OVL269,39,113   ;269
 DEFOVL OVL270,31,97    ;270
 DEFOVL OVL271,31,97    ;271
 DEFOVL OVL272,31,97    ;272
 DEFOVL OVL273,13,57    ;273
 DEFOVL OVL274,13,57    ;274
 DEFOVL OVL275,13,57    ;275
 DEFOVL OVL276,13,57    ;276
 DEFOVL OVL277,11,33    ;277
 DEFOVL OVL278,11,33    ;278
 DEFOVL OVL279,11,33    ;279
 DEFOVL OVL280,43,41    ;280
 DEFOVL OVL281,26,45    ;281
 DEFOVL OVL282,25,49    ;282
 DEFOVL OVL283,39,53    ;283
 DEFOVL OVL284,57,73    ;284
 DEFOVL OVL285,26,77    ;285
 DEFOVL OVL286,30,85    ;286
 DEFOVL OVL287,47,93    ;287
 DEFOVL OVL288,46,97    ;288
 DEFOVL OVL289,48,101   ;289
 DEFOVL OVL290,52,105   ;290
 DEFOVL OVL291,20,21    ;291
 DEFOVL OVL292,20,25    ;292
 DEFOVL OVL293,20,33    ;293
 DEFOVL OVL294,12,45    ;294
 DEFOVL OVL295,12,49    ;295
 DEFOVL OVL296,12,73    ;296
 DEFOVL OVL297,10,89    ;297
 DEFOVL OVL298,10,93    ;298
 DEFOVL OVL299,10,101   ;299
 DEFOVL OVL300,77,65    ;300
 DEFOVL OVL301,46,101   ;301
 DEFOVL OVL302,43,105   ;302
 DEFOVL OVL303,46,109   ;303
 DEFOVL OVL304,52,113   ;304
 DEFOVL OVL305,51,93    ;305
 DEFOVL OVL306,51,93    ;306
 DEFOVL OVL307,46,105   ;307
 DEFOVL OVL308,46,105   ;308
 DEFOVL OVL309,77,105   ;309
 DEFOVL OVL310,13,17    ;310
 DEFOVL OVL045,13,25    ;311
 DEFOVL OVL046,13,25    ;312
 DEFOVL OVL047,13,25    ;313
 DEFOVL OVL314,73,113   ;314
 DEFOVL OVL315,68,93    ;315
 DEFOVL OVL316,55,45    ;316
 DEFOVL OVL317,47,45    ;317
 DEFOVL OVL318,72,61    ;318
 DEFOVL OVL319,66,65    ;319
 DEFOVL OVL320,81,49    ;320
 DEFOVL OVL321,81,53    ;321
 DEFOVL OVL322,61,93    ;322
 DEFOVL OVL323,73,117   ;323
 DEFOVL OVL324,72,81    ;324
 DEFOVL OVL325,71,81    ;325
 DEFOVL OVL326,81,53    ;326
 DEFOVL OVL327,75,85    ;327
 DEFOVL OVL328,46,13    ;328
 DEFOVL OVL329,72,13    ;329

;
;        END FILE: ADVDATA2.ASM  -  THE VORTEX FACTOR
;
