;
;        FILE: ADVCODE2.ASM   --   VORTEX FACTOR
;

; LOOK BOOKCASE

LOOK01   PROC
         MOV   AL,120        ;BOOKCASE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,36+INV     ;PINK CART
         CALL  MAKVIS
         JNE   LOOK01_A
         MOV   AL,13+INV     ;RED CART
         CALL  MAKVIS
         LBEQ  LOOKOB
LOOK01_A:
         CALL  CKDRAW
         JMP   IFOUND
LOOK01   ENDP

; LOOK DESK

LOOK02   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,124        ;CLOSED DESK
         JE    LOOK02_A
         MOV   AL,16+INV     ;YELLOW CART
         CALL  MAKVIS
         JNE   LOOK02_B
         MOV   AL,14+INV     ;KEY
         CALL  MAKVIS
         JNE   LOOK02_B
         MOV   AL,20+INV     ;BIRTH CERT
         CALL  MAKVIS
         JNE   LOOK02_B
LOOK02_A:
         JMP   LOOKOB
LOOK02_B:
         CALL  CKDRAW
         JMP   IFOUND
LOOK02   ENDP

; LOOK TIME MACH SLOT

LOOK03   PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,SLOTSW
         CMP   AL,0
         LBEQ  LOOKOB
         MOV   BX,OFFSET MSG36
         CALL  DISPLY
         CALL  OBDESC
         MOV   AL,'.'
         CALL  CHROUT
         JMP   REPLY
LOOK03   ENDP

; LOOK AT CARTRIDGES

LOOK04   PROC
         MOV   AL,119        ;TIME MACH SLOT
         CALL  CKOBJ
         JE    LOOK04_A
         MOV   AL,NOUNNO
         CMP   AL,SLOTSW
         LBEQ  DMSG012
LOOK04_A:
         JMP   LOOKOB
LOOK04   ENDP

; LOOK SAFE

LOOK05   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,114        ;LOCKED SAFE
         JE    LOOK05_A
         MOV   AL,9+INV      ;BLUE CART
         CALL  MAKVIS
         JNE   LOOK05_B
LOOK05_A:
         JMP   LOOKOB
LOOK05_B:
         CALL  CKDRAW
         JMP   IFOUND
LOOK05   ENDP

; LOOK GAUGE

LOOK06   PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         TEST  SLOTSW,0FFH
         LBEQ  DMSG012
         MOV   AL,94         ;CHARGED BATTERY
         CALL  CKOBJ
         JNE   LOOK06_C
         MOV   AL,67
         JMP   SHORT LOOK06_Z
LOOK06_C:
         MOV   AL,ROOM
         CMP   AL,38
         JNE   LOOK06_A
         MOV   AL,46
         JMP   SHORT LOOK06_Z
LOOK06_A:
         CMP   AL,34
         JNE   LOOK06_B
         MOV   AL,45
         JMP   SHORT LOOK06_Z
LOOK06_B:
         CMP   AL,16
         JNE   LOOK06_D
         MOV   AL,70
         JMP   SHORT LOOK06_Z
LOOK06_D:
         CMP   AL,49
         JNE   LOOK06_E
         MOV   AL,82
         JMP   SHORT LOOK06_Z
LOOK06_E:
         MOV   AL,44
LOOK06_Z:
         JMP   DMSGXX
LOOK06   ENDP

; LOOK DOOR

LOOK07   PROC
         MOV   AL,ROOM
         CMP   AL,2
         JE    LOOK07_A
         CMP   AL,3
         JE    LOOK07_A
         CMP   AL,24
         LBNE  LOOKOB
LOOK07_A:
         JMP   DMSG012
LOOK07   ENDP

; LOOK DIAL

LOOK08   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG040
LOOK08   ENDP

; LOOK COUNTER/WORKBENCH/MAE WEST/MUMMY

LOOK09   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    LOOK09_A
         MOV   AL,21+INV     ;NOTEBOOK
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,28+INV     ;VIAL
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,23+INV     ;SACK LUNCH
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,29+INV     ;HACKSAW
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,30+INV     ;HAIR PIN
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,50+INV     ;RUBY NECKLACE
         CALL  MAKVIS
         JNE   LOOK09_B
         MOV   AL,51+INV     ;PLATINUM BRACLET
         CALL  MAKVIS
         JNE   LOOK09_B
LOOK09_A:
         JMP   LOOKOB
LOOK09_B:
         CALL  CKDRAW
         JMP   IFOUND
LOOK09   ENDP

; LOOK NOTEBOOK

LOOK10   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,22         ;OPEN NOTEBOOK
         JNE   LOOK10_B
         CALL  HAVOBJ
         JE    LOOK10_B
         MOV   AL,53
         TEST  NOTEPG,0FFH
         JE    LOOK10_A
         INC   AL
LOOK10_A:
         JMP   DMSGXX
LOOK10_B:
         JMP   LOOKOB
LOOK10   ENDP

; LOOK PAGE

LOOK11   PROC
         MOV   AL,22
         CALL  HAVOBJ
         LBEQ  NOSEE
         MOV   NOUNNO,AL
         JMP   SHORT LOOK10
LOOK11   ENDP

; LOOK SACK

LOOK12   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         JE    LOOK12_C
         MOV   AH,AL
         CMP   AL,25         ;EMPTY SACK
         JE    LOOK12_C
         INC   AH
         CALL  REPOBJ
         CMP   AL,23
         JNE   LOOK12_A
         MOV   AL,26         ;SANDWICH
         JMP   SHORT LOOK12_B
LOOK12_A:
         MOV   AL,27         ;LIME
LOOK12_B:
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   IFOUND
LOOK12_C:
         JMP   LOOKOB
LOOK12   ENDP

; LOOK CHEST

LOOK13   PROC
         MOV   AL,105        ;OPEN CHEST
         CALL  CKOBJ
         LBEQ  LOOKOB
         MOV   AL,31+INV     ;SCEPTER
         CALL  MAKVIS
         LBEQ  DMSG022
         CALL  CKDRAW
         JMP   IFOUND
LOOK13   ENDP

; LOOK TORCH

LOOK14   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,101        ;TURNED TORCH
         JE    LOOK14_A
         MOV   AL,ROOM
         CMP   AL,37
         JNE   LOOK14_A
         MOV   BX,OFFSET MSG58
         JMP   SHORT LOOK14_B
LOOK14_A:
         MOV   BX,OFFSET MSG59
LOOK14_B:
         CALL  DISPLY
         JMP   REPLY
LOOK14   ENDP

; LOOK SKELETON

LOOK15   PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,47+INV     ;SPOON
         CALL  MAKVIS
         JNE   LOOK15_A
         MOV   AL,43+INV     ;STRING
         CALL  MAKVIS
         JNE   LOOK15_A
         MOV   AL,52+INV     ;BRASS RING
         CALL  MAKVIS
         LBEQ  LOOKOB
LOOK15_A:
         CALL  CKDRAW
         JMP   IFOUND
LOOK15   ENDP

;   ** GET SPECIAL PROCS **

; GET CALENDAR

GET01    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GET01_A
         CMP   AL,8
         JNE   GET01_A
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         JAE   GET01_A
         MOV   AL,8          ;CAL ON WALL
         MOV   AH,15         ;CALENDAR
         CALL  CHGOBJ
         MOV   AL,114+INV    ;LOCKED SAFE
         CALL  MAKVIS
         CALL  CKDRAW
         MOV   BX,OFFSET MSG34
         CALL  DISPLY
GET01_A:
         JMP   VGET
GET01    ENDP

; GET CARTRIDGES

GET02    PROC
         MOV   AL,119        ;TIME MACH SLOT
         CALL  CKOBJ
         JE    GET02_A
         MOV   AL,NOUNNO
         CMP   AL,SLOTSW
         JNE   GET02_A
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         LBHS  DMSG009
         MOV   AL,SLOTSW
         CALL  PUTNRM
         MOV   SLOTSW,0
GET02_A:
         JMP   VGET
GET02    ENDP

; GET LEVER

GET03    PROC
         MOV   AL,89         ;SARC
         MOV   NOUNNO,AL
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,83
         JE    GET03_A
         CMP   AL,84
         LBNE  NOSEE
GET03_A:
         JMP   DMSG021
GET03    ENDP

; ** PUT SPECIAL PROC ROUTINES **

; PUT SUIT

PUT01    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         JE    PUT01_A
         CMP   AL,40         ;WEARING SUIT
         LBEQ  DMSG014
PUT01_A:
         JMP   VPUT
PUT01    ENDP

; ** GO SPECIAL PROC ROUTINES **

; GO TIME MACHINE

GO01     PROC
         MOV   AL,117        ;TIME MACH GAUGE
         CALL  CKOBJ
         LBNE  DMSG014
         MOV   AL,121        ;TIME MACH
         CALL  CKOBJ
         LBEQ  NOSEE
;
;   PROTECTION STARTS HERE
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         LBNE  DMSG023
;
;   PROTECTION ENDS HERE
;
         MOV   AL,ROOM
         INC   AL
         JMP   EXITRM
GO01     ENDP

; GO DEVICE

GO02     PROC
         MOV   AL,ROOM
         CMP   AL,9
         JE    GO02_A
         CMP   AL,31
         JE    GO02_A
         MOV   AL,122        ;DEVICE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,112        ;SAFE SIGN
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,ROOM
         DEC   AL
         JMP   EXITRM
GO02_A:
         JMP   DMSG014
GO02     ENDP

;  GO OUT

GO03     PROC
         MOV   AL,117        ;TIME MACH GAUGE
         CALL  CKOBJ
         JE    GO03_C
         MOV   AL,ROOM
         DEC   AL
GO03_A:
         JMP   EXITRM
GO03_B:
         INC   AL
         JMP   SHORT GO03_A
GO03_C:
         MOV   AL,ROOM
         CMP   AL,9
         JE    GO03_B
         CMP   AL,31
         JE    GO03_B
         JMP   DMSG023
GO03     ENDP

; GO DOOR

GO04     PROC
         MOV   AL,ROOM
         CMP   AL,2
         JE    GO04_E
         CMP   AL,3
         JE    GO04_E
         CMP   AL,24
         JE    GO04_E
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,127
         LBEQ  DMSG017
         CMP   AL,126        ;CLOSED DOOR
         LBEQ  DMSG016
         MOV   AL,ROOM
         CMP   AL,4
         JNE   GO04_A
         MOV   AL,20
         JMP   SHORT GO04_D
GO04_A:
         CMP   AL,20
         JNE   GO04_B
         MOV   AL,4
         JMP   SHORT GO04_D
GO04_B:
         CMP   AL,21
         JNE   GO04_C
         MOV   AL,22
         JMP   SHORT GO04_D
GO04_C:
         MOV   AL,21
GO04_D:
         JMP   EXITRM
GO04_E:
         JMP   DMSG023
GO04     ENDP

; GO HOLE IN WALL

GO05     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         CMP   AL,51
         JE    GO05_C
         CMP   AL,53
         JE    GO05_D
         CMP   AL,37
         JE    GO05_A
         MOV   AL,37
         JMP   SHORT GO05_B
GO05_A:
         MOV   AL,46
GO05_B:
         JMP   EXITRM
GO05_C:
         MOV   AL,53
         JMP   SHORT GO05_B
GO05_D:
         MOV   AL,51
         JMP   SHORT GO05_B
GO05     ENDP

; GO WINDOW

GO06     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,108
         LBEQ  DMSG057
         MOV   AL,ROOM
         XOR   AL,3
         JMP   EXITRM
GO06     ENDP

; GO SECRET PASSAGE

GO07     PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         CMP   AL,51
         JNE   GO07_A
         INC   AL
         INC   AL
GO07_A:
         DEC   AL
         JMP   EXITRM
GO07     ENDP

; OPEN DOOR

OPEN01   PROC
         MOV   AL,ROOM
         CMP   AL,2
         JE    OPEN01_A
         CMP   AL,3
         JE    OPEN01_A
         CMP   AL,24
         JE    OPEN01_A
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,127        ;LOCKED DOOR
         LBEQ  DMSG017
         MOV   AH,125        ;OPEN DOOR
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG018
OPEN01_A:
         JMP   DMSG023
OPEN01   ENDP

; OPEN DESK

OPEN02   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,123        ;OPEN DESK
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         JMP   DMSG018
OPEN02   ENDP

; OPEN NOTEBOOK

OPEN03   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,22
         CALL  REPOBJ
         MOV   NOTEPG,0
         JMP   DMSG018
OPEN03   ENDP

; OPEN SARCOPHAGUS

OPEN04   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,89         ;CLOSED SARC
         LBNE  LOOKOB
         MOV   AH,88         ;OPEN SARC
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   AL,87         ;MUMMY
         CALL  PUTNRM
         JMP   IFOUND
OPEN04   ENDP

; OPEN IRON GATE

OPEN05  PROC
        MOV    AL,NOUNNO
        CALL   CKOBJ
        LBEQ   NOSEE
        JMP    DMSG020
OPEN05  ENDP

; CLOSE DOOR

CLOS01   PROC
         MOV   AL,ROOM
         CMP   AL,2
         JE    CLOS01_B
         CMP   AL,3
         JE    CLOS01_B
         CMP   AL,24
         JE    CLOS01_B
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,125        ;OPEN DOOR
         JNE   CLOS01_A
         MOV   AH,126        ;CLOSED DOOR
         CALL  CHGOBJ
         CALL  CKDRAW
CLOS01_A:
         JMP   DMSG016
CLOS01_B:
         JMP   DMSG023
CLOS01   ENDP

; CLOSE DESK

CLOS02   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,124        ;CLOSED DESK
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG016
CLOS02   ENDP

; CLOSE NOTEBOOK

CLOS03   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,21
         CALL  REPOBJ
         JMP   DMSG016
CLOS03   ENDP

; UNLOCK DOOR

UNLK01   PROC
         MOV   AL,ROOM
         CMP   AL,2
         JE    UNLK01_B
         CMP   AL,3
         JE    UNLK01_B
         CMP   AL,24
         JE    UNLK01_B
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,126        ;UNLOCKED DOOR
         JE    UNLK01_A
         CMP   AL,127        ;LOCKED DOOR
         JNE   UNLK01_B
         PUSH  AX
         MOV   AL,14         ;KEY
         CALL  HAVOBJ
         POP   AX
         JE    UNLK01_B
         MOV   AH,ROOM
         CMP   AH,4
         LBNE  DMSG021
         MOV   AH,126        ;UNLOCKED DOOR
         CALL  CHGOBJ
;
;    PROTECTION STARTS HERE
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         JE    UNLK01_A
         MOV   AL,23+INV     ;SACK
         XOR   AH,AH
         CALL  XCHGOB
;
;    PROTECTION ENDS HERE
;
UNLK01_A:
         JMP   DMSG019
UNLK01_B:
         JMP   DMSG023
UNLK01   ENDP

; INSERT VERB PROC

VINSRT   PROC
         MOV   AL,NOUNNO
         CMP   AL,125        ;CART
         LBEQ  DMSG037
         CMP   AL,9          ;BLUE CART
         JE    VINSRT_A
         CMP   AL,13         ;RED CART
         JE    VINSRT_A
         CMP   AL,16         ;YELLOW CART
         JE    VINSRT_A
         CMP   AL,36         ;PINK CART
         JE    VINSRT_A
         CMP   AL,39         ;WHITE CART
         JE    VINSRT_A
         JMP   BADINP
VINSRT_A:
         CALL  HAVOBJ
         LBEQ  NOHAVE
         TEST  SLOTSW,0FFH
         JNE   VINSRT_B
         MOV   AL,119        ;TIME MACH SLOT
         CALL  CKOBJ
         JNE   VINSRT_C
VINSRT_B:
         JMP   DMSG023
VINSRT_C:
         MOV   AL,NOUNNO
         MOV   SLOTSW,AL
         XOR   AH,AH
         CALL  REPOBJ
         JMP   REPLY
VINSRT   ENDP

; PUSH VERB PROC

VPUSH    PROC
         MOV   AL,NOUNNO
         CMP   AL,118        ;BUTTON
         LBNE  BADINP
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,119          ;TIME MACH SLOT
         CALL  CKOBJ
         JNE   VPUSH_C
         MOV   AL,ROOM
         CMP   AL,20
         JE    VPUSH_G
         CMP   AL,21
         JE    VPUSH_G
         MOV   AL,112        ;SAFE SIGN
         CALL  CKOBJ
         JNE   VPUSH_A
         MOV   AL,111        ;UNSAFE SIGN
         MOV   AH,112        ;SAFE SIGN
         JMP   SHORT VPUSH_B
VPUSH_A:
         MOV   AH,111        ;UNSAFE SIGN
VPUSH_B:
         CALL  CHGOBJ
VPUSH_E:
         JMP   REPLY
VPUSH_H:
         JMP   DMSG043
VPUSH_C:
         MOV   AL,94         ;CHARGED BATTERY
         CALL  CKOBJ
         JE    VPUSH_H
         MOV   AL,SLOTSW
         CMP   AL,0
         JE    VPUSH_H
         MOV   BX,OFFSET TIMTAB
VPUSH_D:
         TEST  BYTE PTR [BX],0FFH
         JE    VPUSH_E
         ADD   BX,2
         CMP   AL,[BX-2]
         JNE   VPUSH_D
         MOV   AH,[BX-1]
         CMP   AH,ROOM
         JE    VPUSH_E
         MOV   AL,ROOM
         CMP   AL,34
         JNE   VPUSH_F
         CALL  CHKDEV
VPUSH_F:
         CALL  XFROBJ
         MOV   ROOM,AH
         JMP   SHORT VPUSH_E
VPUSH_G:
         MOV   AL,125        ;OPEN DOOR
         CALL  CKOBJ
         JNE   VPUSH_E
         MOV   AL,ROOM
         MOV   AH,AL
         XOR   AH,1
         CALL  XFROBJ
         MOV   ROOM,AH
         JMP   VPUSH_E
VPUSH    ENDP

; CHECK DEVICE FOR COAL

CHKDEV   PROC
         PUSH  AX
         DISABLE
         MOV   AL,ROOM
         PUSH  AX
         MOV   ROOM,31       ;1967 DEVICE
         MOV   AL,11         ;COAL
         CALL  CKOBJ
         JE    CHKDEV_A
         INC   ROOM
         MOV   AL,111        ;PRESSURE SIGN
         CALL  CKOBJ
         JE    CHKDEV_A
         DEC   ROOM
         MOV   AL,11         ;COAL
         CALL  GETOBJ
         MOV   ROOM,9        ;2063 DEVICE
         MOV   AL,32         ;DIAMOND
         CALL  PUTNRM
         INC   ROOM
         MOV   AL,112        ;ALL CLEAR SIGN
         MOV   AH,111        ;PRESSURE SIGN
         CALL  CHGOBJ
CHKDEV_A:
         POP   AX
         MOV   ROOM,AL
         ENABLE
         POP   AX
         RET
CHKDEV   ENDP

; EAT VERB PROC

VEAT     PROC
         MOV   AH,NOUNNO
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,40         ;WEARING SUIT
         LBEQ  DMSG014
         CMP   AH,27         ;LIME
         JE    VEAT_A
         CMP   AH,26
         LBNE  DMSG026
VEAT_A:
         XOR   AH,AH
         CALL  REPOBJ
         JMP   REPLY
VEAT     ENDP

; DIG VERB PROC

VDIG     PROC
         MOV   AL,12         ;SHOVEL
         CALL  HAVOBJ
         LBEQ  DMSG023
         MOV   AL,91         ;OCEAN WATER
         CALL  CKOBJ
         LBEQ  DMSG026
         JMP   REPLY
VDIG     ENDP

; GIVE VERB PROC

VGIVE    PROC
         MOV   AL,92         ;MUTANT
         CALL  CKOBJ
         LBEQ  DMSG023
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         XOR   AH,AH
         CMP   AL,26         ;SANDWICH
         JNE   VGIVE_A
         MOV   AH,39         ;WHITE CART
         PUSH  AX
         MOV   BX,OFFSET MSG73
         CALL  DISPLY
         MOV   AL,92
         XOR   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         POP   AX
VGIVE_A:
         CALL  REPOBJ
         JMP   REPLY
VGIVE    ENDP

; GIVE RING

GIVE01   PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,87         ;MUMMY
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   BX,OFFSET MSG90
         CALL  DISPLY
         MOV   AH,82         ;PASSAGE
         CALL  CHGOBJ
         MOV   AL,88         ;OPEN SARC
         MOV   AH,84         ;ENPTY SARC
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   AL,NOUNNO
         XOR   AH,AH
         CALL  REPOBJ
         MOV   AL,89
         JMP   DMSGXX
GIVE01   ENDP

; WEAR SUIT

WEAR01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,40
         CALL  REPOBJ
         JMP   DMSG014
WEAR01   ENDP

; REMOVE SUIT

REMO01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,37
         CALL  REPOBJ
         JMP   REPLY
REMO01   ENDP

; POUR VIAL/ACID/JUICE

POUR01   PROC
         MOV   AL,33         ;FULL VIAL
         CALL  HAVOBJ
         LBEQ  DMSG023
         MOV   AL,96         ;DRY BATTERY
         CALL  CKOBJ
         JE    POUR01_B
         MOV   AH,95         ;FULL BATTERY
         CALL  CHGOBJ
         MOV   AL,8          ;CHARGE COUNT
         MOV   BATTSW,AL
         MOV   BX,OFFSET MSG65
POUR01_A:
         CALL  DISPLY
         MOV   AL,33         ;FULL VIAL
         MOV   AH,28         ;EMPTY VIAL
         CALL  REPOBJ
         JMP   REPLY
POUR01_B:
         MOV   AL,93         ;PUDDLE
         CALL  PUTNRM
         MOV   BX,OFFSET MSG64
         JMP   SHORT POUR01_A
POUR01   ENDP

; MELT/HEAT WAX/BIRD

MELT01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,101
         CALL  CKOBJ
         JNE   MELT01_A
         MOV   AL,102       ;TORCHES
         CALL  CKOBJ
         LBEQ  DMSG023
MELT01_A:
         MOV   AL,46         ;BIRD
         MOV   AH,42         ;SOFT WAX
         CALL  REPOBJ
         MOV   AL,41         ;HARD WAX
         CALL  REPOBJ
         MOV   AL,6
         MOV   WAXSW,AL
         JMP   REPLY
MELT01   ENDP

; LIGHT CANDLE

LITE01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,45         ;LIT CANDLE
         JE    LITE01_B
         MOV   AL,101
         CALL  CKOBJ
         JNE   LITE01_A
         MOV   AL,102        ;TORCH
         CALL  CKOBJ
         LBEQ  DMSG026
LITE01_A:
         MOV   AL,44         ;UNLIT CANDLE
         MOV   AH,45         ;LIT CANDLE
         CALL  REPOBJ
         INC   LITESW
LITE01_B:
         JMP   DMSG028
LITE01   ENDP

; UNLIGHT CANDLE

UNLI01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,45         ;LIT CANDLE
         MOV   AH,44         ;UNLIT CANDLE
         CALL  REPOBJ
         MOV   LITESW,0
         JMP   DMSG029
UNLI01   ENDP

; MAKE CANDLE

MAKE01   PROC
         MOV   AL,42         ;SOFT WAX
         CALL  HAVOBJ
         JE    MAKE01_A
         INC   AL
         CALL  HAVOBJ
MAKE01_A:
         LBEQ  DMSG023
         MOV   AH,44         ;UNLIT CANDLE
         CALL  REPOBJ
         MOV   AL,42         ;SOFTWAX
         XOR   AH,AH
         CALL  REPOBJ
         JMP   REPLY
MAKE01   ENDP

; SQUEEZE LIME

SQU01    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,34         ;LIME HALVES
         LBNE  DMSG043
         MOV   AH,35         ;LIME PEELS
         CALL  REPOBJ
         MOV   AL,28         ;VIAL
         CALL  HAVOBJ
         JE    SQU01_A
         MOV   AH,33         ;FULL VIAL
         CALL  REPOBJ
         MOV   BX,OFFSET MSG63
         JMP   SHORT SQU01_B
SQU01_A:
         MOV   AL,93         ;PUDDLE
         CALL  PUTNRM
         MOV   BX,OFFSET MSG64
SQU01_B:
         CALL  DISPLY
         JMP   REPLY
SQU01    ENDP

; TURN 99

VTURN    PROC
         MOV   BX,OFFSET NOUN
VTURN1:
         MOV   AL,[BX+3]
         CMP   AL,' '
         JNE   VTURN_C
         MOV   AL,[BX+2]
         CMP   AL,' '
         JNE   VTURN_C
         MOV   AL,[BX+1]
         CMP   AL,' '
         JNE   VTURN_A
         MOV   AL,[BX]
         MOV   [BX+1],AL
         MOV   BYTE PTR [BX],'0'
VTURN_A:
         MOV   AL,[BX+1]
         MOV   AH,AL
         CMP   AL,'0'
         JB    VTURN_C
         CMP   AL,'9'
         JA    VTURN_C
         MOV   AL,[BX]
         CMP   AL,'0'
         JB    VTURN_C
         CMP   AL,'9'
         JA    VTURN_C
         MOV   SI,AX
         MOV   AL,114        ;LOCKED SAFE
         MOV   NOUNNO,AL
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AX,SI
         CMP   AL,'1'
         JE    VTURN_D
         CMP   AL,'2'
         JE    VTURN_E
         CMP   AL,'4'
         JE    VTURN_F
VTURN_B:
         MOV   DIALSW,0
VTURN_G:
         JMP   REPLY
VTURN_C:
         JMP   BADINP
VTURN_D:
         CMP   AH,'1'
         JNE   VTURN_B
         CMP   DIALSW,0
         JNE   VTURN_B
         INC   DIALSW
         JMP   SHORT VTURN_G
VTURN_E:
         CMP   AH,'9'
         JNE   VTURN_B
         CMP   DIALSW,1
         JNE   VTURN_B
         INC   DIALSW
         JMP   SHORT VTURN_G
VTURN_F:
         CMP   AH,'2'
         JNE   VTURN_B
         CMP   DIALSW,2
         JNE   VTURN_B
         MOV   AL,114        ;LOCKED SAFE
         CALL  CKOBJ
         JE    VTURN_B
         MOV   AH,113        ;OPEN SAFE
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG018
VTURN    ENDP

; TURN DIAL

TURN01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   BX,OFFSET MSG50
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         MOV   BX,OFFSET VERB
         JMP   VTURN1
TURN01   ENDP

; TURN/PULL.MOVE TORCH

TURN02   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,101        ;TURNED TORCH
         JE    TURN02_C
         CMP   ROOM,37
         JNE   TURN02_C
         MOV   AH,101        ;TURNED TORCH
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   AH,26
         CALCX 20,55
TURN02_A:
         PUSH  AX
         CALCD 20,55,66,80
         CALL  SCRRIT
         MOV   AL,45
         CALL  SHOOVL
         MOV   CX,2000
TURN02_B:
         LOOP  TURN02_B
         POP   AX
         DEC   AH
         JNE   TURN02_A
         MOV   AL,100        ;HOLE IN WALL
         CALL  PUTNRM
         JMP   IFOUND
TURN02_C:
         JMP   DMSG020
TURN02   ENDP

; TURN PAGE

TURN03   PROC
         MOV   AL,22         ;OPEN NOTEBOOK
         CALL  HAVOBJ
         LBEQ  DMSG023
         INC   NOTEPG
         CMP   NOTEPG,1
         JE    TURN03_A
         MOV   NOTEPG,0
TURN03_A:
         JMP   REPLY
TURN03   ENDP

; TURN/PULL/MOVE LEVER

TURN04   PROC
         MOV   NOUNNO,89     ;SARC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,83
         JE    TURN04_A
         CMP   AL,84
         JE    TURN04_B
         JMP   NOSEE
TURN04_A:
         MOV   AH,84         ;SARC
         CALL  CHGOBJ
         MOV   AL,81         ;HOLE IN FLOOR
         XOR   AH,AH
         CALL  CHGOBJ
         MOV   AL,238        ;REMOVE HOLE
         CALL  SHOOVL
         CALCX 49,17
         CALCD 49,17,78,76
         MOV   CX,12
TURN04_D:
         CALL  SCRRIT
         LOOP  TURN04_D
         JMP   SHORT TURN04_C
TURN04_B:
         MOV   AH,83         ;SARC
         CALL  CHGOBJ
         MOV   AL,81         ;HOLE IN FLOOR
         CALL  PUTNRM
         CALCX 49,17
         CALCD 49,17,78,76
         MOV   CX,12
TURN04_E:
         CALL  SCRLFT
         LOOP  TURN04_E
         MOV   AL,223        ;HOLE IN FLOOR
         CALL  SHOOVL
TURN04_C:
         JMP   REPLY
TURN04   ENDP

; SAW WINDOW

SAW01    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,108        ;BARRED WINDOW
         LBNE  DMSG026
         MOV   AL,29         ;HACK SAW
         CALL  HAVOBJ
         LBEQ  DMSG023
         MOV   AL,108        ;BARRED WINDOW
         MOV   AH,107        ;OPEN WINDOW
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         JMP   REPLY
SAW01    ENDP

; SAW/CUT LIME

SAW02    PROC
         CALL  EQUOBJ
         MOV   AL,29         ;HACK SAW
         CALL  HAVOBJ
         JE    SAW02_A
         MOV   AL,NOUNNO
         CMP   AL,27         ;LIME
         JNE   SAW02_A
         CALL  HAVOBJ
         JE    SAW02_A
         MOV   AH,34         ;LIME HALVES
         CALL  REPOBJ
         JMP   REPLY
SAW02_A:
         JMP   DMSG023
SAW02    ENDP

; PICK LOCK

PICK01   PROC
         MOV   AL,30         ;HAIR PIN
         CALL  HAVOBJ
         JE    PICK01_A
         MOV   AL,127        ;LOCKED DOOR
         CALL  CKOBJ
         LBNE  DMSG021
         MOV   AL,106        ;LOCKED CHEST
         CALL  CKOBJ
         JE    PICK01_A
         MOV   AH,105        ;OPEN CHEST
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         MOV   AL,92
         JMP   DMSGXX
PICK01_A:
         JMP   DMSG026
PICK01   ENDP

; CHECK FOR DARK AREA ROUTINE - RETURN ZERO FLAG IF DARK

INDARK   PROC
         PUSH  BX
         PUSH  SI
         MOV   AL,ROOM
         CMP   AL,48
         JB    INDARK_A
         CMP   AL,49
         JE    INDARK_A
         MOV   AL,45         ;LIT CANDLE
         CALL  LOCOBJ
         JNE   INDARK_A
         MOV   SI,OFFSET SCRBLK
         CALL  SHOSCR
         CALL  CLSTXT
         MOV   BX,OFFSET MSG84
         CALL  DISPLY
         XOR   AL,AL
INDARK_A:
         TEST  AL,0FFH
         POP   SI
         POP   BX
         RET
INDARK   ENDP

; CHECK EACH ITEM OF A PUT ALL

CHKPA    PROC
         CMP   AL,40         ;WEARING SUIT
         JNE   CHKPA_A
         XOR   AL,AL
CHKPA_A:
         TEST  AL,0FFH
         RET
CHKPA    ENDP

; CHECK EACH ITEM OF A GET ALL

CHKGA    PROC
         CMP   AL,8          ;CALENDAR ON WALL
         JNE   CHKGA_A
         XOR   AL,AL
CHKGA_A:
         TEST  AL,0FFH
         RET
CHKGA    ENDP

; ROUTINE PERFORMED FOR EACH VALID MOVE

ECHMOV   PROC
         PUSH  AX
         PUSH  BX
         PUSH  CX
         PUSH  DX
         PUSH  SI
         PUSH  DI
         CALL  CKBATT
         CALL  CKHIDE
         CALL  CKRADI
         CALL  CKWAX
         CALL  CKLITE
         POP   DI
         POP   SI
         POP   DX
         POP   CX
         POP   BX
         POP   AX
         RET
ECHMOV   ENDP

; CHECK SOFT WAX

CKWAX    PROC
         TEST  WAXSW,0FFH
         JZ    CKWAX_A
         DEC   WAXSW
         JNE   CKWAX_A
         MOV   AL,42         ;SOFT WAX
         MOV   AH,41         ;HARD WAX
         CALL  XCHGOB
CKWAX_A:
         RET
CKWAX    ENDP

; CHECK CHARGED BATTERY

CKBATT   PROC
         TEST  BATTSW,0FFH
         JE    CKBATT_A
         DEC   BATTSW
         JNE   CKBATT_A
         MOV   AL,95         ;BATTERY
         MOV   AH,94         ;CHARGED BATTERY
         CALL  XCHGOB
CKBATT_A:
         RET
CKBATT   ENDP

; CHECK HIDING OBJECTS IN CASTLE

CKHIDE   PROC
         MOV   AL,ROOM
         CMP   AL,36
         JB    CKHIDE_A
         CMP   AL,46
         JA    CKHIDE_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,30
         JA    CKHIDE_A
         CALL  HIDOBJ
CKHIDE_A:
         RET
CKHIDE   ENDP

; HIDE OBJECTS IN CASTLE

HIDOBJ   PROC
         MOV   AL,ROOM
         MOV   CS:HIDOBJ_E,AL
         DISABLE
         MOV   AL,40
HIDOBJ_A:
         MOV   ROOM,AL
         CMP   AL,CS:HIDOBJ_E
         JE    HIDOBJ_D
         CALL  PNTRM1
HIDOBJ_B:
         INC   BX
         MOV   AL,[BX-1]
         CMP   AL,0
         JE    HIDOBJ_D
         CMP   AL,MXMVOB
         JA    HIDOBJ_B
         CMP   AL,17         ;SAPPHIRE
         JE    HIDOBJ_B
         CMP   AL,18         ;NUGGET
         JE    HIDOBJ_B
         CALL  GETOBJ
         MOV   ROOM,46
         CALL  PUTNRM
         MOV   BX,OFFSET MSG68
         CALL  DISPLY
         CALL  OBDESC
         MOV   BX,OFFSET MSG69
         CALL  DISPLY
HIDOBJ_C:
         MOV   AL,CS:HIDOBJ_E
         MOV   ROOM,AL
         ENABLE
         RET
HIDOBJ_D:
         MOV   AL,ROOM
         INC   AL
         CMP   AL,46
         JB    HIDOBJ_A
         JMP   SHORT HIDOBJ_C
HIDOBJ_E DB    0
HIDOBJ   ENDP

; CHECK FOR RADIATION

CKRADI   PROC
         MOV   AL,RADISW
         CMP   AL,0
         JE    CKRADI_E
         DEC   AL
         JNE   CKRADI_A
         MOV   BX,OFFSET MSG77
         JMP   DEAD2
CKRADI_A:
         MOV   RADISW,AL
         CMP   AL,20
         JNE   CKRADI_B
         MOV   BX,OFFSET MSG74
         JMP   SHORT CKRADI_D
CKRADI_B:
         CMP   AL,12
         JNE   CKRADI_C
         MOV   BX,OFFSET MSG75
         JMP   SHORT CKRADI_D
CKRADI_C:
         CMP   AL,5
         JNE   CKRADI_E
         MOV   BX,OFFSET MSG76
CKRADI_D:
         CALL  DISPLY
CKRADI_E:
         RET
CKRADI   ENDP

; CHECK MOVE OF LIGHT LEFT

CKLITE   PROC
         TEST  LITESW,0FFH
         JE    CKLITE_B
         DEC   LITECT
         JNE   CKLITE_A
         MOV   LITESW,0
         MOV   AL,45         ;LIT CANDLE
         XOR   AH,AH
         CALL  XCHGOB
         CALL  INDARK
         JMP   SHORT CKLITE_B
CKLITE_A:
         MOV   BL,LITECT
         CMP   BL,9
         JA    CKLITE_B
         XOR   BH,BH
         MOV   SI,OFFSET MSG25A
         CALL  ASCLNO
         CALL  SUPRES
         MOV   AL,MSG25A+4
         MOV   MSG83A,AL
         MOV   BX,OFFSET MSG83
         CALL  DISPLY
CKLITE_B:
         RET
CKLITE   ENDP

;   ** IN ROOM ROUTINES **

INRM15   PROC
         PUSH  AX
         TEST  RADISW,0FFH
         JNE   INRM15_A
         MOV   AL,40         ;WEARING SUIT
         CALL  HAVOBJ
         JNE   INRM15_A
         MOV   RADISW,25
INRM15_A:
         MOV   AL,92         ;MUTANT
         CALL  CKOBJ
         JE    INRM15_B
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,8
         JA    INRM15_B
         MOV   BX,OFFSET MSG78
         JMP   DEAD2
INRM15_B:
         POP   AX
         RET
INRM15   ENDP

INRM48   PROC
         PUSH  AX
         MOV   AL,45         ;LIT CANDLE
         CALL  LOCOBJ
         JNE   INRM48_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,50
         JA    INRM48_A
         MOV   BX,OFFSET MSG30
         JMP   DEAD2
INRM48_A:
         POP   AX
         RET
INRM48   ENDP

; ** ENTER ROOM ROUTINES **

ENTR41   PROC
         PUSH  AX
         PUSH  BX
         MOV   BX,OFFSET MSG56
         CALL  DISPLY
         POP   BX
         POP   AX
         RET
ENTR41   ENDP

; ** EXIT ROOM ROUTINES **

; ** ANTIMATION ROUTINES **

; FLIP TORCHES IN CASTLE

MOVTOR   PROC
         INC   FLIPCT
         CMP   FLIPCT,4
         JB    MOVTOR_D
         MOV   FLIPCT,0
         CMP   FLIPSW,0
         JE    MOVTOR_B
         CMP   FLIPSW,1
         JE    MOVTOR_A
         MOV   FLIPSW,0
         MOV   AL,54
         JMP   SHORT MOVTOR_C
MOVTOR_A:
         MOV   AL,52
         JMP   SHORT MOVTOR_C
MOVTOR_B:
         MOV   AL,50
MOVTOR_C:
         CALL  SHOOVL
         INC   AL
         CALL  SHOOVL
         INC   FLIPSW
MOVTOR_D:
         RET
MOVTOR   ENDP

; MOVE FISH IN AQUATIC EXHIBIT

MOVFSH   PROC
         INC   FLIPCT
         CMP   FLIPCT,2
         JB    MOVFSH_B
         MOV   FLIPCT,0
         CALCX 20,17
         CALCD 20,17,33,56
         CALL  SCRLFT
         CALCX 36,69
         CALCD 36,69,41,108
         CALL  SCRRIT
MOVFSH_B:
         RET
MOVFSH   ENDP

; MOVE TUBES IN SCIENCE LAB

MOVLAB   PROC
         INC   BYTE PTR FLP2CT+1
         CMP   BYTE PTR FLP2CT+1,1
         JB    MOVLAB_A
         MOV   BYTE PTR FLP2CT+1,0
         MOV   AH,FLIPSW
         INC   AH
         AND   AH,3
         MOV   FLIPSW,AH
         CMP   AH,3
         JE    MOVLAB_A
         ADD   AH,16
         MOV   AL,OV2
         CALL  SHOOVL
         CALCX 40,109
         CALCD 40,109,46,112
         CALL  SCRDN
; CK FOR ELECT FLASH
MOVLAB_A:                    ;CHK FOR ELECT FLASH
         INC   BYTE PTR FLIPCT+1
         MOV   AL,BYTE PTR FLIPCT+1
         CMP   AL,4
         JE    MOVLAB_B
         CMP   AL,40
         JE    MOVLAB_B
         CMP   AL,42
         JE    MOVLAB_B
         CMP   AL,44
         JB    MOVLAB_C
         MOV   BYTE PTR FLIPCT+1,0
MOVLAB_B:
         MOV   AH,BYTE PTR FLIPCT
         INC   BYTE PTR FLIPCT
         AND   AH,3
         JE    MOVLAB_X
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,50
         JB    MOVLAB_C
MOVLAB_X:
         ADD   AH,19
         MOV   AL,OV2
         CALL  SHOOVL
MOVLAB_C:                    ;FLIP METER INDICATOR
         INC   BYTE PTR FLP2CT
         CMP   BYTE PTR FLP2CT,15
         JB    MOVLAB_E
         MOV   BYTE PTR FLP2CT,0
         MOV   AH,BYTE PTR FLP2SW
         INC   AH
         CMP   AH,3
         JB    MOVLAB_D
         XOR   AH,AH
MOVLAB_D:
         MOV   FLP2SW,AH
         ADD   AH,23
         MOV   AL,OV2
         CALL  SHOOVL
MOVLAB_E:
         RET
MOVLAB   ENDP

; MOVE MUTANT ON BEACH

MOVMUT   PROC
         MOV   AL,92
         CALL  CKOBJ
         JE    MOVMUT_B
         INC   FLIPCT
         CMP   FLIPCT,8
         JB    MOVMUT_A
         MOV   FLIPCT,0
         MOV   AH,FLIPSW
         XOR   AH,1
         MOV   FLIPSW,AH
         ADD   AH,51
         MOV   AL,OV2
         CALL  SHOOVL
MOVMUT_A:
         INC   FLP2CT
         CMP   FLP2CT,12
         JB    MOVMUT_B
         MOV   FLP2CT,0
         MOV   AH,FLP2SW
         XOR   AH,1
         MOV   FLP2SW,AH
         ADD   AH,53
         MOV   AL,OV2
         CALL  SHOOVL
MOVMUT_B:
         RET
MOVMUT   ENDP

;
;        END FILE: ADVCODE2.ASM   --   VORTEX FACTOR
;
