page	80,128
title	TORP.ASM	1/10/85	bjs

include		GENERAL.EQU
include		SOUND.EQU

PHOTON_LAUNCH_ENERGY	EQU	1
PHOTON_ENERGY		EQU	40
FIRE_SCALE		EQU	2

PUBLIC	Firet
PUBLIC	Firkt

EXTRN	Xor_Torp:near
EXTRN	Cos:near
EXTRN	Sin:near

EXTRN	SOUND_FLAG:byte

EXTRN	EFLG:word
EXTRN	ANGLE:word
EXTRN	XDIS:word
EXTRN	YDIS:word
EXTRN	XDRAWN:word
EXTRN	YDRAWN:word
EXTRN	ADRAWN:word
EXTRN	XVELL:word
EXTRN	XVEL:word
EXTRN	YVELL:word
EXTRN	YVEL:word
EXTRN	ENRGY:word

space_data	segment	public	'space_data'

space_data	ends

space_code	segment	public	'space_code'

PAGE
;--- MODULE:	Firet		--------------------------------
; Entry
;	si = enterprise torpedo #
; Exit
;	NONE
; Affects
;	Register	ax
;			EFLG,XDIS,YDIS,XDISL,YDISL,XDRAWN,YDRAWN
; Function
;	1. Fire enterprise torpedos
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Firet	proc	near

	cli					; no updates
	inc	byte ptr EFLG[si]		; enable torp display update
	mov	bl,byte ptr ANGLE+ENTOBJ
	call	sfirx				; displace torp out of range
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	dx,XDIS+ENTOBJ			; copy x position
	jns	fire100
	add	dx,MAX_X_AXIS
fire100:
	cmp	dx,WRAP_FACTOR
	jnb	fire200
	add	dx,MAX_X_AXIS-(2*WRAP_FACTOR)
fire200:
	cmp	dx,MAX_X_AXIS-WRAP_FACTOR
	jb	fire300
	sub	dx,MAX_X_AXIS-(2*WRAP_FACTOR)
fire300:
	mov	XDIS[si],dx
	mov	XDRAWN[si],dx
	mov	bl,byte ptr ANGLE+ENTOBJ	; do y
	call	sfiry				; get y accel.
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	dx,YDIS+ENTOBJ			; copy y position
	jns	fire400
	add	dx,MAX_Y_AXIS
fire400:
	cmp	dx,WRAP_FACTOR
	jnb	fire500
	add	dx,MAX_Y_AXIS-(2*WRAP_FACTOR)
fire500:
	cmp	dx,MAX_Y_AXIS-WRAP_FACTOR
	jb	fire600
	sub	dx,MAX_Y_AXIS-(2*WRAP_FACTOR)
fire600:
	mov	YDIS[si],dx
	mov	YDRAWN[si],dx
	mov	bl,byte ptr ANGLE+ENTOBJ
	mov	byte ptr ANGLE[si],bl
	mov	byte ptr ADRAWN[si],bl
	call	sfirx				; get x acc.
	add	ax,XVELL+ENTOBJ			; add fire vel to ent vel
	mov	XVELL[si],ax
	adc	dx,XVEL+ENTOBJ
	mov	XVEL[si],dx
	mov	bl,byte ptr ANGLE+ENTOBJ	; do y
	call	sfiry				; get y accel.
	add	ax,YVELL+ENTOBJ
	mov	YVELL[si],ax
	adc	dx,YVEL+ENTOBJ
	mov	YVEL[si],dx
	mov	byte ptr ENRGY[si],PHOTON_ENERGY
	sti
	sub	byte ptr ENRGY+ENTOBJ,PHOTON_LAUNCH_ENERGY
	call	Xor_Torp			; draw new torpedo
	or	SOUND_FLAG,PHOTON_SOUND		; fire photon sound
	ret

Firet	endp

PAGE
;--- MODULE:	Firkt		--------------------------------
; Entry
;	si = klingon torpedo #
; Exit
;	NONE
; Affects
;	Register	ax
;			EFLG,XDIS,YDIS,XDISL,YDISL,XDRAWN,YDRAWN
; Function
;	1. Fire klingon torpedos
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Firkt	proc	near

	cli					; no updates
	inc	byte ptr EFLG[si]		; enable torp display update
	mov	bl,byte ptr ANGLE+KLNOBJ
	call	sfirx				; displace torp out of range
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	dx,XDIS+KLNOBJ			; copy x position
	jns	firk100
	add	dx,MAX_X_AXIS
firk100:
	cmp	dx,WRAP_FACTOR
	jnb	firk200
	add	dx,MAX_X_AXIS-(2*WRAP_FACTOR)
firk200:
	cmp	dx,MAX_X_AXIS-WRAP_FACTOR
	jb	firk300
	sub	dx,MAX_X_AXIS-(2*WRAP_FACTOR)
firk300:
	mov	XDIS[si],dx
	mov	XDRAWN[si],dx
	mov	bl,byte ptr ANGLE+KLNOBJ	; do y
	call	sfiry				; get y accel.
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	dx,YDIS+KLNOBJ			; add in y position
	jns	firk400
	add	dx,MAX_Y_AXIS
firk400:
	cmp	dx,WRAP_FACTOR
	jnb	firk500
	add	dx,MAX_Y_AXIS-(2*WRAP_FACTOR)
firk500:
	cmp	dx,MAX_Y_AXIS-WRAP_FACTOR
	jb	firk600
	sub	dx,MAX_Y_AXIS-(2*WRAP_FACTOR)
firk600:
	mov	YDIS[si],dx
	mov	YDRAWN[si],dx
	mov	bl,byte ptr ANGLE+KLNOBJ
	mov	byte ptr ANGLE[si],bl
	mov	byte ptr ADRAWN[si],bl
	call	sfirx				; get x acc.
	add	ax,XVELL+KLNOBJ			; add fire vel to kln vel
	mov	XVELL[si],ax
	adc	dx,XVEL+KLNOBJ
	mov	XVEL[si],dx
	mov	bl,byte ptr ANGLE+KLNOBJ	; do y
	call	sfiry				; get y accel.
	add	ax,YVELL+KLNOBJ
	mov	YVELL[si],ax
	adc	dx,YVEL+KLNOBJ
	mov	YVEL[si],dx
	mov	byte ptr ENRGY[si],PHOTON_ENERGY
	sti
	sub	byte ptr ENRGY+KLNOBJ,PHOTON_LAUNCH_ENERGY
	call	Xor_Torp			; draw new torpedo
	or	SOUND_FLAG,PHOTON_SOUND		; fire photon sound
	ret

Firkt	endp

PAGE
;--- MODULE:	sfirx/sfiry	--------------------------------
; Entry
;	bl = angle
; Exit
;	ax = lo fire velocity
;	dx = hi fire velocity
; Affects
;	Register	ax,bx,dx
; Function
;	1. Scaled torp fire velocity
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

sfirx	proc	near

	call	Cos
	jmp	sfy100
sfiry:
	call	Sin
sfy100:
	cwd					; sign extend
	push	cx
	mov	cx,FIRE_SCALE
sfy200:
	shl	ax,1
	rcl	dx,1
	loop	sfy200
	pop	cx
	ret

sfirx	endp

space_code	ends
	end
