page	80,128
title	STARS	1/22/85	bjs

include		GENERAL.EQU

IF DISPLAY_TYPE
STAR_COUNT		EQU	1024
ELSE
STAR_COUNT		EQU	512
ENDIF

PUBLIC	Randx
PUBLIC	Randy
PUBLIC	Random
PUBLIC	Stars
PUBLIC	Seed_Random

EXTRN	Pixel:near				; in draw.asm

EXTRN	DOT_SEG:word

pc_time		STRUC
	DUMMY		DB	06CH DUP(?)
	TIMER_LOW	DW	?
	TIMER_HIGH	DW	?
	TIMER_OFL	DB	?
pc_time		ENDS

space_data	segment	public	'space_data'

RND		DB	0,0,0,0,0,0		; random number buffer

space_data	ends

space_code	segment	public	'space_code'

PAGE
;--- MODULE:	Randx		--------------------------------
; Entry
;	NONE
; Exit
;	ax=random number 0 to MAX_X_AXIS
; Affects
;	Register	ax
; Function
;	1. Generate a random number from WRAP_FACTOR to (MAX_X_AXIS-WRAP_FACTOR)
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Randx	proc	near

	call	Random				; ax = random # 0 to 64K
	and	ax,1024-1			; get under 1024
	cmp	ax,WRAP_FACTOR
	jb	Randx				; to small
	cmp	ax,MAX_X_AXIS-WRAP_FACTOR	; now get under MAX_X_AXIS-WRAP_FACTOR
	jnb	Randx
	ret

Randx	endp

PAGE
;--- MODULE:	Randy		--------------------------------
; Entry
;	NONE
; Exit
;	ax=random number 0 to MAX_Y_AXIS
; Affects
;	Register	ax
; Function
;	1. Generate a random number from WRAP_FACTOR to (MAX_Y_AXIS-WRAP_FACTOR)
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Randy	proc	near

	call	Random				; ax = random # 0 to 64K
	and	ax,512-1			; get under 512
	cmp	ax,WRAP_FACTOR
	jb	Randy				; too small
	cmp	ax,MAX_Y_AXIS-WRAP_FACTOR	; now get under MAX_Y_AXIS-WRAP_FACTOR
	jnb	Randy
	ret

Randy	endp

PAGE
;--- MODULE:	Random		--------------------------------
; Entry
;	NONE
; Exit
;	ax=random number 0 to 64K
; Affects
;	Register	ax
; Function
;	1. Generate a random number from 0 to 64K
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Random	proc	near

	push	di				; Thanks to Jim Buterfield for this routine
	stc
	mov	al,RND+1
	adc	al,RND+4
	adc	al,RND+5
	mov	RND,al
	mov	di,4
rmov:
	mov	al,RND[di]
	mov	RND[di+1],al
	dec	di
	jns	rmov
	pop	di
	mov	ah,RND+2
	ret

Random	endp

PAGE
;--- MODULE:	Seed_Random	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax
; Function
;	1. Used system clock to seed random number generator
;--- Revision History
;	1/5/85	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Seed_Random	proc	near

	mov	ax,040H				; pc variables
	mov	es,ax
	mov	ax,ES:TIMER_LOW
	mov	RND+1,al
	mov	RND+2,ah
	mov	ax,ES:TIMER_HIGH
	mov	RND+3,al
	mov	RND+4,ah
	ret

Seed_Random	endp

PAGE
;--- MODULE:	Stars		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,di,es
; Function
;	1. Fill sky with stars
;--- Revision History
;	12/20/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Stars	proc	near

	mov	cx,STAR_COUNT			; # of stars
	mov	es,DOT_SEG
star100:
	call	Randx				; random x
	mov	bx,ax
	call	Randy				; random y
	mov	dx,ax
	call	Pixel				; put the star on the screen
	loop	star100
	ret

Stars	endp

space_code	ends
	end
