page	80,128
title	SOUND.ASM	3/27/85	bjs

include		SOUND.EQU
include		PCIO.EQU
include		PLAYINT.EQU

HI_PITCH		EQU	0400H
LO_PITCH		EQU	0800H
HI_BLEEP		EQU	080H		; made when photon fired

PUBLIC	Sound
PUBLIC	Start_Phaser_Sound
PUBLIC	Turn_Off_Sound
PUBLIC	SOUND_FLAG
PUBLIC	SOUND_ENABLE

EXTRN	Random:near

EXTRN	BLINK:byte
EXTRN	HYPER_ENT_FLAG:byte
EXTRN	HYPER_KLN_FLAG:byte

space_data	segment	public	'space_data'

SOUND_FLAG	DB	0			; type of sound to make
SOUND_STATE	DB	0
SOUND_ENABLE	DB	0			; if = 1 sound on

space_data	ends

space_code	segment	public	'space_code'

PAGE
;--- MODULE:	Sound		--------------------------------
; Entry
;	SOUND_FLAG =	warning sound or
;			phaser sound or
;			explosion sound
; Exit
;	NONE
; Affects
;	Register	ax,es
;			SOUND_STATE
; Function
;	1. Update sounds
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Sound	proc	near

	test	SOUND_ENABLE,0FFH		; is sound enabled ?
	je	all_sound_off

	test	SOUND_FLAG,0FFH			; any sound ?
	js	sond020				; sound disabled
	jne	sond010				; yes

all_sound_off:
	jmp	Turn_Off_Sound

sond010:
	test	SOUND_FLAG,HYPER_SOUND		; hyperspace sound ?
	je	sond100				; no

	mov	ah,HYPER_ENT_FLAG
	xor	al,al
	add	ah,HYPER_KLN_FLAG
	push	ax
					
	in	al,SOUND_CTRL
	or	al,03H				; turn sound on
	out	SOUND_CTRL,al

	mov	al,0B6H				; make a high pitch bleep
	out	TIMER_CTRL_PORT,al		; get set to write a word to the timer3

	pop	ax
	out	TIMER2_DATA_PORT,al
	mov	al,ah
	out	TIMER2_DATA_PORT,al
sond020:
       	ret

sond100:
	test	SOUND_FLAG,PHASER_SOUND		; phaser sound ?
	je	sond500				; no

	mov	al,SOUND_STATE
	or	al,al
	js	all_sound_off			; end of phaser sound
	add	al,PHASER_SOUND_RAMP		; ramp sound
	mov	SOUND_STATE,al

	neg	al
	xor	ah,ah
	shl	ax,1
	shl	ax,1
	shl	ax,1
	push	ax
					
	in	al,SOUND_CTRL
	or	al,03H				; turn sound on
	out	SOUND_CTRL,al

	mov	al,0B6H				; make a high pitch bleep
	out	TIMER_CTRL_PORT,al		; get set to write a word to the timer3

	pop	ax
	out	TIMER2_DATA_PORT,al
	mov	al,ah
	out	TIMER2_DATA_PORT,al
       	ret

sond500:
	test	SOUND_FLAG,PHOTON_SOUND		; photon sound ?
	je	sond600				; no

	mov	al,SOUND_STATE
	or	al,al				; start ?
	jne	sond540				; no - already started

	mov	SOUND_STATE,2			; last one tick

	in	al,SOUND_CTRL
	or	al,03H				; turn sound on
	out	SOUND_CTRL,al

	mov	al,0B6H				; make a high pitch bleep
	out	TIMER_CTRL_PORT,al		; get set to write a word to the timer3
	mov	ax,HI_BLEEP
	out	TIMER2_DATA_PORT,al
	mov	al,ah
	out	TIMER2_DATA_PORT,al
	ret

sond540:
	dec	al				; time up turn off bleep
	je	make_all_sound_off		; yes
	mov	SOUND_STATE,al
	ret

make_all_sound_off:
	jmp	Turn_Off_Sound


sond600:
	test	SOUND_FLAG,WARNING_SOUND	; warning sound ?
	je	sond900				; NO
	mov	al,BLINK
	mov	ah,al
	and	ah,WARNING_TIME-1		; time to change sound ?
	jne	sond1000

	push	ax
	in	al,SOUND_CTRL
	or	al,03H				; turn sound on
	out	SOUND_CTRL,al

	mov	al,0B6H				; make a high pitch bleep
	out	TIMER_CTRL_PORT,al		; get set to write a word to the timer3

	mov	bx,HI_PITCH

	pop	ax
	and	al,WARNING_TIME
	je	sond700
	mov	bx,LO_PITCH
sond700:
	mov	al,bl
	out	TIMER2_DATA_PORT,al
	mov	al,bh
	out	TIMER2_DATA_PORT,al
	ret

sond900:
	test	SOUND_FLAG,EXPLOSION_SOUND	; explosion sound ?
	je	sond1000			; no

	in	al,SOUND_CTRL
	or	al,3				; turn sound on
	out	SOUND_CTRL,al

	mov	al,0B6H				; low tone
	out	TIMER_CTRL_PORT,al
	call	Random
	or	ax,2000H
	out	TIMER2_DATA_PORT,al
	mov	al,ah				; %%%
	out	TIMER2_DATA_PORT,al
sond1000:
	ret

Sound	endp

PAGE
;--- MODULE:	Start_Phaser_Sound -----------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	SOUND_FLAG,SOUND_STATE
; Function
;	1. Start phaser sound
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Start_Phaser_Sound	proc	near

	cli
	mov	SOUND_STATE,0
	or	SOUND_FLAG,PHASER_SOUND
	sti
	ret

Start_Phaser_Sound	endp

PAGE
;--- MODULE:	Turn_Off_Sound	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	
; Function
;	1. Turn all sounds off
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Turn_Off_Sound	proc	near

	mov	SOUND_FLAG,0			; stop all sounds
	mov	SOUND_STATE,0
	in	al,SOUND_CTRL
	and	al,0FCH				; turn sound off
	out	SOUND_CTRL,al
	ret

Turn_Off_Sound	endp

space_code	ends
	end
