page	80,128
title	SIN.ASM		1/10/85	bjs

PUBLIC	Sin
PUBLIC	Cos
PUBLIC	Tan_Table

space_data	segment	public	'space_data'

; ****** ACCELERATION TABLE ******

SINE_TABLE	DW	00000H,00324H,00648H,0096AH
		DW	00C8CH,00FABH,012C8H,015E2H
		DW	018F9H,01C0BH,01F1AH,02223H
		DW	02528H,02826H,02B1FH,02E11H
		DW	030FBH,033DFH,036BAH,0398CH
		DW	03C56H,03F17H,041CEH,0447AH
		DW	0471CH,049B4H,04C3FH,04EBFH
		DW	05133H,0539BH,055F5H,05842H
		DW	05A82H,05CB3H,05ED7H,060EBH
		DW	062F1H,064E8H,066CFH,068A6H
		DW	06A6DH,06C23H,06DC9H,06F5EH
		DW	070E2H,07254H,073B5H,07504H
		DW	07641H,0776BH,07884H,07989H
		DW	07A7CH,07B5CH,07C29H,07CE3H
		DW	07D89H,07E1DH,07E9CH,07F09H
		DW	07F61H,07FA6H,07FD8H,07FF5H
		DW	07FFFH,07FF5H,07FD8H,07FA6H
		DW	07F61H,07F09H,07E9CH,07E1DH
		DW	07D89H,07CE3H,07C29H,07B5CH
		DW	07A7CH,07989H,07884H,0776BH
		DW	07641H,07504H,073B5H,07254H
		DW	070E2H,06F5EH,06DC9H,06C23H
		DW	06A6DH,068A6H,066CFH,064E8H
		DW	062F1H,060EBH,05ED7H,05CB3H
		DW	05A82H,05842H,055F5H,0539BH
		DW	05133H,04EBFH,04C3FH,049B4H
		DW	0471CH,0447AH,041CEH,03F17H
		DW	03C56H,0398CH,036BAH,033DFH
		DW	030FBH,02E11H,02B1FH,02826H
		DW	02528H,02223H,01F1AH,01C0BH
		DW	018F9H,015E2H,012C8H,00FABH
		DW	00C8CH,0096AH,00648H,00324H
		DW	00000H,0FCDCH,0F9B8H,0F696H
		DW	0F374H,0F055H,0ED38H,0EA1EH
		DW	0E707H,0E3F5H,0E0E6H,0DDDDH
		DW	0DAD8H,0D7DAH,0D4E1H,0D1EFH
		DW	0CF05H,0CC21H,0C946H,0C674H
		DW	0C3AAH,0C0E9H,0BE32H,0BB86H
		DW	0B8E4H,0B64DH,0B3C1H,0B141H
		DW	0AECDH,0AC65H,0AA0BH,0A7BEH
		DW	0A57EH,0A34DH,0A129H,09F15H
		DW	09D0FH,09B18H,09931H,0975AH
		DW	09593H,093DDH,09237H,090A2H
		DW	08F1EH,08DACH,08C4BH,08AFCH
		DW	089BFH,08895H,0877CH,08677H
		DW	08584H,084A4H,083D7H,0831DH
		DW	08277H,081E3H,08164H,080F7H
		DW	0809FH,0805AH,08028H,0800BH
		DW	08001H,0800BH,08028H,0805AH
		DW	0809FH,080F7H,08164H,081E3H
		DW	08277H,0831DH,083D7H,084A4H
		DW	08584H,08677H,0877CH,08895H
		DW	089BFH,08AFCH,08C4BH,08DACH
		DW	08F1EH,090A2H,09237H,093DDH
		DW	09593H,0975AH,09931H,09B18H
		DW	09D0FH,09F15H,0A129H,0A34DH
		DW	0A57EH,0A7BEH,0AA0BH,0AC65H
		DW	0AECDH,0B141H,0B3C1H,0B64CH
		DW	0B8E4H,0BB86H,0BE32H,0C0E9H
		DW	0C3AAH,0C674H,0C946H,0CC21H
		DW	0CF05H,0D1EFH,0D4E1H,0D7DAH
		DW	0DAD8H,0DDDDH,0E0E6H,0E3F5H
		DW	0E707H,0EA1EH,0ED38H,0F055H
		DW	0F374H,0F695H,0F9B8H,0FCDCH

Tan_Table	DW	00000H,00324H,0064AH,00971H
		DW	00C9BH,00FC9H,012FDH,01636H
		DW	01976H,01CBEH,02010H,0236CH
		DW	026D4H,02A49H,02DCCH,03160H
		DW	03505H,038BDH,03C8AH,0406EH
		DW	0446AH,04882H,04CB8H,0510DH
		DW	05586H,05A25H,05EEEH,063E4H
		DW	0690BH,06E69H,07402H,079DDH

space_data	ends

space_code	segment	public	'space_code'

;--- MODULE:	Cos, Sin	--------------------------------
; Entry
;	bl = angle 0 to 255 where there are 256 degrees in a circle
; Exit
;	ax = -32767 to 32767
; Affects
;	Register	ax,bx
; Function
;	1. Lookup a normalized SIN or COS value from a table 
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data

Cos	proc	near

	add	bl,64			; COS(X)=SIN(X+90)
Sin:
	xor	bh,bh
	shl	bx,1			; adjust for words
	mov	ax,SINE_TABLE[bx]
	ret

Cos	endp

space_code	ends
	end
