page	80,128
title	PHASER.ASM	3/27/85	bjs

include		GENERAL.EQU
include		PHASER.EQU
include		PLANET.EQU

PUBLIC	Erase
PUBLIC	Ephsr
PUBLIC	Erask
PUBLIC	Kphsr

EXTRN	Cos:near
EXTRN	Sin:near
EXTRN	Point:near
EXTRN	Xor_Torp:near
EXTRN	Start_Phaser_Sound:near

EXTRN	CMPS_FLAG:byte
EXTRN	MAX_LENGTH:byte
EXTRN	ACTUAL_LENGTH:byte
EXTRN	GANG:byte
EXTRN	PLANET_ENABLE:byte

EXTRN	PHCT:word
EXTRN	PHA:word
EXTRN	PHX:word
EXTRN	PHY:word
EXTRN	XPOS:word
EXTRN	YPOS:word
EXTRN	ANGLE:word
EXTRN	XDIS:word
EXTRN	YDIS:word
EXTRN	ACCUM_X:word
EXTRN	ACCUM_Y:word
EXTRN	DELTA_X:word
EXTRN	DELTA_Y:word
EXTRN	EFLG:word
EXTRN	SHLDS:word
EXTRN	UFLG:word

space_data	segment	public	'space_data'

space_data	ends

space_code	segment	public	'space_code'

PAGE
;--- MODULE:	Erase		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
;			DELTA_X,DELTA_Y,EFLG'S,UFLG'S
;			PHX,PHX,PHA,PHST,PHCT
; Function
;	1. Erase ent old phaser shot
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Erase	proc	near

	mov	CMPS_FLAG,0			; flag for no compares
	mov	al,byte ptr PHCT+ENTOBJ		; length of old ray
	mov	ah,byte ptr PHA+ENTOBJ		; get old angle
	mov	bx,PHX+ENTOBJ			; get old x and y
	mov	cx,PHY+ENTOBJ
	mov	MAX_LENGTH,al
	mov	GANG,ah
	mov	XPOS,bx
	mov	YPOS,cx
	jmp	phsr

Erase	endp

PAGE
;--- MODULE:	Ephsr		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
;			DELTA_X,DELTA_Y,EFLG'S,UFLG'S
;			PHX,PHX,PHA,PHST,PHCT
; Function
;	1. Draw enterprise new phaser shot
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Ephsr	proc	near

	mov	CMPS_FLAG,1			; flag for compares
	mov	al,PHASER_RANGE			; max length of ray
	cli					; stop changes
	mov	ah,byte ptr ANGLE+ENTOBJ	; get aim
	mov	bx,XDIS+ENTOBJ			; get x
	mov	cx,YDIS+ENTOBJ			; get y
	sti
	mov	MAX_LENGTH,al
	mov	GANG,ah
	mov	byte ptr PHA+ENTOBJ,ah		; save for erase
	mov	PHX+ENTOBJ,bx
	mov	XPOS,bx
	mov	PHY+ENTOBJ,cx
	mov	YPOS,cx
	call	Start_Phaser_Sound		; start phaser sound
	call	phsr				; draw it
	mov	al,ACTUAL_LENGTH		; save length of phaser	ray
	mov	byte ptr PHCT+ENTOBJ,al
	ret

Ephsr	endp

PAGE
;--- MODULE:	Erask		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
;			DELTA_X,DELTA_Y,EFLG'S,UFLG'S
;			PHX,PHX,PHA,PHST,PHCT
; Function
;	1. Erase kln old phaser shot
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Erask	proc	near

	mov	CMPS_FLAG,0			; flag for no compares
	mov	al,byte ptr PHCT+KLNOBJ		; length of old ray
	mov	ah,byte ptr PHA+KLNOBJ		; get old angle
	mov	bx,PHX+KLNOBJ			; get old x and y
	mov	cx,PHY+KLNOBJ
	mov	MAX_LENGTH,al
	mov	GANG,ah
	mov	XPOS,bx
	mov	YPOS,cx
	jmp	phsr

Erask	endp

PAGE
;--- MODULE:	Kphsr		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
;			DELTA_X,DELTA_Y,EFLG'S,UFLG'S
;			PHX,PHX,PHA,PHST,PHCT
; Function
;	1. Draw klingon new phaser shot
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Kphsr	proc	near

	mov	CMPS_FLAG,1			; flag for compares
	mov	al,PHASER_RANGE			; max length of ray
	cli					; stop changes
	mov	ah,byte ptr ANGLE+KLNOBJ	; get aim
	mov	bx,XDIS+KLNOBJ			; get x
	mov	cx,YDIS+KLNOBJ			; get y
	sti
	mov	MAX_LENGTH,al
	mov	GANG,ah
	mov	byte ptr PHA+KLNOBJ,ah		; save for erase
	mov	PHX+KLNOBJ,bx
	mov	XPOS,bx
	mov	PHY+KLNOBJ,cx
	mov	YPOS,cx
	call	Start_Phaser_Sound		; start phaser sound
	call	phsr				; draw it
	mov	al,ACTUAL_LENGTH		; save length of phaser	ray
	mov	byte ptr PHCT+KLNOBJ,al
	ret

Kphsr	endp

PAGE
;--- MODULE:	phsr		--------------------------------
; Entry
;	CMPS_FLAG  = 1 then test for hit
;	MAX_LENGTH = length of ray drawn
;	GANG       = fire angle
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
;			DELTA_X,DELTA_Y,EFLG'S,UFLG'S
; Function
;	1. Draw or erase phaser
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

phsr	proc	near

	xor	ax,ax
	mov	ACTUAL_LENGTH,al		; ctr for length of ray
	mov	ACCUM_X,ax			; zero accum
	mov	ACCUM_Y,ax
phs100:
	mov	bl,GANG				; get angle
	call	Cos				; get delta x
	mov	dx,ax
	mov	bl,GANG				; get angle
	call	Sin				; get delta y
	xor	di,di
	or	dx,dx				; neg x ?
	jns	phs120				; no
	neg	dx
	inc	di
	inc	di
phs120:
	or	ax,ax				; neg y ?
	jns	phs200				; no
	neg	ax
	inc	di
phs200:
	shl	dx,1				; normalize
	js	phs250
	shl	ax,1
	js	phs300
	jmp	phs200
phs250:
	shl	ax,1
phs300:
	mov	DELTA_X,dx
	mov	DELTA_Y,ax
	shl	di,1				; words
	jmp	word ptr cs:phsr_dispatch[di]


phsr_dispatch:
		DW	xpyp,xpyn,xnyp,xnyn


xpyp:
	xor	cx,cx				; change flag
	call	x_positive			; x=+,y=+
	call	y_positive			; add delta's
	or	cx,cx
	je	xpyp				; if no position change
	inc	ACTUAL_LENGTH			; one more pixal
	mov	al,ACTUAL_LENGTH		; outside of ship zone ?
	cmp	al,9
	jb	xpyp				; no
	call	Point				; plot a point
	test	CMPS_FLAG,0FFH			; enabled ?
	je	xpyp2				; no - skip it
	mov	al,ACTUAL_LENGTH		; skip by range ?
	and	al,PHASER_TO_OBJ_RANGE-1
	jne	xpyp2
	call	zaps
	jb	xpyp4				; yes - hit, exit
xpyp2:
	mov	al,ACTUAL_LENGTH		; done full range ?
	cmp	al,MAX_LENGTH
	jb	xpyp				; no
xpyp4:
	ret

xpyn:
	xor	cx,cx
	call	x_positive			; x=+,y=-
	call	y_negative
	or	cx,cx
	je	xpyn				; if no position change
	inc	ACTUAL_LENGTH			; one more pixal
	mov	al,ACTUAL_LENGTH		; outside of ship zone ?
	cmp	al,9
	jb	xpyn				; no
	call	Point
	test	CMPS_FLAG,0FFH			; enabled ?
	je	xpyn2				; no - skip it
	mov	al,ACTUAL_LENGTH		; skip by range ?
	and	al,PHASER_TO_OBJ_RANGE-1
	jne	xpyn2
	call	zaps
	jb	xpyn4
xpyn2:
	mov	al,ACTUAL_LENGTH		; done full range ?
	cmp	al,MAX_LENGTH
	jb	xpyn
xpyn4:
	ret

xnyp:
	xor	cx,cx
	call	x_negative			; x=-,y=+
	call	y_positive
	or	cx,cx
	je	xnyp				; if no position change
	inc	ACTUAL_LENGTH			; one more pixal
	mov	al,ACTUAL_LENGTH		; outside of ship zone ?
	cmp	al,9
	jb	xnyp				; no
	call	Point
	test	CMPS_FLAG,0FFH			; enabled ?
	je	xnyp2				; no - skip it
	mov	al,ACTUAL_LENGTH		; skip by range ?
	and	al,PHASER_TO_OBJ_RANGE-1
	jne	xnyp2
	call	zaps
	jb	xnyp4
xnyp2:
	mov	al,ACTUAL_LENGTH		; done full range ?
	cmp	al,MAX_LENGTH
	jb	xnyp
xnyp4:
	ret

xnyn:
	xor	cx,cx
	call	x_negative			; x=-,y=-
	call	y_negative
	or	cx,cx
	je	xnyn				; if no position change
	inc	ACTUAL_LENGTH			; one more pixal
	mov	al,ACTUAL_LENGTH		; outside of ship zone ?
	cmp	al,9
	jb	xnyn				; no
	call	Point
	test	CMPS_FLAG,0FFH			; enabled ?
	je	xnyn2				; no - skip it
	mov	al,ACTUAL_LENGTH		; skip by range ?
	and	al,PHASER_TO_OBJ_RANGE-1
	jne	xnyn2
	call	zaps
	jb	xnyn4
xnyn2:
	mov	al,ACTUAL_LENGTH		; done full range ?
	cmp	al,MAX_LENGTH
	jb	xnyn
xnyn4:
	ret

phsr	endp

PAGE
;--- MODULE:	x_positive/x_negative/y_positive/y_negative
; Entry
;	XPOS,YPOS,DELTA_X,DELTA_Y
; Exit
;	carry=1 if change in pixel position
; Affects
;	Register	AX
;			XPOS,YPOS,ACCUM_X,ACCUM_Y
; Function
;	1. Move phaser pointers
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

x_positive	proc	near			; X POSITIVE

	mov	ax,DELTA_X
	add	ACCUM_X,ax
	jnb	xng400
	inc	cx				; flag change
	mov	ax,XPOS
	inc	ax
	cmp	ax,MAX_X_AXIS			; wrap ?
	jb	xng300
	xor	ax,ax
	jmp	xng300

x_negative:					; X NEGATIVE

	mov	ax,DELTA_X
	add	ACCUM_X,ax
	jnb	xng400				; no pixal
	inc	cx				; flag change
	mov	ax,XPOS
	dec	ax				; wrap ?
	jns	xng300				; no
	mov	ax,MAX_X_AXIS-1
xng300:
	mov	XPOS,ax				; save x
xng400:
	ret

x_positive	endp

y_positive	proc	near			; Y POSITIVE

	mov	ax,DELTA_Y
	add	ACCUM_Y,ax
	jnb	yng400
	inc	cx				; flag change
	mov	ax,YPOS
	inc	ax
	cmp	ax,MAX_Y_AXIS			; wrap ?
	jb	yng300
	xor	ax,ax
	jmp	yng300

y_negative:					; y negative
	mov	ax,DELTA_Y
	add	ACCUM_Y,ax
	jnb	yng400				; no pixal
	inc	cx				; flag change
	mov	ax,YPOS
	dec	ax				; wrap ?
	jns	yng300				; no
	mov	ax,MAX_Y_AXIS-1
yng300:
	mov	YPOS,ax				; save y
yng400:
	ret

y_positive	endp

PAGE
;--- MODULE:	Kphsr		--------------------------------
; Entry
;	CMPS_FLAG  = 1 then test for hit
; Exit
;	carry = 1 if a hit
; Affects
;	Register	ax,bx,cx,dx,si,di,bp
;			EFLG'S,UFLG'S
; Function
;	1. Test for phaser hit
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

zaps	proc	near

	mov	si,ENTOBJ-2			; check all objects
zap100:
	mov	ax,YPOS				; check y's first
zap200:
	inc	si
	inc	si
	cmp	si,ENDOBJ			; done all objects
	jb	zap210				; no
	test	PLANET_ENABLE,BIT0		; PLANET active ?
	je	zap3000				; no
	sub	ax,PLANET_Y			; PLANET position y
	jns	zap2000
	neg	ax
zap2000:
	cmp	ax,PLANET_RANGE
	jnb	zap3000
	mov	ax,XPOS				; check x
	sub	ax,PLANET_X			; PLANET position x
	jns	zap2100
	neg	ax
zap2100:
	cmp	ax,PLANET_RANGE
	jb	zap600				; hit the Planet
zap3000:
	clc
	ret

zap210:
	test	byte ptr EFLG[si],0FFH		; obj enabled
	je	zap200				; no - try next
	js	zap200				; no - exploding
	sub	ax,YDIS[si]
	jns	zap220
	neg	ax				; complement
zap220:
	cmp	ax,PHASER_TO_OBJ_RANGE		; in range ?
	jnb	zap100				; no
	mov	ax,XPOS				; check x
	sub	ax,XDIS[si]			; same obj's x
	jns	zap240
	neg	ax				; complement
zap240:
	cmp	ax,PHASER_TO_OBJ_RANGE		; x in range ?
	jnb	zap100				; no
	cmp	si,ENTOBJ			; got it - the enterprise ?
	jne	zap300				; no
	sub	SHLDS+ENTOBJ,PHASER_DAMAGE	; lose shield energy
	jmp	zap600				; exit
zap300:
	cmp	si,KLNOBJ			; klingon ?
	jne	zap400				; no
	sub	SHLDS+KLNOBJ,PHASER_DAMAGE	; lose shield energy
	jmp	zap600				; exit
zap400:
	call	Xor_Torp			; hit a torp, erase it
	cli
	mov	byte ptr UFLG[si],0		; stop updates
	mov	byte ptr EFLG[si],0FFH		; start explosion
	sti
zap600:
	stc
	ret

zaps	endp

space_code	ends
		end

