page	80,128
title	KEYS.ASM	3/27/85	bjs

include		GENERAL.EQU
include		KEYS.EQU
include		PCIO.EQU

PUBLIC	KEYBAM
PUBLIC	Reset_Keyboard
PUBLIC	Keybdi
PUBLIC	ENTERPRISE_KEYS
PUBLIC	NON_ENERGY_KEYS
PUBLIC	ALL_KEYS_CTR
PUBLIC	KLINGON_KEYS

space_data	segment	public	'space_data'

ENTERPRISE_KEYS	DB	ENTERPRISE_ROTATE_CW
		DB	ENTERPRISE_ROTATE_CCW
		DB	ENTERPRISE_SHIELDS
		DB	ENTERPRISE_WEAPONS

NON_ENERGY_KEYS	EQU	$-ENTERPRISE_KEYS-1

		DB	ENTERPRISE_PHASERS
		DB	ENTERPRISE_PHOTONS
		DB	ENTERPRISE_IMPULSE
		DB	ENTERPRISE_CLOAK
		DB	ENTERPRISE_HYPERSPACE

ALL_KEYS_CTR	EQU	$-ENTERPRISE_KEYS-1

KLINGON_KEYS	DB	KLINGON_ROTATE_CW
		DB	KLINGON_ROTATE_CCW
		DB	KLINGON_SHIELDS
		DB	KLINGON_WEAPONS

		DB	KLINGON_PHASERS
		DB	KLINGON_PHOTONS
		DB	KLINGON_IMPULSE
		DB	KLINGON_CLOAK
		DB	KLINGON_HYPERSPACE

KEYBAM		DB	128 DUP(080H)

space_data	ends

space_code	segment	public	'space_code'
PAGE
;--- MODULE:	Reset_Keyboard	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,cx,di,es
; Function
;	1. Clear Keybam so no keys appear down
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Reset_Keyboard	proc	near

	mov	ax,ds
	mov	es,ax
	mov	di,offset KEYBAM		; show no keys down
	mov	al,80H
	mov	cx,128
	cld
	rep	stosb
	ret

Reset_Keyboard		endp

PAGE
;--- MODULE:	Keybdi		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	NONE
; Function
;	1. Read keyboard hardware for key matrix value
;	2. Place value in KEYBAM
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:Nothing,ES:Nothing

Keybdi	proc	near

	push	ax
	push	dx
	push	di
	push	ds

	mov	ax,space_data			; set dat segment
	mov	ds,ax
	ASSUME	DS:space_data

	in	al,KBD_IN			; read keyboard matrix value
	mov	di,ax				; index into Keybam
	and	di,7FH	     			; 128 byte table
	mov	KEYBAM[di],al

	in	al,KBD_CTL			; reset keyboard hardware for next key
	mov 	ah,al
	or	al,80h
	out	KBD_CTL,al
	xchg	al,ah
	out	KBD_CTL,al

	test	byte ptr CTRL_KEY+KEYBAM,80H	; CTRL key ?
	jne	keyd200				; no - skip warm start
	test	byte ptr ALT_KEY+KEYBAM,80H	; ALT key ?
	jne	keyd200				; no - skip warm start
	test	byte ptr DEL_KEY+KEYBAM,80H	; DEL key ?
	je	warm_start			; yes - go to warm start

keyd200:

	mov	al,20h				; send non-specific EOI to PIC
	out	INTA00,al
  
	pop	ds
	pop	di
	pop	dx
	pop	ax
	iret

Keybdi	endp

PAGE
;--- MODULE:	warm_start	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	NONE
; Function
;	1. Jumps to reset vector to warm start PC.
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:Nothing,ES:Nothing

warm_start	proc	far

	mov	ax,40H
	mov	ds,ax
	mov	word ptr DS:[72H],1234H
	xor	ax,ax
	dec	ax
	push	ax				; segment 0FFFFH
	inc	ax
	push	ax				; offset 00000H
	ret					; to reset vector

warm_start	endp

space_code	ends

	end
