page	80,128
title	INIT.ASM	3/27/85	bjs

include		GENERAL.EQU
include		PCIO.EQU

IF DISPLAY_TYPE
include		HERC.EQU
ENDIF

PUBLIC	Build_Row_Addr
PUBLIC	Gmode
PUBLIC	Save_Interrupts
PUBLIC	Restore_Interrupts
PUBLIC	Install_Play_Interrupts
PUBLIC	Reset_Variables

PUBLIC	ROW_ADDR
PUBLIC	XVEL
PUBLIC	YVEL
PUBLIC	SHLDS
PUBLIC	DELTA_X
PUBLIC	DELTA_Y
PUBLIC	XDISL
PUBLIC	YDISL
PUBLIC	ANGLE
PUBLIC	ROTATE
PUBLIC	XVELL
PUBLIC	YVELL
PUBLIC	XDIS
PUBLIC	YDIS
PUBLIC	GANG
PUBLIC	DOT_SEG
PUBLIC	AUTO_FLAG
PUBLIC	ENTERPRISE_SCORE
PUBLIC	KLINGON_SCORE
PUBLIC	DRAWN_FLAG
PUBLIC	XDRAWN
PUBLIC	YDRAWN
PUBLIC	ADRAWN
PUBLIC	XPOS
PUBLIC	YPOS
PUBLIC	LETTER_FLAG
PUBLIC	ACCUM_X
PUBLIC	ACCUM_Y
PUBLIC	ACTUAL_LENGTH
PUBLIC	PHX
PUBLIC	PHY
PUBLIC	PHA
PUBLIC	CMPS_FLAG
PUBLIC	ENRGY
PUBLIC	BLINK
PUBLIC	PHST
PUBLIC	PHCT
PUBLIC	FIRE
PUBLIC	EFLG
PUBLIC	UFLG
PUBLIC	EXPS
PUBLIC	FLAGS
PUBLIC	MAX_LENGTH
PUBLIC	FUNCTION_FLAGS

EXTRN	Play_Interrupt:near			; in playint.asm
EXTRN	Keybdi:near				; in keys.asm
EXTRN	Clrscn:near				; in draw.asm
EXTRN	Stars:near				; in stars.asm
EXTRN	Draw_Ent:near				; in draw.asm
EXTRN	Draw_Kln:near				; in draw.asm
EXTRN	Xor_Left_S:near				; in draw.asm
EXTRN	Xor_Left_E:near				; in draw.asm
EXTRN	Xor_Right_S:near			; in draw.asm
EXTRN	Xor_Right_E:near			; in draw.asm

EXTRN	SOUND_FLAG:byte

space_data	segment	public	'space_data'

; ****** RESTART GAME CONSTANTS ******

ZVARS		LABEL	word

ZDRAWN		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZXDISL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZYDISL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZXDIS		DW	MAX_X_AXIS/4,0,0,0,0,0,0,0
		DW	3*MAX_X_AXIS/4,0,0,0,0,0,0,0
ZYDIS		DW	(MAX_Y_AXIS-16)/4,0,0,0,0,0,0,0
		DW	3*(MAX_Y_AXIS-16)/4,0,0,0,0,0,0,0
ZXDRAWN		DW	MAX_X_AXIS/4,0,0,0,0,0,0,0
		DW	3*MAX_X_AXIS/4,0,0,0,0,0,0,0
ZYDRAWN		DW	(MAX_Y_AXIS-16)/4,0,0,0,0,0,0,0
		DW	3*(MAX_Y_AXIS-16)/4,0,0,0,0,0,0,0
ZXVEL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZYVEL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZXVELL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZYVELL		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

ZUFLG		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZEFLG		DW	1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0

ZANGLE		DW	0,0,0,0,0,0,0,0,080H,0,0,0,0,0,0,0
ZADRAWN		DW	0,0,0,0,0,0,0,0,080H,0,0,0,0,0,0,0

ZROTATE		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZFLAGS		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZFIRE		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

ZSHLDS		DW	31,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0
ZENRGY		DW	127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0

ZEXPS		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZUPDT		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

ZPHST		DW	0FFH,0,0,0,0,0,0,0,0FFH,0,0,0,0,0,0,0
ZPHCT		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZPHX		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZPHY		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ZPHA		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

ZEND		LABEL	word

IF DISPLAY_TYPE

GTABLE		DB	035H,02DH,02EH,007H
		DB	05BH,002H,057H,057H
		DB	002H,003H,000H,000H

ELSE

GTABLE		DB	035H,028H,02EH,007H
		DB	05BH,002H,057H,057H
		DB	002H,003H,000H,000H

ENDIF

; ****** SPACE WAR VARABLES ******

TVARS		LABEL	word

DRAWN_FLAG	DW	16 DUP(0)		; IF = 1 THEN ON SCREEN
XDISL		DW	16 DUP(0)		; X DISPLACEMENT LO
YDISL		DW	16 DUP(0)		; Y DISPLACEMENT LO
XDIS		DW	16 DUP(0)		; X DISPLACEMENT
YDIS		DW	16 DUP(0)		; Y DISPLACEMENT
XDRAWN		DW	16 DUP(0)		; X OF DRAWN OBJECT
YDRAWN		DW	16 DUP(0)		; Y OF DRAWN OBJECT
XVEL		DW	16 DUP(0)		; X VELOCITY
YVEL		DW	16 DUP(0)		; Y VELOCITY
XVELL		DW	16 DUP(0)		; X VELOCITY LOW
YVELL		DW	16 DUP(0)		; Y VELOCITY LOW

UFLG		DW	16 DUP(0)		; UPDATE FLAG
EFLG		DW	16 DUP(0)		; ENABLE FLAG

ANGLE		DW	16 DUP(0)		; ANGLES LO
ADRAWN		DW	16 DUP(0)		; OLD ANGLES

ROTATE		DW	16 DUP(0)		; SIGNED ROT
FLAGS		DW	16 DUP(0)		; THRUST FLAG
FIRE		DW	16 DUP(0)		; FIRE TORP KEY FLAGS

SHLDS		DW	16 DUP(0)		; SHIELD ENERGY
ENRGY		DW	16 DUP(0)		; DILITHIUM CRYSTAL ENERGY

EXPS		DW	16 DUP(0)		; EXPLOSION COUNTERS
UPDT		DW	16 DUP(0)

PHST		DW	16 DUP(0)		; PHASOR STATE
PHCT		DW	16 DUP(0)		; PHASOR TIME CTR
PHX		DW	16 DUP(0)		; PHASOR X PART
PHY		DW	16 DUP(0)		; PHASOR Y PART
PHA		DW	16 DUP(0)		; PHASOR ANGLE
SAVE_X_GRAV	DW	16 DUP(0)
SAVE_Y_GRAV	DW	16 DUP(0)

XPOS		DW	0
YPOS		DW	0
DOT_SEG		DW	0			; DOT_SEGMENT
SCN_0		DW	0
SCN_1		DW	0
DELTA_X		DW	0
DELTA_Y		DW	0
ACCUM_X		DW	0
ACCUM_Y		DW	0

KEYS_VEC_OFF 	DW	0 			; SAVE KEYBOARD VECTOR HERE
KEYS_VEC_SEG 	DW	0
TIMER_VEC_OFF	DW	0			; SAVE VINT VECTOR HERE
TIMER_VEC_SEG	DW	0

AUTO_FLAG	DB	0			; BIT0 = ENT, BIT1 = KLN
CMPS_FLAG	DB	0
PIXEL_FLAG	DB	0
LETTER_FLAG	DB	0
FUNCTION_FLAGS	DB	0
ALT_FLAGS	DW	0
ACTUAL_LENGTH	DB	0
MAX_LENGTH	DB	0
GANG		DB	0
BLINK		DB	0			; BLINK CTR

ENTERPRISE_SCORE	DW	0
KLINGON_SCORE		DW	0

ROW_ADDR	DW	MAX_Y_AXIS DUP(?)

space_data	ends

space_code	segment	public	'space_code'

PAGE
;--- MODULE: Build_Row_Addr	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers ax,cx,di,es
;	ROW_ADDR
; Function
;	1. Build beginning raster line address pointer table
;--- Revision History
;	1/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Build_Row_Addr	proc	near

	mov	ax,ds
	mov	es,ax
	mov	cx,MAX_Y_AXIS/LINE_WRAP_COUNT
	xor	ax,ax
	mov	di,offset ROW_ADDR
brow100:
	mov	bl,LINE_WRAP_COUNT
brow200:
	stosw					; put in beginning line ptr
	add	ax,LINE_STEP_SIZE
	dec	bl
	jne	brow200
	sub	ax,(LINE_WRAP_COUNT*LINE_STEP_SIZE-ROW_SIZE)	; back up + ROW_SIZE
	loop	brow100
	ret

Build_Row_Addr	endp

PAGE
;--- MODULE: Save_Interrupts	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers ax,si,es
;	timer_vec_seg,timer_vec_off,keys_vec_off,keys_vec_seg
; Function
;	1. Save Timer interrupt 08h
;	2. Save Keyboard interrupt 09h
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Save_Interrupts	proc	near

	mov	ax,INT_SEG
	mov	es,ax

	mov	si,TIMER_INT*4			; save timer interrupt
	mov	ax,ES:[si]
	mov	TIMER_VEC_OFF,ax
	mov	ax,ES:[si+2]
	mov	TIMER_VEC_SEG,ax

	mov	si,KEYB_INT*4
	mov	ax,ES:[si]
	mov	KEYS_VEC_OFF,ax			; save keyboard interrupt
	mov	ax,ES:[si+2]
	mov	KEYS_VEC_SEG,ax

	ret
	      
Save_Interrupts	endp

PAGE
;--- MODULE: Restore_Interrupts	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers ax,si,es
; Function
;	1. Restore Timer interrupt 08h to original value
;	2. Restore Keyboard interrupt 09h to original value
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Restore_Interrupts	proc	near

	cli
	mov	ax,INT_SEG
	mov	es,ax

	mov	si,TIMER_INT*4			; restore timer interrupt
	mov	ax,TIMER_VEC_OFF
	mov	ES:[si],ax

	mov	ax,TIMER_VEC_SEG
	mov	ES:[si+2],ax

	mov	al,36h				; set timer 0 to square wave 2 byte load
	out	TIMER_CTRL_PORT,al
	xor	al,al				; restore 18.2 Hz interrupts for timer 0
	out	TIMER0_DATA_PORT,al		; write lsb to timer 0 reg
	out	TIMER0_DATA_PORT,al		; write msb to timer 0 reg

	mov	si,KEYB_INT*4
	mov	ax,KEYS_VEC_OFF			; restore keyboard interrupt
	mov	ES:[si],ax

	mov	ax,KEYS_VEC_SEG
	mov	ES:[SI+2],ax

	sti
	ret
	      
Restore_Interrupts	endp

PAGE
;--- MODULE: Install_Play_Interrupts --------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers ax,si,es
;	timer_vec_seg,timer_vec_off,keys_vec_off,keys_vec_seg
; Function
;	1. Install Timer interrupt 08h for playing the game.
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Install_Play_Interrupts	proc	near

	cli					; SAVE CCP INTERRUPTS
	mov	ax,INT_SEG
	mov	es,ax

	mov	si,TIMER_INT*4			; install play timer interrupt

	mov	ax,offset Play_Interrupt
	mov	ES:[si],ax
	mov	ES:[si+2],cs
    
	sti
	ret
	      
Install_Play_Interrupts	endp

PAGE
;--- MODULE: Reset_Variables	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers all
; Function
;	1. Reset variables to begin the game.
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Reset_Variables	proc	near

	mov	ax,ds
	mov	es,ax
	mov	si,offset ZVARS			; initialize game varables
	mov	di,offset TVARS
	mov	cx,(ZEND-ZVARS)
	cld
	rep	movsb
	call	Clrscn				; clear screen
	call	Stars				; make stars
	call	Draw_Ent			; draw first enterprise
	call	Draw_Kln			; draw first klingon
	and	LETTER_FLAG,NOT(BIT0+BIT1+BIT2+BIT3)
	call	Xor_Left_S			; put s on left
	call	Xor_Right_S			; put s on right
	call	Xor_Left_E			; put e on left 
	call	Xor_Right_E			; put e on right
	mov	SOUND_FLAG,0			; sound off
	ret

Reset_Variables	endp

;--- MODULE: Gmode 		--------------------------------
; Entry
;	NONE
; Exit
;	di =  0, Hercules card detected and set to graphics mode
;	di <> 0, No Hercules card, No action
; Affects
;	Registers	ax,cx,dx,si,di,es
; Function
;	1. Place Display Card in Bitmapped Graphics mode
;	2. Fill screen with zeros to clear it.
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data

Gmode	proc	near

IF DISPLAY_TYPE
	mov	dx,HERC_SOFT_SW
	mov	al,3				; goto FULL mode
	out	dx,al

	xor	ax,ax
	mov	dx,HERC_MODE_REG		; blank display
	out	dx,al

;	initialize the 6845

	mov	si,offset GTABLE
	mov	dx,HERC_CRTC_REG
	cld					; starting from reg. ah=0
parms:
	mov	al,ah
	out	dx,ax				; out register number
	inc	dx
	lodsb
	out	dx,al				; output data
	dec	dx
	inc	ah				; next reg.
	cmp	ah,12				; done ?
	jne	parms

	mov	es,DOT_SEG
	xor	ax,ax				; fill 1st screen with zeros
	xor	di,di
	mov	cx,4000h			; clear 16K words
	cld
	rep	stosw

;	scrn_on, page 0

	mov	al,GRPH	or SCRN_ON		; turn screen on in graphics mode
	mov	dx,HERC_MODE_REG
	out	dx,al
ELSE
	mov	ax,06
	int	10H				; RIOS call for 640 X 200 graphics
ENDIF

	ret

Gmode	endp

space_code	ends
	end
