page	80,128
title	GRAVITY.ASM	1/10/85	bjs

include		GENERAL.EQU
include		PLANET.EQU

PUBLIC	Update_Gravity

EXTRN	XDIS:word			; table of x displacements for objects
EXTRN	YDIS:word			; table of y displacements for objects
EXTRN	XVELL:word			; table of x velocity low word for objects
EXTRN	XVEL:word			; table of x velocity word for objects
EXTRN	YVELL:word			; table of y velocity low word for objects
EXTRN	YVEL:word			; table of y velocity word for objects

space_data	segment	public	'space_data'

space_data	ends

space_code	segment	public	'space_code'

;--- MODULE:	Update_Gravity	--------------------------------
; Entry
;	si = object number
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,di
; Function
;	1. Update gravity on all objects
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Update_Gravity	proc	near

	mov	ax,XDIS[si]			; delta x
	sub	ax,PLANET_X			; PLANET position
	js	ux_neg
	mov	dx,YDIS[si]			; delta y
	sub	dx,PLANET_Y			; PLANET position
	js	ux_pos_y_neg

ux_pos_y_pos:
	call	calc_gravity
	neg	bx
	neg	cx
	jmp	ugrav800

ux_pos_y_neg:
	neg	dx				; make delta y pos
	call	calc_gravity
	neg	bx
	jmp	ugrav800

ux_neg:
	neg	ax				; make delta x pos
	mov	dx,YDIS[si]			; delta y
	sub	dx,PLANET_Y			; PLANET position
	js	ux_neg_y_neg
ux_neg_y_pos:
	call	calc_gravity
	neg	cx
	jmp	ugrav800

ux_neg_y_neg:
	neg	dx				; make delta y pos
	call	calc_gravity

ugrav800:
	mov	ax,bx
	cwd
	add	XVELL[si],ax
	adc	XVEL[si],dx
	mov	ax,cx
	cwd
	add	YVELL[si],ax
	adc	YVEL[si],dx
	ret

Update_Gravity	endp

PAGE
;--- MODULE:	calc_gravity	--------------------------------
; Entry
;	ax = delta x
;	dx = delta y
; Exit
;	bx = x accel.
;	cx = x accel.
; Affects
;	Register	bx,cx,di
; Function
;	1. Calculate Bowl Gravity
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

calc_gravity	proc	near

	mov	bx,ax
	shl	bx,1
	shl	bx,1
	shl	bx,1
	mov	cx,dx				; bowl gravity
	shl	cx,1
	shl	cx,1
	shl	cx,1
	ret

calc_gravity	endp

space_code	ends
	end
			