page	80,128
title	DRAW.ASM	3/27/85	bjs

;	All routines that write to the screen are in this file

include		GENERAL.EQU

PUBLIC	Point
PUBLIC	Pixel
PUBLIC	Draw_Array
PUBLIC	Draw_Kln
PUBLIC	Draw_Ent
PUBLIC	Erase_Kln
PUBLIC	Erase_Ent
PUBLIC	Xor_Ent
PUBLIC	Xor_Kln
PUBLIC	Xor_Torp
PUBLIC	Xor_Left_S
PUBLIC	Xor_Right_S
PUBLIC	Xor_Left_E
PUBLIC	Xor_Right_E
PUBLIC	Xor_Ascii
PUBLIC	Display_String
PUBLIC	Display_Decimal
PUBLIC	Xor_Title_Piece
PUBLIC	Clrscn
PUBLIC	Draw_The_Planet
PUBLIC	Ebars
PUBLIC	Expdrw

EXTRN	LETTER_FLAG:byte
EXTRN	ROW_ADDR:word
EXTRN	DOT_SEG:word
EXTRN	KLIN:word	
EXTRN	ENTR:word	
EXTRN	XDRAWN:word	
EXTRN	YDRAWN:word	
EXTRN	ADRAWN:word	
EXTRN	ETOR:word	
EXTRN	KTOR:word	
EXTRN	DRAWN_FLAG:word	
EXTRN	CHARACTER_SET:word	
EXTRN	TITLE_X_DIS:word	
EXTRN	TITLE_Y_DIS:word	
EXTRN	TITLE_TYPE:word	
EXTRN	PLANET_PICTURES:word	
EXTRN	ENRGY:word	
EXTRN	FLAGS:word	
EXTRN	UFLG:word	
EXTRN	EFLG:word	
EXTRN	XDIS:word	
EXTRN	YDIS:word	
EXTRN	ANGLE:word	
EXTRN	SHLDS:word
EXTRN	EXPD:word
EXTRN	EXPS:word
EXTRN	XPOS:word
EXTRN	YPOS:word

space_data	segment	public	'space_data'

; ****** BIT MASK TABLE ******

BITS		DB	10000000B
		DB	01000000B
		DB	00100000B
		DB	00010000B
		DB	00001000B
		DB	00000100B
		DB	00000010B
		DB	00000001B

space_data	ends


space_code	segment	public 	'space_code'

PAGE
;--- MODULE:	Point		--------------------------------
; Entry
;	XPOS = x position
;	YPOS = y position
; Exit
;	al = bit mask
;	di = ptr to byte of pixel
;	es = segment to pixel
; Affects
;	Register	ax,bx,di
; Function
;	1. Xor point at XPOS,YPOS position on screen
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Point	proc	near

	mov	es,DOT_SEG
	mov	bx,XPOS
	mov	dx,YPOS
						; fall thru to pixel
Point	endp

PAGE
;--- MODULE:	Pixel		--------------------------------
; Entry
;	bx = x position
;	dx = y position
;	es = dot segment
; Exit
;	al = bit mask
;	di = ptr to byte of pixel
; Affects
;	Register	ax,bx,di
; Function
;	1. Xor pixel at bx,dx position on screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Pixel	proc	near
			  
	mov	ax,bx
	shr	ax,1
	shr	ax,1
	shr	ax,1

	mov	di,dx
	shl	di,1				; adjust for words
	mov	di,ROW_ADDR[di]			; base of row
	add	di,ax

	and	bx,07H
	mov	al,BITS[bx]			; bit to xor
	xor	ES:[di],al			; xor pixel on screen
	ret

Pixel	endp

PAGE
;--- MODULE:	Draw_Array	--------------------------------
; Entry
;	ax = x position
;	dx = y position
;	ch = array heigth
;	bp = picture offset
; Exit
;	es = dot segment
; Affects
;	Register	ax,bx,cx,dx,di,bp,es
; Function
;	1. Xor draw array 16 bits wide by ch lines high 
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Draw_Array	proc	near

	mov	es,DOT_SEG
	xor	bx,bx
	mov	bl,ch				; center array
 	shr	bx,1
	sub	ax,bx
	jns	dary100				; wrap ?
	add	ax,MAX_X_AXIS			; yes - adjust
dary100:
	mov	cl,al
	and	cl,07h				; shift count
	shr	ax,1
	shr	ax,1
	shr	ax,1				; column #
	mov	di,dx				; center array on y axis

	sub	di,bx
	jns	dary200				; wrap ?
	add	di,MAX_Y_AXIS			; yes - adjust
dary200:
	shl	di,1				; adjust for words
	mov	di,ROW_ADDR[di]			; row base addr
	add	di,ax				; add in column

	push	si				; use si as source of the picture
	mov	si,bp
	mov	bx,LINE_STEP_SIZE-2		; 8K incrementer
	mov	bp,DOT_SIZEB			; max dot buffer size

	cld
dary300:
	lodsw					; get word of the array

	xor	dx,dx				; shift of the the right reg.
	mov	dh,al
	shr	ax,cl				; shift original cl shift count
	shr	dx,cl				; shift out bits into dl
	xor	ES:[di],ah			; put original on screen
	inc	di
	xor	ES:[di],al
	inc	di
	xor	ES:[di],dl			; put shift out bits over one word
	add	di,bx				; skip down one line
	cmp	di,bp				; out of buffer
	jb	dary400				; if no carry still in mode 4
	sub	di,(LINE_WRAP_COUNT*LINE_STEP_SIZE-ROW_SIZE)		; rewind minus length of line
dary400:
	dec	ch				; done full heigth
	jne	dary300
	pop	si
	ret

Draw_Array	endp

PAGE
;--- MODULE:	Draw_Kln		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. If Klingon is not visible draw it 
;--- Revision History
;	1/21/85	bjs   
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Draw_Kln	proc	near

	test	byte ptr [DRAWN_FLAG+KLNOBJ],BIT0
	je	Xor_Kln				; if invisible draw
	ret

Draw_Kln	endp
		       
PAGE
;--- MODULE:	Draw_Ent	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. If Enterprise is not visible draw it 
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Draw_Ent	proc	near

	test	byte ptr [DRAWN_FLAG+ENTOBJ],BIT0
	je	Xor_Ent				; if invisible draw
	ret

Draw_Ent	endp

PAGE
;--- MODULE:	Erase_Kln		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. If Klingon is visible erase it 
;--- Revision History
;	1/21/85	bjs   
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Erase_Kln	proc	near

	test	byte ptr [DRAWN_FLAG+KLNOBJ],BIT0
	jne	Xor_Kln				; if visible erase
	ret

Erase_Kln	endp
		       
PAGE
;--- MODULE:	Erase_Ent	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. If Enterprise is visible erase it 
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Erase_Ent	proc	near

	test	byte ptr [DRAWN_FLAG+ENTOBJ],BIT0
	jne	Xor_Ent				; if visible erase
	ret

Erase_Ent	endp

PAGE
;--- MODULE:	Xor_Kln		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw Klingon at its position 
;--- Revision History
;	12/15/84	bjs   
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Kln	proc	near

	mov	si,KLNOBJ
	mov	bp,offset KLIN			; klingon pictures
	jmp	xore200

Xor_Kln	endp
		       
PAGE
;--- MODULE:	Xor_Ent		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw Enterprise at its position 
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Ent	proc	near

	mov	si,ENTOBJ
	mov	bp,offset ENTR			; enterprise pictures
xore200:
	mov	ax,XDRAWN[si]
	mov	dx,YDRAWN[si]
	mov	bl,byte ptr ADRAWN[si]
	add	bl,8				; center around angle
	and	bx,0F0H				; 16 angles on rocket
	shl	bx,1				; 32 byte to a rocket picture
	add	bp,bx
	mov	ch,ROCKET_HEIGTH
	jmp	xort500

Xor_Ent	endp

PAGE
;--- MODULE:	Xor_Torp	--------------------------------
; Entry
;	si=02,04,06,08,10,12,14	enterprise torps
;	si=18,20,22,24,26,28,30	klingon torps
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw Torpode at its position 
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Torp	proc	near

	mov	ax,XDRAWN[si]			; old torp position
	mov	dx,YDRAWN[si]
	mov	bl,byte ptr ADRAWN[si]
	mov	ch,TORP_HEIGTH			; array heigth
	mov	bp,offset ETOR			; default enterprise torps
	cmp	si,KLNOBJ			; klingon torps ?
	jb	xort200				; no
	mov	bp,offset KTOR			; klingon torps
xort200:
	add	bl,16
	and	bx,0E0H				; correct angle of torp
	shr	bx,1
	add	bp,bx
xort500:
	xor	byte ptr DRAWN_FLAG[si],BIT0	; toggle object state
	jmp	Draw_Array			; go draw rocket

Xor_Torp	endp

PAGE
;--- MODULE:	Xor_Left_S	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw "S" on left side of screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Left_S	proc	near

	mov	ax,CHAR_WIDTH			; put s on left side
	mov	dx,MAX_Y_AXIS-2*CHAR_HEIGTH	; bottom of screen, above E bar
	mov	bl,'S'				; ASCII 'S'
	xor	LETTER_FLAG,BIT0
	jmp	Xor_Ascii

Xor_Left_S	endp


PAGE
;--- MODULE:	Xor_Right_S	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw "S" on right side of screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Right_S	proc	near

	mov	ax,MAX_X_AXIS-CHAR_WIDTH	; put s on right side 
	mov	dx,MAX_Y_AXIS-2*CHAR_HEIGTH	; bottom of screen, above E bar
	mov	bl,'S'				; ascii 'S'
	xor	LETTER_FLAG,BIT1
	jmp	Xor_Ascii

Xor_Right_S	endp

PAGE
;--- MODULE:	Xor_Left_E	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw "E" on left side of screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Left_E	proc	near

	mov	ax,CHAR_WIDTH			; put e on left side
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH	; bottom of screen
	mov	bl,'E'				; ascii 'E'
	xor	LETTER_FLAG,BIT2
	jmp	Xor_Ascii

Xor_Left_E	endp

PAGE
;--- MODULE:	Xor_Right_E	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Xor draw "E" on right side of screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Right_E	proc	near

	mov	ax,MAX_X_AXIS-CHAR_WIDTH	; put e on right side
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH	; bottom of screen
	mov	bl,'E'				; ascii 'E'
	xor	LETTER_FLAG,BIT3
	jmp	Xor_Ascii

Xor_Right_E	endp

PAGE
;--- MODULE:	Xor_Ascii	--------------------------------
; Entry
;	bl = ascii char
;	ax = x position
;	dx = y position
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Draw 10 X 16 Char on screen
;	2. Move to next char position
;	3. Handles CR and LF
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Ascii	proc	near

	cmp	bl,CR				; a return
	jne	xora100				; no
	mov	ax,CHAR_WIDTH			; skip left char
	jmp	xora500
xora100:
	cmp	bl,LF				; a line feed
	jne	xora200				; no
	add	dx,CHAR_HEIGTH
	jmp	xora500
xora200:
	cmp	bl,1FH				; half space ?
	jne	xora250				; no
	add	ax,CHAR_WIDTH/2			; move right by 1/2 of a char
	jmp	xora400

xora250:
	cmp	bl,20H				; a space ?
	je	xora300				; yes - then skip right

	mov	ch,CHAR_HEIGTH			; character heigth
	mov	bp,offset CHARACTER_SET		; index into copy of chars
	and	bx,07FH				; 7 bit ascii

IF DISPLAY_TYPE
	mov	cl,5				; 32 bytes/char for Hercules card
ELSE
	mov	cl,4				; 16 bytes/char for Color card
ENDIF
	shl	bx,cl				; 32 byte to a char picture
	add	bp,bx				; index to correct char
	push	ax
	push	dx
	call	Draw_Array
	pop	dx
	pop	ax
xora300:
	add	ax,CHAR_WIDTH			; chars are this wide
xora400:
	cmp	ax,MAX_X_AXIS			; check for wrap
	jb	xora500
	sub	ax,MAX_X_AXIS			; if wrap down a char line
	add	dx,CHAR_HEIGTH			; chars are this high
	cmp	dx,MAX_Y_AXIS
	jb	xora500
	sub	dx,MAX_Y_AXIS			; if bottom move to top
xora500:
	ret

Xor_Ascii	endp

PAGE
;--- MODULE:	Display_String	--------------------------------
; Entry
;	ax = x position
;	dx = y position
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Display ASCII String.
;	2. Stops on 0 byte.
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Display_String	proc	near

	jmp	diss200
diss100:
	call	Xor_Ascii
diss200:
	pop	bp
	mov	bl,CS:[bp]
	inc	bp
	push	bp
	and	bl,bl
	jnz	diss100
	ret

Display_String	endp

PAGE
;--- MODULE:	Display_Decimal	--------------------------------
; Entry
;	dx = binary number
;	si = x position
;	di = y position
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Display Decimal number at ax,dx
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Display_Decimal	proc	near

	mov	ax,dx
	xor	dx,dx
	mov	cx,10
	div	cx
	push	dx
	mov	dx,ax
	or	ax,ax
	jz	ddec400
	call	Display_Decimal
ddec400:
	pop	bx
	add	bl,30h
	mov	ax,si
	mov	dx,di
	call	Xor_Ascii
	mov	si,ax
	mov	di,dx
	ret

Display_Decimal	endp

PAGE
;--- MODULE:	Xor_Title_Piece	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Display all the pieces in the title
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Xor_Title_Piece	proc	near

	push	cx
	mov	ax,TITLE_X_DIS[si]		; x position of piece
	mov	dx,TITLE_Y_DIS[si]		; y position of piece
	mov	bp,TITLE_TYPE[si]		; type of piece to draw

IF DISPLAY_TYPE
	mov	cl,5				; 32 bytes/title for Hercules card
ELSE
	mov	cl,4				; 16 bytes/title for Color card
ENDIF

	shl	bp,cl				; 32 byte to a char picture
	add	bp,offset CHARACTER_SET		; index into copy of chars
	mov	ch,CHAR_HEIGTH			; title piece heigth
	call	Draw_Array
	pop	cx
	ret

Xor_Title_Piece	endp

PAGE
;--- MODULE: Clrscn		--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Registers ax,cx,di.es
; Function
;	1. Clear the Hi-res screen.
;--- Revision History
;	12/10/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Clrscn	proc	near

	mov	es,DOT_SEG
	mov	cx,DOT_SIZEW
	xor	ax,ax
	xor	di,di
	cld
	rep	stosw
	ret

Clrscn	endp

PAGE
;--- MODULE:	Draw_The_Planet	--------------------------------
; Entry
;	al = equal state to draw
;	bx = x position
;	dx = y position
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,es
; Function
;	1. Draw the Planet
;	2. Planet is always drawn on byte boundary with no wrap
;--- Revision History
;	12/12/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Draw_The_Planet	proc	near

	mov	es,DOT_SEG
	and	ax,0FH				; 16 pictures
	mov	si,ax
	mov	cl,7				; 64 words/picture
	shl	si,cl
	add	si,offset PLANET_PICTURES	; source for Planet's picture

	sub	bx,16				; center 32 bit wide Planet
	sub	dx,16

	mov	di,dx
	shl	di,1				; adjust for words

	mov	di,ROW_ADDR[di]			; base address of row

	shr	bx,1
	shr	bx,1
	shr	bx,1
	add	di,bx				; add in column position

	mov	cx,PLANET_HEIGTH		; PLANET 32 lines high
	mov	bx,LINE_STEP_SIZE-2		; 8K incrementer
	mov	dx,(LINE_WRAP_COUNT*LINE_STEP_SIZE-ROW_SIZE)		; rewind minus length of line
	mov	bp,DOT_SIZEB			; max dot buffer size

	cld
dplanet100:
	lodsw
	xchg	ah,al
	mov	ES:[di],ax
	inc	di
	inc	di
	lodsw
	xchg	ah,al
	mov	ES:[di],ax

	add	di,bx
	cmp	di,bp				; out of video buffer
	jb	dplanet200			; no
	sub	di,dx				; yes - rewind + one scan line
dplanet200:
	loop	dplanet100
	ret

Draw_The_Planet	endp

PAGE
;--- MODULE:	Ebars		--------------------------------
; Entry
;	si = object #
; Exit
;	NONE
; Affects
;	Register	ax,cx,dx,di,es
; Function
;	1. Draw status bars at the bottom of the screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Ebars	proc	near

	mov	es,DOT_SEG
	cld					; draw from left to right
	mov	al,byte ptr SHLDS+ENTOBJ
	or	al,al
	js	ebar250				; neg don't show

	mov	di,ROW_ADDR[2*(MAX_Y_AXIS-2*CHAR_HEIGTH)]	; center up in the middle off left S
	add	di,3				; start in byte column 3

	mov	cl,al
	and	cx,0FH				; low 4 bits
	mov	dx,0FFFFH				       
	shr	dx,cl
	not	dx
	mov	cl,al
	xor	ch,ch
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1				; # of words
	or	cx,cx
	je	ebar200				; if shlds < 16
	mov	ax,0FFFFH 			; solid bar
	rep	stosw
ebar200:
	mov	ax,dx
	xchg	al,ah
	stosw
	xor	ax,ax
	stosw 
ebar250:
	mov	al,byte ptr ENRGY+ENTOBJ
	or	al,al
	js	ebar450				; neg don't show

	mov	di,ROW_ADDR[2*(MAX_Y_AXIS-CHAR_HEIGTH)]	; center just to the rt of left e
	add	di,3				; start in byte column 3

	mov	cl,al
	and	cx,0FH				; low 4 bits
	mov	dx,0ffffh
	shr	dx,cl
	not	dx
	mov	cl,al
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1				; # of words
	or	cx,cx
	je	ebar400				; if shlds < 16
	mov	ax,0FFFFH			; solid bar
	rep	stosw
ebar400:
	mov	ax,dx
	xchg	al,ah
	stosw
	xor	ax,ax
	stosw
ebar450:
	std					; draw from right to left
	mov	al,byte ptr SHLDS+KLNOBJ
	or	al,al
	js	ebar650				; neg don't show

	mov	di,ROW_ADDR[2*(MAX_Y_AXIS-2*CHAR_HEIGTH)]	; center just to the lf of right s
	add	di,ROW_SIZE-5			; byte in from rt

	mov	cl,al
	and	cx,0FH				; low 4 bits
	mov	dx,0FFFFH
	shl	dx,cl
	not	dx
	mov	cl,al
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1				; # of words
	or	cx,cx
	je	ebar600				; if shlds < 16
	mov	ax,0FFFFH			; solid bar
	rep	stosw
ebar600:
	mov	ax,dx
	xchg	al,ah
	stosw
	xor	ax,ax
	stosw
ebar650:
     	mov	al,byte ptr ENRGY+KLNOBJ
	or	al,al
	js	ebar850				; neg don't show

	mov	di,ROW_ADDR[2*(MAX_Y_AXIS-CHAR_HEIGTH)]	; center just to the lf of right e
	add	di,ROW_SIZE-5			; byte in from rt

	mov	cl,al
	and	cx,0fh				; low 4 bits
	mov	dx,0FFFFH
	shl	dx,cl
	not	dx
	mov	cl,al
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1				; # of words
	or	cx,cx
	je	ebar800				; if shlds < 16
	mov	ax,0FFFFH			; solid bar
	rep	stosw
ebar800:
	mov	ax,dx
	xchg	al,ah
	stosw
	xor	ax,ax
	stosw
ebar850:
	cld
	ret

Ebars	endp
PAGE
;--- MODULE:	explod		--------------------------------
; Entry
;	si = object to explode
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,di,bp,es
; function
;	1. Explode routine, update explosions
;--- Revision History
;	12/19/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Expdrw	proc	near

	mov	bp,offset EXPD			; explosition pictures
	mov	al,byte ptr EXPS[si]		; get explosition state
	and	ax,38H				; only 8 explosition pictures
	shl	ax,1				; a word wide
	add	bp,ax				; index to correct picture
	mov	ax,XDIS[si]			; explosition position
	mov	dx,YDIS[si]
	mov	ch,EXPLODE_HEIGTH		; explosition size
	jmp	Draw_Array

Expdrw	endp

space_code	ends
	end
