page   80,128
title	ATTRACT.ASM	3/27/85	bjs

include		GENERAL.EQU
include		PLANET.EQU
include		KEYS.EQU
include		PCIO.EQU

MAX_X_TITLES		EQU	MAX_X_AXIS/TITLE_WIDTH
MAX_Y_TITLES		EQU	MAX_Y_AXIS/TITLE_HEIGTH

TITLE_MOVE_COUNT	EQU	30

PUBLIC	Attract_Mode
PUBLIC	Pause_Test
PUBLIC	TITLE_X_DIS
PUBLIC	TITLE_X_DISL
PUBLIC	TITLE_Y_DIS
PUBLIC	TITLE_Y_DISL
PUBLIC	TITLE_TYPE
PUBLIC	TITLE_X_VEL
PUBLIC	TITLE_Y_VEL
PUBLIC	TITLE_X_VELL
PUBLIC	TITLE_Y_VELL
PUBLIC	TOTAL_PIECES
PUBLIC	PAUSE_ENABLE

EXTRN	Xor_Ent:near
EXTRN	Xor_Kln:near
EXTRN	Turn_Off_Sound:near
EXTRN	Reset_Keyboard:near
EXTRN	Clrscn:near
EXTRN	Stars:near
EXTRN	Display_String:near
EXTRN	Display_Decimal:near
EXTRN	Xor_Title_Piece:near
EXTRN	Random:near
EXTRN	Draw_The_Planet:near
EXTRN	Play_Spacewar:near
EXTRN	Exit:near
EXTRN	Keybdi:near

EXTRN	AUTO_FLAG:byte
EXTRN	PLANET_ENABLE:byte
EXTRN	PLANET_STATE:byte
EXTRN	BLINK:byte
EXTRN	KEYBAM:byte
EXTRN	FUNCTION_FLAGS:byte
EXTRN	SOUND_ENABLE:byte

EXTRN	Enterprise_Score:word
EXTRN	Klingon_Score:word
EXTRN	STACK_END:word
EXTRN	XDRAWN:word
EXTRN	YDRAWN:word
EXTRN	ADRAWN:word

pc_time		STRUC
	DUMMY		DB	06CH DUP(?)
	TIMER_LOW	DW	?
	TIMER_HIGH	DW	?
	TIMER_OFL	DB	?
pc_time		ENDS

space_data	segment	public	'space_data'

PAUSE_ENABLE	DB	0					; if =1 then pause

TITLE_TYPE	DW	0FH,0EH,11H,0EH,10H,0EH,12H,0EH,0FH,0EH,11H	   	; S
		DW	11H,0EH,0EH,0EH,0FH,0EH,10H,0EH,11H			; P
		DW	11H,0EH,0EH,0EH,0FH,0EH,11H,0EH,0EH,0EH,0EH,11H	       	; A
		DW	11H,0EH,12H,0EH,0EH,0EH,0FH,0EH,11H			; C
		DW	11H,0EH,12H,0EH,0EH,11H,0EH,0FH,0EH,11H			; E
		DW	0FH,0EH,0EH,0EH,11H,12H,10H,0FH,11H,12H,0EH,0EH,0EH,0FH	; W
		DW	11H,0EH,0EH,0EH,0FH,0EH,11H,0EH,0EH,0EH,0EH,11H	       	; A
		DW	11H,0EH,0EH,0EH,0FH,0EH,10H,0EH,11H,10H,12H,10H,12H    	; R

TOTAL_PIECES	EQU	($-TITLE_TYPE)/2

TBX		EQU	(MAX_X_TITLES-(8*4))/2		; CENTER X
							; There are 8 chars in 'SPACEWAR'
							;  each char is four title blocks wide
 
TBY		EQU	(MAX_Y_TITLES-5)/2	       	; CENTER Y
							;  title letters are five title blocks high

TX00		EQU	TBX+0

TITLE_X		DW	TITLE_WIDTH*(0+TX00),TITLE_WIDTH*(1+TX00)
		DW	TITLE_WIDTH*(2+TX00),TITLE_WIDTH*(2+TX00)
		DW	TITLE_WIDTH*(2+TX00),TITLE_WIDTH*(1+TX00)
		DW	TITLE_WIDTH*(0+TX00),TITLE_WIDTH*(0+TX00)
		DW	TITLE_WIDTH*(0+TX00),TITLE_WIDTH*(1+TX00)
		DW	TITLE_WIDTH*(2+TX00)				; S
TX01		EQU	TX00+4
		DW	TITLE_WIDTH*(0+TX01),TITLE_WIDTH*(0+TX01)
		DW	TITLE_WIDTH*(0+TX01),TITLE_WIDTH*(0+TX01)
		DW	TITLE_WIDTH*(0+TX01),TITLE_WIDTH*(1+TX01)
		DW	TITLE_WIDTH*(2+TX01),TITLE_WIDTH*(2+TX01)
		DW	TITLE_WIDTH*(2+TX01)				; P
TX02		EQU	TX01+4
		DW	TITLE_WIDTH*(0+TX02),TITLE_WIDTH*(0+TX02)
		DW	TITLE_WIDTH*(0+TX02),TITLE_WIDTH*(0+TX02)
		DW	TITLE_WIDTH*(0+TX02),TITLE_WIDTH*(1+TX02)
		DW	TITLE_WIDTH*(2+TX02),TITLE_WIDTH*(2+TX02)
		DW	TITLE_WIDTH*(2+TX02),TITLE_WIDTH*(1+TX02)
		DW	TITLE_WIDTH*(2+TX02),TITLE_WIDTH*(2+TX02)	; A
TX03		EQU	TX02+4
		DW	TITLE_WIDTH*(2+TX03),TITLE_WIDTH*(1+TX03)
		DW	TITLE_WIDTH*(0+TX03),TITLE_WIDTH*(0+TX03)
		DW	TITLE_WIDTH*(0+TX03),TITLE_WIDTH*(0+TX03)
		DW	TITLE_WIDTH*(0+TX03),TITLE_WIDTH*(1+TX03)
		DW	TITLE_WIDTH*(2+TX03)				; C
TX04		EQU	TX03+4
		DW	TITLE_WIDTH*(2+TX04),TITLE_WIDTH*(1+TX04)
		DW	TITLE_WIDTH*(0+TX04),TITLE_WIDTH*(0+TX04)
		DW	TITLE_WIDTH*(0+TX04),TITLE_WIDTH*(1+TX04)
		DW	TITLE_WIDTH*(0+TX04),TITLE_WIDTH*(0+TX04)
		DW	TITLE_WIDTH*(1+TX04),TITLE_WIDTH*(2+TX04)	; E
TX05		EQU	TX04+4
		DW	TITLE_WIDTH*(3+TX05),TITLE_WIDTH*(3+TX05)
		DW	TITLE_WIDTH*(3+TX05),TITLE_WIDTH*(3+TX05)
		DW	TITLE_WIDTH*(3+TX05),TITLE_WIDTH*(2+TX05)
		DW	TITLE_WIDTH*(2+TX05),TITLE_WIDTH*(1+TX05)
		DW	TITLE_WIDTH*(1+TX05),TITLE_WIDTH*(0+TX05)
		DW	TITLE_WIDTH*(0+TX05),TITLE_WIDTH*(0+TX05)
		DW	TITLE_WIDTH*(0+TX05),TITLE_WIDTH*(0+TX05)	; W
TX06		EQU	TX05+5
		DW	TITLE_WIDTH*(0+TX06),TITLE_WIDTH*(0+TX06)
		DW	TITLE_WIDTH*(0+TX06),TITLE_WIDTH*(0+TX06)
		DW	TITLE_WIDTH*(0+TX06),TITLE_WIDTH*(1+TX06)
		DW	TITLE_WIDTH*(2+TX06),TITLE_WIDTH*(2+TX06)
		DW	TITLE_WIDTH*(2+TX06),TITLE_WIDTH*(1+TX06)
		DW	TITLE_WIDTH*(2+TX06),TITLE_WIDTH*(2+TX06)	; A
TX07		EQU	TX06+4
		DW	TITLE_WIDTH*(0+TX07),TITLE_WIDTH*(0+TX07)
		DW	TITLE_WIDTH*(0+TX07),TITLE_WIDTH*(0+TX07)
		DW	TITLE_WIDTH*(0+TX07),TITLE_WIDTH*(1+TX07)
		DW	TITLE_WIDTH*(2+TX07),TITLE_WIDTH*(2+TX07)
		DW	TITLE_WIDTH*(2+TX07),TITLE_WIDTH*(1+TX07)
		DW	TITLE_WIDTH*(1+TX07),TITLE_WIDTH*(2+TX07)
		DW	TITLE_WIDTH*(2+TX07)				; R

TITLE_Y		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(4+TBY)
		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY)				; S

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(2+TBY)				; P

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(3+TBY),TITLE_HEIGTH*(4+TBY)	; A

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(4+TBY)
		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY)				; C

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(4+TBY)
		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(1+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)	; E

		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(4+TBY)
		DW	TITLE_HEIGTH*(3+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(4+TBY)
		DW	TITLE_HEIGTH*(3+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(1+TBY),TITLE_HEIGTH*(0+TBY)	; W

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(3+TBY),TITLE_HEIGTH*(4+TBY)	; A

		DW	TITLE_HEIGTH*(4+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(0+TBY)
		DW	TITLE_HEIGTH*(0+TBY),TITLE_HEIGTH*(1+TBY)
		DW	TITLE_HEIGTH*(2+TBY),TITLE_HEIGTH*(2+TBY)
		DW	TITLE_HEIGTH*(3+TBY),TITLE_HEIGTH*(3+TBY)
		DW	TITLE_HEIGTH*(4+TBY)				; R

TITLE_X_DIS	DW	90 DUP(0)

TITLE_Y_DIS	DW	90 DUP(0)

TITLE_X_DISL	DW	90 DUP(0)

TITLE_Y_DISL	DW	90 DUP(0)

TITLE_X_VEL	DW	90 DUP(0)

TITLE_Y_VEL	DW	90 DUP(0)

TITLE_X_VELL	DW	90 DUP(0)

TITLE_Y_VELL	DW	90 DUP(0)

space_data	ends

PAGE
space_code	segment	public	'space_code'

;--- MODULE:	Attract_Mode	--------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all registers
; Function
;	1. Display exploding SPACEWAR
;	2. Display Keys and Instructions
;	3. Watch function keys for changes to game modes
;	4. Start a game
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Attract_Mode	proc	near

	CLI
	mov	sp,offset STACK_END

	mov	PAUSE_ENABLE,0			; start with no pause
	call	Turn_Off_Sound			; TURN SOUND OFF
	call	Reset_Keyboard
	call	install_attract_interrupts
	sti

	call	Clrscn
	call	Stars
	call	display_game_mode
attact_a_la_mode:
	call	display_copyright
	call	placing_title
	call	first_movement
	call	move_title			; move the pieces
	call	delay_some			; delay
	call	display_copyright		; xor it off
	call	game_instructions
	call	placing_title			; xor it off
	call	delay_some2			; delay
	call	game_instructions		; xor it off
	call	key_instructions
	call	delay_some2			; delay
	call	key_instructions		; XOR IT OFF
	call	user_supported
	call	delay_some2			; delay
	call	user_supported			; XOR IT OFF
	jmp	attact_a_la_mode

Attract_Mode	endp

PAGE
;--- MODULE:	display_copyright ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all registers
; Function
;	1. Display copyright and scores
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

display_copyright	proc	near

	mov	ax,CHAR_WIDTH*((MAX_X_CHARS-5)/2)	; x,y for version number
	mov	dx,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+0)
	call	Display_String
	DB	'V1.50',00
	mov	ax,CHAR_WIDTH*((MAX_X_CHARS-28)/2)	; x,y for copyright
	mov	dx,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+2)
	call	Display_String
	DB	'COPYRIGHT  ',7FH,' 1985  B SEILER.',00

SHIP_POSITION		EQU	16	

	mov	XDRAWN+ENTOBJ,CHAR_WIDTH*SHIP_POSITION	; x,y for ent score
	mov	YDRAWN+ENTOBJ,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+4)
	mov	byte ptr ADRAWN+ENTOBJ,80H
	call	Xor_Ent
	mov	ax,CHAR_WIDTH*(SHIP_POSITION+1)		; ' = '
	mov	dx,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+4)
	call	Display_String
	DB	' = ',0
	mov	si,ax
	mov	di,dx
	mov	dx,Enterprise_Score
	call	Display_Decimal
	mov	XDRAWN+KLNOBJ,CHAR_WIDTH*(MAX_X_CHARS-SHIP_POSITION-6)	; x,y for kln score
	mov	YDRAWN+KLNOBJ,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+4)
	mov	byte ptr ADRAWN+KLNOBJ,80H
	call	Xor_Kln
	mov	ax,CHAR_WIDTH*(MAX_X_CHARS-SHIP_POSITION-5)		; ' = '
	mov	dx,CHAR_HEIGTH*(((3*MAX_Y_CHARS)/4)+4)
	call	Display_String
	DB	' = ',0
	mov	si,ax
	mov	di,dx
	mov	dx,Klingon_Score
	call	Display_Decimal
	ret
			
display_copyright	endp

PAGE
;--- MODULE:	placing_title	 ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all registers
; Function
;	1. Set up Title	variables
;	2. Display Title pieces
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

placing_title	proc	near

	mov	cx,TOTAL_PIECES
	xor	si,si				; first piece
attr100:
	mov	ax,word ptr TITLE_X[si]		; copy initial position
	mov	TITLE_X_DIS[si],ax
	mov	ax,TITLE_Y[si]
	mov	TITLE_Y_DIS[si],ax
	xor	ax,ax
	mov	TITLE_X_DISL[si],ax		; zero low word
	mov	TITLE_Y_DISL[si],ax
	call	Xor_Title_Piece
	inc	si
	inc	si
	loop	attr100
	ret

placing_title	endp

PAGE
;--- MODULE:	first_movement	 ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all registers
; Function
;	1. Set piece velocities
;	2. Move the title pieces
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

first_movement	proc	near

	mov	cx,TOTAL_PIECES
	xor	si,si				; first piece
attr500:
	call	Random				; random angle
IFE DISPLAY_TYPE
	sar	ax,1
ENDIF
	mov	TITLE_X_VEL[si],ax		; random velocity direction
	call	Random				; random angle
IFE DISPLAY_TYPE
	sar	ax,1
ENDIF
	mov	TITLE_Y_VEL[si],ax
	inc	si
	inc	si
	loop	attr500
	call	delay_some			; delay
	call	move_title			; move the pieces

	mov	cx,TOTAL_PIECES			; reverse motion
	xor	si,si
attr1000:
	neg	TITLE_X_VEL[si]
	neg	TITLE_Y_VEL[si]
	inc	si
	inc	si
	loop	attr1000
	ret
		     
first_movement	endp

PAGE
;--- MODULE:	delay_some	 ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,cx
; Function
;	1. Software wait loops
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

WAIT_DELAY		EQU	8

delay_some2	proc	near

	call	delay_some
delay_some:
	call	Pause_Test
	mov	cx,WAIT_DELAY			; delay
delays100:
	xor	ax,ax
delays200:
	dec	ax
	jne	delays200
	loop	delays100
	ret

delay_some2	endp

PAGE
;--- MODULE:	move_title	 ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all
;		TITLE_X_DIS,TITLE_Y_DIS
;      		TITLE_X_VEL,TITLE_X_VEL
; Function
;	1. Move all title pieces
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

move_title	proc	near

	mov	cx,TITLE_MOVE_COUNT		; number of times to move
movt100:
	xor	si,si				; start at first piece
movt200:
	call	Pause_Test			; check for pause

	call	Xor_Title_Piece			; erase piece	
	mov	ax,TITLE_X_VEL[si]
	cwd
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	TITLE_X_DISL[si],ax
	adc	TITLE_X_DIS[si],dx
	mov	ax,TITLE_Y_VEL[si]
	cwd
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	TITLE_Y_DISL[si],ax
	adc	TITLE_Y_DIS[si],dx
	call	Xor_Title_Piece			; DISPLAY PIECE	
	inc	si
	inc	si
	cmp	si,2*TOTAL_PIECES
	jb	movt200
	loop	movt100
	ret

move_title	endp	  

PAGE
;--- MODULE:	key_instructions ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	all
; Function
;	1. Display keyboard instructions
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

KEY_XL		EQU	(MAX_X_CHARS-((offset kkk4)-(offset kkk3)))/2	; shift left away from center
KEY_XR		EQU	(MAX_X_CHARS/2)+2				; shift right away from center
KEY_Y		EQU	(25-15)/2

key_instructions	proc	near

CENTER_MESS1	EQU	CHAR_WIDTH*((MAX_X_CHARS-(offset kkk2-offset kkk1))/2)

	mov	ax,CENTER_MESS1				; top of box
	mov	dx,CHAR_HEIGTH*(1)
	call	Display_String
	DB	20H,08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,13H,0

	mov	ax,CENTER_MESS1
	mov	dx,CHAR_HEIGTH*(2)
	call	Display_String
kkk1:
	DB	'   G A M E    K E Y S  '
kkk2:				
	DB	0

	mov	ax,CENTER_MESS1				; sides and bottom of box
	mov	dx,CHAR_HEIGTH*(2)
	call	Display_String
	DB	0BH,08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,09H,0
	mov	ax,CHAR_WIDTH*(KEY_XL+3)		; LEFT PLAYER
	mov	dx,CHAR_HEIGTH*(KEY_Y+0)
	call	Display_String
	DB	'LEFT PLAYER KEYS'
	DB	0
	mov	XDRAWN+ENTOBJ,CHAR_WIDTH*(KEY_XL+3+18)	; enterprise picture
	mov	YDRAWN+ENTOBJ,CHAR_HEIGTH*(KEY_Y+0)
	mov	byte ptr ADRAWN+ENTOBJ,80H
	call	Xor_Ent

	mov	ax,CHAR_WIDTH*(KEY_XR+3)		; RIGHT PLAYER
	mov	dx,CHAR_HEIGTH*(KEY_Y+0)
	call	Display_String
	DB	'RIGHT PLAYER KEYS'
	DB	0
	MOV	XDRAWN+KLNOBJ,CHAR_WIDTH*(KEY_XR+3+18)	; KLINGON PICTURE
	MOV	YDRAWN+KLNOBJ,CHAR_HEIGTH*(KEY_Y+0)
	mov	byte ptr ADRAWN+KLNOBJ,80H
	call	Xor_Kln

	mov	ax,CHAR_WIDTH*KEY_XL			; TOP OF KEYS
	mov	dx,CHAR_HEIGTH*(KEY_Y+2)
	call	Display_String
kkk3:
	DB	19H,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1BH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1BH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,16H
	DB	20H,20H
	DB	20H,20H
	DB	19H,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1BH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1BH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,16H
kkk4:
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+3)
	call	Display_String
	DB	15H,'   Q   ',15H,'   W   ',15H,'   E   ',15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,'   7   ',15H,'   8   ',15H,'   9   ',15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+4)
	call	Display_String
	DB	15H,1FH,' FIRE ',1FH,15H,'       ',15H,1FH,' FIRE ',1FH,15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,1FH,' FIRE ',1FH,15H,'       ',15H,1FH,' FIRE ',1FH,15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+5)
	call	Display_String
	DB	15H,'PHASERS',15H,' CLOAK ',15H,'PHOTONS',15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,'PHASERS',15H,' CLOAK ',15H,'PHOTONS',15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL			; MIDDLE OF KEYS
	mov	dx,CHAR_HEIGTH*(KEY_Y+6)
	call	Display_String
	DB	1CH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,14H
	DB	20H,20H
	DB	20H,20H
	DB	1CH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,14H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+7)
	call	Display_String
	DB	15H,'   A   ',15H,'   S   ',15H,'   D   ',15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,'   4   ',15H,'   5   ',15H,'   6   ',15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+8)
	call	Display_String
	DB	15H,1FH,'ROTATE',1FH,15H,'IMPULSE',15H,1FH,'ROTATE',1FH,15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,1FH,'ROTATE',1FH,15H,'IMPULSE',15H,1FH,'ROTATE',1FH,15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+9)
	call	Display_String
	DB	15H,'  CCW  ',15H,'ENGINES',15H,1FH,'  CW  ',1FH,15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,'  CCW  ',15H,'ENGINES',15H,1FH,'  CW  ',1FH,15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL			; MIDDLE OF KEYS
	mov	dx,CHAR_HEIGTH*(KEY_Y+10)
	call	Display_String
	DB	1CH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,14H
	DB	20H,20H
	DB	20H,20H
	DB	1CH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1EH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,14H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+11)
	call	Display_String
	DB	15H,'   Z   ',15H,'   X   ',15H,'   C   ',15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,'   1   ',15H,'   2   ',15H,'   3   ',15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+12)
	call	Display_String
	DB	15H,1FH,'WEAPON',1FH,15H,' HYPER ',15H,1FH,'SHIELD',1FH,15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,1FH,'WEAPON',1FH,15H,' HYPER ',15H,1FH,'SHIELD',1FH,15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL
	mov	dx,CHAR_HEIGTH*(KEY_Y+13)
	call	Display_String
	DB	15H,1FH,'ENERGY',1FH,15H,' SPACE ',15H,1FH,'ENERGY',1FH,15H
	DB	20H,20H
	DB	20H,20H
	DB	15H,1FH,'ENERGY',1FH,15H,' SPACE ',15H,1FH,'ENERGY',1FH,15H
	DB	0
	mov	ax,CHAR_WIDTH*KEY_XL			; BOTTOM OF KEYS
	mov	dx,CHAR_HEIGTH*(KEY_Y+14)
	call	Display_String
	DB	18H,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1AH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1AH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,17H
	DB	20H,20H
	DB	20H,20H
	DB	18H,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1AH,1DH,1DH,1DH,1DH,1DH,1DH,1DH
	DB	1AH,1DH,1DH,1DH,1DH,1DH,1DH,1DH,17H
	DB	0
	ret

key_instructions	endp

PAGE
;--- MODULE:	game_instructions -----------------------------
; Entry
;	AUTO_FLAG,PLANET_ENABLE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,ds,es
; Function
;	1. Display instructions for SPACEWAR game.
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

game_instructions	proc	near

	mov	ax,CHAR_WIDTH*((MAX_X_CHARS-(OFFSET GKK200-OFFSET GKK100))/2)		; PLAYER 1
	mov	dx,CHAR_HEIGTH*(1)
	call	Display_String
	DB	20H,08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,13H,0

	mov	ax,CHAR_WIDTH*((MAX_X_CHARS-(OFFSET GKK200-OFFSET GKK100))/2)		; PLAYER 1
	mov	dx,CHAR_HEIGTH*(2)
	call	Display_String
GKK100:
	DB	'   G A M E    I N S T R U C T I O N S  '
GKK200:
	DB	0

	mov	ax,CHAR_WIDTH*((MAX_X_CHARS-(OFFSET GKK200-OFFSET GKK100))/2)		; PLAYER 1
	mov	dx,CHAR_HEIGTH*(2)
	call	Display_String
	DB	0BH,08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,08H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,08H,09H,0
	mov	ax,CHAR_WIDTH*(1)
IF DISPLAY_TYPE
	mov	dx,CHAR_HEIGTH*((25-18)/2)		; center in y axis
ELSE
	mov	dx,CHAR_HEIGTH*((25-18)/2+1)		; center in y axis
ENDIF
	call	Display_String
	DB	'OBJECT: Destroy the other ship with PHOTON TORPEDOS or',CR,LF
	DB	'        PHASERS until all its SHIELD energy is gone.',CR,LF,CR,LF
	DB	'WEAPONS:PHOTON TORPEDOS - Use = 1 unit, Damage = 4 units.',CR,LF
	DB	'        PHASERS         - Use = 1 unit, Damage = 2 units.',CR,LF,CR,LF
	DB	'DEFENSE:IMPULSE ENGINES - Use = 1 unit every 1/2 second.',CR,LF
	DB	'        CLOAK           - Use = 1 unit every 1/2 second.',CR,LF
	DB	'        HYPER SPACE     - Use = 8 units.',CR,LF
	DB	'COMMENT:You must have energy to use WEAPONS or DEFENCES.',CR,LF
	DB	'        ENERGY is recharged at 1 unit every 2 seconds.',CR,LF
	DB	'        Use PHASERS to shoot incoming PHOTON TORPEDOS.',CR,LF
	DB	'        The WARNING sound indicates SHIELD power too low.',CR,LF
	DB	'        Touching the PLANET will drain your SHIELDS.',CR,LF
	DB	'        The Left Robot player is defensive.',CR,LF
	DB	'        The Right Robot player is offensive.',CR,LF
	DB	'        Function key 8 toggles sound on or off.',CR,LF
	DB	0

	ret

game_instructions	endp

PAGE
;--- MODULE:	user_supported -----------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,ds,es
; Function
;	1. Display user supported software message.
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

user_supported		proc	near

	mov	ax,CHAR_WIDTH*(1)
	mov	dx,CHAR_HEIGTH*((25-16)/2)
	call	Display_String
	DB	'SPACEWAR is distributed under the USER-SUPPORTED',CR,LF
	DB	'concept.  You are encouraged to copy and share this',CR,LF
	DB	'program with other users.  If you enjoy SPACEWAR, and want me',CR,LF
	DB	'to finish SPACE MINEZ your contribution ($20 suggested) will',CR,LF
	DB	'be appreciated.  For a $30 contribution you will receive the',CR,LF
	DB	'source code for latest version of SPACEWAR.',CR,LF,CR,LF
	DB	'USER-SUPPORTED software is based on these three beliefs:',CR,LF
	DB	' 1.  The value of software is best assessed by the',CR,LF
	DB	'     user on his own system.',CR,LF
	DB	' 2.  Creation of personal computer software can and',CR,LF
	DB	'     should be supported by computing community.',CR,LF
	DB	' 3.  That copying of programs should be encourged,',CR,LF
	DB	'     rather than restricted.',CR,LF,CR,LF
	DB	'Bill Seiler == 317 Lockewood Lane == Scotts Valley, CA. 95066',CR,LF
	DB	0

	ret

user_supported	endp

PAGE
;--- MODULE:	display_game_mode --------------------------------
; Entry
;	AUTO_FLAG,PLANET_ENABLE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,ds,es
; Function
;	1. Display game modes at the bottom of the screen
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

CENTER_FUN_X	EQU	(MAX_X_CHARS-((offset ddd2)-(offset ddd1)))/2
	  

display_game_mode	proc	near

	mov	ax,CENTER_FUN_X*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-2*CHAR_HEIGTH
	call	Display_String			; display top of function keys
	DB	' '
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	DB	08H,08H,08H,08H,08H,08H,08H,08H,13H
	db	0

	mov	ax,CENTER_FUN_X*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String			; display function key numbers and boxes
ddd1:
	DB	' '
	DB	01H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	02H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	03H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	04H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	05H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	06H,08H,08H,08H,08H,08H,08H,08H,09H
	DB	07H,08H,08H,08H,08H,08H,08H,08H,09H
ddd2:
	db	0
	mov	ax,CENTER_FUN_X*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	DB	'  ',1FH,' EXIT ',1FH
	DB	'  ',1FH,' PLAY ',1FH
	DB	'  ',1FH,'ROBOT',1FH,'L'
	DB	'  ',1FH,'ROBOT',1FH,'R'
	DB	'  ',1FH,'PLANET',1FH
	DB	'  ','GRAVITY'
	DB	'  ',' PAUSE '
	DB	0
	test	AUTO_FLAG,BIT0
	je	no_random
	call	invert_3
no_random:
	test	AUTO_FLAG,BIT1
	je	no_smart
	call	invert_4
no_smart:
	test	PLANET_ENABLE,BIT0
	je	no_planet
	call	invert_5
no_planet:
	test	PLANET_ENABLE,BIT1
	je	no_gravity
	call	INVERT_6
no_gravity:
	test	PAUSE_ENABLE,BIT0
	je	no_pause
	call	INVERT_7
no_pause:
	ret

display_game_mode	endp
	   
PAGE
;--- MODULE:	invert_1 --------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,ds,es
; Function
;	1. Invert function keys
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

invert_1	proc	near

	mov	ax,(CENTER_FUN_X+2+0*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_2:
	mov	ax,(CENTER_FUN_X+2+1*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_3:
	mov	ax,(CENTER_FUN_X+2+2*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_4:
	mov	ax,(CENTER_FUN_X+2+3*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_5:
	mov	ax,(CENTER_FUN_X+2+4*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_6:
	mov	ax,(CENTER_FUN_X+2+5*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret

invert_7:
	mov	ax,(CENTER_FUN_X+2+6*9)*CHAR_WIDTH
	mov	dx,MAX_Y_AXIS-CHAR_HEIGTH
	call	Display_String
	db	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0
	ret
	
Invert_1	endp

PAGE
;--- MODULE:	Attract_Interrupt ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,bx,cx,dx,si,di,bp,ds,es
; Function
;	1. System clock timer interrupt for attract mode.
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Attract_Interrupt	proc	near

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	al,20H				; send non-specific EOI to PIC
	out	INTA00,al

	mov	ax,space_data
	mov	ds,ax
	ASSUME	DS:space_data

	inc	BLINK				; game state ctr

	test	BLINK,3				; time to update sys clock
	jne	sys_t5				; no
	mov	ax,040H
	mov	es,ax
	inc	ES:TIMER_LOW
	jnz	sys_t4
	inc	ES:TIMER_HIGH
sys_t4:
	cmp	ES:TIMER_HIGH,018H		; 24 hours ?
	jnz	sys_t5				; no
	cmp	ES:TIMER_LOW,0B0H		; maybe - check low
	jnz	sys_t5				; no
	xor	ax,ax				; timer overflow zero
	mov	ES:TIMER_LOW,ax
	mov	ES:TIMER_HIGH,ax
	mov	ES:TIMER_OFL,1			; flag overflow
sys_t5:

;	****** NEXT PLANET STATE ******

	mov	al,BLINK
	and	al,PLANET_TIME-1
	jne	atti100
	mov	bx,ATTRACT_PLANET_X		; top right of the screen
	mov	dx,ATTRACT_PLANET_Y
	inc	PLANET_STATE
	mov	al,PLANET_STATE
	call	Draw_The_Planet
atti100:
	test	byte ptr RANDOM_ROBOT_KEY+KEYBAM,80H	; random robot
	jne	atti300
	test	FUNCTION_FLAGS,BIT0
	jne	atti310
atti240:
	call	invert_3
	xor	AUTO_FLAG,BIT0
	or	FUNCTION_FLAGS,BIT0
	jmp	atti310
atti300:
	and	FUNCTION_FLAGS,NOT BIT0
atti310:
	test	byte ptr SMART_ROBOT_KEY+KEYBAM,80H	; smart robot
	jne	atti400
	test	FUNCTION_FLAGS,BIT1
	jne	atti410
	call	invert_4
	xor	AUTO_FLAG,BIT1
	or	FUNCTION_FLAGS,BIT1
	jmp	atti410
atti400:
	and	FUNCTION_FLAGS,NOT BIT1
atti410:
	test	byte ptr PLANET_KEY+KEYBAM,80H	; enable PLANET 
	jne	atti500
	test	FUNCTION_FLAGS,BIT2
	jne	atti510
	call	invert_5
	xor	PLANET_ENABLE,BIT0
	or	FUNCTION_FLAGS,BIT2
	jmp	atti510
atti500:
	and	FUNCTION_FLAGS,NOT BIT2
atti510:
	test	byte ptr GRAVITY_KEY+KEYBAM,80H	; enable gravity
	jne	atti600
	test	FUNCTION_FLAGS,BIT3
	jne	atti610
	call	invert_6
	xor	PLANET_ENABLE,BIT1
	or	FUNCTION_FLAGS,BIT3
	jmp	atti610
atti600:
	and	FUNCTION_FLAGS,NOT BIT3
atti610:
	test	byte ptr PAUSE_KEY+KEYBAM,80H	; pause the attract mode
	jne	atti700
	test	FUNCTION_FLAGS,BIT4
	jne	atti710
	call	invert_7
	xor	PAUSE_ENABLE,BIT0
	or	FUNCTION_FLAGS,BIT4
	jmp	atti710
atti700:
	and	FUNCTION_FLAGS,NOT BIT4
atti710:
	test	byte ptr SOUND_KEY+KEYBAM,80H	; toggle sound on/off
	jne	atti720
	test	FUNCTION_FLAGS,BIT5
	jne	atti730
	xor	SOUND_ENABLE,BIT0
	or	FUNCTION_FLAGS,BIT5
	jmp	atti730
atti720:
	and	FUNCTION_FLAGS,NOT BIT5
atti730:
	test	byte ptr PLAY_KEY+KEYBAM,80H
	jne	atti800
	jmp	Play_Spacewar

atti800:
	test 	byte ptr EXIT_KEY+KEYBAM,80H
	jne	atti850
	jmp	Exit
atti850:

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	iret

Attract_Interrupt	endp

PAGE
;--- MODULE:	install_attract_interrupts ---------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	Register	ax,si,es
; Function
;	1. Install timer and keyboard interrupt for attract mode
;--- Revision History
;	12/15/84	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

install_attract_interrupts	proc	near

	cli					; SAVE CCP INTERRUPTS
	mov	ax,INT_SEG
	mov	es,ax

	mov	si,TIMER_INT*4			; install attract timer interrupt

	mov	ax,offset Attract_Interrupt
	mov	ES:[si],ax
	mov	ES:[si+2],cs
    
	sti
	ret

install_attract_interrupts	endp

PAGE
;--- MODULE:	Pause_Test	 ------------------------------
; Entry
;	NONE
; Exit
;	NONE
; Affects
;	NONE
; Function
;	1. Waits in routine if pause state active
;--- Revision History
;	1/5/85	bjs
;---------------------------------------------------------------
	ASSUME	CS:space_code,DS:space_data,ES:Nothing

Pause_Test	proc	near

	sti					; allow interrupts
ptest100:
	test	PAUSE_ENABLE,BIT0		; time to pause
	jne	ptest100			; yes - wait here

	ret

Pause_Test	endp

space_code	ends
	end

