#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "COMMON.H"

static Screen This;

static Rect InstructionsButtonBounds = { 169, 223, 71, 14 };
static bool InstructionsButtonHovered;

static void DrawWinCount(void)
{
	char winCountText[16];

	DrawText("WINS", 14, 229);

	itoa(WinCount, winCountText, 10);
	DrawTextCenter(winCountText, 49, 229);
}

static void DrawInstructionsButton(void)
{
	Blit(InstructionsButtonHovered ? IMG_BUTTON_INSTRUCTIONS_HOVER : IMG_BUTTON_INSTRUCTIONS, InstructionsButtonBounds.X, InstructionsButtonBounds.Y);
}

static void OnActivate()
{
	BlitFullscreen(IMG_INSTRUCTIONS_BACKGROUND);
	DrawInstructionsButton();
	DrawWinCount();
}

static void OnUpdate()
{
	if (InstructionsButtonHovered != RectContains(&InstructionsButtonBounds, MouseX, MouseY))
	{
		InstructionsButtonHovered = !InstructionsButtonHovered;
		DrawInstructionsButton();
	}
}

static void OnKeyDown(short key)
{
	if (key == KEY_ESCAPE)
	{
		PlayClick();
		ActivateScreen(GameScreen);
	}
}

static void OnMouseDown()
{
	if (InstructionsButtonHovered)
	{
		PlayClick();
		ActivateScreen(GameScreen);
	}
}

static void OnMouseUp()
{
}

static void DrawDragContent()
{
}

Screen *InitInstructionsScreen(void)
{
	This.OnActivate = OnActivate;
	This.OnUpdate = OnUpdate;
	This.OnKeyDown = OnKeyDown;
	This.OnMouseDown = OnMouseDown;
	This.OnMouseUp = OnMouseUp;
	This.DrawDragContent = DrawDragContent;
	return &This;
}
