#include <stdio.h>
#include <stdlib.h>
#include "COMMON.H"

static Screen This;

Rect GameButtonBounds = { 15, 169, 45, 45 };
bool GameButtonHovered;
bool BootChimePlayed;

bool TextRandomized;
short WeatherIndex;
short AirQualityIndex;
short DroneActivityIndex;
char Temperature[8];

char *WeatherValues[] = {
	"Rain",
	"Hazy",
	"Hazy",
};

char *AirQualityValues[] = {
	"Poor",
};

char *DroneActivityValues[] = {
	"Light",
	"Heavy",
};

static void PlayMusic(void)
{
	sound(73);
	delay(220);
	sound(110);
	delay(220);
	sound(165);
	delay(220);
	sound(98);
	delay(220);
	sound(110);
	delay(220);
	sound(147);
	delay(440);
	nosound();
}

static void OnActivate()
{
	if (!TextRandomized)
	{
		TextRandomized = true;
		WeatherIndex = rand() % COUNTOF(WeatherValues);
		AirQualityIndex = rand() % COUNTOF(AirQualityValues);
		DroneActivityIndex = rand() % COUNTOF(DroneActivityValues);
		sprintf(Temperature, "%d~C", (rand() % 10) + 19);
	}

	BlitFullscreen(IMG_DESKTOP_BACKGROUND);

	DrawText("SOLITAIRE", 19, 220);
	DrawText("SHENZHEN", 143, 54);
	DrawText("CAM 04 - LIVE", 134, 65);
	DrawText("WEATHER:", 111, 85);
	DrawText("TEMPERATURE:", 111, 95);
	DrawText("AIR QUALITY:", 111, 105);
	DrawText("DRONE ACTIVITY:", 111, 115);
	DrawTextRight(WeatherValues[WeatherIndex], 210, 85);
	DrawTextRight(Temperature, 210, 95);
	DrawTextRight(AirQualityValues[AirQualityIndex], 210, 105);
	DrawTextRight(DroneActivityValues[DroneActivityIndex], 210, 115);
}

static void OnUpdate()
{
	if (!BootChimePlayed)
	{
		BootChimePlayed = true;
		PlayMusic();
		ShowMouse = true;
	}

	if (GameButtonHovered != RectContains(&GameButtonBounds, MouseX, MouseY))
	{
		GameButtonHovered = !GameButtonHovered;
		Blit(GameButtonHovered ? IMG_ICON_GAME_HOVER : IMG_ICON_GAME, 15, 169);
	}
}

static void OnKeyDown(short key)
{
	if (key == KEY_ESCAPE)
	{
		ActivateScreen(ShutdownScreen);
	}
}

static void OnMouseDown()
{
	if (GameButtonHovered)
	{
		PlayClick();
		ActivateScreen(GameScreen);
	}
}

static void OnMouseUp()
{
}

static void DrawDragContent()
{
}

Screen *InitDesktopScreen(void)
{
	This.OnActivate = OnActivate;
	This.OnUpdate = OnUpdate;
	This.OnKeyDown = OnKeyDown;
	This.OnMouseDown = OnMouseDown;
	This.OnMouseUp = OnMouseUp;
	This.DrawDragContent = DrawDragContent;
	return &This;
}
