#include <dos.h>
#include "ASSETS.H"

#define KEY_ESCAPE 0x1B

typedef short bool;
#define false 0
#define true 1
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

typedef struct
{
	short X, Y, W, H;
} Rect;

typedef struct
{
	void (*OnActivate)(void);
	void (*OnUpdate)(void);
	void (*OnKeyDown)(short key);
	void (*OnMouseDown)(void);
	void (*OnMouseUp)(void);
	void (*DrawDragContent)(void);
} Screen;

#define HIBYTE(x) ((x & 0xFF00) >> 8)
#define LOBYTE(x) (x & 0xFF)
#define COUNTOF(x) (sizeof(x) / sizeof(x[0]))

//===========================================================================
// Input state
//===========================================================================
extern short MouseX, MouseY;
extern bool MouseLeft, MouseLeftOld, MouseRight, MouseRightOld, ShowMouse;

//===========================================================================
// Assets
//===========================================================================
extern long ImageOffsets[];
extern short ImageWidths[];
extern short ImageHeights[];
extern byte far* ImageData;

//===========================================================================
// Screens
//===========================================================================
extern Screen *BootScreen, *DesktopScreen, *GameScreen, *InstructionsScreen, *ShutdownScreen;
void ActivateScreen(Screen *screen);
Screen *InitBootScreen(void);
Screen *InitDesktopScreen(void);
Screen *InitGameScreen(void);
Screen *InitInstructionsScreen(void);
Screen *InitShutdownScreen(void);

//===========================================================================
// Video
//===========================================================================
void SetVideoMode(byte mode);
void SetVideoModeX(void);
void SetPalette(byte *palette);

// Set the screen (0-2) to display.
void SetDisplayedScreen(short screen);

// Set the screen (0-2) to use as the target of all draw calls.
void SetTargetScreen(short screen);

// Copy one screen (0-2) to another.
void CopyScreen(short dstScreen, short srcScreen);
void CopyScreenRect(short dstScreen, short srcScreen, short x, short y, short w, short h);

// Get all metadata for an image.
void ImageInfo(short imageID, short *w, short *h, byte huge **image);

// Copy a fullscreen image to the screen.
void BlitFullscreen(short imageID);

// Copy an image to the screen.
void Blit(short imageID, short x, short y);

// Copy an image to the screen, except for transparent pixels.
void BlitBlend(short imageID, short x, short y);

void FillRect(byte color, short x, short y, short w, short h);
void DrawText(char* s, short x, short y);
void DrawTextCenter(char* s, short x, short y);
void DrawTextRight(char* s, short x, short y);

//===========================================================================
// Win count
//===========================================================================
extern short WinCount;
void LoadWinCount(void);
void SaveWinCount(void);

//===========================================================================
// Uncategorized
//===========================================================================
void Assert(bool condition, char *message);
void Quit(void);
bool RectContains(Rect *rect, short x, short y);
bool RectOverlaps(Rect *firstRect, Rect *secondRect);
short Min(short a, short b);
short Max(short a, short b);
void PlayClick(void);
void MarkRectDirty(short x, short y, short w, short h);
