
#ifndef __MIXER_H
#define __MIXER_H

typedef 	void 	(*mixerPFV)();

void init_mixer(int dev, int io, int irq, int dma, int hdma, int channels );
void close_mixer();
void mix_setvolume (int chn, int vol);
void set_mixbuffsize ( int size );
void mix_playsound (int chn, char *snd, int beg, int loop, int end, int speed);
void mix_setfreq (int chn, int speed);

void reset_sound(); // reset if corrupted
void close_soundtimers();

void init_sound();
void close_sound ();

volatile extern int snd_mixfreq;
volatile extern char mix_balance[32];    // balance; 0-15
volatile extern int mix_speed[32];       // play speed, in 16.16fixed; 0=don't play
extern char *mix_sample[32];    // sample adxs
volatile extern unsigned int mix_adx[32];         // current offset
volatile extern unsigned int mix_end[32];         // sample end adx
volatile extern unsigned int mix_loop[32];         // sample loop adx, 1=no loop
volatile extern int mix_volume[32];      // mixing volume
volatile extern mixerPFV mix_call_routine;    // routine
volatile extern char outtable[1024];
volatile extern mixerPFV sndendfunction[32];
volatile extern int intfromchannel;

volatile extern char *buffer;
volatile extern int bufadx;
extern int sends;
volatile extern char mix_channels; // channels to mix

volatile extern char snd_device; // 0=none, 1=gus (st), 2=sb (mono/stereo)
extern int disable_16bitmix;
extern int sndio,snddma,sndirq,sndhighdma,sndhdmamask;
extern int use_interpolation;
extern int force_mixfreq;
extern int unsigned16bit;
extern int disp_audioinfo;

#endif
