/* GFX.H - copyright (c) Toni Rsnen, 1998 *
 * ---------------------------------------- *
 * For more information, see GFX.C header   */

#ifndef __GFX_H
#define __GFX_H

#include "version.h"

#define PACKED __attribute__ ((packed))
#pragma pack(1)
struct VBE_vInfo
{   char VBESig[4] PACKED;
    short VBEVer;
    short QEMofs,QEMseg;
    unsigned int VBEFeat;
    short ModeOfs,ModeSeg,Memory;
    char VBEReserve[236];
};

struct VBE_mInfo
{   short ModeAttrib PACKED;
    char WinAAttrib PACKED;
    char WinBAttrib PACKED;
    short MinWinSize;  // granulity
    short WindowSize;
    short SegmA,SegmB;
    short MoveOfs,MoveSeg;
    short ByteHoriz;
    short XRes;
    short YRes;
    char CharWidth,CharHeight;
    char BitPlanes,BitsPerPixel;
    char Banks;
    char DispMode;
    char BankSize;
    char DispPages;
    char Reserve1;
    char Masks[8];
    char DirectColor;
    unsigned int PhysBasePtr PACKED;
    unsigned int PtrMEM;
    short OffMemSize;
    char Reserve[206];
};



typedef 	void 	(*gfxPFV)();


extern gfxPFV putnpic,putblendpic; // routines

extern int spr_ysize,spr_xsize,spr_xmaxadd; // required by putnpic -function
extern int sxsize,sysize;
extern int vidmemsize;  // video memory size in bytes

extern int putnpic8b (int x, int y, void *kuva); // sprite.asm
extern int putnpic16b (int x, int y, void *kuva); // sprite.asm
extern int putblendpic16b (int x, int y, void *kuva); // sprite.asm

int setvesamode (int mode);
int VBE2_detect();
int VBE12_detect();
int SetVBE2Mode (short mode);
int SetVBE1Mode (short mode);
void vbe_setbank(int n);
void putpic (int x, int y, char *kuva);
void putp (unsigned int x,unsigned int y, short c);
void putcolorpic (int x, int y, void *kuva, register int col);
void getpic (int x1, int y1, int x2, int y2, void *kuva);
void setpal (char col, char r,char g,char b);
void setpale (int r, int g, int b);
void waitsync (void);
void aline (int x1, int y1, int x2, int y2);
void abar (int x1, int y1, int x2, int y2);
void set320 ();
void UnpackLBM (char *name, char *kuva);
unsigned char gpix (int x, int y);
void acircle (int xp,int yp,int radius);
void purakuva (char *name, char* where);
void waitretrace();
void bankedflip();
void flip();
void panic (int i, char *name);
void set_videoparams();
void arec (int x1, int y1, int x2, int y2);
#ifdef DEBUG
void debuglog(char *rivi);
#endif // DEBUG

extern struct VBE_vInfo VBEInfo;

extern char gen_palette[768];
extern short drawcolor;
void *ruutu,*ruutu2;
void *zbuffer;
extern char *spritedest;
extern short VBESelector;
extern char nocolor;
extern int xclipmax,yclipmax;
extern char modeset;
extern int banksize,currbank;
extern char force_bankedVESA; // cmdline swtch: force to banked (vesa 1.2) mode

extern struct VBE_mInfo modeinfo;
extern int scr_y_adxs[480];

#ifndef DEBUG
#define debuglog(a)
#endif // DEBUG

#endif


