/* MPACK.C
 * Simple RLE-like packing algorhytm implementation
 *************
 * 29.08.2000 : Toni Rsnen
 *              modifications/documentation for open source
 *
 */

/*   MPACK.C/H - copyright (c) Toni Rsnen, 1998
 *   --------------------------------------------
 *   Simple RLE-alike memory packing algorhytms.
 *
 *   Files required: MPACK.C, MPACK.H
 *
 *   Revision history:
 *       20.06.98: Added headers
 *
 */


char *k1,*k2;
int i;

int spackmem (unsigned char *p1, unsigned char *p2, int size)
{ int sp = 0;
  int tp = 0;
  unsigned char c,b,c2,b2;
  int i;

  while (sp < size)
    { c = 1; b = *(p1+sp);
      while ( (*(p1+sp+c) == b) && (c < 131) && (c+sp < size) ) { c++; }
      if (c > 4)
        { *(p2+tp++) = c+124;
          *(p2+tp++) = b;
          sp += c;
        }
      else
        { c = 1; c2 = 0;
          while ( (c2 < 5) && (c < 127) && (c+sp < size) )
            { b2 = *(p1+sp+c++);
              if (b == b2)
                { c2++; } else { b = b2; c2 = 0; }
            }
          c -= c2;
          *(p2+tp++) = c;
          while ( c > 0)
            { *(p2+tp++) = *(p1+sp++);
              c--;
            }
        }
    }
  return (tp);
}

int sunpackmem(unsigned char *p1, unsigned char *p2, int size)
{ int sp = 0;
  int tp = 0;
  unsigned char c,b;
  int i;
  while (sp < size)
    { c = *(p1+sp++);
      if (c > 127)
        { b = *(p1+sp++); c -= 124;
          while (c > 0)
            { *(p2+tp++) = b; c--; }
        }
      else
        {
          while (c > 0)
            { *(p2+tp++) = *(p1+sp++); c--; }
        }
    }
  return (tp);
}


