/* MAKESPR.C
 * Sprite data conversion utility
 *************
 * 29.08.2000 : Toni Rsnen
 *              modifications/documentation for open source
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "gfx2.h"
#include "mpack.h"


char *pack;
int x,y,size,i;
FILE *tied;

void save_mapsprites()
{  UnpackLBM ("/work/dp2/m/mapspr.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("mapspr.dat", "wb");

   x = 1; y = 1;

   do {  getpic (x,y, x+21,y+21, ruutu2);
         size = spackmem (ruutu2, pack, 22*22+8);

         drawcolor = 15; aline (x,y,x+21,y+21);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 23;
         if (x > 290) { y += 23; x = 1; }
         getpic (x,y, x+21,y+21, ruutu2);
         for (size=0, i=20; i < 22*22; i++)
           if (*((char*)(ruutu2)+i)) size++;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}


void save_mapspeedsprites()
{  UnpackLBM ("/work/dp2/m/mapbspr.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("mapbspr.dat", "wb");

   x = 1; y = 1;

   do {  getpic (x,y, x+21,y+21, ruutu2);
         size = spackmem (ruutu2, pack, 22*22+8);

         drawcolor = 15; aline (x,y,x+21,y+21);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 23;
         if (x > 290) { y += 23; x = 1; }
         getpic (x,y, x+21,y+21, ruutu2);
         for (size=0, i=20; i < 22*22; i++)
           if (*((char*)(ruutu2)+i)) size++;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}

void save_prodsprites()
{  UnpackLBM ("/work/dp2/m/prod1.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("prods.dat", "wb");

   x = 1; y = 1;

   do {  getpic (x,y, x+21,y+21, ruutu2);
         size = spackmem (ruutu2, pack, 22*22+8);

         putnpic (x,y+50, ruutu2);

         drawcolor = 15; aline (x,y,x+21,y+21);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 23;
         if (x > 290) { y += 23; x = 1; }
         getpic (x,y, x+21,y+21, ruutu2);
         for (size=0, i=20; i < 20*20; i++)
           if (*((char*)(ruutu2)+i)) size++;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}


void save_selectpics()
{  UnpackLBM ("/work/dp2/m/sels.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("sels.dat", "wb");

   x = 1; y = 1;

   do {  getpic (x,y, x+21,y+21, ruutu2);
         size = spackmem (ruutu2, pack, 22*22+8);

         drawcolor = 15; aline (x,y,x+21,y+21);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 23;
         if (x > 290) { y += 23; x = 1; }
         getpic (x,y, x+21,y+21, ruutu2);
         for (size=0, i=20; i < 300; i++)
           if (*((char*)(ruutu2)+i)) size++;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}

void save_racepics()
{  UnpackLBM ("/work/dp2/m/races.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("races.dat", "wb");


   x = 1; y = 1;

   do {  getpic (x,y, x+24,y+24, ruutu2);
         size = spackmem (ruutu2, pack, 25*25+8);

         drawcolor = 15; aline (x,y,x+24,y+24);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 26;
         if (x > 290)
           {  y += 26; x = 1;
              if (y >= 131)
                {  y = 1; UnpackLBM ("/work/dp2/m/races2.lbm", ruutu);
                   flip();
                }
           }
         if (x == 1)
           {  getpic (x,y, x+21,y+21, ruutu2);
              for (size=0, i=20; i < 300; i++)
                if (*((char*)(ruutu2)+i)) size++;
           }
         else
           size = 1;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}

void save_smallracepics()
{  UnpackLBM ("/work/dp2/m/racess.lbm", ruutu);
   setpale (64,64,64); flip();

   tied = fopen ("racess.dat", "wb");


   x = 1; y = 1;

   do {  getpic (x,y, x+8,y+8, ruutu2);
         size = spackmem (ruutu2, pack, 9*9+8);

         drawcolor = 15; aline (x,y,x+8,y+8);
         flip();

         fwrite ( &size,4,1, tied);
         fwrite (pack,size,1, tied);

         x += 10;
         if (x > 10*12)
           {  y += 10; x = 1;  }
         if (x == 1)
           {  getpic (x,y, x+8,y+8, ruutu2);
              for (size=0, i=20; i < 80; i++)
                if (*((char*)(ruutu2)+i)) size++;
           }
         else
           size = 1;

      }  while (size != 0);
   fwrite ( &size,4,1, tied);

   fclose (tied);
}


void save_animsprites()
{  int xsize,ysize,b;
   UnpackLBM ("/work/dp2/m/anim1.lbm",ruutu);
   flip();
   setpale (64,64,64);
   tied = fopen ( "anim.dat", "wb" );
   x = 1; y = 1;
   do { xsize = 1; ysize = 1;
        while (gpix(x,y+ysize) != 2) { ysize++; }
        while (gpix(x+xsize,y) != 2) { xsize++; }

        fwrite (&xsize, 4,1, tied);
        fwrite (&ysize, 4,1, tied);
        do { getpic (x,y,x+xsize-1,y+ysize-1, ruutu2);
             drawcolor = 15; aline (x,y,x+xsize-1,y+ysize-1);
             flip();
             
             size = spackmem (ruutu2, pack, xsize*ysize+8);
             fwrite (&size, 4,1, tied);
             fwrite (pack, size,1, tied);

             x += (xsize+1);
             if (x+xsize > 318)
               {  y += (ysize+1); x = 1;
               }

             getpic (x,y,x+xsize-1,y+ysize-1, ruutu2);
             size = 0;
             for (i = 10; i < xsize*ysize+6; i++)
               if ( *((char*)(ruutu2)+i) != 0) { size++; }
             if (x+xsize > 319) size = 0;
           } while (size != 0);
        fwrite ( &size, 4,1, tied);

        x = 1; y += (ysize+1);
        b = gpix(x-1,y-1);
        if (b == 2)
          {  UnpackLBM ("/work/dp2/m/anim2.lbm",ruutu);
             flip();
             setpale (64,64,64);
             x = 1; y = 1; b = 1;
          }
      } while (b == 1);
   size = 0; fwrite (&size, 4,1, tied);

   fclose (tied);
}


int main (void)
{
   set320();
   ruutu = (char*) malloc (640*480);
   ruutu2 = (char*) malloc (640*480);
   pack = (char*) malloc (640*480);
   spritedest = ruutu;

   save_mapsprites();

   save_prodsprites();

   save_selectpics();

   save_racepics();

   save_smallracepics();

   save_mapspeedsprites();

   save_animsprites();

//   getch();

   textmode (03);
}
