/* MAKEHELP.C
 * Help compilation utility
 *************
 * 29.08.2000 : Toni Rsnen
 *              modifications/documentation for open source
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "gfx2.h"

#define HF_TITLE 1
#define HF_TEXT 2
#define HF_PAGEEND -1

FILE *src;
char rivi[100],cmd[30],rivi2[100];
int l,fchar,line;
int error,i;
FILE *tied;

char *font[5];
int fontofs[5][256];
char fontwidth[5][256];

int pageofs[32];

int page,pagelines;

// *******************************************************************
void load_font (char *name, int nro, int sizeapprox)
{  int w,size,i,o,ysize;
   FILE *tied = fopen (name, "rb");

   panic ( tied==NULL, name);

   if (font[nro] == NULL)
     font[nro] = (char*) malloc (sizeapprox); // ...too little, perhaps?

   fread ( &ysize,4,1,tied);

   o = 0; i = 32;
   fread ( &w, 4,1, tied);
   while (w)
     {
        fontwidth[nro][i] = w;
        fontofs[nro][i] = o;
        fread ( &size, 4,1, tied);
        fread ( ruutu2, size,1, tied);

        sunpackmem (ruutu2, (font[nro]+fontofs[nro][i]), size);

        o += w*ysize+16;

        fread ( &w, 4,1, tied); i++;
     }

   panic ( o >= sizeapprox, "font_size>approx");

   fclose (tied);
}

// *******************************************************************
void writef (int x, int y, char *text, int fnro)
{  int l,i;
   unsigned char c;

   l = strlen (text);

   for (i = 0; i < l; i++)
     {
        c = text[i];
        putnpic ( x,y, font[fnro]+fontofs[fnro][c] );
        x += fontwidth[fnro][c]-2;
     }
}

// *******************************************************************
int getflen (char *text, int fnro)
{  int l,i,li;
   unsigned char c;

   l = strlen (text);
   li = 0;

   for (i = 0; i < l; i++)
     {
        c = text[i];
        li += fontwidth[fnro][c]-2;
     }
   return li;
}


void get_next_param()
{  int len;
   rivi2[0] = 0; len = 0;
   while (1)
     {  rivi2[len] = rivi[fchar]; len++; fchar++;
        if ( (rivi[fchar] == ' ') || (fchar >= strlen(rivi)) )
          {  fchar++; break; }
     }
   rivi2[len] = 0;
}

int main ()
{  src = fopen ("help.txt", "r");
   tied = fopen ("helpt.dat", "wb");

   ruutu = malloc (64000);
   load_font ("med.f", 1, 16384);
   load_font ("tiny.f", 2, 16384);

   fwrite (pageofs, 32,4, tied);

   line = page = error = 0;

   while (!feof(src))
     {  fchar = 1;
        fgets (rivi, 80, src); line++;
          // remove last CR and padding spaces
        while (rivi[l=strlen(rivi)-1] == 10) rivi[strlen(rivi)-1] = 0;
//        while (rivi[0] == ' ') strcpy (rivi, rivi+1);

        if (rivi[0] == '@') // command
          {  get_next_param (); strcpy (cmd, rivi2);

             if (!stricmp (rivi2,"PAGE"))
               {  get_next_param ();
                  page = atoi (rivi2);
                  pageofs[page] = ftell (tied);
                  pagelines = 0;
               }

             if (!stricmp (rivi2,"END"))
               {  break;
               }

             if (!stricmp (rivi2,"NEXTPAGE"))
               {  page++;
                  pageofs[page] = ftell (tied);
                  pagelines = 0;
               }

             if (!stricmp (rivi2,"PAGEEND"))
               {  i = HF_PAGEEND; fwrite (&i, 4,1, tied);
               }

             if (!stricmp (rivi2,"TITLE"))
               {  i = HF_TITLE; fwrite (&i, 4,1, tied);
                  get_next_param ();
                  strcpy (rivi2,rivi+7);

                  i = strlen (rivi2)+1;
                  fwrite (&i,4,1, tied);
                  fwrite (rivi2,i,1, tied);
               }
          }
        else
          if ( (rivi[0] != ';') && (rivi[0] != 0) )
            {  i = HF_TEXT; fwrite (&i, 4,1, tied);

               if (getflen(rivi,1) > 290)
                 {  printf ("ERROR: Line %i too long\n",line); error ++; }

               i = strlen (rivi)+1;
               fwrite (&i,4,1, tied);
               fwrite (rivi,i,1, tied);
               pagelines++;
               if (pagelines == 15)
                 {  printf ("ERROR: Too many lines for page at line %i\n",line); error++; }
            }

        if (error > 15)
          {  printf ("ERROR: Too many errors, terminated\n"); break; }
     }

   fseek (tied, 0, SEEK_SET);
   fwrite (pageofs, 32,4, tied);


   fclose (src);
   fclose (tied);
}
